/*
 * Decompiled with CFR 0.152.
 */
package edu.rpi.twc.sesamestream.impl;

import edu.rpi.twc.sesamestream.impl.LList;
import edu.rpi.twc.sesamestream.impl.SubscriptionImpl;
import edu.rpi.twc.sesamestream.impl.TriplePattern;
import edu.rpi.twc.sesamestream.impl.VarList;

public class PartialSolution {
    private final SubscriptionImpl subscription;
    private final LList<TriplePattern> graphPattern;
    private final VarList bindings;

    public PartialSolution(SubscriptionImpl subscription) {
        this.subscription = subscription;
        this.bindings = null;
        this.graphPattern = subscription.getQuery().getGraphPattern();
    }

    public PartialSolution(SubscriptionImpl subscription, LList<TriplePattern> graphPattern, VarList bindings) {
        this.subscription = subscription;
        this.graphPattern = graphPattern;
        this.bindings = bindings;
    }

    public VarList getBindings() {
        return this.bindings;
    }

    public LList<TriplePattern> getGraphPattern() {
        return this.graphPattern;
    }

    public SubscriptionImpl getSubscription() {
        return this.subscription;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PartialSolution(").append(this.bindings).append(", {");
        boolean first = true;
        LList<TriplePattern> cur = this.graphPattern;
        while (!cur.isNil()) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(cur.getValue());
            cur = cur.getRest();
        }
        sb.append("})");
        return sb.toString();
    }
}

