/*
 * Decompiled with CFR 0.152.
 */
package edu.rpi.twc.sesamestream.impl;

import edu.rpi.twc.sesamestream.QueryEngine;
import edu.rpi.twc.sesamestream.impl.LList;
import edu.rpi.twc.sesamestream.impl.QueryEngineImpl;
import edu.rpi.twc.sesamestream.impl.SimpleQueryModelVisitor;
import edu.rpi.twc.sesamestream.impl.SolutionSequenceModifier;
import edu.rpi.twc.sesamestream.impl.TriplePattern;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.openrdf.query.Binding;
import org.openrdf.query.algebra.DescribeOperator;
import org.openrdf.query.algebra.Distinct;
import org.openrdf.query.algebra.Exists;
import org.openrdf.query.algebra.Extension;
import org.openrdf.query.algebra.ExtensionElem;
import org.openrdf.query.algebra.Filter;
import org.openrdf.query.algebra.Join;
import org.openrdf.query.algebra.Not;
import org.openrdf.query.algebra.Order;
import org.openrdf.query.algebra.Projection;
import org.openrdf.query.algebra.ProjectionElem;
import org.openrdf.query.algebra.ProjectionElemList;
import org.openrdf.query.algebra.QueryModelNode;
import org.openrdf.query.algebra.QueryModelVisitor;
import org.openrdf.query.algebra.Reduced;
import org.openrdf.query.algebra.Slice;
import org.openrdf.query.algebra.StatementPattern;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.ValueConstant;
import org.openrdf.query.algebra.ValueExpr;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.algebra.helpers.TupleExprs;
import org.openrdf.query.impl.BindingImpl;

public class Query {
    private static final Logger LOGGER = Logger.getLogger(Query.class.getName());
    private final Set<String> bindingNames;
    private Map<String, String> extendedBindingNames;
    private LList<TriplePattern> graphPattern;
    private List<Filter> filters;
    private Set<Binding> constants;
    private final SolutionSequenceModifier sequenceModifier = new SolutionSequenceModifier();
    private final QueryForm queryForm;

    public Query(TupleExpr expr, QueryEngineImpl.TriplePatternDeduplicator deduplicator) throws QueryEngine.IncompatibleQueryException {
        this.bindingNames = new HashSet<String>();
        this.graphPattern = LList.NIL;
        List<QueryModelNode> l = this.visit((QueryModelNode)expr);
        if (l.size() != 1) {
            throw new QueryEngine.IncompatibleQueryException("multiple root nodes");
        }
        QueryModelNode root = l.iterator().next();
        LinkedList<StatementPattern> patterns = new LinkedList<StatementPattern>();
        this.queryForm = Query.findQueryType(root);
        if (QueryForm.SELECT != this.queryForm) {
            throw new QueryEngine.IncompatibleQueryException(this.queryForm.name() + " query form is currently not supported");
        }
        this.findPatternsInRoot(root, patterns);
        for (StatementPattern pat : patterns) {
            this.graphPattern = this.graphPattern.push(deduplicator.deduplicate(new TriplePattern(pat)));
        }
    }

    public QueryForm getQueryForm() {
        return this.queryForm;
    }

    public Set<Binding> getConstants() {
        return this.constants;
    }

    private static QueryForm findQueryType(QueryModelNode root) throws QueryEngine.IncompatibleQueryException {
        if (root instanceof Slice) {
            return QueryForm.SELECT;
        }
        if (root instanceof Reduced) {
            return QueryForm.SELECT;
        }
        if (root instanceof Projection || root instanceof Distinct) {
            return QueryForm.SELECT;
        }
        if (root instanceof DescribeOperator) {
            return QueryForm.DESCRIBE;
        }
        throw new QueryEngine.IncompatibleQueryException("could not infer type of query from root node: " + root);
    }

    private void addExtendedBindingName(String from, String to) {
        if (from.equals(to)) {
            return;
        }
        if (null == this.extendedBindingNames) {
            this.extendedBindingNames = new HashMap<String, String>();
        }
        this.extendedBindingNames.put(from, to);
    }

    public LList<TriplePattern> getGraphPattern() {
        return this.graphPattern;
    }

    public Set<String> getBindingNames() {
        return this.bindingNames;
    }

    public Map<String, String> getExtendedBindingNames() {
        return this.extendedBindingNames;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public SolutionSequenceModifier getSequenceModifier() {
        return this.sequenceModifier;
    }

    private void findPatternsInRoot(QueryModelNode root, Collection<StatementPattern> patterns) throws QueryEngine.IncompatibleQueryException {
        if (root instanceof Projection) {
            this.findPatterns((Projection)root, patterns);
        } else if (root instanceof Join) {
            this.findPatterns((Join)root, patterns);
        } else if (root instanceof Filter) {
            this.findPatterns((Filter)root, patterns);
        } else if (root instanceof Distinct) {
            this.sequenceModifier.makeDistinct();
            List<QueryModelNode> l = this.visitChildren(root);
            if (1 != l.size()) {
                throw new QueryEngine.IncompatibleQueryException("exactly one node expected beneath DISTINCT");
            }
            this.findPatternsInRoot(l.get(0), patterns);
        } else if (root instanceof Reduced) {
            this.sequenceModifier.makeReduced();
            List<QueryModelNode> l = this.visitChildren(root);
            if (1 != l.size()) {
                throw new QueryEngine.IncompatibleQueryException("exactly one node expected beneath DISTINCT");
            }
            this.findPatternsInRoot(l.get(0), patterns);
        } else if (root instanceof Slice) {
            List<QueryModelNode> l;
            Slice s = (Slice)root;
            if (s.hasLimit()) {
                this.sequenceModifier.setLimit(s.getLimit());
            }
            if (s.hasOffset()) {
                this.sequenceModifier.setOffset(s.getOffset());
            }
            if (1 != (l = this.visitChildren(root)).size()) {
                throw new QueryEngine.IncompatibleQueryException("exactly one node expected beneath Slice");
            }
            this.findPatternsInRoot(l.get(0), patterns);
        } else {
            throw new QueryEngine.IncompatibleQueryException("expected Projection or Distinct at root node of query; found " + root);
        }
    }

    private void findPatterns(StatementPattern p, Collection<StatementPattern> patterns) {
        patterns.add(p);
    }

    private void findPatterns(Join j, Collection<StatementPattern> patterns) throws QueryEngine.IncompatibleQueryException {
        for (QueryModelNode n : this.visitChildren((QueryModelNode)j)) {
            if (n instanceof StatementPattern) {
                this.findPatterns((StatementPattern)n, patterns);
                continue;
            }
            if (n instanceof Join) {
                this.findPatterns((Join)n, patterns);
                continue;
            }
            throw new QueryEngine.IncompatibleQueryException("unexpected node: " + n);
        }
    }

    private void findPatterns(Filter f, Collection<StatementPattern> patterns) throws QueryEngine.IncompatibleQueryException {
        if (null == this.filters) {
            this.filters = new LinkedList<Filter>();
        }
        this.filters.add(f);
        List<QueryModelNode> filterChildren = this.visitChildren((QueryModelNode)f);
        if (2 != filterChildren.size()) {
            throw new QueryEngine.IncompatibleQueryException("expected exactly two nodes beneath filter");
        }
        QueryModelNode valueExpr = filterChildren.get(0);
        if (!(valueExpr instanceof ValueExpr)) {
            throw new QueryEngine.IncompatibleQueryException("expected value expression as first child of filter; found " + valueExpr);
        }
        this.checkFilterFunctionSupported((ValueExpr)valueExpr);
        QueryModelNode filterChild = filterChildren.get(1);
        if (filterChild instanceof Join) {
            this.findPatterns((Join)filterChild, patterns);
        } else if (filterChild instanceof StatementPattern) {
            this.findPatterns((StatementPattern)filterChild, patterns);
        } else {
            throw new QueryEngine.IncompatibleQueryException("expected join or statement pattern beneath filter; found " + filterChild);
        }
    }

    private void checkFilterFunctionSupported(ValueExpr expr) throws QueryEngine.IncompatibleQueryException {
        if (expr instanceof Not) {
            List<QueryModelNode> children = this.visitChildren((QueryModelNode)expr);
            if (1 != children.size()) {
                throw new QueryEngine.IncompatibleQueryException("expected exactly one node beneath NOT");
            }
            QueryModelNode valueExpr = children.get(0);
            if (!(valueExpr instanceof ValueExpr)) {
                throw new QueryEngine.IncompatibleQueryException("expected value expression as first child of NOT; found " + valueExpr);
            }
            this.checkFilterFunctionSupported((ValueExpr)valueExpr);
        } else if (expr instanceof Exists) {
            throw new QueryEngine.IncompatibleQueryException("EXISTS and NOT EXISTS are not supported");
        }
    }

    private void findPatterns(Projection p, Collection<StatementPattern> patterns) throws QueryEngine.IncompatibleQueryException {
        List<QueryModelNode> l = this.visitChildren((QueryModelNode)p);
        Extension ext = null;
        for (QueryModelNode n : l) {
            if (n instanceof Extension) {
                ext = (Extension)n;
                continue;
            }
            if (!(n instanceof ProjectionElemList)) continue;
            ProjectionElemList pl = (ProjectionElemList)n;
            for (ProjectionElem pe : pl.getElements()) {
                this.bindingNames.add(pe.getSourceName());
                this.addExtendedBindingName(pe.getSourceName(), pe.getTargetName());
            }
        }
        if (null != ext) {
            l = this.visitChildren((QueryModelNode)ext);
        }
        for (QueryModelNode n : l) {
            if (n instanceof Join) {
                Join j = (Join)n;
                if (TupleExprs.containsProjection((TupleExpr)j)) {
                    throw new QueryEngine.IncompatibleQueryException("join contains projection");
                }
                this.findPatterns(j, patterns);
                continue;
            }
            if (n instanceof StatementPattern) {
                this.findPatterns((StatementPattern)n, patterns);
                continue;
            }
            if (n instanceof Filter) {
                this.findPatterns((Filter)n, patterns);
                continue;
            }
            if (n instanceof ProjectionElemList) continue;
            if (n instanceof ExtensionElem) {
                ExtensionElem ee = (ExtensionElem)n;
                ValueExpr ve = ee.getExpr();
                if (ve instanceof ValueConstant) {
                    String name = ee.getName();
                    String target = this.extendedBindingNames.get(name);
                    if (null == target) {
                        throw new QueryEngine.IncompatibleQueryException("ExtensionElem does not correspond to a projection variable");
                    }
                    ValueConstant vc = (ValueConstant)ve;
                    if (null == this.constants) {
                        this.constants = new HashSet<Binding>();
                    }
                    this.constants.add((Binding)new BindingImpl(target, vc.getValue()));
                    continue;
                }
                if (ve instanceof Var) continue;
                throw new QueryEngine.IncompatibleQueryException("expected ValueConstant or Var within ExtensionElem; found " + ve);
            }
            if (n instanceof Order) {
                throw new QueryEngine.IncompatibleQueryException("the ORDER BY modifier is not supported by SesameStream");
            }
            throw new QueryEngine.IncompatibleQueryException("unexpected type: " + n.getClass());
        }
    }

    private List<QueryModelNode> visit(QueryModelNode node) {
        LinkedList<QueryModelNode> visited = new LinkedList<QueryModelNode>();
        SimpleQueryModelVisitor v = new SimpleQueryModelVisitor(visited);
        try {
            node.visit((QueryModelVisitor)v);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return visited;
    }

    private List<QueryModelNode> visitChildren(QueryModelNode node) {
        LinkedList<QueryModelNode> visited = new LinkedList<QueryModelNode>();
        SimpleQueryModelVisitor v = new SimpleQueryModelVisitor(visited);
        try {
            node.visitChildren((QueryModelVisitor)v);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return visited;
    }

    public static enum QueryForm {
        ASK,
        CONSTRUCT,
        DESCRIBE,
        SELECT;

    }
}

