/*
 * Decompiled with CFR 0.152.
 */
package edu.rpi.twc.sesamestream.impl;

import edu.rpi.twc.sesamestream.BindingSetHandler;
import edu.rpi.twc.sesamestream.QueryEngine;
import edu.rpi.twc.sesamestream.SesameStream;
import edu.rpi.twc.sesamestream.Subscription;
import edu.rpi.twc.sesamestream.impl.FilterEvaluator;
import edu.rpi.twc.sesamestream.impl.LList;
import edu.rpi.twc.sesamestream.impl.PartialSolution;
import edu.rpi.twc.sesamestream.impl.Query;
import edu.rpi.twc.sesamestream.impl.SolutionHandler;
import edu.rpi.twc.sesamestream.impl.SubscriptionImpl;
import edu.rpi.twc.sesamestream.impl.TripleIndex;
import edu.rpi.twc.sesamestream.impl.TriplePattern;
import edu.rpi.twc.sesamestream.impl.VarList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import net.fortytwo.linkeddata.CacheEntry;
import net.fortytwo.linkeddata.LinkedDataCache;
import net.fortytwo.ripple.RippleException;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.algebra.Filter;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.impl.MapBindingSet;
import org.openrdf.query.parser.ParsedQuery;
import org.openrdf.query.parser.QueryParserUtil;
import org.openrdf.sail.Sail;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;

public class QueryEngineImpl
implements QueryEngine {
    private static final Logger LOGGER = Logger.getLogger(QueryEngineImpl.class.getName());
    private final TripleIndex index;
    private final List<PartialSolution> intermediateSolutionBuffer = new LinkedList<PartialSolution>();
    private final List<Statement> statementBuffer = new LinkedList<Statement>();
    private final Map<TriplePattern, TriplePattern> uniquePatterns;
    private final TriplePatternDeduplicator deduplicator;
    private LinkedDataCache linkedDataCache;
    private SailConnection linkedDataCacheConnection;
    private final SolutionHandler binder = new SolutionHandler(){

        @Override
        public void handle(PartialSolution ps, TriplePattern matched, VarList newBindings) {
            QueryEngineImpl.this.increment(QueryEngineImpl.this.countBindingOps, false);
            QueryEngineImpl.this.handleSolution(ps, matched, newBindings);
        }
    };
    private boolean logHasChanged = false;
    private long timeCurrentOperationBegan;
    private final Counter countQueries = new Counter();
    private final Counter countTriplePatterns = new Counter();
    private final Counter countStatements = new Counter();
    private final Counter countPartialSolutions = new Counter();
    private final Counter countSolutions = new Counter();
    private final Counter countIndexOps = new Counter();
    private final Counter countBindingOps = new Counter();
    private final Counter countReplaceOps = new Counter();
    private final FilterEvaluator filterEvaluator;
    private boolean mutex;

    public QueryEngineImpl() {
        this.index = new TripleIndex();
        this.uniquePatterns = new HashMap<TriplePattern, TriplePattern>();
        this.deduplicator = new TriplePatternDeduplicator();
        ValueFactoryImpl valueFactory = new ValueFactoryImpl();
        this.filterEvaluator = new FilterEvaluator((ValueFactory)valueFactory);
        this.clear();
    }

    public void setLinkedDataCache(LinkedDataCache cache, Sail sail) throws SailException {
        this.linkedDataCache = cache;
        this.linkedDataCache.setAutoCommit(true);
        this.linkedDataCacheConnection = sail.getConnection();
    }

    public TripleIndex getIndex() {
        return this.index;
    }

    public void clear() {
        this.index.clear();
        this.uniquePatterns.clear();
        this.countQueries.reset();
        this.countTriplePatterns.reset();
        this.countStatements.reset();
        this.countPartialSolutions.reset();
        this.countSolutions.reset();
        this.countIndexOps.reset();
        this.countBindingOps.reset();
        this.countReplaceOps.reset();
        this.logHeader();
    }

    public Subscription addQuery(String q, BindingSetHandler h) throws QueryEngine.IncompatibleQueryException, QueryEngine.InvalidQueryException {
        ParsedQuery query;
        String baseURI = "http://example.org/baseURI";
        try {
            query = QueryParserUtil.parseQuery((QueryLanguage)QueryLanguage.SPARQL, (String)q, (String)baseURI);
        }
        catch (MalformedQueryException e) {
            throw new QueryEngine.InvalidQueryException((Throwable)e);
        }
        return this.addQuery(query.getTupleExpr(), h);
    }

    public Subscription addQuery(TupleExpr t, BindingSetHandler h) throws QueryEngine.IncompatibleQueryException {
        this.mutexUp();
        this.increment(this.countQueries, true);
        this.timeCurrentOperationBegan = System.currentTimeMillis();
        Query q = new Query(t, this.deduplicator);
        SubscriptionImpl s = new SubscriptionImpl(q, h);
        PartialSolution query = new PartialSolution(s);
        this.addPartialSolution(query);
        this.flushPartialSolutions();
        this.logEntry();
        this.mutexDown();
        return s;
    }

    public void addStatement(Statement s) {
        if (this.mutex) {
            this.statementBuffer.add(s);
        } else {
            this.mutexUp();
            this.increment(this.countStatements, false);
            this.timeCurrentOperationBegan = System.currentTimeMillis();
            this.index.match(this.toVarList(s), s, this.binder);
            this.flushPartialSolutions();
            this.logEntry();
            this.mutexDown();
        }
    }

    public void addStatements(Statement ... statements) {
        for (Statement s : statements) {
            this.addStatement(s);
        }
    }

    public void addStatements(Collection<Statement> statements) {
        for (Statement s : statements) {
            this.addStatement(s);
        }
    }

    private void mutexUp() {
        this.mutex = true;
    }

    private void mutexDown() {
        this.mutex = false;
        if (this.statementBuffer.size() > 0) {
            this.addStatement(this.statementBuffer.remove(0));
        }
    }

    private void addPartialSolution(PartialSolution ps) {
        this.increment(this.countPartialSolutions, true);
        this.intermediateSolutionBuffer.add(ps);
    }

    private void flushPartialSolutions() {
        for (PartialSolution q : this.intermediateSolutionBuffer) {
            LList<TriplePattern> cur = q.getGraphPattern();
            while (!cur.isNil()) {
                this.indexTriplePattern(cur.getValue(), q);
                cur = cur.getRest();
            }
        }
        this.intermediateSolutionBuffer.clear();
    }

    private VarList toVarList(Statement s) {
        VarList l = null;
        l = new VarList(null, s.getObject(), l);
        l = new VarList(null, (Value)s.getPredicate(), l);
        l = new VarList(null, (Value)s.getSubject(), l);
        return l;
    }

    private VarList toVarList(TriplePattern p) {
        VarList l = null;
        l = new VarList(p.getObject().getName(), p.getObject().getValue(), l);
        l = new VarList(p.getPredicate().getName(), p.getPredicate().getValue(), l);
        l = new VarList(p.getSubject().getName(), p.getSubject().getValue(), l);
        return l;
    }

    private void indexTriplePattern(TriplePattern p, PartialSolution q) {
        this.increment(this.countIndexOps, false);
        VarList l = this.toVarList(p);
        this.index.index(p, l, q);
        if (null != this.linkedDataCache) {
            Value s = p.getSubject().getValue();
            Value o = p.getObject().getValue();
            try {
                if (null != s && s instanceof URI) {
                    System.out.println("looking up subject: " + s);
                    CacheEntry.Status status = this.linkedDataCache.retrieveUri((URI)s, this.linkedDataCacheConnection);
                    System.out.println("\t" + status);
                }
                if (null != o && o instanceof URI) {
                    System.out.println("looking up object: " + o);
                    this.linkedDataCache.retrieveUri((URI)o, this.linkedDataCacheConnection);
                }
            }
            catch (RippleException e) {
                LOGGER.severe(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private void handleSolution(PartialSolution ps, TriplePattern matched, VarList newBindings) {
        if (1 == ps.getGraphPattern().length()) {
            this.produceSolution(ps, VarList.union(newBindings, ps.getBindings()));
        } else {
            LList<TriplePattern> nextPatterns = LList.NIL;
            VarList nextBindings = VarList.union(newBindings, ps.getBindings());
            LList<TriplePattern> cur = ps.getGraphPattern();
            while (!cur.isNil()) {
                TriplePattern t = cur.getValue();
                if (t != matched) {
                    TriplePattern p = this.replace(t, newBindings);
                    nextPatterns = null == p ? nextPatterns.push(t) : nextPatterns.push(this.deduplicator.deduplicate(p));
                }
                cur = cur.getRest();
            }
            this.addPartialSolution(new PartialSolution(ps.getSubscription(), nextPatterns, nextBindings));
        }
    }

    private void produceSolution(PartialSolution r, VarList nextBindings) {
        Query.QueryForm form;
        MapBindingSet solution;
        Query q = r.getSubscription().getQuery();
        if (!r.getSubscription().isActive()) {
            return;
        }
        List<Filter> filters = q.getFilters();
        if (null == filters) {
            solution = this.toSolutionBindings(nextBindings, r);
        } else {
            BindingSet bs = this.toFilterableBindingSet(nextBindings);
            for (Filter f : filters) {
                try {
                    if (this.filterEvaluator.applyFilter(f, bs)) continue;
                    return;
                }
                catch (QueryEvaluationException e) {
                    LOGGER.severe("query evaluation error while applying filter");
                    e.printStackTrace(System.err);
                    return;
                }
            }
            solution = this.toSolutionBindings(bs, r);
        }
        if (null != q.getConstants()) {
            for (Binding b : q.getConstants()) {
                solution.addBinding(b);
            }
        }
        if (Query.QueryForm.SELECT == (form = q.getQueryForm())) {
            if (q.getSequenceModifier().trySolution((BindingSet)solution, r.getSubscription())) {
                this.handleSolution(r.getSubscription().getHandler(), (BindingSet)solution);
            }
        } else {
            throw new IllegalStateException("unexpected query form: " + (Object)((Object)form));
        }
    }

    private BindingSet toFilterableBindingSet(VarList bindings) {
        MapBindingSet bs = new MapBindingSet();
        for (VarList cur = bindings; null != cur; cur = cur.getRest()) {
            bs.addBinding(cur.getName(), cur.getValue());
        }
        return bs;
    }

    private MapBindingSet toSolutionBindings(BindingSet bs, PartialSolution r) {
        MapBindingSet newBindings = new MapBindingSet();
        Set<String> names = r.getSubscription().getQuery().getBindingNames();
        Map<String, String> extNames = r.getSubscription().getQuery().getExtendedBindingNames();
        for (String name : names) {
            String finalName;
            Value val = bs.getValue(name);
            if (null == val) {
                LOGGER.warning("no value bound to variable '" + name + "' in solution");
                continue;
            }
            if (null == extNames) {
                finalName = name;
            } else {
                finalName = extNames.get(name);
                if (null == finalName) {
                    finalName = name;
                }
            }
            newBindings.addBinding(finalName, val);
        }
        return newBindings;
    }

    private MapBindingSet toSolutionBindings(VarList bindings, PartialSolution r) {
        MapBindingSet newBindings = new MapBindingSet();
        Set<String> names = r.getSubscription().getQuery().getBindingNames();
        Map<String, String> extNames = r.getSubscription().getQuery().getExtendedBindingNames();
        for (VarList cur = bindings; null != cur; cur = cur.getRest()) {
            String finalName;
            String name = cur.getName();
            if (!names.contains(name)) continue;
            if (null == extNames) {
                finalName = name;
            } else {
                finalName = extNames.get(name);
                if (null == finalName) {
                    finalName = name;
                }
            }
            newBindings.addBinding(finalName, cur.getValue());
        }
        return newBindings;
    }

    private TriplePattern replace(TriplePattern p, VarList bindings) {
        this.increment(this.countReplaceOps, false);
        Var newSubject = p.getSubject();
        Var newPredicate = p.getPredicate();
        Var newObject = p.getObject();
        boolean changed = false;
        for (VarList cur = bindings; null != cur; cur = cur.getRest()) {
            if (!p.getSubject().hasValue() && p.getSubject().getName().equals(cur.getName())) {
                newSubject = cur.asVar();
                changed = true;
            }
            if (!p.getPredicate().hasValue() && p.getPredicate().getName().equals(cur.getName())) {
                newPredicate = cur.asVar();
                changed = true;
            }
            if (p.getObject().hasValue() || !p.getObject().getName().equals(cur.getName())) continue;
            newObject = cur.asVar();
            changed = true;
        }
        return changed ? new TriplePattern(newSubject, newPredicate, newObject) : null;
    }

    private void increment(Counter counter, boolean logChange) {
        if (SesameStream.getDoPerformanceMetrics()) {
            counter.increment();
            if (logChange) {
                this.logHasChanged = true;
            }
        }
    }

    private void logHeader() {
        if (SesameStream.getDoPerformanceMetrics()) {
            System.out.println("LOG\ttime1,time2,queries,statements,patterns,partial,solutions,indexOps,bindingOps,replaceOps");
        }
    }

    private void logEntry() {
        if (SesameStream.getDoPerformanceMetrics() && (!SesameStream.getDoUseCompactLogFormat() || this.logHasChanged)) {
            System.out.println("LOG\t" + this.timeCurrentOperationBegan + "," + System.currentTimeMillis() + "," + this.countQueries.getCount() + "," + this.countStatements.getCount() + "," + this.countTriplePatterns.getCount() + "," + this.countPartialSolutions.getCount() + "," + this.countSolutions.getCount() + "," + this.countIndexOps.getCount() + "," + this.countBindingOps.getCount() + "," + this.countReplaceOps.getCount());
            this.logHasChanged = false;
        }
    }

    private static String toString(BindingSet b) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String n : b.getBindingNames()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(n).append(":").append(b.getValue(n));
        }
        return sb.toString();
    }

    private void handleSolution(BindingSetHandler handler, BindingSet solution) {
        this.increment(this.countSolutions, true);
        if (SesameStream.getDoPerformanceMetrics()) {
            System.out.println("SOLUTION\t" + System.currentTimeMillis() + "\t" + QueryEngineImpl.toString(solution));
        }
        handler.handle(solution);
    }

    private static class Counter {
        private long count = 0L;

        private Counter() {
        }

        public void increment() {
            ++this.count;
        }

        public void reset() {
            this.count = 0L;
        }

        public long getCount() {
            return this.count;
        }
    }

    public class TriplePatternDeduplicator {
        public TriplePattern deduplicate(TriplePattern t) {
            TriplePattern t2 = (TriplePattern)QueryEngineImpl.this.uniquePatterns.get(t);
            if (null == t2) {
                QueryEngineImpl.this.increment(QueryEngineImpl.this.countTriplePatterns, true);
                return t;
            }
            return t2;
        }
    }
}

