/*
 * Decompiled with CFR 0.152.
 */
package edu.rpi.twc.sesamestream.impl;

import edu.rpi.twc.sesamestream.SesameStream;
import edu.rpi.twc.sesamestream.impl.SubscriptionImpl;
import java.util.HashSet;
import java.util.Set;
import org.openrdf.query.BindingSet;

public class SolutionSequenceModifier {
    private Set<BindingSet> distinctSet;
    private boolean hasReduced = false;
    private long limit = -1L;
    private long count = 0L;

    public void makeDistinct() {
        if (null == this.distinctSet) {
            this.distinctSet = new HashSet<BindingSet>();
        }
    }

    public void makeReduced() {
        this.makeDistinct();
        this.hasReduced = true;
    }

    public void setLimit(long limit) {
        if (limit < 0L) {
            throw new IllegalArgumentException("negative LIMIT");
        }
        this.limit = limit;
    }

    public void setOffset(long offset) {
        if (offset < 0L) {
            throw new IllegalArgumentException("negative OFFSET");
        }
        this.count = -offset;
    }

    public boolean trySolution(BindingSet solution, SubscriptionImpl subs) {
        if (null != this.distinctSet) {
            if (this.distinctSet.contains(solution)) {
                return false;
            }
            if (this.hasReduced && (long)this.distinctSet.size() >= SesameStream.getReducedModifierCapacity()) {
                this.distinctSet.clear();
            }
            this.distinctSet.add(solution);
        }
        ++this.count;
        if (this.count > 0L) {
            if (-1L == this.limit) {
                return true;
            }
            if (this.count == this.limit) {
                subs.cancel();
                return true;
            }
            return this.count <= this.limit;
        }
        return false;
    }
}

