/*
 * Decompiled with CFR 0.152.
 */
package edu.rpi.twc.sesamestream.impl;

import edu.rpi.twc.sesamestream.impl.LList;
import edu.rpi.twc.sesamestream.impl.PartialSolution;
import edu.rpi.twc.sesamestream.impl.SolutionHandler;
import edu.rpi.twc.sesamestream.impl.TriplePattern;
import edu.rpi.twc.sesamestream.impl.VarList;
import edu.rpi.twc.sesamestream.impl.Visitor;
import java.util.HashMap;
import java.util.Map;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public class TripleIndex {
    private LList<PartialSolutionWrapper> partialSolutions;
    private Map<Value, TripleIndex> valueIndices;
    private TripleIndex wildcardIndex;

    public void clear() {
        this.partialSolutions = null;
        this.wildcardIndex = null;
        if (null != this.valueIndices) {
            this.valueIndices.clear();
        }
    }

    public void index(TriplePattern p, VarList tuple, PartialSolution ps) {
        if (null == tuple) {
            if (null == this.partialSolutions) {
                this.partialSolutions = LList.NIL;
            }
            this.partialSolutions = this.partialSolutions.push(new PartialSolutionWrapper(p, ps));
        } else {
            Value v = tuple.getValue();
            if (null == v) {
                if (null == this.wildcardIndex) {
                    this.wildcardIndex = new TripleIndex();
                }
                this.wildcardIndex.index(p, tuple.getRest(), ps);
            } else {
                TripleIndex n;
                if (null == this.valueIndices) {
                    this.valueIndices = new HashMap<Value, TripleIndex>();
                }
                if (null == (n = this.valueIndices.get(v))) {
                    n = new TripleIndex();
                    this.valueIndices.put(v, n);
                }
                n.index(p, tuple.getRest(), ps);
            }
        }
    }

    public void match(VarList tuple, Statement st, SolutionHandler binder) {
        if (null == tuple) {
            if (null != this.partialSolutions) {
                LList<PartialSolutionWrapper> cur = this.partialSolutions;
                while (!cur.isNil()) {
                    PartialSolutionWrapper ps = cur.getValue();
                    VarList newBindings = null;
                    TriplePattern matched = ps.triplePattern;
                    if (!matched.getSubject().hasValue()) {
                        newBindings = new VarList(matched.getSubject().getName(), (Value)st.getSubject(), newBindings);
                    }
                    if (!matched.getPredicate().hasValue()) {
                        newBindings = new VarList(matched.getPredicate().getName(), (Value)st.getPredicate(), newBindings);
                    }
                    if (!matched.getObject().hasValue()) {
                        newBindings = new VarList(matched.getObject().getName(), st.getObject(), newBindings);
                    }
                    binder.handle(ps.partialSolution, matched, newBindings);
                    cur = cur.getRest();
                }
            }
        } else {
            TripleIndex child;
            if (null != this.valueIndices && null != (child = this.valueIndices.get(tuple.getValue()))) {
                child.match(tuple.getRest(), st, binder);
            }
            if (null != this.wildcardIndex) {
                this.wildcardIndex.match(tuple.getRest(), st, binder);
            }
        }
    }

    public boolean visitPartialSolutions(Visitor<PartialSolution> v) {
        if (null != this.partialSolutions) {
            LList<PartialSolutionWrapper> cur = this.partialSolutions;
            while (!cur.isNil()) {
                if (!v.visit(cur.getValue().partialSolution)) {
                    return false;
                }
                cur = cur.getRest();
            }
        }
        if (null != this.valueIndices) {
            for (TripleIndex i : this.valueIndices.values()) {
                if (i.visitPartialSolutions(v)) continue;
                return false;
            }
        }
        return null == this.wildcardIndex || this.wildcardIndex.visitPartialSolutions(v);
    }

    public void print() {
        this.printInternal("");
    }

    private void printInternal(String heading) {
        block4: {
            block3: {
                if (null == this.partialSolutions) break block3;
                System.out.println(heading + ":");
                LList<PartialSolutionWrapper> cur = this.partialSolutions;
                while (!cur.isNil()) {
                    System.out.println("\t" + cur.getValue().partialSolution);
                    cur = cur.getRest();
                }
                break block4;
            }
            if (null != this.wildcardIndex) {
                this.wildcardIndex.printInternal(heading + "? ");
            }
            if (null == this.valueIndices) break block4;
            for (Map.Entry<Value, TripleIndex> e : this.valueIndices.entrySet()) {
                e.getValue().printInternal(heading + this.valueToString(e.getKey()) + " ");
            }
        }
    }

    private String valueToString(Value v) {
        if (v instanceof URI) {
            return "<" + v.stringValue() + ">";
        }
        if (v instanceof BNode) {
            return "_:" + v.stringValue();
        }
        if (v instanceof Literal) {
            return "\"" + v.stringValue() + "\"";
        }
        throw new IllegalStateException("value is of unknown type: " + v);
    }

    private class PartialSolutionWrapper {
        public final TriplePattern triplePattern;
        public final PartialSolution partialSolution;

        private PartialSolutionWrapper(TriplePattern triplePattern, PartialSolution partialSolution) {
            this.triplePattern = triplePattern;
            this.partialSolution = partialSolution;
        }
    }
}

