/*
 * Decompiled with CFR 0.152.
 */
package edu.rpi.twc.sesamestream.impl;

import edu.rpi.twc.sesamestream.SesameStream;
import org.openrdf.model.Value;
import org.openrdf.query.algebra.Var;

public class VarList {
    private final String name;
    private final Value value;
    private final VarList rest;

    public VarList(String name, Value value, VarList rest) {
        this.name = name;
        this.value = value;
        this.rest = rest;
        if (SesameStream.getDoDebug()) {
            this.checkForDuplicateName(name);
        }
    }

    private void checkForDuplicateName(String name) {
        if (null == name) {
            return;
        }
        VarList cur = this.getRest();
        while (null != cur) {
            if (name.equals(cur.getName())) {
                throw new IllegalStateException("duplicate name '" + name + "' in VarList: " + this);
            }
            cur = cur.rest;
        }
    }

    public String getName() {
        return this.name;
    }

    public Value getValue() {
        return this.value;
    }

    public VarList getRest() {
        return this.rest;
    }

    public Var asVar() {
        return new Var(this.name, this.value);
    }

    public static VarList union(VarList first, VarList second) {
        VarList cur1 = second;
        VarList cur2 = first;
        while (null != cur2) {
            cur1 = new VarList(cur2.name, cur2.value, cur1);
            cur2 = cur2.rest;
        }
        return cur1;
    }

    public int length() {
        VarList cur = this;
        int l = 0;
        while (cur != null) {
            ++l;
            cur = cur.rest;
        }
        return l;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("VarList(");
        boolean first = true;
        VarList cur = this;
        while (null != cur) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(cur.name).append(":").append(cur.value);
            cur = cur.rest;
        }
        sb.append(")");
        return sb.toString();
    }
}

