/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.automan.core.scheduler;

import edu.umass.cs.automan.core.AutomanAdapter;
import edu.umass.cs.automan.core.answer.AbstractAnswer;
import edu.umass.cs.automan.core.exception.OverBudgetException;
import edu.umass.cs.automan.core.logging.DebugLog$;
import edu.umass.cs.automan.core.logging.LogLevelDebug;
import edu.umass.cs.automan.core.logging.LogLevelInfo;
import edu.umass.cs.automan.core.logging.LogLevelWarn;
import edu.umass.cs.automan.core.logging.LogType$;
import edu.umass.cs.automan.core.mock.MockAnswer;
import edu.umass.cs.automan.core.policy.validation.ValidationPolicy;
import edu.umass.cs.automan.core.question.Question;
import edu.umass.cs.automan.core.scheduler.SchedulerState$;
import edu.umass.cs.automan.core.scheduler.Task;
import edu.umass.cs.automan.core.util.Stopwatch$;
import edu.umass.cs.automan.core.util.Time;
import edu.umass.cs.automan.core.util.Utilities$;
import java.util.Date;
import java.util.UUID;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.PriorityQueue;
import scala.collection.mutable.StringBuilder;
import scala.math.BigDecimal;
import scala.math.Ordering;
import scala.math.PartialOrdering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong;

@ScalaSignature(bytes="\u0006\u0001\u00055h\u0001B\u0001\u0003\u0001=\u0011\u0011bU2iK\u0012,H.\u001a:\u000b\u0005\r!\u0011!C:dQ\u0016$W\u000f\\3s\u0015\t)a!\u0001\u0003d_J,'BA\u0004\t\u0003\u001d\tW\u000f^8nC:T!!\u0003\u0006\u0002\u0005\r\u001c(BA\u0006\r\u0003\u0015)X.Y:t\u0015\u0005i\u0011aA3ek\u000e\u00011C\u0001\u0001\u0011!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fM\"Aq\u0003\u0001BC\u0002\u0013\u0005\u0001$\u0001\u0005rk\u0016\u001cH/[8o+\u0005I\u0002C\u0001\u000e\u001d\u001b\u0005Y\"BA\f\u0005\u0013\ti2D\u0001\u0005Rk\u0016\u001cH/[8o\u0011!y\u0002A!A!\u0002\u0013I\u0012!C9vKN$\u0018n\u001c8!\u0011!\t\u0003A!b\u0001\n\u0003\u0011\u0013a\u00022bG.,g\u000eZ\u000b\u0002GA\u0011A%J\u0007\u0002\t%\u0011a\u0005\u0002\u0002\u000f\u0003V$x.\\1o\u0003\u0012\f\u0007\u000f^3s\u0011!A\u0003A!A!\u0002\u0013\u0019\u0013\u0001\u00032bG.,g\u000e\u001a\u0011\t\u000b)\u0002A\u0011A\u0016\u0002\rqJg.\u001b;?)\racf\f\t\u0003[\u0001i\u0011A\u0001\u0005\u0006/%\u0002\r!\u0007\u0005\u0006C%\u0002\ra\t\u0005\bc\u0001\u0011\r\u0011\"\u00013\u0003%Ig.\u001b;`i&lW-F\u00014!\t!\u0014(D\u00016\u0015\t1t'\u0001\u0003vi&d'\"\u0001\u001d\u0002\t)\fg/Y\u0005\u0003uU\u0012A\u0001R1uK\"1A\b\u0001Q\u0001\nM\n!\"\u001b8ji~#\u0018.\\3!\u0011\u001dq\u0004A1A\u0005\u0002}\n\u0001\"^:f?ZL'\u000f^\u000b\u0002\u0001B\u0011\u0011#Q\u0005\u0003\u0005J\u0011qAQ8pY\u0016\fg\u000e\u0003\u0004E\u0001\u0001\u0006I\u0001Q\u0001\nkN,wL^5si\u0002BQA\u0012\u0001\u0005\u0002\u001d\u000b1A];o)\u0005A\u0005CA\rJ\u0013\tQED\u0001\u0002B\u0003\")A\n\u0001C\u0005\u001b\u0006i\u0011N\\5u)&\u001c7.U;fk\u0016,\"A\u00149\u0015\u0005=S\u0006c\u0001)V/6\t\u0011K\u0003\u0002S'\u00069Q.\u001e;bE2,'B\u0001+\u0013\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003-F\u0013Q\u0002\u0015:j_JLG/_)vKV,\u0007CA\tY\u0013\tI&C\u0001\u0003M_:<\u0007\"B.L\u0001\u0004a\u0016aA1ogB\u0019Q,\u001a5\u000f\u0005y\u001bgBA0c\u001b\u0005\u0001'BA1\u000f\u0003\u0019a$o\\8u}%\t1#\u0003\u0002e%\u00059\u0001/Y2lC\u001e,\u0017B\u00014h\u0005\u0011a\u0015n\u001d;\u000b\u0005\u0011\u0014\u0002cA5m]6\t!N\u0003\u0002l\t\u0005!Qn\\2l\u0013\ti'N\u0001\u0006N_\u000e\\\u0017I\\:xKJ\u0004\"a\u001c9\r\u0001\u0011)\u0011o\u0013b\u0001e\n\t\u0011)\u0005\u0002tmB\u0011\u0011\u0003^\u0005\u0003kJ\u0011qAT8uQ&tw\r\u0005\u0002\u0012o&\u0011\u0001P\u0005\u0002\u0004\u0003:L\b\"\u0002>\u0001\t\u0013Y\u0018A\u0003;bg.\u001cF/\u0019;vgR\u0019A0!\u0004\u0011\ru\f\t!a\u00024\u001d\t\tb0\u0003\u0002\u0000%\u00051\u0001K]3eK\u001aLA!a\u0001\u0002\u0006\t\u0019Q*\u00199\u000b\u0005}\u0014\u0002c\u0001\u001b\u0002\n%\u0019\u00111B\u001b\u0003\tU+\u0016\n\u0012\u0005\b\u0003\u001fI\b\u0019AA\t\u0003\t!8\u000f\u0005\u0003^K\u0006M\u0001cA\u0017\u0002\u0016%\u0019\u0011q\u0003\u0002\u0003\tQ\u000b7o\u001b\u0005\b\u00037\u0001A\u0011BA\u000f\u0003-!\u0018m]6J]N,'\u000f^:\u0015\r\u0005}\u0011\u0011EA\u0013!\u0011iV-a\u0002\t\u000f\u0005\r\u0012\u0011\u0004a\u0001y\u00061a.Z<NCBDq!a\n\u0002\u001a\u0001\u0007A0\u0001\u0004pY\u0012l\u0015\r\u001d\u0005\b\u0003W\u0001A\u0011BA\u0017\u0003-!\u0018m]6Va\u0012\fG/Z:\u0015\r\u0005}\u0011qFA\u0019\u0011\u001d\t\u0019#!\u000bA\u0002qDq!a\n\u0002*\u0001\u0007A\u0010C\u0004\u00026\u0001!I!a\u000e\u0002\u0011I,\u0017\r\u001c+jG.$\u0012a\u0016\u0005\b\u0003w\u0001A\u0011BA\u001f\u0003!\u0011XO\\0m_>\u0004Hc\u0001%\u0002@!A\u0011\u0011IA\u001d\u0001\u0004\t\t\"A\u0003uCN\\7\u000fC\u0004\u0002F\u0001!\t!a\u0012\u0002!A\u0014xnY3tg~#\u0018.\\3pkR\u001cHCBA%\u0003\u001f\n\t\u0006\u0005\u0004\u0012\u0003\u0017\n\t\u0002Q\u0005\u0004\u0003\u001b\u0012\"A\u0002+va2,'\u0007\u0003\u0005\u0002\u0010\u0005\r\u0003\u0019AA\t\u0011\u001d\t\u0019&a\u0011A\u0002]\u000bAbY;se\u0016tGo\u0018;jG.Dq!a\u0016\u0001\t\u0003\tI&\u0001\bq_N$x,Y:`]\u0016,G-\u001a3\u0015\u0019\u0005E\u00111LA/\u0003?\n\t'!\u001a\t\u0011\u0005\u0005\u0013Q\u000ba\u0001\u0003#Aa!IA+\u0001\u0004\u0019\u0003BB\f\u0002V\u0001\u0007\u0011\u0004C\u0004\u0002d\u0005U\u0003\u0019\u0001!\u0002!M,hMZ3sK\u0012|F/[7f_V$\b\u0002CA4\u0003+\u0002\r!!\u001b\u0002\u0013\td\u0017mY6mSN$\b\u0003B/f\u0003W\u00022!`A7\u0013\u0011\ty'!\u0002\u0003\rM#(/\u001b8h\u0011\u001d\t\u0019\b\u0001C\u0001\u0003k\n\u0001$Y2dKB$xL]3kK\u000e$x,\u00198e?\u000e\fgnY3m+\u0011\t9(a%\u0015\u0011\u0005E\u0011\u0011PA?\u0003#C\u0001\"a\u001f\u0002r\u0001\u0007\u0011\u0011C\u0001\nC2dw\f^1tWND\u0001\"a \u0002r\u0001\u0007\u0011\u0011Q\u0001\tgR\u0014\u0018\r^3hsB!\u00111QAG\u001b\t\t)I\u0003\u0003\u0002\b\u0006%\u0015A\u0003<bY&$\u0017\r^5p]*\u0019\u00111\u0012\u0003\u0002\rA|G.[2z\u0013\u0011\ty)!\"\u0003!Y\u000bG.\u001b3bi&|g\u000eU8mS\u000eL\bBB\u0011\u0002r\u0001\u00071\u0005\u0002\u0004r\u0003c\u0012\rA\u001d\u0005\b\u0003/\u0003A\u0011AAM\u0003)!x\u000e^1m?\u000e|7\u000f^\u000b\u0005\u00037\u000b)\u000b\u0006\u0003\u0002\u001e\u0006\r\u0006cA/\u0002 &\u0019\u0011\u0011U4\u0003\u0015\tKw\rR3dS6\fG\u000e\u0003\u0005\u0002B\u0005U\u0005\u0019AA\t\t\u0019\t\u0018Q\u0013b\u0001e\"9\u0011\u0011\u0016\u0001\u0005\u0002\u0005-\u0016A\u0005:fiJLWM^3`S:4\u0018M]5b]R,B!!,\u00028R)\u0001)a,\u00024\"A\u0011\u0011WAT\u0001\u0004\t\t\"A\u0004sk:t\u0017N\\4\t\u0011\u0005U\u0016q\u0015a\u0001\u0003#\t\u0001\"\u00198to\u0016\u0014X\r\u001a\u0003\u0007c\u0006\u001d&\u0019\u0001:\t\u000f\u0005m\u0006\u0001\"\u0001\u0002>\u0006y1\u000f]1x]~KgN^1sS\u0006tG/\u0006\u0003\u0002@\u0006\u0015Gc\u0001!\u0002B\"A\u00111YA]\u0001\u0004\t\t\"A\u0005oK^|F/Y:lg\u00121\u0011/!/C\u0002IDq!!3\u0001\t\u0003\tY-A\tbY2|6/\u001a;`S:4\u0018M]5b]R,B!!4\u0002lR9\u0001)a4\u0002T\u0006]\u0007\u0002CAi\u0003\u000f\u0004\r!!\u0005\u0002\r\t,gm\u001c:f\u0011!\t).a2A\u0002\u0005E\u0011!B1gi\u0016\u0014\b\u0002CAm\u0003\u000f\u0004\r!a7\u0002\u000bM$\u0018\r^3\u0011\t\u0005u\u00171\u001d\b\u0004[\u0005}\u0017bAAq\u0005\u0005q1k\u00195fIVdWM]*uCR,\u0017\u0002BAs\u0003O\u0014QAV1mk\u0016L1!!;\u0013\u0005-)e.^7fe\u0006$\u0018n\u001c8\u0005\rE\f9M1\u0001s\u0001")
public class Scheduler {
    private final Question question;
    private final AutomanAdapter backend;
    private final Date init_time;
    private final boolean use_virt;

    public Question question() {
        return this.question;
    }

    public AutomanAdapter backend() {
        return this.backend;
    }

    public Date init_time() {
        return this.init_time;
    }

    public boolean use_virt() {
        return this.use_virt;
    }

    public AbstractAnswer run() {
        this.backend().question_startup_hook(this.question(), this.init_time());
        List<Task> tasks = this.backend().memo_restore(this.question());
        DebugLog$.MODULE$.apply(new StringBuilder().append((Object)"Found ").append((Object)BoxesRunTime.boxToInteger((int)tasks.size())).append((Object)" saved Tasks in database with ").append((Object)BoxesRunTime.boxToInteger((int)tasks.count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Task x$1) {
                return x$1.answer().isDefined();
            }
        }))).append((Object)" answers.").toString(), new LogLevelInfo(), LogType$.MODULE$.SCHEDULER(), this.question().id());
        return this.run_loop(tasks);
    }

    /*
     * WARNING - void declaration
     */
    private <A> PriorityQueue<Object> initTickQueue(List<MockAnswer<A>> ans) {
        void var3_3;
        BoxedUnit boxedUnit;
        Ordering<Object> timeOrd = new Ordering<Object>(this){

            public Some tryCompare(Object x, Object y) {
                return Ordering.class.tryCompare((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lteq(Object x, Object y) {
                return Ordering.class.lteq((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gteq(Object x, Object y) {
                return Ordering.class.gteq((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lt(Object x, Object y) {
                return Ordering.class.lt((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gt(Object x, Object y) {
                return Ordering.class.gt((Ordering)this, (Object)x, (Object)y);
            }

            public boolean equiv(Object x, Object y) {
                return Ordering.class.equiv((Ordering)this, (Object)x, (Object)y);
            }

            public Object max(Object x, Object y) {
                return Ordering.class.max((Ordering)this, (Object)x, (Object)y);
            }

            public Object min(Object x, Object y) {
                return Ordering.class.min((Ordering)this, (Object)x, (Object)y);
            }

            public Ordering<Object> reverse() {
                return Ordering.class.reverse((Ordering)this);
            }

            public <U> Ordering<U> on(Function1<U, Object> f) {
                return Ordering.class.on((Ordering)this, f);
            }

            public Ordering.Ops mkOrderingOps(Object lhs) {
                return Ordering.class.mkOrderingOps((Ordering)this, (Object)lhs);
            }

            public int compare(long o1, long o2) {
                return -new RichLong(Predef$.MODULE$.longWrapper(o1)).compare((Object)BoxesRunTime.boxToLong((long)o2));
            }
            {
                PartialOrdering.class.$init$((PartialOrdering)this);
                Ordering.class.$init$((Ordering)this);
            }
        };
        PriorityQueue q = new PriorityQueue((Ordering)timeOrd);
        if (ans.nonEmpty()) {
            List times = (List)((SeqLike)ans.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final long apply(MockAnswer<A> x$2) {
                    return x$2.time_delta_in_ms();
                }
            }, List$.MODULE$.canBuildFrom())).distinct();
            q.$plus$plus$eq((TraversableOnce)times);
            boxedUnit = new Some((Object)q);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return var3_3;
    }

    private Map<UUID, Date> taskStatus(List<Task> ts) {
        return ((TraversableOnce)ts.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<UUID, Date> apply(Task t) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t.task_id()), (Object)t.state_changed_at());
            }
        }, List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private List<UUID> taskInserts(Map<UUID, Date> newMap, Map<UUID, Date> oldMap) {
        return ((TraversableOnce)((TraversableLike)newMap.filter((Function1)new Serializable(this, oldMap){
            public static final long serialVersionUID = 0L;
            private final Map oldMap$1;

            public final boolean apply(Tuple2<UUID, Date> x0$1) {
                Tuple2<UUID, Date> tuple2 = x0$1;
                if (tuple2 != null) {
                    UUID uuid = (UUID)tuple2._1();
                    boolean bl = !this.oldMap$1.contains((Object)uuid);
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                this.oldMap$1 = oldMap$1;
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final UUID apply(Tuple2<UUID, Date> x0$2) {
                Tuple2<UUID, Date> tuple2 = x0$2;
                if (tuple2 != null) {
                    UUID uuid;
                    UUID uUID = uuid = (UUID)tuple2._1();
                    return uUID;
                }
                throw new MatchError(tuple2);
            }
        }, Iterable$.MODULE$.canBuildFrom())).toList();
    }

    private List<UUID> taskUpdates(Map<UUID, Date> newMap, Map<UUID, Date> oldMap) {
        return ((TraversableOnce)((TraversableLike)newMap.filter((Function1)new Serializable(this, oldMap){
            public static final long serialVersionUID = 0L;
            private final Map oldMap$2;

            public final boolean apply(Tuple2<UUID, Date> x0$3) {
                Tuple2<UUID, Date> tuple2 = x0$3;
                if (tuple2 != null) {
                    UUID uuid = (UUID)tuple2._1();
                    Date date = (Date)tuple2._2();
                    boolean bl = this.oldMap$2.contains((Object)uuid) && date.after((Date)this.oldMap$2.apply((Object)uuid));
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                this.oldMap$2 = oldMap$2;
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final UUID apply(Tuple2<UUID, Date> x0$4) {
                Tuple2<UUID, Date> tuple2 = x0$4;
                if (tuple2 != null) {
                    UUID uuid;
                    UUID uUID = uuid = (UUID)tuple2._1();
                    return uUID;
                }
                throw new MatchError(tuple2);
            }
        }, Iterable$.MODULE$.canBuildFrom())).toList();
    }

    public long edu$umass$cs$automan$core$scheduler$Scheduler$$realTick() {
        return Utilities$.MODULE$.elapsedMilliseconds(this.init_time(), new Date());
    }

    private AbstractAnswer run_loop(List<Task> tasks) {
        AbstractAnswer abstractAnswer;
        long l;
        int _update_frequency_ms = this.question().update_frequency_ms();
        PriorityQueue<Object> _virtual_times = this.initTickQueue(this.question().mock_answers());
        if (_virtual_times.nonEmpty()) {
            long ct = BoxesRunTime.unboxToLong((Object)_virtual_times.dequeue());
            DebugLog$.MODULE$.apply(new StringBuilder().append((Object)"Virtual clock starts at ").append((Object)BoxesRunTime.boxToLong((long)ct)).append((Object)" ms.").toString(), new LogLevelDebug(), LogType$.MODULE$.SCHEDULER(), this.question().id());
            l = ct;
        } else {
            l = 0L;
        }
        LongRef _current_time = LongRef.create((long)l);
        ValidationPolicy _vp = this.question().validation_policy_instance();
        Map<UUID, Date> _status_changeset = this.taskStatus(tasks);
        boolean _timeout_occurred = false;
        ObjectRef _all_tasks = ObjectRef.create(tasks);
        BooleanRef _done = BooleanRef.create((boolean)_vp.is_done((List<Task>)((List)_all_tasks.elem)));
        try {
            while (true) {
                if (_done.elem) {
                    _all_tasks.elem = this.accept_reject_and_cancel((List<Task>)((List)_all_tasks.elem), _vp, this.backend());
                    abstractAnswer = _vp.select_answer((List<Task>)((List)_all_tasks.elem));
                    break;
                }
                Time __duration = Stopwatch$.MODULE$.apply(new Serializable(this, _virtual_times, _current_time, _vp, _all_tasks, _done){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Scheduler $outer;
                    private final PriorityQueue _virtual_times$1;
                    private final LongRef _current_time$1;
                    private final ValidationPolicy _vp$1;
                    private final ObjectRef _all_tasks$1;
                    private final BooleanRef _done$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        Tuple2<List<Task>, Object> tuple2 = this.$outer.process_timeouts((List<Task>)((List)this._all_tasks$1.elem), this._current_time$1.elem);
                        if (tuple2 != null) {
                            Tuple2 tuple22;
                            List __tasks = (List)tuple2._1();
                            boolean __suffered_timeout = tuple2._2$mcZ$sp();
                            Tuple2 tuple23 = tuple22 = new Tuple2((Object)__tasks, (Object)BoxesRunTime.boxToBoolean((boolean)__suffered_timeout));
                            List __tasks2 = (List)tuple23._1();
                            boolean __suffered_timeout2 = tuple23._2$mcZ$sp();
                            List<String> __blacklist = this._vp$1.blacklisted_workers((List<Task>)__tasks2);
                            List<Task> __dedup_tasks = this._vp$1.mark_duplicates((List<Task>)__tasks2);
                            List<Task> __new_tasks = this.$outer.post_as_needed(__dedup_tasks, this.$outer.backend(), this.$outer.question(), __suffered_timeout2, __blacklist);
                            Object object = this.$outer.use_virt() ? this._virtual_times$1.$plus$plus$eq((TraversableOnce)((List)((SeqLike)__new_tasks.map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final int apply(Task x$4) {
                                    return x$4.timeout_in_s();
                                }
                            }, List$.MODULE$.canBuildFrom())).distinct()).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final long apply(int x$5) {
                                    return this.apply$mcJI$sp(x$5);
                                }

                                public long apply$mcJI$sp(int x$5) {
                                    return (long)x$5 * 1000L;
                                }
                            }, List$.MODULE$.canBuildFrom())) : BoxedUnit.UNIT;
                            List<Task> list = __dedup_tasks;
                            Tuple2 tuple24 = __new_tasks.$colon$colon$colon(list).partition((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(Task x$7) {
                                    Enumeration.Value value = x$7.state();
                                    Enumeration.Value value2 = SchedulerState$.MODULE$.RUNNING();
                                    return !(value != null ? !value.equals(value2) : value2 != null);
                                }
                            });
                            if (tuple24 != null) {
                                long l;
                                Tuple2 tuple25;
                                List __running_tasks = (List)tuple24._1();
                                List __unrunning_tasks = (List)tuple24._2();
                                Tuple2 tuple26 = tuple25 = new Tuple2((Object)__running_tasks, (Object)__unrunning_tasks);
                                List __running_tasks2 = (List)tuple26._1();
                                List __unrunning_tasks2 = (List)tuple26._2();
                                Predef$.MODULE$.assert(__running_tasks2.size() > 0);
                                DebugLog$.MODULE$.apply(new StringBuilder().append((Object)"Retrieving answers for ").append((Object)BoxesRunTime.boxToInteger((int)__running_tasks2.size())).append((Object)" running tasks from backend.").toString(), new LogLevelInfo(), LogType$.MODULE$.SCHEDULER(), this.$outer.question().id());
                                List<Task> __answered_tasks = this.$outer.backend().retrieve((List<Task>)__running_tasks2, Utilities$.MODULE$.xMillisecondsFromDate(this._current_time$1.elem, this.$outer.init_time()));
                                Predef$.MODULE$.assert(this.$outer.retrieve_invariant((List<Task>)__running_tasks2, __answered_tasks));
                                List<Task> list2 = __answered_tasks;
                                List __all_tasks = __unrunning_tasks2.$colon$colon$colon(list2);
                                this._done$1.elem = this._vp$1.is_done((List<Task>)__all_tasks);
                                this._all_tasks$1.elem = __all_tasks;
                                if (this.$outer.use_virt()) {
                                    long t = this._virtual_times$1.nonEmpty() ? BoxesRunTime.unboxToLong((Object)this._virtual_times$1.dequeue()) : this._current_time$1.elem + 1000L;
                                    DebugLog$.MODULE$.apply(new StringBuilder().append((Object)"Advancing virtual clock to ").append((Object)BoxesRunTime.boxToLong((long)t)).append((Object)" ms.").toString(), new LogLevelDebug(), LogType$.MODULE$.SCHEDULER(), this.$outer.question().id());
                                    l = t;
                                } else {
                                    l = this.$outer.edu$umass$cs$automan$core$scheduler$Scheduler$$realTick();
                                }
                                this._current_time$1.elem = l;
                                return;
                            }
                            throw new MatchError((Object)tuple24);
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this._virtual_times$1 = _virtual_times$1;
                        this._current_time$1 = _current_time$1;
                        this._vp$1 = _vp$1;
                        this._all_tasks$1 = _all_tasks$1;
                        this._done$1 = _done$1;
                    }
                });
                if (_done.elem || __duration.duration_ms() >= (long)_update_frequency_ms) continue;
                long t = (long)_update_frequency_ms - __duration.duration_ms();
                DebugLog$.MODULE$.apply(new StringBuilder().append((Object)"Putting scheduler to sleep for ").append((Object)BoxesRunTime.boxToLong((long)t)).append((Object)" ms.").toString(), new LogLevelDebug(), LogType$.MODULE$.SCHEDULER(), this.question().id());
                Thread.sleep(t);
            }
        }
        catch (OverBudgetException overBudgetException) {
            abstractAnswer = _vp.select_over_budget_answer((List<Task>)((List)_all_tasks.elem), overBudgetException.need(), overBudgetException.have());
        }
        AbstractAnswer answer = abstractAnswer;
        this.backend().question_shutdown_hook(this.question());
        return answer;
    }

    public Tuple2<List<Task>, Object> process_timeouts(List<Task> ts, long current_tick) {
        Tuple2 tuple2 = ts.partition((Function1)new Serializable(this, current_tick){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Scheduler $outer;
            private final long current_tick$1;

            public final boolean apply(Task t) {
                Enumeration.Value value = t.state();
                Enumeration.Value value2 = SchedulerState$.MODULE$.RUNNING();
                return !(value != null ? !value.equals(value2) : value2 != null) && t.is_timedout(Utilities$.MODULE$.xMillisecondsFromDate(this.current_tick$1, this.$outer.init_time()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.current_tick$1 = current_tick$1;
            }
        });
        if (tuple2 != null) {
            Tuple2 tuple22;
            Tuple2 tuple23;
            List timeouts = (List)tuple2._1();
            List otherwise = (List)tuple2._2();
            Tuple2 tuple24 = tuple23 = new Tuple2((Object)timeouts, (Object)otherwise);
            List timeouts2 = (List)tuple24._1();
            List otherwise2 = (List)tuple24._2();
            if (timeouts2.nonEmpty()) {
                List timed_out;
                DebugLog$.MODULE$.apply(new StringBuilder().append((Object)"Cancelling ").append((Object)BoxesRunTime.boxToInteger((int)timeouts2.size())).append((Object)" timed-out tasks.").toString(), new LogLevelInfo(), LogType$.MODULE$.SCHEDULER(), this.question().id());
                List list = timed_out = (List)this.backend().cancel((List<Task>)timeouts2).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Task apply(Task x$11) {
                        return x$11.copy_as_timeout();
                    }
                }, List$.MODULE$.canBuildFrom());
                Tuple2 tuple25 = new Tuple2((Object)otherwise2.$colon$colon$colon(list), (Object)BoxesRunTime.boxToBoolean((boolean)timeouts2.nonEmpty()));
                tuple22 = tuple25;
            } else {
                tuple22 = new Tuple2(ts, (Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
            return tuple22;
        }
        throw new MatchError((Object)tuple2);
    }

    public List<Task> post_as_needed(List<Task> tasks, AutomanAdapter backend, Question question, boolean suffered_timeout, List<String> blacklist) {
        List<Task> list;
        ValidationPolicy s = question.validation_policy_instance();
        if (tasks.count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Task x$13) {
                Enumeration.Value value = x$13.state();
                Enumeration.Value value2 = SchedulerState$.MODULE$.RUNNING();
                return !(value != null ? !value.equals(value2) : value2 != null);
            }
        }) == 0) {
            List<Task> new_tasks = s.spawn(tasks, suffered_timeout);
            Predef$.MODULE$.assert(this.spawn_invariant(new_tasks));
            List<Task> list2 = tasks;
            BigDecimal cost = this.total_cost((List<Task>)new_tasks.$colon$colon$colon(list2));
            if (question.budget().$less(cost)) {
                DebugLog$.MODULE$.apply(new StringBuilder().append((Object)"Over budget. Need: ").append((Object)cost.toString()).append((Object)", have: ").append((Object)question.budget().toString()).toString(), new LogLevelWarn(), LogType$.MODULE$.SCHEDULER(), question.id());
                throw new OverBudgetException(cost, question.budget());
            }
            List<Task> posted = backend.post(new_tasks, blacklist);
            DebugLog$.MODULE$.apply(new StringBuilder().append((Object)"Posting ").append((Object)BoxesRunTime.boxToInteger((int)posted.size())).append((Object)" tasks to backend.").toString(), new LogLevelInfo(), LogType$.MODULE$.SCHEDULER(), question.id());
            list = posted;
        } else {
            list = List$.MODULE$.empty();
        }
        return list;
    }

    public <A> List<Task> accept_reject_and_cancel(List<Task> all_tasks, ValidationPolicy strategy, AutomanAdapter backend) {
        List<Task> to_cancel = strategy.tasks_to_cancel(all_tasks);
        List<Task> to_accept = strategy.tasks_to_accept(all_tasks);
        List<Task> to_reject = strategy.tasks_to_reject(all_tasks);
        Predef$.MODULE$.assert(to_accept.forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Task x$15) {
                Enumeration.Value value = x$15.state();
                Enumeration.Value value2 = SchedulerState$.MODULE$.ANSWERED();
                return !(value != null ? !value.equals(value2) : value2 != null);
            }
        }), (Function0)new Serializable(this, all_tasks){
            public static final long serialVersionUID = 0L;
            private final List all_tasks$1;

            public final String apply() {
                return ((TraversableOnce)this.all_tasks$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Enumeration.Value apply(Task x$16) {
                        return x$16.state();
                    }
                }, List$.MODULE$.canBuildFrom())).mkString(", ");
            }
            {
                this.all_tasks$1 = all_tasks$1;
            }
        });
        Predef$.MODULE$.assert(to_reject.forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Task x$17) {
                Enumeration.Value value = x$17.state();
                Enumeration.Value value2 = SchedulerState$.MODULE$.ANSWERED();
                return !(value != null ? !value.equals(value2) : value2 != null);
            }
        }), (Function0)new Serializable(this, all_tasks){
            public static final long serialVersionUID = 0L;
            private final List all_tasks$1;

            public final String apply() {
                return ((TraversableOnce)this.all_tasks$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Enumeration.Value apply(Task x$18) {
                        return x$18.state();
                    }
                }, List$.MODULE$.canBuildFrom())).mkString(", ");
            }
            {
                this.all_tasks$1 = all_tasks$1;
            }
        });
        String correct_answer = strategy.rejection_response(to_accept);
        List<Task> list = to_cancel;
        List<Task> list2 = to_accept;
        List action_items = to_reject.$colon$colon$colon(list2).$colon$colon$colon(list);
        List remaining_tasks = (List)all_tasks.filterNot((Function1)new Serializable(this, action_items){
            public static final long serialVersionUID = 0L;
            private final List action_items$1;

            public final boolean apply(Task x$21) {
                return this.action_items$1.contains((Object)x$21);
            }
            {
                this.action_items$1 = action_items$1;
            }
        });
        List<Task> cancelled = to_cancel.nonEmpty() ? backend.cancel(to_cancel) : List$.MODULE$.empty();
        Predef$.MODULE$.assert(this.all_set_invariant(to_cancel, cancelled, SchedulerState$.MODULE$.CANCELLED()));
        List<Task> accepted = to_accept.nonEmpty() ? backend.accept(to_accept) : List$.MODULE$.empty();
        Predef$.MODULE$.assert(this.all_set_invariant(to_accept, accepted, SchedulerState$.MODULE$.ACCEPTED()));
        List<Task> rejected = to_reject.nonEmpty() ? backend.reject((List<Tuple2<Task, String>>)((List)to_reject.map((Function1)new Serializable(this, correct_answer){
            public static final long serialVersionUID = 0L;
            private final String correct_answer$1;

            public final Tuple2<Task, String> apply(Task t) {
                return new Tuple2((Object)t, (Object)this.correct_answer$1);
            }
            {
                this.correct_answer$1 = correct_answer$1;
            }
        }, List$.MODULE$.canBuildFrom()))) : List$.MODULE$.empty();
        Predef$.MODULE$.assert(this.all_set_invariant(to_reject, rejected, SchedulerState$.MODULE$.REJECTED()));
        List list3 = remaining_tasks;
        List<Task> list4 = cancelled;
        List<Task> list5 = accepted;
        return rejected.$colon$colon$colon(list5).$colon$colon$colon(list4).$colon$colon$colon(list3);
    }

    public <A> BigDecimal total_cost(List<Task> tasks) {
        return (BigDecimal)((LinearSeqOptimized)tasks.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(Task t) {
                Enumeration.Value value = t.state();
                Enumeration.Value value2 = SchedulerState$.MODULE$.CANCELLED();
                if (value == null) {
                    if (value2 == null) return false;
                } else if (value.equals(value2)) return false;
                Enumeration.Value value3 = t.state();
                Enumeration.Value value4 = SchedulerState$.MODULE$.DUPLICATE();
                if (value3 == null) {
                    if (value4 == null) return false;
                } else if (value3.equals(value4)) return false;
                Enumeration.Value value5 = t.state();
                Enumeration.Value value6 = SchedulerState$.MODULE$.TIMEOUT();
                if (value5 == null) {
                    if (value6 == null) return false;
                } else if (value5.equals(value6)) return false;
                Enumeration.Value value7 = t.state();
                Enumeration.Value value8 = SchedulerState$.MODULE$.REJECTED();
                if (value7 == null) {
                    if (value8 == null) return false;
                } else if (value7.equals(value8)) return false;
                if (!t.from_memo()) return true;
                return false;
            }
        })).foldLeft((Object)package$.MODULE$.BigDecimal().apply(0), (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final BigDecimal apply(BigDecimal x0$5, Task x1$1) {
                Tuple2 tuple2 = new Tuple2((Object)x0$5, (Object)x1$1);
                if (tuple2 != null) {
                    BigDecimal acc = (BigDecimal)tuple2._1();
                    Task t = (Task)tuple2._2();
                    BigDecimal bigDecimal = acc.$plus(t.cost());
                    return bigDecimal;
                }
                throw new MatchError((Object)tuple2);
            }
        });
    }

    public <A> boolean retrieve_invariant(List<Task> running, List<Task> answered) {
        return running.count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Task x$25) {
                Enumeration.Value value = x$25.state();
                Enumeration.Value value2 = SchedulerState$.MODULE$.RUNNING();
                return !(value != null ? !value.equals(value2) : value2 != null);
            }
        }) == running.size() && answered.size() == running.size() && answered.count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(Task t) {
                Enumeration.Value value = t.state();
                Enumeration.Value value2 = SchedulerState$.MODULE$.RUNNING();
                if (value == null) {
                    if (value2 == null) return true;
                } else if (value.equals(value2)) return true;
                Enumeration.Value value3 = t.state();
                Enumeration.Value value4 = SchedulerState$.MODULE$.ANSWERED();
                if (value3 == null) {
                    if (value4 == null) return true;
                } else if (value3.equals(value4)) return true;
                Enumeration.Value value5 = t.state();
                Enumeration.Value value6 = SchedulerState$.MODULE$.DUPLICATE();
                if (value5 == null) {
                    if (value6 == null) return true;
                } else if (value5.equals(value6)) return true;
                Enumeration.Value value7 = t.state();
                Enumeration.Value value8 = SchedulerState$.MODULE$.TIMEOUT();
                if (value7 != null) {
                    if (!value7.equals(value8)) return false;
                    return true;
                }
                if (value8 == null) return true;
                return false;
            }
        }) == running.size();
    }

    public <A> boolean spawn_invariant(List<Task> new_tasks) {
        return new_tasks.size() != 0;
    }

    public <A> boolean all_set_invariant(List<Task> before, List<Task> after, Enumeration.Value state) {
        Set after_set = ((TraversableOnce)after.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final UUID apply(Task t) {
                return t.task_id();
            }
        }, List$.MODULE$.canBuildFrom())).toSet();
        return BoxesRunTime.unboxToBoolean((Object)before.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2)new Serializable(this, after_set){
            public static final long serialVersionUID = 0L;
            private final Set after_set$1;

            public final boolean apply(boolean x0$6, Task x1$2) {
                Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)x0$6), (Object)x1$2);
                if (tuple2 != null) {
                    boolean acc = tuple2._1$mcZ$sp();
                    Task t = (Task)tuple2._2();
                    boolean bl = acc && this.after_set$1.contains((Object)t.task_id());
                    return bl;
                }
                throw new MatchError((Object)tuple2);
            }
            {
                this.after_set$1 = after_set$1;
            }
        }));
    }

    public Scheduler(Question question, AutomanAdapter backend) {
        this.question = question;
        this.backend = backend;
        this.init_time = new Date();
        this.use_virt = question.mock_answers().nonEmpty();
        question.init_validation_policy();
        question.init_price_policy();
        question.init_timeout_policy();
    }
}

