/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.automan.adapters.mturk.worker;

import com.amazonaws.mturk.requester.Assignment;
import com.amazonaws.mturk.requester.Comparator;
import com.amazonaws.mturk.requester.HIT;
import com.amazonaws.mturk.requester.QualificationRequest;
import com.amazonaws.mturk.requester.QualificationRequirement;
import com.amazonaws.mturk.requester.QualificationType;
import com.amazonaws.mturk.service.axis.RequesterService;
import edu.umass.cs.automan.adapters.mturk.question.MTurkQuestion;
import edu.umass.cs.automan.adapters.mturk.worker.HITState;
import edu.umass.cs.automan.adapters.mturk.worker.HITState$;
import edu.umass.cs.automan.adapters.mturk.worker.HITType;
import edu.umass.cs.automan.adapters.mturk.worker.MTState;
import edu.umass.cs.automan.core.logging.DebugLog$;
import edu.umass.cs.automan.core.logging.LogLevelDebug;
import edu.umass.cs.automan.core.logging.LogLevelInfo;
import edu.umass.cs.automan.core.logging.LogType$;
import edu.umass.cs.automan.core.question.Question;
import edu.umass.cs.automan.core.scheduler.Task;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class MTurkMethods$ {
    public static final MTurkMethods$ MODULE$;
    private final int WORKER_TIMEOUT_EPSILON_S;

    static {
        new MTurkMethods$();
    }

    public int WORKER_TIMEOUT_EPSILON_S() {
        return this.WORKER_TIMEOUT_EPSILON_S;
    }

    public MTurkQuestion mtquestion_for_tasks(List<Task> ts) {
        Question question = this.question_for_tasks(ts);
        if (question instanceof MTurkQuestion) {
            Question question2 = question;
            MTurkQuestion mTurkQuestion = (MTurkQuestion)((Object)question2);
            return mTurkQuestion;
        }
        throw new Exception("MTurkAdapter can only operate on Tasks for MTurkQuestions.");
    }

    public Question question_for_tasks(List<Task> ts) {
        Map tg = ts.groupBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Question apply(Task x$1) {
                return x$1.question();
            }
        });
        if (tg.size() != 1) {
            throw new Exception("MTurkAdapter can only process groups of Tasks for the same Question.");
        }
        return (Question)((Tuple2)tg.head())._1();
    }

    public MTState mturk_grantQualifications(HITState hitstate, MTState state, RequesterService backend) {
        ObjectRef internal_state = ObjectRef.create((Object)state);
        QualificationRequest[] requests = backend.getAllQualificationRequests(hitstate.hittype().disqualification().getQualificationTypeId());
        Predef$.MODULE$.refArrayOps((Object[])requests).foreach((Function1)new Serializable(hitstate, backend, internal_state){
            public static final long serialVersionUID = 0L;
            private final HITState hitstate$1;
            private final RequesterService backend$1;
            private final ObjectRef internal_state$1;

            public final void apply(QualificationRequest request) {
                String worker_id = request.getSubjectId();
                if (((MTState)this.internal_state$1.elem).disqualifications().contains((Object)request.getQualificationTypeId())) {
                    String hit_type_id = ((MTState)this.internal_state$1.elem).getHITTypeIDforQualificationTypeID(request.getQualificationTypeId());
                    String group_id = this.hitstate$1.hittype().group_id();
                    if (((MTState)this.internal_state$1.elem).worker_whitelist().contains((Object)new Tuple2((Object)worker_id, (Object)group_id))) {
                        String string = ((MTState)this.internal_state$1.elem).getHITTypeForWhitelistedWorker(worker_id, group_id).id();
                        String string2 = hit_type_id;
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            this.backend$1.rejectQualificationRequest(request.getQualificationRequestId(), "You cannot request this qualification more than once.");
                        } else {
                            this.backend$1.rejectQualificationRequest(request.getQualificationRequestId(), "You have already requested a qualification or submitted work for an associated HITType that disqualifies you from participating in this HITType.");
                        }
                    } else {
                        this.internal_state$1.elem = ((MTState)this.internal_state$1.elem).updateWorkerWhitelist(worker_id, group_id, hit_type_id);
                        Tuple3 batchKey = (Tuple3)((MTState)this.internal_state$1.elem).getBatchKeyByHITTypeId(hit_type_id).get();
                        this.backend$1.grantQualification(request.getQualificationRequestId(), Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)((MTState)this.internal_state$1.elem).getBatchNo((Tuple3<String, BigDecimal, Object>)batchKey).get())));
                    }
                    return;
                }
                throw new Exception("User-defined qualifications not yet supported.");
            }
            {
                this.hitstate$1 = hitstate$1;
                this.backend$1 = backend$1;
                this.internal_state$1 = internal_state$1;
            }
        });
        return (MTState)internal_state.elem;
    }

    public QualificationRequirement mturk_createQualification(String title, Tuple3<String, BigDecimal, Object> batchKey, int batch_no, RequesterService backend) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd:z");
        String datestr = sdf.format(new Date());
        String qualtxt = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"AutoMan automatically generated Disqualification (title: ", ", date: ", ", batchKey: ", ", batch_no: ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{title, datestr, batchKey, BoxesRunTime.boxToInteger((int)batch_no)}));
        QualificationType qual = backend.createQualificationType(new StringBuilder().append((Object)"AutoMan ").append((Object)UUID.randomUUID()).toString(), "automan", qualtxt);
        DebugLog$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating disqualification ID: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{qual.getQualificationTypeId()})), new LogLevelInfo(), LogType$.MODULE$.ADAPTER(), null);
        return new QualificationRequirement(qual.getQualificationTypeId(), Comparator.EqualTo, Predef$.MODULE$.int2Integer(batch_no), null, Predef$.MODULE$.boolean2Boolean(false));
    }

    public Assignment[] mturk_getAllAssignmentsForHIT(HITState hit_state, RequesterService backend) {
        return backend.getAllAssignmentsForHIT(hit_state.HITId());
    }

    public void mturk_approveAssignment(Assignment assignment, String text, RequesterService backend) {
        backend.approveAssignment(assignment.getAssignmentId(), text);
    }

    public void mturk_rejectAssignment(Assignment assignment, String reason, RequesterService backend) {
        backend.rejectAssignment(assignment.getAssignmentId(), reason);
    }

    public void mturk_forceExpireHIT(HITState hit_state, RequesterService backend) {
        backend.forceExpireHIT(hit_state.HITId());
    }

    public BigDecimal mturk_getAccountBalance(RequesterService backend) {
        return BigDecimal$.MODULE$.double2bigDecimal(backend.getAccountBalance());
    }

    public void mturk_disposeQualificationType(String qual_id, RequesterService backend) {
        DebugLog$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleting disqualification ID: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{qual_id})), new LogLevelInfo(), LogType$.MODULE$.ADAPTER(), null);
        backend.disposeQualificationType(qual_id);
    }

    public void mturk_assignQualification(String disqualification_id, String worker_id, int integerValue, boolean sendNotification, RequesterService backend) {
        backend.assignQualification(disqualification_id, worker_id, Predef$.MODULE$.int2Integer(integerValue), Predef$.MODULE$.boolean2Boolean(sendNotification));
    }

    public void mturk_revokeQualification(String qualificationTypeId, String worker_id, String reason, RequesterService backend) {
        backend.revokeQualification(qualificationTypeId, worker_id, reason);
    }

    public MTState mturk_registerHITType(String title, String desc, List<String> keywords, Tuple3<String, BigDecimal, Object> batch_key, MTState state, RequesterService backend) {
        MTState internal_state = state;
        DebugLog$.MODULE$.apply(new StringBuilder().append((Object)"Registering new HIT Type for batch key = ").append(batch_key).toString(), new LogLevelDebug(), LogType$.MODULE$.ADAPTER(), null);
        Tuple3<String, BigDecimal, Object> tuple3 = batch_key;
        if (tuple3 != null) {
            Nil$ nil$;
            Tuple3 tuple32;
            String group_id = (String)tuple3._1();
            BigDecimal cost = (BigDecimal)tuple3._2();
            int worker_timeout = BoxesRunTime.unboxToInt((Object)tuple3._3());
            Tuple3 tuple33 = tuple32 = new Tuple3((Object)group_id, (Object)cost, (Object)BoxesRunTime.boxToInteger((int)worker_timeout));
            String group_id2 = (String)tuple33._1();
            BigDecimal cost2 = (BigDecimal)tuple33._2();
            int worker_timeout2 = BoxesRunTime.unboxToInt((Object)tuple33._3());
            internal_state = internal_state.updateBatchNo(batch_key);
            int batch_no = BoxesRunTime.unboxToInt((Object)internal_state.getBatchNo(batch_key).get());
            QualificationRequirement disqualification = this.mturk_createQualification(title, batch_key, batch_no, backend);
            DebugLog$.MODULE$.apply(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Created disqualification ", " for batch key = "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{disqualification.getQualificationTypeId()}))).append(batch_key).toString(), new LogLevelDebug(), LogType$.MODULE$.ADAPTER(), null);
            if (batch_no != 1) {
                DebugLog$.MODULE$.apply(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Batch #", " run, using disqualification ", " for batch "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)batch_no), disqualification.getQualificationTypeId()}))).append(batch_key).toString(), new LogLevelDebug(), LogType$.MODULE$.ADAPTER(), null);
                nil$ = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new QualificationRequirement[]{disqualification}));
            } else {
                DebugLog$.MODULE$.apply(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Batch #", " run, using no qualifications for batch "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)batch_no)}))).append(batch_key).toString(), new LogLevelDebug(), LogType$.MODULE$.ADAPTER(), null);
                nil$ = Nil$.MODULE$;
            }
            Nil$ qs = nil$;
            long autoApprovalDelayInSeconds = 259200;
            String hit_type_id = backend.registerHITType(Predef$.MODULE$.long2Long(autoApprovalDelayInSeconds), Predef$.MODULE$.long2Long((long)worker_timeout2 + (long)this.WORKER_TIMEOUT_EPSILON_S()), Predef$.MODULE$.double2Double(cost2.toDouble()), title, keywords.mkString(","), desc, (QualificationRequirement[])qs.toArray(ClassTag$.MODULE$.apply(QualificationRequirement.class)));
            HITType hittype = new HITType(hit_type_id, disqualification, group_id2);
            internal_state = internal_state.addDisqualifications(disqualification.getQualificationTypeId(), hittype.id());
            internal_state = internal_state.updateHITTypes(batch_key, hittype);
            return internal_state;
        }
        throw new MatchError(tuple3);
    }

    public MTState mturk_createHIT(List<Task> ts, Tuple3<String, BigDecimal, Object> batch_key, Question question, MTState state, RequesterService backend) {
        MTState internal_state = state;
        MTurkQuestion q = (MTurkQuestion)((Object)((Task)ts.head()).question());
        Tuple2<HITType, MTState> tuple2 = this.get_or_create_hittype(question.title(), q.description(), q.keywords(), batch_key, internal_state, backend);
        if (tuple2 != null) {
            MTState state2;
            Tuple2 tuple22;
            HITType hit_type = (HITType)tuple2._1();
            MTState state22 = (MTState)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)hit_type, (Object)state22);
            HITType hit_type2 = (HITType)tuple23._1();
            internal_state = state2 = (MTState)tuple23._2();
            String xml = ((MTurkQuestion)((Object)question)).toXML(true).toString();
            DebugLog$.MODULE$.apply(new StringBuilder().append((Object)"Posting task XML:\n").append((Object)xml.toString()).toString(), new LogLevelDebug(), LogType$.MODULE$.ADAPTER(), question.id());
            HIT hit = backend.createHIT(hit_type2.id(), null, null, null, xml, null, null, null, Predef$.MODULE$.long2Long((long)((Task)ts.head()).timeout_in_s()), Predef$.MODULE$.int2Integer(ts.size()), question.id().toString(), (QualificationRequirement[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(QualificationRequirement.class)), (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)));
            HITState hs = HITState$.MODULE$.apply(backend.getHIT(hit.getHITId()), ts, hit_type2);
            Tuple2 hit_key = new Tuple2(batch_key, (Object)question.memo_hash());
            DebugLog$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating new HIT with ID ", " for batch key ", " and ", " assignments."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{hs.HITId(), batch_key, BoxesRunTime.boxToInteger((int)ts.size())})), new LogLevelDebug(), LogType$.MODULE$.ADAPTER(), question.id());
            internal_state = internal_state.updateHITIDs((Tuple2<Tuple3<String, BigDecimal, Object>, String>)hit_key, hs.HITId());
            return internal_state.updateHITStates(hs.HITId(), hs);
        }
        throw new MatchError(tuple2);
    }

    public MTState mturk_extendHIT(List<Task> ts, int timeout_in_s, Tuple2<Tuple3<String, BigDecimal, Object>, String> hit_key, MTState state, RequesterService backend) {
        MTState internal_state = state;
        HITState hitstate = internal_state.getHITState(hit_key);
        long expiry_s = Math.max(60, timeout_in_s);
        DebugLog$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Extending HIT ID ", " with ", " new assignments and timeout ", " sec"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{hitstate.HITId(), BoxesRunTime.boxToInteger((int)ts.size()), BoxesRunTime.boxToLong((long)expiry_s)})), new LogLevelDebug(), LogType$.MODULE$.ADAPTER(), ((Task)ts.head()).question().id());
        backend.extendHIT(hitstate.HITId(), Predef$.MODULE$.int2Integer(ts.size()), Predef$.MODULE$.long2Long(expiry_s));
        HITState hs = hitstate.addNewTasks(backend.getHIT(hitstate.HITId()), ts);
        return internal_state.updateHITStates(hs.HITId(), hs);
    }

    public Tuple2<HITType, MTState> get_or_create_hittype(String title, String desc, List<String> keywords, Tuple3<String, BigDecimal, Object> batch_key, MTState state, RequesterService backend) {
        MTState internal_state = state;
        Tuple3<String, BigDecimal, Object> tuple3 = batch_key;
        if (tuple3 != null) {
            String group_id;
            String string;
            String group_id2 = string = (group_id = (String)tuple3._1());
            if (internal_state.hit_types().contains(batch_key)) {
                DebugLog$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Reusing HITType with ID ", " for batch key ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((HITType)internal_state.hit_types().apply(batch_key)).id(), batch_key})), new LogLevelInfo(), LogType$.MODULE$.ADAPTER(), null);
            } else {
                internal_state = this.mturk_registerHITType(title, desc, keywords, batch_key, internal_state, backend);
            }
            return new Tuple2(internal_state.hit_types().apply(batch_key), (Object)internal_state);
        }
        throw new MatchError(tuple3);
    }

    public HIT[] mturk_searchAllHITs(RequesterService backend) {
        return backend.searchAllHITs();
    }

    private MTurkMethods$() {
        MODULE$ = this;
        this.WORKER_TIMEOUT_EPSILON_S = 15;
    }
}

