/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.automan.core.policy.aggregation;

import edu.umass.cs.automan.core.logging.DebugLog;
import edu.umass.cs.automan.core.logging.LogLevelInfo;
import edu.umass.cs.automan.core.logging.LogType;
import edu.umass.cs.automan.core.policy.aggregation.ChoiceFreq;
import java.util.Random;

public final class AgreementSimulation {
    private AgreementSimulation() {
        throw new AssertionError();
    }

    public static int minToWin(int n, int n2, double d, int n3) {
        Random random = new Random();
        ChoiceFreq choiceFreq = new ChoiceFreq(n2);
        for (int i = 0; i < n3; ++i) {
            AgreementSimulation.simulation(n, n2, choiceFreq, random);
        }
        return AgreementSimulation.tailThreshold(n2, 1.0 - d, choiceFreq);
    }

    public static double confidenceOfOutcome(int n, int n2, int n3, int n4) {
        Random random = new Random();
        ChoiceFreq choiceFreq = new ChoiceFreq(n2);
        for (int i = 0; i < n4; ++i) {
            AgreementSimulation.simulation(n, n2, choiceFreq, random);
        }
        return 1.0 - AgreementSimulation.tailProbability(n2, n3, choiceFreq);
    }

    private static void simulation(int n, int n2, ChoiceFreq choiceFreq, Random random) {
        int n3;
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = Math.abs(random.nextInt(Integer.MAX_VALUE)) % n;
        }
        int[] nArray2 = new int[n];
        for (n3 = 0; n3 < n; ++n3) {
            nArray2[n3] = 0;
        }
        for (n3 = 0; n3 < n2; ++n3) {
            int n4 = nArray[n3];
            nArray2[n4] = nArray2[n4] + 1;
        }
        n3 = 0;
        for (int i = 0; i < n; ++i) {
            if (nArray2[i] <= n3) continue;
            n3 = nArray2[i];
        }
        assert (n3 <= n2);
        choiceFreq.recordOutcome(n3);
    }

    private static double tailProbability(int n, int n2, ChoiceFreq choiceFreq) {
        double d = 0.0;
        for (int i = n; i >= n2; --i) {
            double d2 = (double)choiceFreq.countForOutcome(i) / (double)choiceFreq.numSimulations();
            d += d2;
        }
        return d;
    }

    private static int tailThreshold(int n, double d, ChoiceFreq choiceFreq) {
        double d2;
        double d3;
        int n2 = 1;
        for (d2 = 1.0; n2 <= n && d2 > d; d2 -= d3, ++n2) {
            d3 = (double)choiceFreq.countForOutcome(n2) / (double)choiceFreq.numSimulations();
        }
        if (n2 <= n && d2 <= d) {
            String string = String.format("MONTECARLO: %s identical answers required for %s tasks", Integer.toString(n2), Integer.toString(n));
            DebugLog.apply(string, LogLevelInfo.apply(), LogType.STRATEGY(), null);
            return n2;
        }
        return -1;
    }
}

