/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.automan.core.policy.validation;

import edu.umass.cs.automan.core.logging.DebugLog$;
import edu.umass.cs.automan.core.logging.LogLevel$;
import edu.umass.cs.automan.core.logging.LogType$;
import edu.umass.cs.automan.core.policy.price.MLEPricePolicy;
import edu.umass.cs.automan.core.policy.timeout.DoublingTimeoutPolicy;
import edu.umass.cs.automan.core.policy.validation.MonteCarlo;
import edu.umass.cs.automan.core.policy.validation.ScalarValidationPolicy;
import edu.umass.cs.automan.core.question.ScalarQuestion;
import edu.umass.cs.automan.core.scheduler.SchedulerState$;
import edu.umass.cs.automan.core.scheduler.Task;
import java.util.Date;
import java.util.UUID;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.math.BigDecimal;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001Y4A!\u0001\u0002\u0001#\t\u0019B)\u001a4bk2$8kY1mCJ\u0004v\u000e\\5ds*\u00111\u0001B\u0001\u000bm\u0006d\u0017\u000eZ1uS>t'BA\u0003\u0007\u0003\u0019\u0001x\u000e\\5ds*\u0011q\u0001C\u0001\u0005G>\u0014XM\u0003\u0002\n\u0015\u00059\u0011-\u001e;p[\u0006t'BA\u0006\r\u0003\t\u00197O\u0003\u0002\u000e\u001d\u0005)Q/\\1tg*\tq\"A\u0002fIV\u001c\u0001a\u0005\u0002\u0001%A\u00111\u0003F\u0007\u0002\u0005%\u0011QC\u0001\u0002\u0017'\u000e\fG.\u0019:WC2LG-\u0019;j_:\u0004v\u000e\\5ds\"Aq\u0003\u0001B\u0001B\u0003%\u0001$\u0001\u0005rk\u0016\u001cH/[8o!\tI2$D\u0001\u001b\u0015\t9b!\u0003\u0002\u001d5\tq1kY1mCJ\fV/Z:uS>t\u0007\"\u0002\u0010\u0001\t\u0003y\u0012A\u0002\u001fj]&$h\b\u0006\u0002!CA\u00111\u0003\u0001\u0005\u0006/u\u0001\r\u0001\u0007\u0005\bG\u0001\u0011\r\u0011\"\u0001%\u0003MqU/\u001c2fe>37+[7vY\u0006$\u0018n\u001c8t+\u0005)\u0003C\u0001\u0014*\u001b\u00059#\"\u0001\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005):#aA%oi\"1A\u0006\u0001Q\u0001\n\u0015\nACT;nE\u0016\u0014xJZ*j[Vd\u0017\r^5p]N\u0004\u0003\"\u0002\u0018\u0001\t\u0003y\u0013!\u00062p]\u001a,'O]8oS~\u001bwN\u001c4jI\u0016t7-\u001a\u000b\u0004aM*\u0004C\u0001\u00142\u0013\t\u0011tE\u0001\u0004E_V\u0014G.\u001a\u0005\u0006i5\u0002\r\u0001M\u0001\u000bG>tg-\u001b3f]\u000e,\u0007\"\u0002\u001c.\u0001\u0004)\u0013A\u00048v[~C\u0017\u0010]8uQ\u0016\u001cXm\u001d\u0005\u0006q\u0001!\t!O\u0001\u0013GV\u0014(/\u001a8u?\u000e|gNZ5eK:\u001cW\r\u0006\u00021u!)1h\u000ea\u0001y\u0005)A/Y:lgB\u0019Q(\u0012%\u000f\u0005y\u001aeBA C\u001b\u0005\u0001%BA!\u0011\u0003\u0019a$o\\8u}%\t\u0001&\u0003\u0002EO\u00059\u0001/Y2lC\u001e,\u0017B\u0001$H\u0005\u0011a\u0015n\u001d;\u000b\u0005\u0011;\u0003CA%M\u001b\u0005Q%BA&\u0007\u0003%\u00198\r[3ek2,'/\u0003\u0002N\u0015\n!A+Y:l\u0011\u0015y\u0005\u0001\"\u0001Q\u00031I7oX2p]\u001aLG-\u001a8u)\r\tF+\u0016\t\u0003MIK!aU\u0014\u0003\u000f\t{w\u000e\\3b]\")1H\u0014a\u0001y!)aG\u0014a\u0001K!)q\u000b\u0001C\u00011\u0006IQ.\u0019=`C\u001e\u0014X-\u001a\u000b\u0003KeCQa\u000f,A\u0002qBQa\u0017\u0001\u0005\u0002q\u000bQa\u001d9bo:$2\u0001P/_\u0011\u0015Y$\f1\u0001=\u0011\u0015y&\f1\u0001R\u0003-A\u0017\rZ0uS6,w.\u001e;\t\u000b\u0005\u0004A\u0011\u00012\u0002-\u0015D\b/Z2uK\u0012|fm\u001c:`C\u001e\u0014X-Z7f]R$B!J2fO\")A\r\u0019a\u0001K\u00051AO]5bYNDQA\u001a1A\u0002\u0015\nq!\\1y?\u0006<'\u000fC\u00035A\u0002\u0007\u0001\u0007C\u0003j\u0001\u0011\u0005!.\u0001\u0006ok6|Fo\\0sk:$B!J6m]\")1\b\u001ba\u0001y!)Q\u000e\u001ba\u0001K\u0005)!o\\;oI\")q\u000e\u001ba\u0001a\u00061!/Z<be\u0012\u0004\"!P9\n\u0005I<%A\u0003\"jO\u0012+7-[7bY\")A\u000f\u0001C\u0001k\u0006I\u0001/Z:tS6L7/\u001c\u000b\u0002a\u0001")
public class DefaultScalarPolicy
extends ScalarValidationPolicy {
    public final ScalarQuestion edu$umass$cs$automan$core$policy$validation$DefaultScalarPolicy$$question;
    private final int NumberOfSimulations;

    public int NumberOfSimulations() {
        return this.NumberOfSimulations;
    }

    public double bonferroni_confidence(double confidence, int num_hypotheses) {
        Predef$.MODULE$.assert(num_hypotheses > 0);
        return 1.0 - (1.0 - confidence) / (double)num_hypotheses;
    }

    @Override
    public double current_confidence(List<Task> tasks) {
        List<Task> valid_ts = this.completed_workerunique_tasks(tasks);
        if (valid_ts.size() == 0) {
            return 0.0;
        }
        int biggest_answer = ((SeqLike)((Tuple2)valid_ts.groupBy((Function1)new Serializable(this){

            public final Option<Object> apply(Task x$1) {
                return x$1.answer();
            }
        }).maxBy((Function1)new Serializable(this){

            public final int apply(Tuple2<Option<Object>, List<Task>> x0$1) {
                Tuple2<Option<Object>, List<Task>> tuple2 = x0$1;
                if (tuple2 != null) {
                    List ts = (List)tuple2._2();
                    int n = ts.size();
                    return n;
                }
                throw new MatchError(tuple2);
            }
        }, (Ordering)Ordering.Int$.MODULE$))._2()).size();
        return MonteCarlo.confidenceOfOutcome(this.edu$umass$cs$automan$core$policy$validation$DefaultScalarPolicy$$question.num_possibilities().toInt(), valid_ts.size(), biggest_answer, this.NumberOfSimulations());
    }

    @Override
    public boolean is_confident(List<Task> tasks, int num_hypotheses) {
        boolean bl;
        if (tasks.size() == 0) {
            DebugLog$.MODULE$.apply("Have no tasks; confidence is undefined.", LogLevel$.MODULE$.INFO(), LogType$.MODULE$.STRATEGY(), this.edu$umass$cs$automan$core$policy$validation$DefaultScalarPolicy$$question.id());
            bl = false;
        } else {
            double thresh;
            double conf = this.current_confidence(tasks);
            if (conf >= (thresh = this.bonferroni_confidence(this.edu$umass$cs$automan$core$policy$validation$DefaultScalarPolicy$$question.confidence(), num_hypotheses))) {
                DebugLog$.MODULE$.apply(new StringBuilder().append((Object)"Reached or exceeded alpha = ").append((Object)((Object)BoxesRunTime.boxToDouble((double)(1.0 - thresh))).toString()).toString(), LogLevel$.MODULE$.INFO(), LogType$.MODULE$.STRATEGY(), this.edu$umass$cs$automan$core$policy$validation$DefaultScalarPolicy$$question.id());
                bl = true;
            } else {
                List<Task> valid_ts = this.completed_workerunique_tasks(tasks);
                if (valid_ts.size() > 0) {
                    int biggest_answer = ((SeqLike)((Tuple2)valid_ts.groupBy((Function1)new Serializable(this){

                        public final Option<Object> apply(Task x$2) {
                            return x$2.answer();
                        }
                    }).maxBy((Function1)new Serializable(this){

                        public final int apply(Tuple2<Option<Object>, List<Task>> x0$2) {
                            Tuple2<Option<Object>, List<Task>> tuple2 = x0$2;
                            if (tuple2 != null) {
                                List ts = (List)tuple2._2();
                                int n = ts.size();
                                return n;
                            }
                            throw new MatchError(tuple2);
                        }
                    }, (Ordering)Ordering.Int$.MODULE$))._2()).size();
                    DebugLog$.MODULE$.apply(new StringBuilder().append((Object)"Need more tasks for alpha = ").append((Object)BoxesRunTime.boxToDouble((double)(1.0 - thresh))).append((Object)"; have ").append((Object)BoxesRunTime.boxToInteger((int)biggest_answer)).append((Object)" agreeing tasks.").toString(), LogLevel$.MODULE$.INFO(), LogType$.MODULE$.STRATEGY(), this.edu$umass$cs$automan$core$policy$validation$DefaultScalarPolicy$$question.id());
                } else {
                    DebugLog$.MODULE$.apply(new StringBuilder().append((Object)"Need more tasks for alpha = ").append((Object)BoxesRunTime.boxToDouble((double)(1.0 - thresh))).append((Object)"; currently have no agreement.").toString(), LogLevel$.MODULE$.INFO(), LogType$.MODULE$.STRATEGY(), this.edu$umass$cs$automan$core$policy$validation$DefaultScalarPolicy$$question.id());
                }
                bl = false;
            }
        }
        return bl;
    }

    public int max_agree(List<Task> tasks) {
        List<Task> valid_ts = this.completed_workerunique_tasks(tasks);
        if (valid_ts.size() == 0) {
            return 0;
        }
        return ((SeqLike)((Tuple2)valid_ts.groupBy((Function1)new Serializable(this){

            public final Option<Object> apply(Task x$3) {
                return x$3.answer();
            }
        }).maxBy((Function1)new Serializable(this){

            public final int apply(Tuple2<Option<Object>, List<Task>> x0$3) {
                Tuple2<Option<Object>, List<Task>> tuple2 = x0$3;
                if (tuple2 != null) {
                    List ts = (List)tuple2._2();
                    int n = ts.size();
                    return n;
                }
                throw new MatchError(tuple2);
            }
        }, (Ordering)Ordering.Int$.MODULE$))._2()).size();
    }

    @Override
    public List<Task> spawn(List<Task> tasks, boolean had_timeout) {
        block4: {
            int n;
            BigDecimal reward;
            int task_timeout_in_s;
            int worker_timeout_in_s;
            IntRef nextRound;
            block3: {
                int round;
                block2: {
                    round = tasks.nonEmpty() ? BoxesRunTime.unboxToInt((Object)((TraversableOnce)tasks.map((Function1)new Serializable(this){

                        public final int apply(Task x$4) {
                            return x$4.round();
                        }
                    }, List$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Int$.MODULE$)) : 0;
                    nextRound = IntRef.create((int)round);
                    worker_timeout_in_s = ((DoublingTimeoutPolicy)this.edu$umass$cs$automan$core$policy$validation$DefaultScalarPolicy$$question._timeout_policy_instance()).calculateWorkerTimeout(tasks, round, had_timeout);
                    task_timeout_in_s = ((DoublingTimeoutPolicy)this.edu$umass$cs$automan$core$policy$validation$DefaultScalarPolicy$$question._timeout_policy_instance()).calculateTaskTimeout(worker_timeout_in_s);
                    reward = ((MLEPricePolicy)this.edu$umass$cs$automan$core$policy$validation$DefaultScalarPolicy$$question._price_policy_instance()).calculateReward(tasks, round, had_timeout);
                    if (!had_timeout) break block2;
                    n = tasks.count((Function1)new Serializable(this, round){
                        private final int round$1;

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final boolean apply(Task t) {
                            if (t.round() != this.round$1) return false;
                            Enumeration.Value value = t.state();
                            Enumeration.Value value2 = SchedulerState$.MODULE$.TIMEOUT();
                            if (value != null) {
                                if (!value.equals(value2)) return false;
                                return true;
                            }
                            if (value2 == null) return true;
                            return false;
                        }
                        {
                            this.round$1 = round$1;
                        }
                    });
                    break block3;
                }
                if (tasks.count((Function1)new Serializable(this){

                    public final boolean apply(Task x$5) {
                        Enumeration.Value value = x$5.state();
                        Enumeration.Value value2 = SchedulerState$.MODULE$.RUNNING();
                        return !(value != null ? !value.equals(value2) : value2 != null);
                    }
                }) != 0) break block4;
                nextRound.elem = round + 1;
                n = this.num_to_run(tasks, round, reward);
            }
            int num_to_spawn = n;
            DebugLog$.MODULE$.apply(new StringBuilder().append((Object)"You should spawn ").append((Object)BoxesRunTime.boxToInteger((int)num_to_spawn)).append((Object)" more Tasks at $").append((Object)reward).append((Object)"/task, ").append((Object)BoxesRunTime.boxToInteger((int)task_timeout_in_s)).append((Object)"s until question timeout, ").append((Object)BoxesRunTime.boxToInteger((int)worker_timeout_in_s)).append((Object)"s until worker task timeout.").toString(), LogLevel$.MODULE$.INFO(), LogType$.MODULE$.STRATEGY(), this.edu$umass$cs$automan$core$policy$validation$DefaultScalarPolicy$$question.id());
            List new_tasks = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), num_to_spawn).map((Function1)new Serializable(this, nextRound, worker_timeout_in_s, task_timeout_in_s, reward){
                private final /* synthetic */ DefaultScalarPolicy $outer;
                private final IntRef nextRound$1;
                private final int worker_timeout_in_s$1;
                private final int task_timeout_in_s$1;
                private final BigDecimal reward$1;

                /*
                 * WARNING - void declaration
                 */
                public final Task apply(int i) {
                    void var3_3;
                    Date now = new Date();
                    Task t = new Task(UUID.randomUUID(), this.$outer.edu$umass$cs$automan$core$policy$validation$DefaultScalarPolicy$$question, this.nextRound$1.elem, this.task_timeout_in_s$1, this.worker_timeout_in_s$1, this.reward$1, now, SchedulerState$.MODULE$.READY(), false, (Option<String>)None$.MODULE$, (Option<Object>)None$.MODULE$, now);
                    DebugLog$.MODULE$.apply(new StringBuilder().append((Object)"spawned question_id = ").append((Object)this.$outer.edu$umass$cs$automan$core$policy$validation$DefaultScalarPolicy$$question.id_string()).toString(), LogLevel$.MODULE$.INFO(), LogType$.MODULE$.STRATEGY(), this.$outer.edu$umass$cs$automan$core$policy$validation$DefaultScalarPolicy$$question.id());
                    return var3_3;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.nextRound$1 = nextRound$1;
                    this.worker_timeout_in_s$1 = worker_timeout_in_s$1;
                    this.task_timeout_in_s$1 = task_timeout_in_s$1;
                    this.reward$1 = reward$1;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom())).toList();
            return new_tasks;
        }
        return Nil$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    public int expected_for_agreement(int trials, int max_agr, double confidence) {
        int to_run = 0;
        boolean done = false;
        while (!done) {
            void var5_4;
            int min_required = MonteCarlo.requiredForAgreement(this.edu$umass$cs$automan$core$policy$validation$DefaultScalarPolicy$$question.num_possibilities().toInt(), trials + var5_4, confidence, 1000000);
            int expected = max_agr + var5_4;
            if (min_required < 0 || min_required > expected) {
                ++var5_4;
                continue;
            }
            boolean bl = true;
        }
        return to_run;
    }

    public int num_to_run(List<Task> tasks, int round, BigDecimal reward) {
        List tasks_no_dupes = (List)tasks.filter((Function1)new Serializable(this){

            public final boolean apply(Task x$6) {
                Enumeration.Value value = x$6.state();
                Enumeration.Value value2 = SchedulerState$.MODULE$.DUPLICATE();
                return value != null ? !value.equals(value2) : value2 != null;
            }
        });
        int options = this.edu$umass$cs$automan$core$policy$validation$DefaultScalarPolicy$$question.num_possibilities().$greater(scala.package$.MODULE$.BigInt().apply(Integer.MAX_VALUE)) ? 1000 : this.edu$umass$cs$automan$core$policy$validation$DefaultScalarPolicy$$question.num_possibilities().toInt();
        double adjusted_conf = this.bonferroni_confidence(this.edu$umass$cs$automan$core$policy$validation$DefaultScalarPolicy$$question.confidence(), round + 1);
        double expected = this.expected_for_agreement(tasks_no_dupes.size(), this.max_agree((List<Task>)tasks_no_dupes), adjusted_conf);
        double biggest_bang = package$.MODULE$.min(package$.MODULE$.floor(this.edu$umass$cs$automan$core$policy$validation$DefaultScalarPolicy$$question.budget().toDouble() / reward.toDouble()), package$.MODULE$.floor(this.edu$umass$cs$automan$core$policy$validation$DefaultScalarPolicy$$question.time_value_per_hour().toDouble() / this.edu$umass$cs$automan$core$policy$validation$DefaultScalarPolicy$$question.wage().toDouble()));
        return (int)package$.MODULE$.max(expected, biggest_bang);
    }

    /*
     * WARNING - void declaration
     */
    public double pessimism() {
        void var1_1;
        double p = package$.MODULE$.max(this.edu$umass$cs$automan$core$policy$validation$DefaultScalarPolicy$$question.time_value_per_hour().$div(this.edu$umass$cs$automan$core$policy$validation$DefaultScalarPolicy$$question.wage()).toDouble(), 1.0);
        if (p > 1.0) {
            DebugLog$.MODULE$.apply("Using pessimistic (expensive) strategy.", LogLevel$.MODULE$.INFO(), LogType$.MODULE$.STRATEGY(), this.edu$umass$cs$automan$core$policy$validation$DefaultScalarPolicy$$question.id());
        } else {
            DebugLog$.MODULE$.apply("Using Using optimistic (cheap) strategy.", LogLevel$.MODULE$.INFO(), LogType$.MODULE$.STRATEGY(), this.edu$umass$cs$automan$core$policy$validation$DefaultScalarPolicy$$question.id());
        }
        return (double)var1_1;
    }

    public DefaultScalarPolicy(ScalarQuestion question) {
        this.edu$umass$cs$automan$core$policy$validation$DefaultScalarPolicy$$question = question;
        super(question);
        this.NumberOfSimulations = 1000000;
        DebugLog$.MODULE$.apply("DEFAULTSCALAR strategy loaded.", LogLevel$.MODULE$.INFO(), LogType$.MODULE$.STRATEGY(), question.id());
    }
}

