/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.automan.core.policy.validation;

import java.util.Random;

public final class MonteCarlo {
    private MonteCarlo() {
        throw new AssertionError();
    }

    public static int requiredForAgreement(int n, int n2, double d, int n3) {
        Occurrences occurrences = new Occurrences(n2 + 1);
        for (int i = 0; i < n3; ++i) {
            MonteCarlo.iteration(n, n2, occurrences);
        }
        return MonteCarlo.calculate_min_agreement(n2, d, n3, occurrences);
    }

    public static double confidenceOfOutcome(int n, int n2, int n3, int n4) {
        Occurrences occurrences = new Occurrences(n2 + 1);
        for (int i = 0; i < n4; ++i) {
            MonteCarlo.iteration(n, n2, occurrences);
        }
        return MonteCarlo.calculate_odds(n2, n3, n4, occurrences);
    }

    private static void iteration(int n, int n2, Occurrences occurrences) {
        int n3;
        Random random = new Random();
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = Math.abs(random.nextInt(Integer.MAX_VALUE)) % n;
        }
        int[] nArray2 = new int[n];
        for (n3 = 0; n3 < n; ++n3) {
            nArray2[n3] = 0;
        }
        for (n3 = 0; n3 < n2; ++n3) {
            int n4 = nArray[n3];
            nArray2[n4] = nArray2[n4] + 1;
        }
        n3 = 0;
        for (int i = 0; i < n; ++i) {
            if (nArray2[i] <= n3) continue;
            n3 = nArray2[i];
        }
        assert (n3 <= n2);
        int n5 = n3;
        occurrences.occurrences[n5] = occurrences.occurrences[n5] + 1;
    }

    private static int calculate_min_agreement(int n, double d, int n2, Occurrences occurrences) {
        double d2;
        double d3;
        int n3 = 1;
        double d4 = 1.0 - d;
        for (d2 = 1.0; n3 <= n && d2 > d4; d2 -= d3, ++n3) {
            d3 = (double)occurrences.occurrences[n3] / (double)n2;
        }
        if (n3 <= n && d2 <= d4) {
            String string = String.format("MONTECARLO: %s identical answers required for %s tasks", Integer.toString(n3), Integer.toString(n));
            return n3;
        }
        return -1;
    }

    private static double calculate_odds(int n, int n2, int n3, Occurrences occurrences) {
        double d = 0.0;
        for (int i = n; i >= n2; --i) {
            double d2 = (double)occurrences.occurrences[i] / (double)n3;
            d += d2;
        }
        return 1.0 - d;
    }

    private static class Occurrences {
        public int[] occurrences;

        public Occurrences(int n) {
            this.occurrences = new int[n];
        }
    }
}

