package plasma

package object docker {

  /** Create a container from [image] with common defaults.
   *
   * These defaults are based on the configuration that "docker run" uses.
   */
  def container(image : String) : ContainerConfig =
    ContainerConfig(Image = image,
                    Hostname = "", // let Docker pick
                    User = "", // let Docker pick
                    Memory = 0L, // no limit
                    MemorySwap = 0L, // no limit
                    AttachStdin = true,
                    AttachStdout = true,
                    AttachStderr = true,
                    StdinOnce = true,
                    NetworkDisabled = true,
                    Env = List(),
                    WorkingDir = "",
                    Entrypoint = List(),
                    Cmd = List(),
                    Tty = false,
                    OpenStdin = true,
                    Volumes = Map(),
                    VolumesFrom = "",
                    ExposedPorts = None)


}

