/*
 * Decompiled with CFR 0.152.
 */
package de.jflex.plugin.maven;

import de.jflex.plugin.maven.ClassInfo;
import de.jflex.plugin.maven.LexSimpleAnalyzer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import jflex.Main;
import jflex.Options;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public class JFlexMojo
extends AbstractMojo {
    public static final String SRC_MAIN_JFLEX = "src/main/jflex";
    private MavenProject project;
    private File[] lexDefinitions;
    private File outputDirectory;
    private int staleMillis;
    private boolean verbose;
    private boolean unusedWarning;
    private boolean dump;
    private boolean dot;
    private File skeleton;
    private boolean jlex;
    private String generationMethod = "pack";
    private boolean minimize = true;
    private boolean backup = true;
    private boolean legacyDot = false;
    private boolean inputStreamCtor = false;
    private boolean emitScala = true;

    public void execute() throws MojoExecutionException, MojoFailureException {
        List<File> filesIt;
        this.outputDirectory = this.getAbsolutePath(this.outputDirectory);
        this.project.addCompileSourceRoot(this.outputDirectory.getPath());
        if (this.lexDefinitions != null) {
            filesIt = Arrays.asList(this.lexDefinitions);
            this.getLog().debug((CharSequence)("Parsing " + this.lexDefinitions.length + " jflex files or directories given in configuration"));
        } else {
            this.getLog().debug((CharSequence)"Use lexer files found in (default) src/main/jflex");
            filesIt = new ArrayList<File>();
            File defaultDir = this.getAbsolutePath(new File(SRC_MAIN_JFLEX));
            if (defaultDir.isDirectory()) {
                filesIt.add(defaultDir);
            }
        }
        for (File lexDefinition : filesIt) {
            lexDefinition = this.getAbsolutePath(lexDefinition);
            this.parseLexDefinition(lexDefinition);
        }
    }

    private void parseLexDefinition(File lexDefinition) throws MojoFailureException, MojoExecutionException {
        assert (lexDefinition.isAbsolute()) : lexDefinition;
        if (lexDefinition.isDirectory()) {
            String[] extensions = new String[]{"jflex", "jlex", "lex", "flex"};
            this.getLog().debug((CharSequence)("Processing lexer files found in " + lexDefinition));
            Iterator fileIterator = FileUtils.iterateFiles((File)lexDefinition, (String[])extensions, (boolean)true);
            while (fileIterator.hasNext()) {
                File lexFile = (File)fileIterator.next();
                this.parseLexFile(lexFile);
            }
        } else {
            this.parseLexFile(lexDefinition);
        }
    }

    private void parseLexFile(File lexFile) throws MojoFailureException, MojoExecutionException {
        assert (lexFile.isAbsolute()) : lexFile;
        this.getLog().debug((CharSequence)("Generating " + (this.emitScala ? "Scala" : "Java") + " code from " + lexFile.getName()));
        ClassInfo classInfo = null;
        try {
            classInfo = LexSimpleAnalyzer.guessPackageAndClass(lexFile);
        }
        catch (FileNotFoundException e1) {
            throw new MojoFailureException(e1.getMessage());
        }
        catch (IOException e3) {
            classInfo = new ClassInfo();
            classInfo.className = "Yylex";
            classInfo.packageName = null;
        }
        this.checkParameters(lexFile);
        String generatedFilename = this.emitScala ? classInfo.getOutputFilename().replaceFirst("java$", "scala") : classInfo.getOutputFilename();
        File generatedFile = new File(this.outputDirectory, generatedFilename);
        if (lexFile.lastModified() - generatedFile.lastModified() <= (long)this.staleMillis) {
            this.getLog().info((CharSequence)("  " + generatedFile.getName() + " is up to date."));
            this.getLog().debug((CharSequence)("StaleMillis = " + this.staleMillis + "ms"));
            return;
        }
        Options.setDefaults();
        Options.setDir((File)generatedFile.getParentFile());
        Options.dump = this.dump;
        Options.verbose = this.verbose;
        Options.unused_warning = this.unusedWarning;
        Options.dot = this.dot;
        Options.legacy_dot = this.legacyDot;
        Options.emitInputStreamCtor = this.inputStreamCtor;
        Options.emitScala = this.emitScala;
        if (this.skeleton != null) {
            if (this.emitScala) {
                this.getLog().warn((CharSequence)"Using the default Scala skeleton, custom skeletons not currently supported");
            }
            Options.setSkeleton((File)this.skeleton);
        }
        Options.jlex = this.jlex;
        Options.no_minimize = !this.minimize;
        boolean bl = Options.no_backup = !this.backup;
        if (!"pack".equals(this.generationMethod)) {
            throw new MojoExecutionException("Illegal generation method: " + this.generationMethod);
        }
        try {
            Main.generate((File)lexFile);
            this.getLog().info((CharSequence)("  generated " + generatedFile));
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }

    private void checkParameters(File lexFile) throws MojoExecutionException {
        if (lexFile == null) {
            throw new MojoExecutionException("<lexDefinition> is empty. Please define input file with <lexDefinition>input.jflex</lexDefinition>");
        }
        assert (lexFile.isAbsolute()) : lexFile;
        if (!lexFile.isFile()) {
            throw new MojoExecutionException("Input file does not exist: " + lexFile);
        }
    }

    protected File getAbsolutePath(File path) {
        if (path == null || path.isAbsolute()) {
            return path;
        }
        return new File(this.project.getBasedir().getAbsolutePath(), path.getPath());
    }
}

