/*
 * Decompiled with CFR 0.152.
 */
package jflex;

import java.io.File;
import java.io.PrintWriter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jflex.Action;
import jflex.CharClassInterval;
import jflex.DFA;
import jflex.LexParse;
import jflex.LexScan;
import jflex.Options;
import jflex.Out;
import jflex.Skeleton;

public abstract class Emitter {
    protected static final Pattern JAVADOC_COMMENT_AND_MAYBE_ANNOTATIONS_PATTERN = Pattern.compile(".*/\\*\\*(.*)\\*/(?:\\s*@[a-z][a-z0-9_]*(?:\\.[a-z][a-z0-9_]*)*   (?:\\s*\\(\\s*(?:\"(?:\\\"|[^\"])*\"                   |'(?:[^']|\\\\(?:'|u[0-9a-f]{4}))'                   |[^)])+\\))?)*\\s*", 38);
    protected static final int FINAL = 1;
    protected static final int NOLOOK = 8;
    protected File inputFile;
    protected PrintWriter out;
    protected Skeleton skel;
    protected LexScan scanner;
    protected LexParse parser;
    protected DFA dfa;
    protected boolean[] isTransition;
    protected int numRows;
    protected int[] rowMap;
    protected boolean[] rowKilled;
    protected int numCols;
    protected int[] colMap;
    protected boolean[] colKilled;
    protected Map<Action, Integer> actionTable = new LinkedHashMap<Action, Integer>();
    protected CharClassInterval[] intervals;

    public static String getBaseName(String className) {
        int gen = className.indexOf(60);
        if (gen < 0) {
            return className;
        }
        return className.substring(0, gen);
    }

    public static File normalize(String name, File input) {
        File outputFile = Options.getDir() == null ? (input == null || input.getParent() == null ? new File(name) : new File(input.getParent(), name)) : new File(Options.getDir(), name);
        if (outputFile.exists() && !Options.no_backup) {
            File backup = new File(outputFile.toString() + "~");
            if (backup.exists()) {
                backup.delete();
            }
            if (outputFile.renameTo(backup)) {
                Out.println("Old file \"" + outputFile + "\" saved as \"" + backup + "\"");
            } else {
                Out.println("Couldn't save old file \"" + outputFile + "\", overwriting!");
            }
        }
        return outputFile;
    }

    protected void println() {
        this.out.println();
    }

    protected void println(String line) {
        this.out.println(line);
    }

    protected void println(int i) {
        this.out.println(i);
    }

    protected void print(String line) {
        this.out.print(line);
    }

    protected void print(int i) {
        this.out.print(i);
    }

    protected void print(int i, int tab) {
        int exp = i < 0 ? 1 : 10;
        while (tab-- > 1) {
            if (Math.abs(i) < exp) {
                this.print(" ");
            }
            exp *= 10;
        }
        this.print(i);
    }

    protected boolean hasGenLookAhead() {
        return this.dfa.lookaheadUsed;
    }

    protected abstract void emitLookBuffer();

    protected abstract void emitScanError();

    protected abstract void emitMain();

    protected abstract void emitNoMatch();

    protected abstract void emitNextInput();

    protected void emitHeader() {
        this.println("/* The following code was generated by JFlex 1.6.1 */");
        this.println("");
    }

    protected abstract void emitUserCode();

    protected abstract void emitClassName();

    public static boolean endsWithJavadoc(StringBuilder usercode) {
        Matcher matcher = JAVADOC_COMMENT_AND_MAYBE_ANNOTATIONS_PATTERN.matcher(usercode);
        return matcher.matches() && !matcher.group(1).contains("*/");
    }

    protected abstract void emitLexicalStates();

    protected abstract void emitDynamicInit();

    protected abstract void emitCharMapInitFunction(int var1);

    protected abstract void emitCharMapArrayUnPacked();

    protected abstract int emitCharMapArray();

    protected void printUC(int c) {
        if (c > 255) {
            this.out.print("\\u");
            if (c < 4096) {
                this.out.print("0");
            }
            this.out.print(Integer.toHexString(c));
        } else {
            this.out.print("\\");
            this.out.print(Integer.toOctalString(c));
        }
    }

    protected abstract void emitRowMapArray();

    protected abstract void emitAttributes();

    protected abstract void emitClassCode();

    protected abstract void emitConstructorDecl();

    protected abstract void emitConstructorDecl(boolean var1);

    protected void emitCtorArgs() {
        for (int i = 0; i < this.scanner.ctorArgs.size(); ++i) {
            this.print(", " + this.scanner.ctorTypes.get(i));
            this.print(" " + this.scanner.ctorArgs.get(i));
        }
    }

    protected abstract void emitDoEOF();

    protected abstract void emitLexFunctHeader();

    protected abstract void emitGetRowMapNext();

    protected String escapify(String s) {
        StringBuilder result = new StringBuilder(s.length() * 2);
        block8: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\'': {
                    result.append("\\'");
                    continue block8;
                }
                case '\"': {
                    result.append("\\\"");
                    continue block8;
                }
                case '\\': {
                    result.append("\\\\");
                    continue block8;
                }
                case '\t': {
                    result.append("\\t");
                    continue block8;
                }
                case '\r': {
                    if (i + 1 != s.length() && s.charAt(i + 1) == '\n') continue block8;
                    result.append("\"+ZZ_NL+\"");
                    continue block8;
                }
                case '\n': {
                    result.append("\"+ZZ_NL+\"");
                    continue block8;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    public abstract void emitActionTable();

    protected abstract void emitActions();

    protected abstract void emitEOFVal();

    protected void findActionStates() {
        this.isTransition = new boolean[this.dfa.numStates];
        for (int i = 0; i < this.dfa.numStates; ++i) {
            for (int j = 0; !this.isTransition[i] && j < this.dfa.numInput; j = (int)((char)(j + 1))) {
                int n = j;
                this.isTransition[i] = this.dfa.table[i][n] != -1;
            }
        }
    }

    protected void reduceColumns() {
        this.colMap = new int[this.dfa.numInput];
        this.colKilled = new boolean[this.dfa.numInput];
        int translate = 0;
        this.numCols = this.dfa.numInput;
        block0: for (int i = 0; i < this.dfa.numInput; ++i) {
            this.colMap[i] = i - translate;
            for (int j = 0; j < i; ++j) {
                int k = -1;
                boolean equal = true;
                while (equal && ++k < this.dfa.numStates) {
                    equal = this.dfa.table[k][i] == this.dfa.table[k][j];
                }
                if (!equal) continue;
                ++translate;
                this.colMap[i] = this.colMap[j];
                this.colKilled[i] = true;
                --this.numCols;
                continue block0;
            }
        }
    }

    protected void reduceRows() {
        this.rowMap = new int[this.dfa.numStates];
        this.rowKilled = new boolean[this.dfa.numStates];
        int translate = 0;
        this.numRows = this.dfa.numStates;
        block0: for (int i = 0; i < this.dfa.numStates; ++i) {
            this.rowMap[i] = i - translate;
            for (int j = 0; j < i; ++j) {
                int k = -1;
                boolean equal = true;
                while (equal && ++k < this.dfa.numInput) {
                    equal = this.dfa.table[i][k] == this.dfa.table[j][k];
                }
                if (!equal) continue;
                ++translate;
                this.rowMap[i] = this.rowMap[j];
                this.rowKilled[i] = true;
                --this.numRows;
                continue block0;
            }
        }
    }

    protected abstract void setupEOFCode();

    public abstract void emit();
}

