/*
 * Decompiled with CFR 0.152.
 */
package jflex;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import jflex.Action;
import jflex.CharClasses;
import jflex.DFA;
import jflex.EOFActions;
import jflex.Emitter;
import jflex.ErrorMessages;
import jflex.GeneratorException;
import jflex.JavaCountEmitter;
import jflex.JavaHiLowEmitter;
import jflex.LexParse;
import jflex.LexScan;
import jflex.Out;
import jflex.Skeleton;

public class JavaEmitter
extends Emitter {
    private String visibility = "public";

    public JavaEmitter(File inputFile, LexParse parser, DFA dfa) throws IOException {
        String name = JavaEmitter.getBaseName(parser.scanner.className) + ".java";
        File outputFile = JavaEmitter.normalize(name, inputFile);
        Out.println("Writing code to \"" + outputFile + "\"");
        this.out = new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));
        this.parser = parser;
        this.scanner = parser.scanner;
        this.visibility = this.scanner.visibility;
        this.inputFile = inputFile;
        this.dfa = dfa;
        this.skel = new Skeleton(this.out);
    }

    protected void emitLookBuffer() {
        if (!this.hasGenLookAhead()) {
            return;
        }
        this.println("  /** For the backwards DFA of general lookahead statements */");
        this.println("  private boolean [] zzFin = new boolean [ZZ_BUFFERSIZE+1];");
        this.println();
    }

    protected void emitScanError() {
        this.print("  private void zzScanError(int errorCode)");
        if (this.scanner.scanErrorException != null) {
            this.print(" throws " + this.scanner.scanErrorException);
        }
        this.println(" {");
        this.skel.emitNext();
        if (this.scanner.scanErrorException == null) {
            this.println("    throw new Error(message);");
        } else {
            this.println("    throw new " + this.scanner.scanErrorException + "(message);");
        }
        this.skel.emitNext();
        this.print("  " + this.visibility + " void yypushback(int number) ");
        if (this.scanner.scanErrorException == null) {
            this.println(" {");
        } else {
            this.println(" throws " + this.scanner.scanErrorException + " {");
        }
    }

    protected void emitMain() {
        if (!(this.scanner.standalone || this.scanner.debugOption || this.scanner.cupDebug)) {
            return;
        }
        if (this.scanner.cupDebug) {
            this.println("  /**");
            this.println("   * Converts an int token code into the name of the");
            this.println("   * token by reflection on the cup symbol class/interface " + this.scanner.cupSymbol);
            this.println("   *");
            this.println("   * This code was contributed by Karl Meissner <meissnersd@yahoo.com>");
            this.println("   */");
            this.println("  private String getTokenName(int token) {");
            this.println("    try {");
            this.println("      java.lang.reflect.Field [] classFields = " + this.scanner.cupSymbol + ".class.getFields();");
            this.println("      for (int i = 0; i < classFields.length; i++) {");
            this.println("        if (classFields[i].getInt(null) == token) {");
            this.println("          return classFields[i].getName();");
            this.println("        }");
            this.println("      }");
            this.println("    } catch (Exception e) {");
            this.println("      e.printStackTrace(System.err);");
            this.println("    }");
            this.println("");
            this.println("    return \"UNKNOWN TOKEN\";");
            this.println("  }");
            this.println("");
            this.println("  /**");
            this.println("   * Same as " + this.scanner.functionName + " but also prints the token to standard out");
            this.println("   * for debugging.");
            this.println("   *");
            this.println("   * This code was contributed by Karl Meissner <meissnersd@yahoo.com>");
            this.println("   */");
            if (this.scanner.cupCompatible || this.scanner.cup2Compatible) {
                this.print("  public ");
            } else {
                this.print("  " + this.visibility + " ");
            }
            if (this.scanner.tokenType == null) {
                if (this.scanner.isInteger) {
                    this.print("int");
                } else if (this.scanner.isIntWrap) {
                    this.print("Integer");
                } else {
                    this.print("Yytoken");
                }
            } else {
                this.print(this.scanner.tokenType);
            }
            this.print(" debug_");
            this.print(this.scanner.functionName);
            this.print("() throws java.io.IOException");
            if (this.scanner.lexThrow != null) {
                this.print(", ");
                this.print(this.scanner.lexThrow);
            }
            if (this.scanner.scanErrorException != null) {
                this.print(", ");
                this.print(this.scanner.scanErrorException);
            }
            this.println(" {");
            this.println("    " + this.scanner.tokenType + " s = " + this.scanner.functionName + "();");
            this.print("    System.out.println( ");
            if (this.scanner.lineCount) {
                this.print("\"line:\" + (yyline+1) + ");
            }
            if (this.scanner.columnCount) {
                this.print("\" col:\" + (yycolumn+1) + ");
            }
            this.println("\" --\"+ yytext() + \"--\" + getTokenName(s.sym) + \"--\");");
            this.println("    return s;");
            this.println("  }");
            this.println("");
        }
        if (this.scanner.standalone) {
            this.println("  /**");
            this.println("   * Runs the scanner on input files.");
            this.println("   *");
            this.println("   * This is a standalone scanner, it will print any unmatched");
            this.println("   * text to System.out unchanged.");
            this.println("   *");
            this.println("   * @param argv   the command line, contains the filenames to run");
            this.println("   *               the scanner on.");
            this.println("   */");
        } else {
            this.println("  /**");
            this.println("   * Runs the scanner on input files.");
            this.println("   *");
            this.println("   * This main method is the debugging routine for the scanner.");
            this.println("   * It prints debugging information about each returned token to");
            this.println("   * System.out until the end of file is reached, or an error occured.");
            this.println("   *");
            this.println("   * @param argv   the command line, contains the filenames to run");
            this.println("   *               the scanner on.");
            this.println("   */");
        }
        String className = JavaEmitter.getBaseName(this.scanner.className);
        this.println("  public static void main(String argv[]) {");
        this.println("    if (argv.length == 0) {");
        this.println("      System.out.println(\"Usage : java " + className + " [ --encoding <name> ] <inputfile(s)>\");");
        this.println("    }");
        this.println("    else {");
        this.println("      int firstFilePos = 0;");
        this.println("      String encodingName = \"UTF-8\";");
        this.println("      if (argv[0].equals(\"--encoding\")) {");
        this.println("        firstFilePos = 2;");
        this.println("        encodingName = argv[1];");
        this.println("        try {");
        this.println("          java.nio.charset.Charset.forName(encodingName); // Side-effect: is encodingName valid? ");
        this.println("        } catch (Exception e) {");
        this.println("          System.out.println(\"Invalid encoding '\" + encodingName + \"'\");");
        this.println("          return;");
        this.println("        }");
        this.println("      }");
        this.println("      for (int i = firstFilePos; i < argv.length; i++) {");
        this.println("        " + className + " scanner = null;");
        this.println("        try {");
        this.println("          java.io.FileInputStream stream = new java.io.FileInputStream(argv[i]);");
        this.println("          java.io.Reader reader = new java.io.InputStreamReader(stream, encodingName);");
        this.println("          scanner = new " + className + "(reader);");
        if (this.scanner.standalone) {
            this.println("          while ( !scanner.zzAtEOF ) scanner." + this.scanner.functionName + "();");
        } else if (this.scanner.cupDebug) {
            this.println("          while ( !scanner.zzAtEOF ) scanner.debug_" + this.scanner.functionName + "();");
        } else {
            this.println("          do {");
            this.println("            System.out.println(scanner." + this.scanner.functionName + "());");
            this.println("          } while (!scanner.zzAtEOF);");
            this.println("");
        }
        this.println("        }");
        this.println("        catch (java.io.FileNotFoundException e) {");
        this.println("          System.out.println(\"File not found : \\\"\"+argv[i]+\"\\\"\");");
        this.println("        }");
        this.println("        catch (java.io.IOException e) {");
        this.println("          System.out.println(\"IO error scanning file \\\"\"+argv[i]+\"\\\"\");");
        this.println("          System.out.println(e);");
        this.println("        }");
        this.println("        catch (Exception e) {");
        this.println("          System.out.println(\"Unexpected exception:\");");
        this.println("          e.printStackTrace();");
        this.println("        }");
        this.println("      }");
        this.println("    }");
        this.println("  }");
        this.println("");
    }

    protected void emitNoMatch() {
        this.println("            zzScanError(ZZ_NO_MATCH);");
    }

    protected void emitNextInput() {
        this.println("          if (zzCurrentPosL < zzEndReadL) {");
        this.println("            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);");
        this.println("            zzCurrentPosL += Character.charCount(zzInput);");
        this.println("          }");
        this.println("          else if (zzAtEOF) {");
        this.println("            zzInput = YYEOF;");
        this.println("            break zzForAction;");
        this.println("          }");
        this.println("          else {");
        this.println("            // store back cached positions");
        this.println("            zzCurrentPos  = zzCurrentPosL;");
        this.println("            zzMarkedPos   = zzMarkedPosL;");
        this.println("            boolean eof = zzRefill();");
        this.println("            // get translated positions and possibly new buffer");
        this.println("            zzCurrentPosL  = zzCurrentPos;");
        this.println("            zzMarkedPosL   = zzMarkedPos;");
        this.println("            zzBufferL      = zzBuffer;");
        this.println("            zzEndReadL     = zzEndRead;");
        this.println("            if (eof) {");
        this.println("              zzInput = YYEOF;");
        this.println("              break zzForAction;");
        this.println("            }");
        this.println("            else {");
        this.println("              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);");
        this.println("              zzCurrentPosL += Character.charCount(zzInput);");
        this.println("            }");
        this.println("          }");
    }

    protected void emitUserCode() {
        if (this.scanner.userCode.length() > 0) {
            this.println(this.scanner.userCode.toString());
        }
        if (this.scanner.cup2Compatible) {
            this.println();
            this.println("/* CUP2 imports */");
            this.println("import edu.tum.cup2.scanner.*;");
            this.println("import edu.tum.cup2.grammar.*;");
            this.println();
        }
    }

    protected void emitClassName() {
        if (!JavaEmitter.endsWithJavadoc(this.scanner.userCode)) {
            String path = this.inputFile.toString();
            if (File.separatorChar != '/') {
                path = path.replace(File.separatorChar, '/');
            }
            this.println("/**");
            this.println(" * This class is a scanner generated by ");
            this.println(" * <a href=\"http://www.jflex.de/\">JFlex</a> 1.6.1");
            this.println(" * from the specification file <tt>" + path + "</tt>");
            this.println(" */");
        }
        if (this.scanner.isPublic) {
            this.print("public ");
        }
        if (this.scanner.isAbstract) {
            this.print("abstract ");
        }
        if (this.scanner.isFinal) {
            this.print("final ");
        }
        this.print("class ");
        this.print(this.scanner.className);
        if (this.scanner.isExtending != null) {
            this.print(" extends ");
            this.print(this.scanner.isExtending);
        }
        if (this.scanner.isImplementing != null) {
            this.print(" implements ");
            this.print(this.scanner.isImplementing);
        }
        this.println(" {");
    }

    protected void emitLexicalStates() {
        int i;
        for (String name : this.scanner.states.names()) {
            int num = this.scanner.states.getNumber(name);
            this.println("  " + this.visibility + " static final int " + name + " = " + 2 * num + ";");
        }
        this.println("");
        this.println("  /**");
        this.println("   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l");
        this.println("   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l");
        this.println("   *                  at the beginning of a line");
        this.println("   * l is of the form l = 2*k, k a non negative integer");
        this.println("   */");
        this.println("  private static final int ZZ_LEXSTATE[] = { ");
        int j = 0;
        this.print("    ");
        for (i = 0; i < 2 * this.dfa.numLexStates - 1; ++i) {
            this.print(this.dfa.entryState[i], 2);
            this.print(", ");
            if (++j < 16) continue;
            this.println();
            this.print("    ");
            j = 0;
        }
        this.println(this.dfa.entryState[i]);
        this.println("  };");
    }

    protected void emitDynamicInit() {
        int count = 0;
        int value = this.dfa.table[0][0];
        this.println("  /** ");
        this.println("   * The transition table of the DFA");
        this.println("   */");
        JavaCountEmitter e = new JavaCountEmitter("Trans");
        e.setValTranslation(1);
        e.emitInit();
        for (int i = 0; i < this.dfa.numStates; ++i) {
            if (this.rowKilled[i]) continue;
            for (int c = 0; c < this.dfa.numInput; ++c) {
                if (this.colKilled[c]) continue;
                if (this.dfa.table[i][c] == value) {
                    ++count;
                    continue;
                }
                e.emit(count, value);
                count = 1;
                value = this.dfa.table[i][c];
            }
        }
        e.emit(count, value);
        e.emitUnpack();
        this.println(e.toString());
    }

    protected void emitCharMapInitFunction(int packedCharMapPairs) {
        CharClasses cl = this.parser.getCharClasses();
        if (cl.getMaxCharCode() < 256) {
            return;
        }
        this.println("");
        this.println("  /** ");
        this.println("   * Unpacks the compressed character translation table.");
        this.println("   *");
        this.println("   * @param packed   the packed character translation table");
        this.println("   * @return         the unpacked character translation table");
        this.println("   */");
        this.println("  private static char [] zzUnpackCMap(String packed) {");
        this.println("    char [] map = new char[0x" + Integer.toHexString(cl.getMaxCharCode() + 1) + "];");
        this.println("    int i = 0;  /* index in packed string  */");
        this.println("    int j = 0;  /* index in unpacked array */");
        this.println("    while (i < " + 2 * packedCharMapPairs + ") {");
        this.println("      int  count = packed.charAt(i++);");
        this.println("      char value = packed.charAt(i++);");
        this.println("      do map[j++] = value; while (--count > 0);");
        this.println("    }");
        this.println("    return map;");
        this.println("  }");
    }

    protected void emitCharMapArrayUnPacked() {
        CharClasses cl = this.parser.getCharClasses();
        this.println("");
        this.println("  /** ");
        this.println("   * Translates characters to character classes");
        this.println("   */");
        this.println("  private static final char [] ZZ_CMAP = {");
        int n = 0;
        this.print("    ");
        int max = cl.getMaxCharCode();
        for (int c = 0; c <= max; c = (int)((char)(c + 1))) {
            this.print(this.colMap[cl.getClassCode(c)], 2);
            if (c >= max) continue;
            this.print(", ");
            if (++n < 16) continue;
            this.println();
            this.print("    ");
            n = 0;
        }
        this.println();
        this.println("  };");
        this.println();
    }

    protected int emitCharMapArray() {
        CharClasses cl = this.parser.getCharClasses();
        if (cl.getMaxCharCode() < 256) {
            this.emitCharMapArrayUnPacked();
            return 0;
        }
        this.intervals = cl.getIntervals();
        this.println("");
        this.println("  /** ");
        this.println("   * Translates characters to character classes");
        this.println("   */");
        this.println("  private static final String ZZ_CMAP_PACKED = ");
        int n = 0;
        this.print("    \"");
        int numPairs = 0;
        for (int i = 0; i < this.intervals.length; ++i) {
            int count = this.intervals[i].end - this.intervals[i].start + 1;
            int value = this.colMap[this.intervals[i].charClass];
            while (count > 65535) {
                this.printUC(65535);
                this.printUC(value);
                count -= 65535;
                ++numPairs;
                ++n;
            }
            ++numPairs;
            this.printUC(count);
            this.printUC(value);
            if (i >= this.intervals.length - 1 || ++n < 10) continue;
            this.println("\"+");
            this.print("    \"");
            n = 0;
        }
        this.println("\";");
        this.println();
        this.println("  /** ");
        this.println("   * Translates characters to character classes");
        this.println("   */");
        this.println("  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);");
        this.println();
        return numPairs;
    }

    protected void emitRowMapArray() {
        this.println("");
        this.println("  /** ");
        this.println("   * Translates a state to a row index in the transition table");
        this.println("   */");
        JavaHiLowEmitter e = new JavaHiLowEmitter("RowMap");
        e.emitInit();
        for (int i = 0; i < this.dfa.numStates; ++i) {
            e.emit(this.rowMap[i] * this.numCols);
        }
        e.emitUnpack();
        this.println(e.toString());
    }

    protected void emitAttributes() {
        this.println("  /**");
        this.println("   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>");
        this.println("   */");
        JavaCountEmitter e = new JavaCountEmitter("Attribute");
        e.emitInit();
        int count = 1;
        int value = 0;
        if (this.dfa.isFinal[0]) {
            value = 1;
        }
        if (!this.isTransition[0]) {
            value |= 8;
        }
        for (int i = 1; i < this.dfa.numStates; ++i) {
            int attribute = 0;
            if (this.dfa.isFinal[i]) {
                attribute = 1;
            }
            if (!this.isTransition[i]) {
                attribute |= 8;
            }
            if (value == attribute) {
                ++count;
                continue;
            }
            e.emit(count, value);
            count = 1;
            value = attribute;
        }
        e.emit(count, value);
        e.emitUnpack();
        this.println(e.toString());
    }

    protected void emitClassCode() {
        if (this.scanner.classCode != null) {
            this.println("  /* user code: */");
            this.println(this.scanner.classCode);
        }
        if (this.scanner.cup2Compatible) {
            this.println();
            this.println("  /* CUP2 code: */");
            this.println("  private <T> ScannerToken<T> token(Terminal terminal, T value) {");
            this.println("    return new ScannerToken<T>(terminal, value, yyline, yycolumn);");
            this.println("  }");
            this.println();
            this.println("  private ScannerToken<Object> token(Terminal terminal) {");
            this.println("    return new ScannerToken<Object>(terminal, yyline, yycolumn);");
            this.println("  }");
            this.println();
        }
    }

    protected void emitConstructorDecl() {
        this.emitConstructorDecl(true);
        if ((this.scanner.standalone || this.scanner.debugOption) && this.scanner.ctorArgs.size() > 0) {
            Out.warning(ErrorMessages.get(ErrorMessages.CTOR_DEBUG));
            this.println();
            this.emitConstructorDecl(false);
        }
    }

    protected void emitConstructorDecl(boolean printCtorArgs) {
        this.println("  /**");
        this.println("   * Creates a new scanner");
        if (this.scanner.emitInputStreamCtor) {
            this.println("   * There is also a java.io.InputStream version of this constructor.");
        }
        this.println("   *");
        this.println("   * @param   in  the java.io.Reader to read input from.");
        this.println("   */");
        String warn = "// WARNING: this is a default constructor for debug/standalone only. Has no custom parameters or init code.";
        if (!printCtorArgs) {
            this.println(warn);
        }
        this.print("  ");
        if (this.scanner.isPublic) {
            this.print("public ");
        }
        this.print(JavaEmitter.getBaseName(this.scanner.className));
        this.print("(java.io.Reader in");
        if (printCtorArgs) {
            this.emitCtorArgs();
        }
        this.print(")");
        if (this.scanner.initThrow != null && printCtorArgs) {
            this.print(" throws ");
            this.print(this.scanner.initThrow);
        }
        this.println(" {");
        if (this.scanner.initCode != null && printCtorArgs) {
            this.print("  ");
            this.print(this.scanner.initCode);
        }
        this.println("    this.zzReader = in;");
        this.println("  }");
        this.println();
        if (this.scanner.emitInputStreamCtor) {
            Out.warning(ErrorMessages.EMITTING_INPUTSTREAM_CTOR, -1);
            this.println("  /**");
            this.println("   * Creates a new scanner.");
            this.println("   * There is also java.io.Reader version of this constructor.");
            this.println("   *");
            this.println("   * @param   in  the java.io.Inputstream to read input from.");
            this.println("   */");
            if (!printCtorArgs) {
                this.println(warn);
            }
            this.print("  ");
            if (this.scanner.isPublic) {
                this.print("public ");
            }
            this.print(JavaEmitter.getBaseName(this.scanner.className));
            this.print("(java.io.InputStream in");
            if (printCtorArgs) {
                this.emitCtorArgs();
            }
            this.print(")");
            if (this.scanner.initThrow != null && printCtorArgs) {
                this.print(" throws ");
                this.print(this.scanner.initThrow);
            }
            this.println(" {");
            this.println("    this(new java.io.InputStreamReader");
            this.print("             (in, java.nio.charset.Charset.forName(\"UTF-8\"))");
            if (printCtorArgs) {
                for (int i = 0; i < this.scanner.ctorArgs.size(); ++i) {
                    this.print(", " + this.scanner.ctorArgs.get(i));
                }
            }
            this.println(");");
            this.println("  }");
        }
    }

    protected void emitCtorArgs() {
        for (int i = 0; i < this.scanner.ctorArgs.size(); ++i) {
            this.print(", " + this.scanner.ctorTypes.get(i));
            this.print(" " + this.scanner.ctorArgs.get(i));
        }
    }

    protected void emitDoEOF() {
        if (this.scanner.eofCode == null) {
            return;
        }
        this.println("  /**");
        this.println("   * Contains user EOF-code, which will be executed exactly once,");
        this.println("   * when the end of file is reached");
        this.println("   */");
        this.print("  private void zzDoEOF()");
        if (this.scanner.eofThrow != null) {
            this.print(" throws ");
            this.print(this.scanner.eofThrow);
        }
        this.println(" {");
        this.println("    if (!zzEOFDone) {");
        this.println("      zzEOFDone = true;");
        this.println("    " + this.scanner.eofCode);
        this.println("    }");
        this.println("  }");
        this.println("");
        this.println("");
    }

    protected void emitLexFunctHeader() {
        if (this.scanner.cupCompatible || this.scanner.cup2Compatible) {
            this.print("  public ");
        } else {
            this.print("  " + this.visibility + " ");
        }
        if (this.scanner.tokenType == null) {
            if (this.scanner.isInteger) {
                this.print("int");
            } else if (this.scanner.isIntWrap) {
                this.print("Integer");
            } else {
                this.print("Yytoken");
            }
        } else {
            this.print(this.scanner.tokenType);
        }
        this.print(" ");
        this.print(this.scanner.functionName);
        this.print("() throws java.io.IOException");
        if (this.scanner.lexThrow != null) {
            this.print(", ");
            this.print(this.scanner.lexThrow);
        }
        if (this.scanner.scanErrorException != null) {
            this.print(", ");
            this.print(this.scanner.scanErrorException);
        }
        this.println(" {");
        this.skel.emitNext();
        this.println("    int [] zzTransL = ZZ_TRANS;");
        this.println("    int [] zzRowMapL = ZZ_ROWMAP;");
        this.println("    int [] zzAttrL = ZZ_ATTRIBUTE;");
        this.skel.emitNext();
        if (this.scanner.charCount) {
            this.println("      yychar+= zzMarkedPosL-zzStartRead;");
            this.println("");
        }
        if (this.scanner.lineCount || this.scanner.columnCount) {
            this.println("      boolean zzR = false;");
            this.println("      int zzCh;");
            this.println("      int zzCharCount;");
            this.println("      for (zzCurrentPosL = zzStartRead  ;");
            this.println("           zzCurrentPosL < zzMarkedPosL ;");
            this.println("           zzCurrentPosL += zzCharCount ) {");
            this.println("        zzCh = Character.codePointAt(zzBufferL, zzCurrentPosL, zzMarkedPosL);");
            this.println("        zzCharCount = Character.charCount(zzCh);");
            this.println("        switch (zzCh) {");
            this.println("        case '\\u000B':");
            this.println("        case '\\u000C':");
            this.println("        case '\\u0085':");
            this.println("        case '\\u2028':");
            this.println("        case '\\u2029':");
            if (this.scanner.lineCount) {
                this.println("          yyline++;");
            }
            if (this.scanner.columnCount) {
                this.println("          yycolumn = 0;");
            }
            this.println("          zzR = false;");
            this.println("          break;");
            this.println("        case '\\r':");
            if (this.scanner.lineCount) {
                this.println("          yyline++;");
            }
            if (this.scanner.columnCount) {
                this.println("          yycolumn = 0;");
            }
            this.println("          zzR = true;");
            this.println("          break;");
            this.println("        case '\\n':");
            this.println("          if (zzR)");
            this.println("            zzR = false;");
            this.println("          else {");
            if (this.scanner.lineCount) {
                this.println("            yyline++;");
            }
            if (this.scanner.columnCount) {
                this.println("            yycolumn = 0;");
            }
            this.println("          }");
            this.println("          break;");
            this.println("        default:");
            this.println("          zzR = false;");
            if (this.scanner.columnCount) {
                this.println("          yycolumn += zzCharCount;");
            }
            this.println("        }");
            this.println("      }");
            this.println();
            if (this.scanner.lineCount) {
                this.println("      if (zzR) {");
                this.println("        // peek one character ahead if it is \\n (if we have counted one line too much)");
                this.println("        boolean zzPeek;");
                this.println("        if (zzMarkedPosL < zzEndReadL)");
                this.println("          zzPeek = zzBufferL[zzMarkedPosL] == '\\n';");
                this.println("        else if (zzAtEOF)");
                this.println("          zzPeek = false;");
                this.println("        else {");
                this.println("          boolean eof = zzRefill();");
                this.println("          zzEndReadL = zzEndRead;");
                this.println("          zzMarkedPosL = zzMarkedPos;");
                this.println("          zzBufferL = zzBuffer;");
                this.println("          if (eof) ");
                this.println("            zzPeek = false;");
                this.println("          else ");
                this.println("            zzPeek = zzBufferL[zzMarkedPosL] == '\\n';");
                this.println("        }");
                this.println("        if (zzPeek) yyline--;");
                this.println("      }");
            }
        }
        if (this.scanner.bolUsed) {
            this.println("      if (zzMarkedPosL > zzStartRead) {");
            this.println("        switch (zzBufferL[zzMarkedPosL-1]) {");
            this.println("        case '\\n':");
            this.println("        case '\\u000B':");
            this.println("        case '\\u000C':");
            this.println("        case '\\u0085':");
            this.println("        case '\\u2028':");
            this.println("        case '\\u2029':");
            this.println("          zzAtBOL = true;");
            this.println("          break;");
            this.println("        case '\\r': ");
            this.println("          if (zzMarkedPosL < zzEndReadL)");
            this.println("            zzAtBOL = zzBufferL[zzMarkedPosL] != '\\n';");
            this.println("          else if (zzAtEOF)");
            this.println("            zzAtBOL = false;");
            this.println("          else {");
            this.println("            boolean eof = zzRefill();");
            this.println("            zzMarkedPosL = zzMarkedPos;");
            this.println("            zzEndReadL = zzEndRead;");
            this.println("            zzBufferL = zzBuffer;");
            this.println("            if (eof) ");
            this.println("              zzAtBOL = false;");
            this.println("            else ");
            this.println("              zzAtBOL = zzBufferL[zzMarkedPosL] != '\\n';");
            this.println("          }");
            this.println("          break;");
            this.println("        default:");
            this.println("          zzAtBOL = false;");
            this.println("        }");
            this.println("      }");
        }
        this.skel.emitNext();
        if (this.scanner.bolUsed) {
            this.println("      if (zzAtBOL)");
            this.println("        zzState = ZZ_LEXSTATE[zzLexicalState+1];");
            this.println("      else");
            this.println("        zzState = ZZ_LEXSTATE[zzLexicalState];");
            this.println();
        } else {
            this.println("      zzState = ZZ_LEXSTATE[zzLexicalState];");
            this.println();
        }
        this.println("      // set up zzAction for empty match case:");
        this.println("      int zzAttributes = zzAttrL[zzState];");
        this.println("      if ( (zzAttributes & 1) == 1 ) {");
        this.println("        zzAction = zzState;");
        this.println("      }");
        this.println();
        this.skel.emitNext();
    }

    protected void emitGetRowMapNext() {
        this.println("          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];");
        this.println("          if (zzNext == -1) break zzForAction;");
        this.println("          zzState = zzNext;");
        this.println();
        this.println("          zzAttributes = zzAttrL[zzState];");
        this.println("          if ( (zzAttributes & 1) == 1 ) {");
        this.skel.emitNext();
        this.println("            if ( (zzAttributes & 8) == 8 ) break zzForAction;");
        this.skel.emitNext();
    }

    public void emitActionTable() {
        int lastAction = 1;
        int count = 0;
        int value = 0;
        this.println("  /** ");
        this.println("   * Translates DFA states to action switch labels.");
        this.println("   */");
        JavaCountEmitter e = new JavaCountEmitter("Action");
        e.emitInit();
        for (int i = 0; i < this.dfa.numStates; ++i) {
            Action action;
            int newVal = 0;
            if (this.dfa.isFinal[i] && (action = this.dfa.action[i]).isEmittable()) {
                Integer stored = (Integer)this.actionTable.get(action);
                if (stored == null) {
                    stored = lastAction++;
                    this.actionTable.put(action, stored);
                }
                newVal = stored;
            }
            if (value == newVal) {
                ++count;
                continue;
            }
            if (count > 0) {
                e.emit(count, value);
            }
            count = 1;
            value = newVal;
        }
        if (count > 0) {
            e.emit(count, value);
        }
        e.emitUnpack();
        this.println(e.toString());
    }

    protected void emitActions() {
        this.println("        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {");
        int i = this.actionTable.size() + 1;
        for (Map.Entry entry : this.actionTable.entrySet()) {
            Action action = (Action)entry.getKey();
            int label = (Integer)entry.getValue();
            this.println("          case " + label + ": ");
            if (action.lookAhead() == 1) {
                this.println("            // lookahead expression with fixed base length");
                this.println("            zzMarkedPos = Character.offsetByCodePoints");
                this.println("                (zzBufferL, zzStartRead, zzEndRead - zzStartRead, zzStartRead, " + action.getLookLength() + ");");
            }
            if (action.lookAhead() == 2 || action.lookAhead() == 3) {
                this.println("            // lookahead expression with fixed lookahead length");
                this.println("            zzMarkedPos = Character.offsetByCodePoints");
                this.println("                (zzBufferL, zzStartRead, zzEndRead - zzStartRead, zzMarkedPos, -" + action.getLookLength() + ");");
            }
            if (action.lookAhead() == 4) {
                this.println("            // general lookahead, find correct zzMarkedPos");
                this.println("            { int zzFState = " + this.dfa.entryState[action.getEntryState()] + ";");
                this.println("              int zzFPos = zzStartRead;");
                this.println("              if (zzFin.length <= zzBufferL.length) { zzFin = new boolean[zzBufferL.length+1]; }");
                this.println("              boolean zzFinL[] = zzFin;");
                this.println("              while (zzFState != -1 && zzFPos < zzMarkedPos) {");
                this.println("                zzFinL[zzFPos] = ((zzAttrL[zzFState] & 1) == 1);");
                this.println("                zzInput = Character.codePointAt(zzBufferL, zzFPos, zzMarkedPos);");
                this.println("                zzFPos += Character.charCount(zzInput);");
                this.println("                zzFState = zzTransL[ zzRowMapL[zzFState] + zzCMapL[zzInput] ];");
                this.println("              }");
                this.println("              if (zzFState != -1) { zzFinL[zzFPos++] = ((zzAttrL[zzFState] & 1) == 1); } ");
                this.println("              while (zzFPos <= zzMarkedPos) {");
                this.println("                zzFinL[zzFPos++] = false;");
                this.println("              }");
                this.println();
                this.println("              zzFState = " + this.dfa.entryState[action.getEntryState() + 1] + ";");
                this.println("              zzFPos = zzMarkedPos;");
                this.println("              while (!zzFinL[zzFPos] || (zzAttrL[zzFState] & 1) != 1) {");
                this.println("                zzInput = Character.codePointBefore(zzBufferL, zzFPos, zzStartRead);");
                this.println("                zzFPos -= Character.charCount(zzInput);");
                this.println("                zzFState = zzTransL[ zzRowMapL[zzFState] + zzCMapL[zzInput] ];");
                this.println("              };");
                this.println("              zzMarkedPos = zzFPos;");
                this.println("            }");
            }
            if (this.scanner.debugOption) {
                this.print("            System.out.println(");
                if (this.scanner.lineCount) {
                    this.print("\"line: \"+(yyline+1)+\" \"+");
                }
                if (this.scanner.columnCount) {
                    this.print("\"col: \"+(yycolumn+1)+\" \"+");
                }
                this.println("\"match: --\"+zzToPrintable(yytext())+\"--\");");
                this.print("            System.out.println(\"action [" + action.priority + "] { ");
                this.print(this.escapify(action.content));
                this.println(" }\");");
            }
            this.println("            { " + action.content);
            this.println("            }");
            this.println("          case " + i++ + ": break;");
        }
    }

    protected void emitEOFVal() {
        Action defaultAction;
        EOFActions eofActions = this.parser.getEOFActions();
        if (this.scanner.eofCode != null) {
            this.println("            zzDoEOF();");
        }
        if (eofActions.numActions() > 0) {
            this.println("            switch (zzLexicalState) {");
            int last = this.dfa.numStates;
            for (String name : this.scanner.states.names()) {
                int num = this.scanner.states.getNumber(name);
                Action action = eofActions.getAction(num);
                if (action == null) continue;
                this.println("            case " + name + ": {");
                if (this.scanner.debugOption) {
                    this.print("              System.out.println(");
                    if (this.scanner.lineCount) {
                        this.print("\"line: \"+(yyline+1)+\" \"+");
                    }
                    if (this.scanner.columnCount) {
                        this.print("\"col: \"+(yycolumn+1)+\" \"+");
                    }
                    this.println("\"match: <<EOF>>\");");
                    this.print("              System.out.println(\"action [" + action.priority + "] { ");
                    this.print(this.escapify(action.content));
                    this.println(" }\");");
                }
                this.println("              " + action.content);
                this.println("            }");
                this.println("            case " + ++last + ": break;");
            }
            this.println("            default:");
        }
        if ((defaultAction = eofActions.getDefault()) != null) {
            this.println("              {");
            if (this.scanner.debugOption) {
                this.print("                System.out.println(");
                if (this.scanner.lineCount) {
                    this.print("\"line: \"+(yyline+1)+\" \"+");
                }
                if (this.scanner.columnCount) {
                    this.print("\"col: \"+(yycolumn+1)+\" \"+");
                }
                this.println("\"match: <<EOF>>\");");
                this.print("                System.out.println(\"action [" + defaultAction.priority + "] { ");
                this.print(this.escapify(defaultAction.content));
                this.println(" }\");");
            }
            this.println("                " + defaultAction.content);
            this.println("              }");
        } else if (this.scanner.eofVal != null) {
            this.println("          { " + this.scanner.eofVal + " }");
        } else if (this.scanner.isInteger) {
            if (this.scanner.tokenType != null) {
                Out.error(ErrorMessages.INT_AND_TYPE);
                throw new GeneratorException();
            }
            this.println("        return YYEOF;");
        } else {
            this.println("        return null;");
        }
        if (eofActions.numActions() > 0) {
            this.println("        }");
        }
    }

    protected void setupEOFCode() {
        if (this.scanner.eofclose) {
            this.scanner.eofCode = LexScan.conc(this.scanner.eofCode, "  yyclose();");
            this.scanner.eofThrow = LexScan.concExc(this.scanner.eofThrow, "java.io.IOException");
        }
    }

    public void emit() {
        this.setupEOFCode();
        if (this.scanner.functionName == null) {
            this.scanner.functionName = "yylex";
        }
        this.reduceColumns();
        this.findActionStates();
        this.emitHeader();
        this.emitUserCode();
        this.emitClassName();
        this.skel.emitNext();
        this.println("  private static final int ZZ_BUFFERSIZE = " + this.scanner.bufferSize + ";");
        if (this.scanner.debugOption) {
            this.println("  private static final String ZZ_NL = System.getProperty(\"line.separator\");");
        }
        this.skel.emitNext();
        this.emitLexicalStates();
        int packedCharMapPairs = this.emitCharMapArray();
        this.emitActionTable();
        this.reduceRows();
        this.emitRowMapArray();
        this.emitDynamicInit();
        this.skel.emitNext();
        this.emitAttributes();
        this.skel.emitNext();
        this.emitLookBuffer();
        this.emitClassCode();
        this.skel.emitNext();
        this.emitConstructorDecl();
        this.emitCharMapInitFunction(packedCharMapPairs);
        if (this.scanner.debugOption) {
            this.println("");
            this.println("  private static String zzToPrintable(String str) {");
            this.println("    StringBuilder builder = new StringBuilder();");
            this.println("    for (int n = 0 ; n < str.length() ; ) {");
            this.println("      int ch = str.codePointAt(n);");
            this.println("      int charCount = Character.charCount(ch);");
            this.println("      n += charCount;");
            this.println("      if (ch > 31 && ch < 127) {");
            this.println("        builder.append((char)ch);");
            this.println("      } else if (charCount == 1) {");
            this.println("        builder.append(String.format(\"\\\\u%04X\", ch));");
            this.println("      } else {");
            this.println("        builder.append(String.format(\"\\\\U%06X\", ch));");
            this.println("      }");
            this.println("    }");
            this.println("    return builder.toString();");
            this.println("  }");
        }
        this.skel.emitNext();
        this.emitScanError();
        this.skel.emitNext();
        this.emitDoEOF();
        this.skel.emitNext();
        this.emitLexFunctHeader();
        this.emitNextInput();
        this.emitGetRowMapNext();
        this.skel.emitNext();
        this.emitEOFVal();
        this.skel.emitNext();
        this.emitActions();
        this.skel.emitNext();
        this.emitNoMatch();
        this.skel.emitNext();
        this.emitMain();
        this.skel.emitNext();
        this.out.close();
    }
}

