/*
 * Decompiled with CFR 0.152.
 */
package jflex;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import jflex.Action;
import jflex.CharClasses;
import jflex.DFA;
import jflex.EOFActions;
import jflex.Emitter;
import jflex.ErrorMessages;
import jflex.GeneratorException;
import jflex.LexParse;
import jflex.LexScan;
import jflex.Out;
import jflex.ScalaCountEmitter;
import jflex.ScalaHiLowEmitter;
import jflex.Skeleton;

public class ScalaEmitter
extends Emitter {
    public ScalaEmitter(File inputFile, LexParse parser, DFA dfa) throws IOException {
        String name = ScalaEmitter.getBaseName(parser.scanner.className) + ".scala";
        File outputFile = ScalaEmitter.normalize(name, inputFile);
        Out.println("Writing code to \"" + outputFile + "\"");
        this.out = new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));
        this.parser = parser;
        this.scanner = parser.scanner;
        this.inputFile = inputFile;
        this.dfa = dfa;
        this.skel = new Skeleton(this.out);
    }

    protected void emitLookBuffer() {
        if (!this.hasGenLookAhead()) {
            return;
        }
        this.println("  /** For the backwards DFA of general lookahead statements */");
        this.println("  var zzFin: Array[Boolean] = new Array[Boolean](ZZ_BUFFERSIZE+1)");
        this.println();
    }

    protected void emitScanError() {
        if (this.scanner.scanErrorException != null) {
            this.println("  @throws[" + this.scanner.scanErrorException + "]");
        }
        this.println("  def zzScanError(errorCode: Int): Unit = {");
        this.skel.emitNext();
        if (this.scanner.scanErrorException == null) {
            this.println("    throw new Error(message)");
        } else {
            this.println("    throw new " + this.scanner.scanErrorException + "(message)");
        }
        this.skel.emitNext();
        if (this.scanner.scanErrorException != null) {
            this.println(" @throws[" + this.scanner.scanErrorException + "]");
        }
        this.println(" def yypushback(number: Int): Unit = {");
    }

    protected void emitMain() {
        if (!(this.scanner.standalone || this.scanner.debugOption || this.scanner.cupDebug)) {
            return;
        }
        if (this.scanner.cupDebug) {
            this.println("  /**");
            this.println("   * Converts an int token code into the name of the");
            this.println("   * token by reflection on the cup symbol class/interface " + this.scanner.cupSymbol);
            this.println("   *");
            this.println("   * This code was contributed by Karl Meissner <meissnersd@yahoo.com>");
            this.println("   */");
            this.println("  def getTokenName(token: Int): String = {");
            this.println("    try {");
            this.println("      val classFields: Array[java.lang.reflect.Field] = " + this.scanner.cupSymbol + ".class.getFields()");
            this.println("      for (i <- 0 until classFields.length) {");
            this.println("        if (classFields(i).getInt(null) == token) {");
            this.println("          return classFields[i].getName()");
            this.println("        }");
            this.println("      }");
            this.println("    } catch {");
            this.println("      case e: Exception => e.printStackTrace(System.err)");
            this.println("    }");
            this.println("");
            this.println("    \"UNKNOWN TOKEN\"");
            this.println("  }");
            this.println("");
            this.println("  /**");
            this.println("   * Same as " + this.scanner.functionName + " but also prints the token to standard out");
            this.println("   * for debugging.");
            this.println("   *");
            this.println("   * This code was contributed by Karl Meissner <meissnersd@yahoo.com>");
            this.println("   */");
            this.println("@throws[java.io.IOException]");
            if (this.scanner.scanErrorException != null) {
                this.println("@throws[" + this.scanner.scanErrorException + "]");
            }
            if (this.scanner.scanErrorException != null) {
                this.println("@throws[" + this.scanner.lexThrow + "]");
            }
            this.print("def debug_" + this.scanner.functionName + ": ");
            if (this.scanner.tokenType == null) {
                if (this.scanner.isInteger) {
                    this.print("Int");
                } else if (this.scanner.isIntWrap) {
                    this.print("Integer");
                } else {
                    this.print("Yytoken");
                }
            } else {
                this.print(this.scanner.tokenType);
            }
            this.println(" = {");
            this.println("    val s: " + this.scanner.tokenType + " = " + this.scanner.functionName + "()");
            this.print("    println( ");
            if (this.scanner.lineCount) {
                this.print("\"line:\" + (yyline+1) + ");
            }
            if (this.scanner.columnCount) {
                this.print("\" col:\" + (yycolumn+1) + ");
            }
            this.println("\" --\"+ yytext() + \"--\" + getTokenName(s.sym) + \"--\")");
            this.println("    s");
            this.println("  }");
            this.println("");
        }
        if (this.scanner.standalone) {
            this.println("  /**");
            this.println("   * Runs the scanner on input files.");
            this.println("   *");
            this.println("   * This is a standalone scanner, it will print any unmatched");
            this.println("   * text to System.out unchanged.");
            this.println("   *");
            this.println("   * @param argv   the command line, contains the filenames to run");
            this.println("   *               the scanner on.");
            this.println("   */");
        } else {
            this.println("  /**");
            this.println("   * Runs the scanner on input files.");
            this.println("   *");
            this.println("   * This main method is the debugging routine for the scanner.");
            this.println("   * It prints debugging information about each returned token to");
            this.println("   * System.out until the end of file is reached, or an error occured.");
            this.println("   *");
            this.println("   * @param argv   the command line, contains the filenames to run");
            this.println("   *               the scanner on.");
            this.println("   */");
        }
        String className = ScalaEmitter.getBaseName(this.scanner.className);
        this.println("  def main(args: Array[String]): Unit = {");
        this.println("    if (args.length == 0) {");
        this.println("      println(\"Usage : java " + className + " [ --encoding <name> ] <inputfile(s)>\");");
        this.println("    }");
        this.println("    else {");
        this.println("      val firstFilePos = 0");
        this.println("      val encodingName = \"UTF-8\"");
        this.println("      if (args(0) == \"--encoding\") {");
        this.println("        firstFilePos = 2");
        this.println("        encodingName = argv(1)");
        this.println("        try {");
        this.println("          java.nio.charset.Charset.forName(encodingName) // Side-effect: is encodingName valid? ");
        this.println("        } catch{");
        this.println("            case e: Exception => println(\"Invalid encoding '\" + encodingName + \"'\")");
        this.println("          return");
        this.println("        }");
        this.println("      }");
        this.println("      for (i <- 0 until args.length) {");
        this.println("        " + className + " scanner = null");
        this.println("        try {");
        this.println("          val stream = new java.io.FileInputStream(argv(i))");
        this.println("          val reader = new java.io.InputStreamReader(stream, encodingName)");
        this.println("          scanner = new " + className + "(reader)");
        if (this.scanner.standalone) {
            this.println("          while ( !scanner.zzAtEOF ) scanner." + this.scanner.functionName + "()");
        } else if (this.scanner.cupDebug) {
            this.println("          while ( !scanner.zzAtEOF ) scanner.debug_" + this.scanner.functionName + "()");
        } else {
            this.println("          do {");
            this.println("            println(scanner." + this.scanner.functionName + "())");
            this.println("          } while (!scanner.zzAtEOF);");
            this.println("");
        }
        this.println("        }");
        this.println("        catch {");
        this.println("          case e: java.io.FileNotFoundException => println(\"File not found : \\\"\"+argv[i]+\"\\\"\")");
        this.println("          case e: java.io.IOException =>  println(\"IO error scanning file \\\"\"+argv[i]+\"\\\"\"); println(e)");
        this.println("          case e: Exception => println(\"Unexpected exception:\"); e.printStackTrace()");
        this.println("        }");
        this.println("      }");
        this.println("    }");
        this.println("  }");
        this.println("");
    }

    protected void emitNoMatch() {
        this.println("            zzScanError(ZZ_NO_MATCH); null");
    }

    protected void emitNextInput() {
        this.println("          if (zzCurrentPosL < zzEndReadL) {");
        this.println("            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL)");
        this.println("            zzCurrentPosL += Character.charCount(zzInput)");
        this.println("          }");
        this.println("          else if (zzAtEOF) {");
        this.println("            zzInput = YYEOF");
        this.println("            break");
        this.println("          }");
        this.println("          else {");
        this.println("            // store back cached positions");
        this.println("            zzCurrentPos  = zzCurrentPosL");
        this.println("            zzMarkedPos   = zzMarkedPosL");
        this.println("            val eof = zzRefill()");
        this.println("            // get translated positions and possibly new buffer");
        this.println("            zzCurrentPosL  = zzCurrentPos");
        this.println("            zzMarkedPosL   = zzMarkedPos");
        this.println("            zzBufferL      = zzBuffer");
        this.println("            zzEndReadL     = zzEndRead");
        this.println("            if (eof) {");
        this.println("              zzInput = YYEOF");
        this.println("              break");
        this.println("            }");
        this.println("            else {");
        this.println("              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL)");
        this.println("              zzCurrentPosL += Character.charCount(zzInput)");
        this.println("            }");
        this.println("          }");
    }

    protected void emitUserCode() {
        if (this.scanner.userCode.length() > 0) {
            this.println(this.scanner.userCode.toString());
        }
        if (this.scanner.cup2Compatible) {
            this.println();
            this.println("/* CUP2 imports */");
            this.println("import edu.tum.cup2.scanner._");
            this.println("import edu.tum.cup2.grammar._");
            this.println();
        }
    }

    protected void emitImports() {
        this.println("import java.io.Reader");
        this.println("import scala.util.control.Breaks._");
        this.println();
    }

    protected void emitClassName() {
        if (!ScalaEmitter.endsWithJavadoc(this.scanner.userCode)) {
            String path = this.inputFile.toString();
            if (File.separatorChar != '/') {
                path = path.replace(File.separatorChar, '/');
            }
            this.println("/**");
            this.println(" * This class is a scanner generated by ");
            this.println(" * <a href=\"http://www.jflex.de/\">JFlex</a> 1.6.1");
            this.println(" * from the specification file <tt>" + path + "</tt>");
            this.println(" */");
        }
        if (this.scanner.isAbstract) {
            this.print("abstract ");
        }
        if (this.scanner.isFinal) {
            this.print("final ");
        }
        this.print("class ");
        this.print(this.scanner.className);
        this.print("(in: Reader) ");
        if (this.scanner.isExtending != null) {
            this.print(" extends ");
            this.print(this.scanner.isExtending);
        }
        if (this.scanner.isImplementing != null) {
            this.print(" implements ");
            this.print(this.scanner.isImplementing);
        }
        this.println(" {");
    }

    protected void emitLexicalStates() {
        int i;
        for (String name : this.scanner.states.names()) {
            int num = this.scanner.states.getNumber(name);
            this.println("  final val " + name + " = " + 2 * num);
        }
        this.println("");
        this.println("  /**");
        this.println("   * ZZ_LEXSTATE(l) is the state in the DFA for the lexical state l");
        this.println("   * ZZ_LEXSTATE(l+1) is the state in the DFA for the lexical state l");
        this.println("   *                  at the beginning of a line");
        this.println("   * l is of the form l = 2*k, k a non negative integer");
        this.println("   */");
        this.println("  final val ZZ_LEXSTATE = Array[Int]( ");
        int j = 0;
        this.print("    ");
        for (i = 0; i < 2 * this.dfa.numLexStates - 1; ++i) {
            this.print(this.dfa.entryState[i], 2);
            this.print(", ");
            if (++j < 16) continue;
            this.println();
            this.print("    ");
            j = 0;
        }
        this.println(this.dfa.entryState[i]);
        this.println("  )");
    }

    protected void emitDynamicInit() {
        int count = 0;
        int value = this.dfa.table[0][0];
        this.println("  /** ");
        this.println("   * The transition table of the DFA");
        this.println("   */");
        ScalaCountEmitter e = new ScalaCountEmitter("Trans");
        e.setValTranslation(1);
        e.emitInit();
        for (int i = 0; i < this.dfa.numStates; ++i) {
            if (this.rowKilled[i]) continue;
            for (int c = 0; c < this.dfa.numInput; ++c) {
                if (this.colKilled[c]) continue;
                if (this.dfa.table[i][c] == value) {
                    ++count;
                    continue;
                }
                e.emit(count, value);
                count = 1;
                value = this.dfa.table[i][c];
            }
        }
        e.emit(count, value);
        e.emitUnpack();
        e.emitEnd();
        this.println(e.toString());
    }

    protected void emitCharMapInitFunction(int packedCharMapPairs) {
        CharClasses cl = this.parser.getCharClasses();
        if (cl.getMaxCharCode() < 256) {
            return;
        }
        this.println("");
        this.println("  /** ");
        this.println("   * Unpacks the compressed character translation table.");
        this.println("   *");
        this.println("   * @param packed   the packed character translation table");
        this.println("   * @return         the unpacked character translation table");
        this.println("   */");
        this.println("  def zzUnpackCMap(packed: String): Array[Char] = {");
        this.println("    val map = new Array[Char](0x" + Integer.toHexString(cl.getMaxCharCode() + 1) + ")");
        this.println("    var i = 0  /* index in packed string  */");
        this.println("    var j = 0  /* index in unpacked array */");
        this.println("    while (i < " + 2 * packedCharMapPairs + ") {");
        this.println("      var count = packed.charAt(i).toInt; i += 1");
        this.println("      val value = packed.charAt(i); i += 1");
        this.println("      map(j) = value; j += 1; count -= 1");
        this.println("      while(count > 0){");
        this.println("        map(j) = value; j += 1; count -= 1");
        this.println("      }");
        this.println("    }");
        this.println("    map");
        this.println("  }");
    }

    protected void emitCharMapArrayUnPacked() {
        CharClasses cl = this.parser.getCharClasses();
        this.println("");
        this.println("  /** ");
        this.println("   * Translates characters to character classes");
        this.println("   */");
        this.println("  final val ZZ_CMAP: Array[Char](");
        int n = 0;
        this.print("    ");
        int max = cl.getMaxCharCode();
        for (int c = 0; c <= max; c = (int)((char)(c + 1))) {
            this.print(this.colMap[cl.getClassCode(c)], 2);
            if (c >= max) continue;
            this.print(", ");
            if (++n < 16) continue;
            this.println();
            this.print("    ");
            n = 0;
        }
        this.println();
        this.println("  )");
        this.println();
    }

    protected int emitCharMapArray() {
        CharClasses cl = this.parser.getCharClasses();
        if (cl.getMaxCharCode() < 256) {
            this.emitCharMapArrayUnPacked();
            return 0;
        }
        this.intervals = cl.getIntervals();
        this.println("");
        this.println("  /** ");
        this.println("   * Translates characters to character classes");
        this.println("   */");
        this.println("  final val ZZ_CMAP_PACKED: String = ");
        this.print("    \"");
        int numPairs = 0;
        for (int i = 0; i < this.intervals.length; ++i) {
            int count = this.intervals[i].end - this.intervals[i].start + 1;
            int value = this.colMap[this.intervals[i].charClass];
            while (count > 65535) {
                this.printUC(65535);
                this.printUC(value);
                count -= 65535;
                ++numPairs;
            }
            ++numPairs;
            this.printUC(count);
            this.printUC(value);
        }
        this.println("\"");
        this.println();
        this.println("  /** ");
        this.println("   * Translates characters to character classes");
        this.println("   */");
        this.println("  final val ZZ_CMAP: Array[Char] = zzUnpackCMap(ZZ_CMAP_PACKED)");
        this.println();
        return numPairs;
    }

    protected void emitRowMapArray() {
        this.println("");
        this.println("  /** ");
        this.println("   * Translates a state to a row index in the transition table");
        this.println("   */");
        ScalaHiLowEmitter e = new ScalaHiLowEmitter("RowMap");
        e.emitInit();
        for (int i = 0; i < this.dfa.numStates; ++i) {
            e.emit(this.rowMap[i] * this.numCols);
        }
        e.emitUnpack();
        e.emitEnd();
        this.println(e.toString());
    }

    protected void emitAttributes() {
        this.println("  /**");
        this.println("   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>");
        this.println("   */");
        ScalaCountEmitter e = new ScalaCountEmitter("Attribute");
        e.emitInit();
        int count = 1;
        int value = 0;
        if (this.dfa.isFinal[0]) {
            value = 1;
        }
        if (!this.isTransition[0]) {
            value |= 8;
        }
        for (int i = 1; i < this.dfa.numStates; ++i) {
            int attribute = 0;
            if (this.dfa.isFinal[i]) {
                attribute = 1;
            }
            if (!this.isTransition[i]) {
                attribute |= 8;
            }
            if (value == attribute) {
                ++count;
                continue;
            }
            e.emit(count, value);
            count = 1;
            value = attribute;
        }
        e.emit(count, value);
        e.emitUnpack();
        e.emitEnd();
        this.println(e.toString());
    }

    protected void emitClassCode() {
        if (this.scanner.classCode != null) {
            this.println("  /* user code: */");
            this.println(this.scanner.classCode);
        }
        if (this.scanner.cup2Compatible) {
            this.println();
            this.println("  /* CUP2 code: */");
            this.println("  def token[T](Terminal terminal, T value): ScannerToken[T] = ");
            this.println("    new ScannerToken[T](terminal, value, yyline, yycolumn)");
            this.println();
            this.println("  def token[Object](Terminal terminal) = ");
            this.println("    new ScannerToken[Object](terminal, yyline, yycolumn)");
            this.println();
        }
    }

    protected void emitConstructorDecl() {
        this.emitConstructorDecl(true);
        if ((this.scanner.standalone || this.scanner.debugOption) && this.scanner.ctorArgs.size() > 0) {
            Out.warning(ErrorMessages.get(ErrorMessages.CTOR_DEBUG));
            this.println();
            this.emitConstructorDecl(false);
        }
    }

    protected void emitConstructorDecl(boolean printCtorArgs) {
        this.println("  /**");
        this.println("   * Creates a new scanner");
        if (this.scanner.emitInputStreamCtor) {
            this.println("   * There is also a java.io.InputStream version of this constructor.");
        }
        this.println("   *");
        this.println("   * @param   in  the java.io.Reader to read input from.");
        this.println("   */");
        String warn = "// WARNING: this is a default constructor for debug/standalone only. Has no custom parameters or init code.";
        if (!printCtorArgs) {
            this.println(warn);
        }
        if (this.scanner.initThrow != null && printCtorArgs) {
            this.println("  @throws[" + this.scanner.initThrow + "]");
        }
        this.print("  def this(in: java.io.Reader");
        if (printCtorArgs) {
            this.emitCtorArgs();
        }
        this.print(")");
        this.println(" {");
        if (this.scanner.initCode != null && printCtorArgs) {
            this.print("  ");
            this.print(this.scanner.initCode);
        }
        this.println("    this(); zzReader = in");
        this.println("  }");
        this.println();
        if (this.scanner.emitInputStreamCtor) {
            Out.warning(ErrorMessages.EMITTING_INPUTSTREAM_CTOR, -1);
            this.println("  /**");
            this.println("   * Creates a new scanner.");
            this.println("   * There is also java.io.Reader version of this constructor.");
            this.println("   *");
            this.println("   * @param   in  the java.io.Inputstream to read input from.");
            this.println("   */");
            if (!printCtorArgs) {
                this.println(warn);
            }
            if (this.scanner.initThrow != null && printCtorArgs) {
                this.println("  @throws[" + this.scanner.initThrow + "]");
            }
            this.print("  def this(in: java.io.InputStream");
            if (printCtorArgs) {
                this.emitCtorArgs();
            }
            this.print(")");
            this.println(" {");
            this.println("    this(new java.io.InputStreamReader");
            this.print("             (in, java.nio.charset.Charset.forName(\"UTF-8\"))");
            if (printCtorArgs) {
                for (int i = 0; i < this.scanner.ctorArgs.size(); ++i) {
                    this.print(", " + this.scanner.ctorArgs.get(i));
                }
            }
            this.println(")");
            this.println("  }");
        }
    }

    protected void emitCtorArgs() {
        for (int i = 0; i < this.scanner.ctorArgs.size(); ++i) {
            this.print(", " + this.scanner.ctorArgs.get(i));
            this.print(": " + this.scanner.ctorTypes.get(i));
        }
    }

    protected void emitDoEOF() {
        if (this.scanner.eofCode == null) {
            return;
        }
        this.println("  /**");
        this.println("   * Contains user EOF-code, which will be executed exactly once,");
        this.println("   * when the end of file is reached");
        this.println("   */");
        if (this.scanner.eofThrow != null) {
            this.println(" @throws[" + this.scanner.eofThrow + "]");
        }
        this.print("  def zzDoEOF() = {");
        this.println("    if (!zzEOFDone) {");
        this.println("      zzEOFDone = true");
        this.println("    " + this.scanner.eofCode);
        this.println("    }");
        this.println("  }");
        this.println("");
        this.println("");
    }

    protected void emitLexFunctHeader() {
        this.println(" @throws[java.io.IOException](\"if any I/O-Error occurs\")");
        if (this.scanner.lexThrow != null) {
            this.println(" @throws[" + this.scanner.lexThrow + "]");
        }
        if (this.scanner.scanErrorException != null) {
            this.println(" @throws[" + this.scanner.scanErrorException + "]");
        }
        this.print(" def " + this.scanner.functionName + "(): ");
        if (this.scanner.tokenType == null) {
            if (this.scanner.isInteger) {
                this.print("Int");
            } else if (this.scanner.isIntWrap) {
                this.print("Integer");
            } else {
                this.print("Yytoken");
            }
        } else {
            this.print(this.scanner.tokenType);
        }
        this.println(" = {");
        this.skel.emitNext();
        this.println("    val zzTransL: Array[Int] = ZZ_TRANS");
        this.println("    val zzRowMapL: Array[Int] = ZZ_ROWMAP");
        this.println("    val zzAttrL: Array[Int] = ZZ_ATTRIBUTE");
        this.println();
        this.print("    var ret: ");
        if (this.scanner.tokenType == null) {
            if (this.scanner.isInteger) {
                this.print("Int");
            } else if (this.scanner.isIntWrap) {
                this.print("Integer");
            } else {
                this.print("Yytoken");
            }
        } else {
            this.print(this.scanner.tokenType);
        }
        this.println(" = null");
        this.skel.emitNext();
        if (this.scanner.charCount) {
            this.println("      yychar += zzMarkedPosL-zzStartRead");
            this.println("");
        }
        if (this.scanner.lineCount || this.scanner.columnCount) {
            this.println("      var zzR = false");
            this.println("      var zzCh: Int");
            this.println("      var zzCharCount: Int");
            this.println("      for (zzCurrentPosL = zzStartRead  ;");
            this.println("           zzCurrentPosL < zzMarkedPosL ;");
            this.println("           zzCurrentPosL += zzCharCount ) {");
            this.println("        zzCh = Character.codePointAt(zzBufferL, zzCurrentPosL, zzMarkedPosL)");
            this.println("        zzCharCount = Character.charCount(zzCh)");
            this.println("        zzCh match {");
            this.println("        case '\\u000B' | '\\u000C' | '\\u0085' | '\\u2028' | '\\u2029' =>");
            if (this.scanner.lineCount) {
                this.println("          yyline += 1");
            }
            if (this.scanner.columnCount) {
                this.println("          yycolumn = 0");
            }
            this.println("          zzR = false");
            this.println("        case '\\r' =>");
            if (this.scanner.lineCount) {
                this.println("          yyline += 1");
            }
            if (this.scanner.columnCount) {
                this.println("          yycolumn = 0");
            }
            this.println("          zzR = true");
            this.println("        case '\\n' => ");
            this.println("          if (zzR)");
            this.println("            zzR = false");
            this.println("          else {");
            if (this.scanner.lineCount) {
                this.println("            yyline += 1");
            }
            if (this.scanner.columnCount) {
                this.println("            yycolumn = 0");
            }
            this.println("          }");
            this.println("        case _ =>");
            this.println("          zzR = false");
            if (this.scanner.columnCount) {
                this.println("          yycolumn += zzCharCount");
            }
            this.println("        }");
            this.println("      }");
            this.println();
            if (this.scanner.lineCount) {
                this.println("      if (zzR) {");
                this.println("        // peek one character ahead if it is \\n (if we have counted one line too much)");
                this.println("        val zzPeek: Boolean");
                this.println("        if (zzMarkedPosL < zzEndReadL)");
                this.println("          zzPeek = zzBufferL(zzMarkedPosL) == '\\n'");
                this.println("        else if (zzAtEOF)");
                this.println("          zzPeek = false");
                this.println("        else {");
                this.println("          val eof = zzRefill()");
                this.println("          zzEndReadL = zzEndRead");
                this.println("          zzMarkedPosL = zzMarkedPos");
                this.println("          zzBufferL = zzBuffer");
                this.println("          if (eof) ");
                this.println("            zzPeek = false");
                this.println("          else ");
                this.println("            zzPeek = zzBufferL(zzMarkedPosL) == '\\n'");
                this.println("        }");
                this.println("        if (zzPeek) yyline -= 1");
                this.println("      }");
            }
        }
        if (this.scanner.bolUsed) {
            this.println("      if (zzMarkedPosL > zzStartRead) {");
            this.println("        zzBufferL(zzMarkedPosL-1) match {");
            this.println("        case '\\n' | '\\u000B' | '\\u000C' | '\\u0085' | '\\u2028' | '\\u2029' => ");
            this.println("          zzAtBOL = true");
            this.println("        case '\\r' =>");
            this.println("          if (zzMarkedPosL < zzEndReadL)");
            this.println("            zzAtBOL = zzBufferL(zzMarkedPosL) != '\\n'");
            this.println("          else if (zzAtEOF)");
            this.println("            zzAtBOL = false");
            this.println("          else {");
            this.println("            val eof = zzRefill()");
            this.println("            zzMarkedPosL = zzMarkedPos");
            this.println("            zzEndReadL = zzEndRead");
            this.println("            zzBufferL = zzBuffer");
            this.println("            if (eof) ");
            this.println("              zzAtBOL = false");
            this.println("            else ");
            this.println("              zzAtBOL = zzBufferL(zzMarkedPosL) != '\\n'");
            this.println("          }");
            this.println("        case _ => zzAtBOL = false");
            this.println("        }");
            this.println("      }");
        }
        this.skel.emitNext();
        if (this.scanner.bolUsed) {
            this.println("      if (zzAtBOL)");
            this.println("        zzState = ZZ_LEXSTATE(zzLexicalState+1)");
            this.println("      else");
            this.println("        zzState = ZZ_LEXSTATE(zzLexicalState)");
            this.println();
        } else {
            this.println("      zzState = ZZ_LEXSTATE(zzLexicalState)");
            this.println();
        }
        this.println("      // set up zzAction for empty match case:");
        this.println("      var zzAttributes = zzAttrL(zzState)");
        this.println("      if ( (zzAttributes & 1) == 1 ) {");
        this.println("        zzAction = zzState");
        this.println("      }");
        this.println();
        this.skel.emitNext();
    }

    protected void emitGetRowMapNext() {
        this.println("          val zzNext = zzTransL(zzRowMapL(zzState) + zzCMapL(zzInput))");
        this.println("          if (zzNext == -1) break");
        this.println("          zzState = zzNext");
        this.println();
        this.println("          zzAttributes = zzAttrL(zzState)");
        this.println("          if ( (zzAttributes & 1) == 1 ) {");
        this.skel.emitNext();
        this.println("            if ( (zzAttributes & 8) == 8 ) break");
        this.skel.emitNext();
    }

    public void emitActionTable() {
        int lastAction = 1;
        int count = 0;
        int value = 0;
        this.println("  /** ");
        this.println("   * Translates DFA states to action switch labels.");
        this.println("   */");
        ScalaCountEmitter e = new ScalaCountEmitter("Action");
        e.emitInit();
        for (int i = 0; i < this.dfa.numStates; ++i) {
            Action action;
            int newVal = 0;
            if (this.dfa.isFinal[i] && (action = this.dfa.action[i]).isEmittable()) {
                Integer stored = (Integer)this.actionTable.get(action);
                if (stored == null) {
                    stored = lastAction++;
                    this.actionTable.put(action, stored);
                }
                newVal = stored;
            }
            if (value == newVal) {
                ++count;
                continue;
            }
            if (count > 0) {
                e.emit(count, value);
            }
            count = 1;
            value = newVal;
        }
        if (count > 0) {
            e.emit(count, value);
        }
        e.emitUnpack();
        e.emitEnd();
        this.println(e.toString());
    }

    protected void emitActions() {
        this.println("        (if (zzAction < 0) zzAction else ZZ_ACTION(zzAction)) match {");
        int i = this.actionTable.size() + 1;
        for (Map.Entry entry : this.actionTable.entrySet()) {
            Action action = (Action)entry.getKey();
            int label = (Integer)entry.getValue();
            this.println("          case " + label + " => ");
            if (action.lookAhead() == 1) {
                this.println("            // lookahead expression with fixed base length");
                this.print("            zzMarkedPos = Character.offsetByCodePoints");
                this.println("(zzBufferL, zzStartRead, zzEndRead - zzStartRead, zzStartRead, " + action.getLookLength() + ")");
            }
            if (action.lookAhead() == 2 || action.lookAhead() == 3) {
                this.println("            // lookahead expression with fixed lookahead length");
                this.print("            zzMarkedPos = Character.offsetByCodePoints");
                this.println("(zzBufferL, zzStartRead, zzEndRead - zzStartRead, zzMarkedPos, -" + action.getLookLength() + ")");
            }
            if (action.lookAhead() == 4) {
                this.println("            // general lookahead, find correct zzMarkedPos");
                this.println("            { var zzFState = " + this.dfa.entryState[action.getEntryState()]);
                this.println("              var zzFPos = zzStartRead");
                this.println("              if (zzFin.length <= zzBufferL.length) { zzFin = new Array[Boolean](zzBufferL.length+1) }");
                this.println("              val zzFinL = zzFin");
                this.println("              while (zzFState != -1 && zzFPos < zzMarkedPos) {");
                this.println("                zzFinL(zzFPos) = ((zzAttrL(zzFState) & 1) == 1)");
                this.println("                zzInput = Character.codePointAt(zzBufferL, zzFPos, zzMarkedPos)");
                this.println("                zzFPos += Character.charCount(zzInput)");
                this.println("                zzFState = zzTransL( zzRowMapL(zzFState) + zzCMapL(zzInput) )");
                this.println("              }");
                this.println("              if (zzFState != -1) { zzFinL(zzFPos) = ((zzAttrL(zzFState) & 1) == 1) } ");
                this.println("              zzFPos += 1");
                this.println("              while (zzFPos <= zzMarkedPos) {");
                this.println("                zzFinL(zzFPos) = false");
                this.println("                zzFPos += 1");
                this.println("              }");
                this.println();
                this.println("              zzFState = " + this.dfa.entryState[action.getEntryState() + 1]);
                this.println("              zzFPos = zzMarkedPos");
                this.println("              while (!zzFinL(zzFPos) || (zzAttrL(zzFState) & 1) != 1) {");
                this.println("                zzInput = Character.codePointBefore(zzBufferL, zzFPos, zzStartRead)");
                this.println("                zzFPos -= Character.charCount(zzInput)");
                this.println("                zzFState = zzTransL( zzRowMapL(zzFState) + zzCMapL(zzInput) )");
                this.println("              }");
                this.println("              zzMarkedPos = zzFPos");
                this.println("            }");
            }
            if (this.scanner.debugOption) {
                this.print("            println(");
                if (this.scanner.lineCount) {
                    this.print("\"line: \"+(yyline+1)+\" \"+");
                }
                if (this.scanner.columnCount) {
                    this.print("\"col: \"+(yycolumn+1)+\" \"+");
                }
                this.println("\"match: --\"+zzToPrintable(yytext())+\"--\");");
                this.print("            println(\"action [" + action.priority + "] { ");
                this.print(this.escapify(action.content));
                this.println(" }\")");
            }
            for (String actionLine : action.content.split("\n")) {
                this.println("             " + actionLine);
            }
            this.println("          case " + i++ + " => null // noop");
        }
    }

    protected void emitEOFVal() {
        Action defaultAction;
        EOFActions eofActions = this.parser.getEOFActions();
        if (this.scanner.eofCode != null) {
            this.println("            zzDoEOF()");
        }
        if (eofActions.numActions() > 0) {
            this.println("            zzLexicalState match {");
            int last = this.dfa.numStates;
            for (String name : this.scanner.states.names()) {
                int num = this.scanner.states.getNumber(name);
                Action action = eofActions.getAction(num);
                if (action == null) continue;
                this.println("            case " + name + " => {");
                if (this.scanner.debugOption) {
                    this.print("              println(");
                    if (this.scanner.lineCount) {
                        this.print("\"line: \"+(yyline+1)+\" \"+");
                    }
                    if (this.scanner.columnCount) {
                        this.print("\"col: \"+(yycolumn+1)+\" \"+");
                    }
                    this.println("\"match: <<EOF>>\")");
                    this.print("              println(\"action [" + action.priority + "] { ");
                    this.print(this.escapify(action.content));
                    this.println(" }\")");
                }
                this.println("              " + action.content);
                this.println("            }");
                this.println("            case " + ++last + " => //noop");
            }
            this.println("            case _ => ");
        }
        if ((defaultAction = eofActions.getDefault()) != null) {
            if (this.scanner.debugOption) {
                this.print("                println(");
                if (this.scanner.lineCount) {
                    this.print("\"line: \"+(yyline+1)+\" \"+");
                }
                if (this.scanner.columnCount) {
                    this.print("\"col: \"+(yycolumn+1)+\" \"+");
                }
                this.println("\"match: <<EOF>>\")");
                this.print("                println(\"action [" + defaultAction.priority + "] { ");
                this.print(this.escapify(defaultAction.content));
                this.println(" }\")");
            }
            this.println("        " + defaultAction.content);
        } else if (this.scanner.eofVal != null) {
            this.println("          { " + this.scanner.eofVal + " }");
        } else if (this.scanner.isInteger) {
            if (this.scanner.tokenType != null) {
                Out.error(ErrorMessages.INT_AND_TYPE);
                throw new GeneratorException();
            }
            this.println("        return YYEOF");
        } else {
            this.println("        return null");
        }
        if (eofActions.numActions() > 0) {
            this.println("        }");
        }
    }

    protected void setupEOFCode() {
        if (this.scanner.eofclose) {
            this.scanner.eofCode = LexScan.conc(this.scanner.eofCode, "  yyclose()");
            this.scanner.eofThrow = LexScan.concExc(this.scanner.eofThrow, "java.io.IOException");
        }
    }

    public void emit() {
        this.setupEOFCode();
        if (this.scanner.functionName == null) {
            this.scanner.functionName = "yylex";
        }
        this.reduceColumns();
        this.findActionStates();
        this.emitHeader();
        this.emitUserCode();
        this.emitImports();
        this.emitClassName();
        this.skel.emitNext();
        this.println("  final val ZZ_BUFFERSIZE = " + this.scanner.bufferSize);
        if (this.scanner.debugOption) {
            this.println("  final val ZZ_NL = System.getProperty(\"line.separator\")");
        }
        this.skel.emitNext();
        this.emitLexicalStates();
        int packedCharMapPairs = this.emitCharMapArray();
        this.emitActionTable();
        this.reduceRows();
        this.emitRowMapArray();
        this.emitDynamicInit();
        this.skel.emitNext();
        this.emitAttributes();
        this.skel.emitNext();
        this.emitLookBuffer();
        this.emitClassCode();
        this.skel.emitNext();
        this.emitCharMapInitFunction(packedCharMapPairs);
        if (this.scanner.debugOption) {
            this.println("");
            this.println("  def zzToPrintable(str: String): String = {");
            this.println("    StringBuilder builder = new StringBuilder()");
            this.println("    var n = 0");
            this.println("    while (n < str.length()) {");
            this.println("      val ch = str.codePointAt(n)");
            this.println("      val charCount = Character.charCount(ch)");
            this.println("      n += charCount");
            this.println("      if (ch > 31 && ch < 127) {");
            this.println("        builder.append((char)ch)");
            this.println("      } else if (charCount == 1) {");
            this.println("        builder.append(String.format(\"\\\\u%04X\", ch))");
            this.println("      } else {");
            this.println("        builder.append(String.format(\"\\\\U%06X\", ch))");
            this.println("      }");
            this.println("    }");
            this.println("    builder.toString()");
            this.println("  }");
        }
        this.skel.emitNext();
        this.emitScanError();
        this.skel.emitNext();
        this.emitDoEOF();
        this.skel.emitNext();
        this.emitLexFunctHeader();
        this.emitNextInput();
        this.emitGetRowMapNext();
        this.skel.emitNext();
        this.emitEOFVal();
        this.skel.emitNext();
        this.emitActions();
        this.skel.emitNext();
        this.emitNoMatch();
        this.skel.emitNext();
        this.emitMain();
        this.skel.emitNext();
        this.out.close();
    }
}

