/*
 * Decompiled with CFR 0.152.
 */
package jflextest;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class CustomClassLoader
extends ClassLoader {
    private List<String> pathItems;

    public CustomClassLoader(String classPath) {
        this.scanPath(classPath);
    }

    private void scanPath(String classPath) {
        if (classPath == null) {
            return;
        }
        String separator = System.getProperty("path.separator");
        this.pathItems = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(classPath, separator);
        while (st.hasMoreTokens()) {
            this.pathItems.add(st.nextToken());
        }
    }

    public void addPath(String pathItem) {
        this.pathItems.add(pathItem);
    }

    public synchronized InputStream getResourceAsStream(String name) {
        InputStream s = super.getResourceAsStream(name);
        if (s != null) {
            return s;
        }
        for (String path : this.pathItems) {
            if (this.isJar(path)) {
                s = this.getZipEntryStream(path, name);
                if (s == null) continue;
                return s;
            }
            File file = new File(path, name);
            if (!file.canRead()) continue;
            try {
                return new FileInputStream(file);
            }
            catch (IOException e) {
            }
        }
        return null;
    }

    public synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c;
        try {
            c = this.findLoadedClass(name);
            if (c != null) {
                return c;
            }
            c = this.findSystemClass(name);
            if (c != null) {
                return c;
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        byte[] data = this.lookupClassData(name);
        if (data == null) {
            throw new ClassNotFoundException();
        }
        c = this.defineClass(name, data, 0, data.length);
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    private byte[] lookupClassData(String className) throws ClassNotFoundException {
        byte[] data = null;
        for (String path : this.pathItems) {
            String fileName = className.replace('.', '/') + ".class";
            data = this.isJar(path) ? this.loadJarData(path, fileName) : this.loadFileData(path, fileName);
            if (data == null) continue;
            return data;
        }
        throw new ClassNotFoundException();
    }

    boolean isJar(String pathEntry) {
        return pathEntry.endsWith(".jar") || pathEntry.endsWith(".zip");
    }

    private byte[] loadFileData(String path, String fileName) {
        File file = new File(path, fileName);
        if (file.canRead()) {
            try {
                int n;
                FileInputStream stream = new FileInputStream(file);
                ByteArrayOutputStream out = new ByteArrayOutputStream(1000);
                byte[] b = new byte[1000];
                while ((n = stream.read(b)) != -1) {
                    out.write(b, 0, n);
                }
                stream.close();
                out.close();
                return out.toByteArray();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return null;
    }

    private InputStream getZipEntryStream(String file, String entryName) {
        try {
            ZipFile zip = new ZipFile(new File(file));
            ZipEntry entry = zip.getEntry(entryName);
            if (entry == null) {
                return null;
            }
            return zip.getInputStream(entry);
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadJarData(String path, String fileName) {
        block20: {
            byte[] byArray;
            int size;
            ZipEntry entry;
            ZipFile zipFile;
            try {
                zipFile = new ZipFile(new File(path));
                entry = zipFile.getEntry(fileName);
                if (entry == null) {
                    return null;
                }
                size = (int)entry.getSize();
            }
            catch (IOException io) {
                return null;
            }
            InputStream stream = null;
            try {
                int n;
                stream = zipFile.getInputStream(entry);
                if (stream == null) {
                    byte[] byArray2 = null;
                    return byArray2;
                }
                byte[] data = new byte[size];
                for (int pos = 0; pos < size; pos += n) {
                    n = stream.read(data, pos, data.length - pos);
                }
                zipFile.close();
                byArray = data;
            }
            catch (IOException e) {
                break block20;
            }
            finally {
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException e) {}
            }
            return byArray;
        }
        return null;
    }
}

