/*
 * Decompiled with CFR 0.152.
 */
package jflextest;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DiffStream {
    private int linesProcessed;

    private boolean match(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        return s1.replace('\\', '/').equals(s2.replace('\\', '/'));
    }

    public String diff(Reader input, Reader expected) {
        return this.diff(null, input, expected);
    }

    public String diff(List<Integer> diffLines, Reader input, Reader expected) {
        if (diffLines == null) {
            diffLines = new ArrayList<Integer>();
        }
        this.linesProcessed = 1;
        BufferedReader myInput = new BufferedReader(input);
        BufferedReader myExpected = new BufferedReader(expected);
        try {
            String readFromExpected;
            String readFromInput;
            do {
                readFromInput = myInput.readLine();
                readFromExpected = myExpected.readLine();
                if (readFromInput == null && readFromExpected != null) {
                    return "EOF reached in Expected(Line:" + this.linesProcessed + ")... got more Lines to compare.\n";
                }
                if (readFromInput != null && readFromExpected == null) {
                    return "EOF reached in Input(Line:" + this.linesProcessed + ")... more Lines expected.\n";
                }
                if (readFromInput != null && !this.match(readFromInput, readFromExpected) && !diffLines.contains(new Integer(this.linesProcessed))) {
                    return "Difference in line " + this.linesProcessed + "\n" + "expected :[" + readFromExpected + "]\n" + "but got  :[" + readFromInput + "]";
                }
                ++this.linesProcessed;
            } while (readFromInput != null && readFromExpected != null);
        }
        catch (IOException e) {
            return "Error processing Files...compare aborted.\n";
        }
        return null;
    }

    public String diff(String input, String expected) {
        return this.diff(new StringReader(input), new StringReader(expected));
    }
}

