/*
 * Decompiled with CFR 0.152.
 */
package jflextest;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jflex.GeneratorException;
import jflex.Main;
import jflex.Options;
import jflex.Out;
import jflex.SilentExit;
import jflextest.CustomClassLoader;
import jflextest.TestResult;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.types.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Exec {
    private static String javaVersion = "1.5";

    private static String[] toArray(List<String> a, List<String> b) {
        if (a == null) {
            a = new ArrayList<String>();
        }
        if (b == null) {
            b = new ArrayList<String>();
        }
        String[] cmdline = new String[a.size() + b.size()];
        int n = 0;
        for (String aElem : a) {
            cmdline[n++] = aElem;
        }
        for (String bElem : b) {
            cmdline[n++] = bElem;
        }
        return cmdline;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TestResult execJavac(String toCompile, File dir, String jflexTestVersion) {
        Project p = new Project();
        Javac javac = new Javac();
        Path path = new Path(p, dir.toString());
        javac.setProject(p);
        javac.setSrcdir(path);
        javac.setDestdir(dir);
        javac.setTarget(javaVersion);
        javac.setSource(javaVersion);
        javac.setSourcepath(new Path(p, ""));
        javac.setIncludes(toCompile);
        Path classPath = javac.createClasspath();
        classPath.setPath(System.getProperty("user.home") + "/.m2/repository/de/jflex/jflex/" + jflexTestVersion + "/jflex-" + jflexTestVersion + ".jar");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream outSafe = System.err;
        System.setErr(new PrintStream(out));
        try {
            javac.execute();
            TestResult testResult = new TestResult(out.toString(), true);
            return testResult;
        }
        catch (BuildException e) {
            TestResult testResult = new TestResult((Object)((Object)e) + System.getProperty("line.separator") + out.toString(), false);
            return testResult;
        }
        finally {
            System.setErr(outSafe);
        }
    }

    public static TestResult execJFlex(List<String> cmdline, List<String> files) {
        String[] cmd = Exec.toArray(cmdline, files);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            Options.setDefaults();
            Out.setOutputStream((OutputStream)out);
            Main.generate((String[])cmd);
            return new TestResult(out.toString(), true);
        }
        catch (GeneratorException e) {
            return new TestResult(out.toString(), false);
        }
        catch (SilentExit e) {
            return new TestResult(out.toString(), false);
        }
    }

    public static String getJFlexVersion() {
        ArrayList<String> cmdLine = new ArrayList<String>();
        cmdLine.add("--version");
        TestResult test = Exec.execJFlex(cmdLine, new ArrayList<String>());
        return test.getOutput();
    }

    public static TestResult execClass(String theClass, String path, List<String> cmdline, List<String> files, String jflexTestVersion, String outputFileEncoding) throws UnsupportedEncodingException {
        Method main;
        Class c;
        String[] cmd = Exec.toArray(cmdline, files);
        Class[] sig = new Class[]{String[].class};
        CustomClassLoader l = new CustomClassLoader(path);
        l.addPath(System.getProperty("user.home") + "/.m2/repository/de/jflex/jflex/" + jflexTestVersion + "/jflex-" + jflexTestVersion + ".jar");
        try {
            c = l.loadClass(theClass, true);
        }
        catch (ClassNotFoundException e) {
            System.out.println("no such class: " + e);
            return null;
        }
        try {
            main = c.getMethod("main", sig);
        }
        catch (NoSuchMethodException e) {
            System.out.println("no main: " + e);
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        boolean success = true;
        PrintStream stdOut = System.out;
        System.setOut(new PrintStream(out, true));
        try {
            Object[] params = new Object[]{cmd};
            main.invoke(null, params);
            System.setOut(stdOut);
        }
        catch (IllegalAccessException e) {
            System.setOut(stdOut);
            System.out.println("main not public :" + e + main);
            return null;
        }
        catch (InvocationTargetException e) {
            System.setOut(stdOut);
            System.out.println("test subject threw exception :" + e);
            success = false;
        }
        return new TestResult(out.toString(outputFileEncoding), success);
    }

    public static void main(String[] args) {
        ArrayList<String> files = new ArrayList<String>();
        files.addAll(Arrays.asList(args));
        System.out.println();
        System.out.println("jflex:\n" + Exec.execJFlex(new ArrayList<String>(), files));
        try {
            System.out.println("class:\n" + Exec.execClass("jflextest.Main", ".", new ArrayList<String>(), files, "1.7.0-SNAPSHOT", "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            System.out.println("UTF-8 is not a supported encoding.");
            System.exit(1);
        }
    }
}

