/*
 * Decompiled with CFR 0.152.
 */
package jflextest;

import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import jflextest.Exec;
import jflextest.Main;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class JFlexTestsuiteMojo
extends AbstractMojo {
    private String testDirectory = null;
    private boolean verbose;
    private String testcases;
    private String jflexTestVersion;

    public void execute() throws MojoExecutionException, MojoFailureException {
        boolean success = true;
        try {
            System.setOut(new PrintStream(System.out, true));
            ArrayList<File> files = new ArrayList();
            this.getLog().info((CharSequence)"JFlexTest Version: 1.0alpha");
            this.getLog().info((CharSequence)("Testing version: " + Exec.getJFlexVersion()));
            this.getLog().info((CharSequence)("Test directory: " + this.testDirectory));
            this.getLog().info((CharSequence)("Test case(s): " + (null == this.testcases ? "All" : this.testcases)));
            if (this.testcases != null && this.testcases.length() > 0) {
                for (String testCase : this.testcases.split("\\s*,\\s*")) {
                    File dir = new File(this.testDirectory, testCase.trim());
                    if (!dir.isDirectory()) {
                        throw new MojoFailureException(dir + " - test path not found");
                    }
                    List<File> t = Main.scan(dir, ".test", false);
                    files.addAll(t);
                }
            }
            if (files.isEmpty()) {
                files = Main.scan(new File(this.testDirectory), ".test", true);
            }
            Main.verbose = this.verbose;
            Main.jflexTestVersion = this.jflexTestVersion;
            this.getLog().info((CharSequence)("verbose: " + this.verbose));
            success = Main.runTests(files);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Exception", e);
        }
        if (!success) {
            throw new MojoFailureException("Test(s) failed.");
        }
    }
}

