/*
 * Decompiled with CFR 0.152.
 */
package jflextest;

import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import jflextest.Exec;
import jflextest.TestCase;
import jflextest.TestFailException;
import jflextest.TestLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main {
    public static boolean verbose;
    public static String jflexTestVersion;
    public static final String version = "1.0alpha";

    public static void showUsage(String error) {
        System.out.println("Usage: [-v] [-testpath path] <test1> <test2> <test3> ...");
        System.out.println();
        System.out.println(error);
    }

    public static List<File> scan(File dir, final String extension, boolean recursive) {
        ArrayList<File> result = new ArrayList<File>();
        FilenameFilter extFilter = new FilenameFilter(){

            public boolean accept(File f, String name) {
                return name.endsWith(extension);
            }
        };
        String[] files = dir.list(extFilter);
        if (files != null) {
            for (String file : files) {
                result.add(new File(dir, file));
            }
        }
        if (!recursive) {
            return result;
        }
        FilenameFilter dirFilter = new FilenameFilter(){

            public boolean accept(File f, String name) {
                return new File(f, name).isDirectory();
            }
        };
        String[] dirs = dir.list(dirFilter);
        if (dirs == null) {
            return result;
        }
        for (String childDir : dirs) {
            List<File> t = Main.scan(new File(dir, childDir), extension, true);
            result.addAll(t);
        }
        return result;
    }

    public static boolean runTests(List<File> tests) {
        int successCount = 0;
        int totalCount = 0;
        for (File test : tests) {
            ++totalCount;
            if (verbose) {
                System.out.println("");
                System.out.println("Processing test [" + test + "]");
            }
            try {
                File currentDir = new File(test.getParent());
                TestLoader loader = new TestLoader(new FileReader(test));
                TestCase currentTest = loader.load();
                currentTest.init(currentDir);
                if (currentTest == null) {
                    throw new TestFailException("not loaded");
                }
                if (verbose) {
                    System.out.println("Loaded successfully");
                }
                currentTest.createScanner();
                while (currentTest.hasMoreToDo()) {
                    currentTest.runNext();
                }
                ++successCount;
                System.out.println("Test [" + test + "] finished successfully.");
            }
            catch (TestFailException e) {
                System.out.println("Test [" + test + "] failed!");
            }
            catch (IOException e) {
                System.out.println("IO Error:" + e.getMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.out.println();
        System.out.println("All done - " + successCount + " tests completed successfully, " + (totalCount - successCount) + " tests failed.");
        return 0 == totalCount - successCount;
    }

    public static void main(String[] argv) {
        System.setOut(new PrintStream(System.out, true));
        System.out.println("JFlexTest Version: 1.0alpha");
        System.out.println("Testing version: " + Exec.getJFlexVersion());
        File dir = new File("testcases");
        List<File> files = new ArrayList<File>();
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].equals("-testpath")) {
                if (++i >= argv.length) {
                    Main.showUsage("missing path argument");
                    return;
                }
                dir = new File(argv[i]);
                if (dir.isDirectory()) continue;
                Main.showUsage(dir + " - test path not found");
                return;
            }
            if (argv[i].equals("-v")) {
                verbose = true;
                continue;
            }
            List<File> t = Main.scan(new File(dir, argv[i]), ".test", false);
            files.addAll(t);
        }
        if (files.isEmpty()) {
            files = Main.scan(dir, ".test", true);
        }
        Main.runTests(files);
    }
}

