/*
 * Decompiled with CFR 0.152.
 */
package jflextest;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import jflextest.DiffStream;
import jflextest.Exec;
import jflextest.InputOutput;
import jflextest.Main;
import jflextest.TestFailException;
import jflextest.TestResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestCase {
    private List<String> jflexCmdln;
    private List<String> jflexFiles;
    private List<String> javacExtraFiles;
    private List<Integer> jflexDiff;
    private String inputFileEncoding = "UTF-8";
    private String outputFileEncoding = "UTF-8";
    private String commonInputFile = null;
    private String className;
    private String testName;
    private String description;
    private TestResult jflexResult;
    private TestResult javacResult;
    private TestResult classExecResult;
    private File testPath;
    private boolean expectJavacFail;
    private boolean expectJFlexFail;
    private List<InputOutput> inputOutput;

    public void setTestName(String s) {
        this.testName = s;
        this.className = this.testName.substring(0, 1).toUpperCase(Locale.ENGLISH) + this.testName.substring(1);
    }

    public void setJFlexDiff(List<Integer> d) {
        this.jflexDiff = d;
    }

    public String getTestName() {
        return this.testName;
    }

    public void setDescription(String s) {
        this.description = s;
    }

    public void setExpectJavacFail(boolean b) {
        this.expectJavacFail = b;
    }

    public void setExpectJFlexFail(boolean b) {
        this.expectJFlexFail = b;
    }

    public void setJflexCmdln(List<String> v) {
        this.jflexCmdln = v;
    }

    public void setJavacExtraFiles(List<String> v) {
        this.javacExtraFiles = v;
    }

    public void setInputOutput(List<InputOutput> v) {
        this.inputOutput = v;
    }

    public void setInputFileEncoding(String e) {
        this.inputFileEncoding = e;
    }

    public void setOutputFileEncoding(String e) {
        this.outputFileEncoding = e;
    }

    public void setCommonInputFile(String f) {
        this.commonInputFile = f;
    }

    public TestCase() {
        this.setDefaults();
    }

    private void setDefaults() {
        this.jflexFiles = new ArrayList<String>();
    }

    public void init(File testDir) {
        ArrayList<InputOutput> temp = new ArrayList<InputOutput>();
        for (String file : testDir.list()) {
            if (null != this.commonInputFile) {
                if (!file.equals(this.testName + ".output")) continue;
                temp.add(new InputOutput(new File(testDir, this.testName).toString(), true));
                this.commonInputFile = new File(testDir, this.commonInputFile).toString();
                continue;
            }
            if (!file.endsWith(".input") || !file.startsWith(this.testName + "-")) continue;
            String name = file.substring(0, file.length() - 6);
            temp.add(new InputOutput(new File(testDir, name).toString(), new File(testDir, name + ".output").exists()));
        }
        if (null != this.commonInputFile && 0 == temp.size()) {
            temp.add(new InputOutput(null, false));
        }
        this.setInputOutput(temp);
        this.testPath = testDir;
    }

    public void createScanner() throws TestFailException {
        this.jflexFiles.add(new File(this.testPath, this.testName + ".flex").getPath());
        this.jflexResult = Exec.execJFlex(this.jflexCmdln, this.jflexFiles);
        if (this.jflexResult.getSuccess()) {
            if (Main.verbose) {
                System.out.println("Scanner generation successful");
            }
            if (this.expectJFlexFail) {
                System.out.println("JFlex failure expected!");
                throw new TestFailException();
            }
            File expected = new File(this.testPath, this.testName + "-flex.output");
            if (expected.exists()) {
                String diff;
                DiffStream check = new DiffStream();
                try {
                    diff = check.diff(this.jflexDiff, new StringReader(this.jflexResult.getOutput()), new FileReader(expected));
                }
                catch (FileNotFoundException e) {
                    System.out.println("Error opening file " + expected);
                    throw new TestFailException();
                }
                if (diff != null) {
                    System.out.println("Test failed, unexpected jflex output: " + diff);
                    System.out.println("JFlex output: " + this.jflexResult.getOutput());
                    throw new TestFailException();
                }
            } else {
                System.out.println("Warning: no file for expected output [" + expected + "]");
            }
            StringBuilder builder = new StringBuilder();
            builder.append(new File(this.testPath, this.className + ".java").getName());
            if (null != this.javacExtraFiles) {
                for (String extraFile : this.javacExtraFiles) {
                    builder.append(',').append(extraFile);
                }
            }
            String toCompile = builder.toString();
            if (Main.verbose) {
                System.out.println("File(s) to Compile: " + toCompile);
            }
            this.javacResult = Exec.execJavac(toCompile, this.testPath, Main.jflexTestVersion);
            if (Main.verbose) {
                System.out.println("Compilation successful: " + this.javacResult.getSuccess() + " [expected: " + !this.expectJavacFail + "]");
            }
            if (this.javacResult.getSuccess() == this.expectJavacFail) {
                System.out.println("Compilation failed, messages:");
                System.out.println(this.javacResult.getOutput());
                throw new TestFailException();
            }
        } else {
            if (!this.expectJFlexFail) {
                System.out.println("Scanner generation failed!");
                System.out.println("JFlex output was:\n" + this.jflexResult.getOutput());
                throw new TestFailException();
            }
            File expected = new File(this.testPath, this.testName + "-flex.output");
            if (expected.exists()) {
                String diff;
                DiffStream check = new DiffStream();
                try {
                    diff = check.diff(this.jflexDiff, new StringReader(this.jflexResult.getOutput()), new FileReader(expected));
                }
                catch (FileNotFoundException e) {
                    System.out.println("Error opening file " + expected);
                    throw new TestFailException();
                }
                if (diff != null) {
                    System.out.println("Test failed, unexpected jflex output: " + diff);
                    System.out.println("JFlex output: " + this.jflexResult.getOutput());
                    throw new TestFailException();
                }
            }
        }
    }

    public boolean hasMoreToDo() {
        return !this.inputOutput.isEmpty();
    }

    public void runNext() throws TestFailException, UnsupportedEncodingException {
        File expected;
        InputOutput current = this.inputOutput.remove(0);
        ArrayList<String> inputFiles = new ArrayList<String>();
        inputFiles.add(null != this.commonInputFile ? this.commonInputFile : current.getName() + ".input");
        ArrayList<String> cmdLine = new ArrayList<String>();
        cmdLine.add("--encoding");
        cmdLine.add(this.inputFileEncoding);
        this.classExecResult = Exec.execClass(this.className, this.testPath.toString(), cmdLine, inputFiles, Main.jflexTestVersion, this.outputFileEncoding);
        if (Main.verbose) {
            System.out.println("Running scanner on [" + current.getName() + "]");
        }
        if ((expected = new File(current.getName() + ".output")).exists()) {
            String diff;
            DiffStream check = new DiffStream();
            try {
                diff = check.diff(this.jflexDiff, new StringReader(this.classExecResult.getOutput()), new InputStreamReader((InputStream)new FileInputStream(expected), this.outputFileEncoding));
            }
            catch (FileNotFoundException e) {
                System.out.println("Error opening file " + expected);
                throw new TestFailException();
            }
            catch (UnsupportedEncodingException e) {
                System.out.println("Unsupported encoding '" + this.outputFileEncoding + "'");
                throw new TestFailException();
            }
            if (diff != null) {
                System.out.println("Test failed, unexpected output: " + diff);
                System.out.println("Test output: " + this.classExecResult.getOutput());
                throw new TestFailException();
            }
        } else {
            System.out.println("Warning: no file for expected output [" + expected + "]");
        }
    }

    public String toString() {
        return "Testname: " + this.testName + "\nDescription: " + this.description + "JFlexFail: " + this.expectJFlexFail + " JavacFail: " + this.expectJavacFail + "\n" + "JFlex Command line: " + this.jflexCmdln + (null != this.javacExtraFiles ? " Javac Extra Files: " + Arrays.toString(this.javacExtraFiles.toArray()) : "") + "\n" + "Files to run Main on " + this.inputOutput + (null != this.commonInputFile ? " Common input file: " + this.commonInputFile : "");
    }
}

