/* The following code was generated by JFlex 1.4.3 on 4/7/15 3:37 PM */

package jflex;

import java.util.SortedSet;
import java.util.TreeSet;

/**
 * Scans the common single-property Unicode.org data file format, populating
 * unicodeVersion.propertyValueIntervals and 
 * unicodeVersion.usedPropertyValueAliases.
 */

public class EnumeratedPropertyFileScanner {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int END_RANGE = 4;
  public static final int DEFAULT_PROPERTY_VALUE = 12;
  public static final int YYINITIAL = 0;
  public static final int COMMENT_LINE = 10;
  public static final int PROPERTY_NAME = 6;
  public static final int PROPERTY_VALUE = 8;
  public static final int BEGIN_RANGE = 2;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6, 6
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\2\1\3\2\0\1\4\22\0\1\26\2\0\1\6\12\0"+
    "\1\25\1\0\12\1\1\16\1\5\4\0\1\17\6\1\11\0\1\7"+
    "\20\0\4\1\1\13\1\1\1\24\1\0\1\21\3\0\1\20\1\23"+
    "\1\11\1\12\1\0\1\10\1\22\1\14\4\0\1\15\uff86\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\5\0\1\1\3\0\2\2\1\3\1\0\1\4\3\0"+
    "\1\5\1\6\1\0\2\1\1\7\2\0\2\10\4\0"+
    "\1\11\2\0\1\1\1\10\4\0\1\10\1\12\2\0"+
    "\1\13\1\10\1\12\2\0\1\13\2\10\1\12\2\0"+
    "\1\13\2\10\2\0\1\10\2\0\1\10\2\0\1\10"+
    "\1\14\1\15\2\10\1\0\1\2\1\10\1\2";

  private static int [] zzUnpackAction() {
    int [] result = new int[75];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\27\0\56\0\105\0\134\0\163\0\212\0\241"+
    "\0\270\0\317\0\346\0\375\0\u0114\0\u012b\0\u0142\0\u0159"+
    "\0\u0170\0\u0187\0\u019e\0\u01b5\0\317\0\u01cc\0\u01e3\0\u01fa"+
    "\0\u0211\0\u0228\0\u023f\0\u0256\0\375\0\u026d\0\u0284\0\317"+
    "\0\u029b\0\u02b2\0\u0211\0\u02c9\0\u02e0\0\u02f7\0\u030e\0\u0325"+
    "\0\u033c\0\u0353\0\u036a\0\u0381\0\u0398\0\u03af\0\u03c6\0\u03dd"+
    "\0\u03f4\0\u040b\0\u0422\0\u0439\0\317\0\u0450\0\u0467\0\317"+
    "\0\u047e\0\u0495\0\u04ac\0\u04c3\0\u04da\0\u04f1\0\u0508\0\u051f"+
    "\0\u0536\0\u054d\0\u0564\0\u057b\0\u0592\0\u05a9\0\u05c0\0\u05d7"+
    "\0\u05ee\0\u0605\0\u061c";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[75];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\0\1\10\1\11\1\12\1\13\1\0\1\14\4\0"+
    "\1\10\12\0\1\11\2\0\1\15\2\0\1\16\17\0"+
    "\1\17\1\15\1\0\1\20\1\21\2\0\1\22\5\0"+
    "\1\20\12\0\1\21\2\23\1\24\1\25\1\26\21\23"+
    "\1\24\2\27\1\30\1\25\1\26\1\0\1\31\17\27"+
    "\1\30\3\6\1\25\23\6\1\32\1\33\1\24\1\25"+
    "\1\26\6\32\1\33\12\32\1\24\1\0\1\34\11\0"+
    "\1\34\15\0\1\11\1\12\1\13\1\0\1\14\17\0"+
    "\1\11\32\0\1\12\25\0\1\35\4\0\1\36\7\0"+
    "\1\37\6\0\1\35\2\0\1\15\2\0\1\16\20\0"+
    "\1\15\2\0\1\16\23\0\1\16\25\0\1\40\2\0"+
    "\1\41\11\0\1\41\15\0\1\21\2\0\1\22\20\0"+
    "\1\21\2\0\1\22\23\0\1\22\2\23\3\0\21\23"+
    "\3\0\1\24\1\25\1\26\21\0\1\24\3\0\1\25"+
    "\23\0\2\27\5\0\17\27\1\42\2\0\1\30\1\25"+
    "\1\26\1\0\1\31\17\0\1\30\3\31\1\25\1\43"+
    "\22\31\2\32\3\0\21\32\1\0\1\32\1\44\3\0"+
    "\6\32\1\44\12\32\2\0\1\45\11\0\1\45\23\0"+
    "\1\46\36\0\1\47\7\0\1\50\11\0\1\50\13\0"+
    "\2\27\5\0\17\27\1\0\1\32\1\51\3\0\6\32"+
    "\1\51\12\32\2\0\1\52\11\0\1\52\24\0\1\53"+
    "\36\0\1\54\6\0\1\55\11\0\1\55\13\0\1\32"+
    "\1\56\3\0\6\32\1\56\12\32\2\0\1\57\11\0"+
    "\1\57\25\0\1\60\36\0\1\61\5\0\1\62\11\0"+
    "\1\62\13\0\1\32\1\63\3\0\6\32\1\63\11\32"+
    "\1\64\2\0\1\65\11\0\1\65\26\0\1\66\35\0"+
    "\1\67\5\0\1\70\11\0\1\70\13\0\1\32\1\71"+
    "\3\0\6\32\1\71\11\32\1\64\1\0\2\32\3\0"+
    "\20\32\1\72\11\0\1\73\37\0\1\74\5\0\2\32"+
    "\3\0\20\32\1\64\1\0\1\32\1\75\3\0\6\32"+
    "\1\75\12\32\15\0\1\76\35\0\1\77\3\0\1\32"+
    "\1\100\3\0\6\32\1\100\12\32\16\0\1\101\35\0"+
    "\1\102\2\0\1\32\1\103\3\0\6\32\1\103\12\32"+
    "\17\0\1\104\26\0\1\105\10\0\1\32\1\106\3\0"+
    "\6\32\1\106\12\32\3\0\1\104\23\0\1\104\2\0"+
    "\1\105\23\0\1\105\1\32\1\107\1\110\2\0\1\111"+
    "\5\32\1\107\12\32\1\110\1\32\1\112\1\110\2\0"+
    "\1\111\5\32\1\112\12\32\1\110\2\0\1\110\2\0"+
    "\1\113\20\0\1\110\2\32\1\113\2\0\21\32\1\113"+
    "\2\32\1\110\2\0\1\111\20\32\1\110\2\0\1\113"+
    "\23\0\1\113";

  private static int [] zzUnpackTrans() {
    int [] result = new int[1587];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\5\0\1\1\3\0\1\11\2\1\1\0\1\1\3\0"+
    "\2\1\1\0\1\11\2\1\2\0\2\1\4\0\1\11"+
    "\2\0\2\1\4\0\2\1\2\0\3\1\2\0\3\1"+
    "\1\11\2\0\1\11\2\1\2\0\1\1\2\0\1\1"+
    "\2\0\5\1\1\0\3\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[75];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /* user code: */
  UnicodeVersion unicodeVersion;
  SortedSet<NamedRange> intervals = new TreeSet<NamedRange>();
  String defaultPropertyValue;
  String propertyName;
  int start;
  int end;
  
  public void addPropertyValueIntervals() {
    int prevEnd = -1;
    int prevStart = -1;
    String prevValue = "";
    for (NamedRange interval : intervals) {
      if (interval.start > prevEnd + 1) {
        // Unassigned code points get the default property value, e.g. "Unknown"
        unicodeVersion.addInterval
          (propertyName, defaultPropertyValue, prevEnd + 1, interval.start - 1);
      }
      if (prevEnd == -1) {
        prevStart = interval.start;
        prevValue = interval.name;
      } else if (interval.start > prevEnd + 1 || ! interval.name.equals(prevValue)) {
        unicodeVersion.addInterval(propertyName, prevValue, prevStart, prevEnd);
        prevStart = interval.start;
        prevValue = interval.name;
      }
      prevEnd = interval.end;
    }

    // Add final default property value interval, if necessary
    if (prevEnd < unicodeVersion.maximumCodePoint) {
      unicodeVersion.addInterval(propertyName, defaultPropertyValue, 
                                 prevEnd + 1, unicodeVersion.maximumCodePoint);
    }
    
    // Add final named interval
    unicodeVersion.addInterval(propertyName, prevValue, prevStart, prevEnd);
  }
  
  protected boolean accept(String propertyValue) {
    return true;
  }


  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public EnumeratedPropertyFileScanner(java.io.Reader in, UnicodeVersion unicodeVersion, String defaultPropertyName, String defaultPropertyValue) {
    this.unicodeVersion = unicodeVersion;
  this.propertyName = defaultPropertyName;
  this.defaultPropertyValue = defaultPropertyValue;
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public EnumeratedPropertyFileScanner(java.io.InputStream in, UnicodeVersion unicodeVersion, String defaultPropertyName, String defaultPropertyValue) {
    this(new java.io.InputStreamReader(in), unicodeVersion, defaultPropertyName, defaultPropertyValue);
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 78) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead > 0) {
      zzEndRead+= numRead;
      return false;
    }
    // unlikely but not impossible: read 0 characters, but not at end of stream    
    if (numRead == 0) {
      int c = zzReader.read();
      if (c == -1) {
        return true;
      } else {
        zzBuffer[zzEndRead++] = (char) c;
        return false;
      }     
    }

	// numRead < 0
    return true;
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEOFDone = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void zzDoEOF() throws java.io.IOException {
    if (!zzEOFDone) {
      zzEOFDone = true;
      yyclose();
    }
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public int scan() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 10: 
          { start = Integer.parseInt(yytext(), 16); yybegin(BEGIN_RANGE);
          }
        case 14: break;
        case 13: 
          { yybegin(DEFAULT_PROPERTY_VALUE);
          }
        case 15: break;
        case 5: 
          { yybegin(PROPERTY_VALUE);
          }
        case 16: break;
        case 6: 
          { propertyName = yytext();
          }
        case 17: break;
        case 12: 
          { yybegin(PROPERTY_NAME);
          }
        case 18: break;
        case 8: 
          { defaultPropertyValue = yytext();
          }
        case 19: break;
        case 7: 
          { String val = yytext();
                                       if (accept(val)) {
                                         intervals.add(new NamedRange(start, end, val));
                                       }
          }
        case 20: break;
        case 11: 
          { end = Integer.parseInt(yytext(), 16);
          }
        case 21: break;
        case 9: 
          { yybegin(END_RANGE);
          }
        case 22: break;
        case 4: 
          { end = start; yybegin(PROPERTY_VALUE);
          }
        case 23: break;
        case 1: 
          { yybegin(YYINITIAL);
          }
        case 24: break;
        case 2: 
          { 
          }
        case 25: break;
        case 3: 
          { yybegin(COMMENT_LINE);
          }
        case 26: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            zzDoEOF();
            switch (zzLexicalState) {
            case DEFAULT_PROPERTY_VALUE: {
              addPropertyValueIntervals(); return 0;
            }
            case 76: break;
            case YYINITIAL: {
              addPropertyValueIntervals(); return 0;
            }
            case 77: break;
            case PROPERTY_NAME: {
              addPropertyValueIntervals(); return 0;
            }
            case 78: break;
            case PROPERTY_VALUE: {
              addPropertyValueIntervals(); return 0;
            }
            case 79: break;
            default:
            return YYEOF;
            }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
