/* The following code was generated by JFlex 1.4.3 on 4/7/15 3:37 PM */

package jflex;

/**
 * 
 */

public final class UnicodeDataScanner {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int ISO_COMMENT_11 = 22;
  public static final int NUMERIC_VALUE_OTHER_8 = 16;
  public static final int NAME_1 = 2;
  public static final int SIMPLE_LOWERCASE_MAPPING_13 = 26;
  public static final int DECOMPOSITION_TYPE_AND_MAPPING_5 = 10;
  public static final int BIDI_MIRRORED_9 = 18;
  public static final int UNICODE_1_NAME_10 = 20;
  public static final int SIMPLE_UPPERCASE_MAPPING_12 = 24;
  public static final int NUMERIC_TYPE_6 = 12;
  public static final int GENERAL_CATEGORY_2 = 4;
  public static final int NUMERIC_VALUE_INTEGER_7 = 14;
  public static final int IGNORE_REST_OF_LINE = 30;
  public static final int YYINITIAL = 0;
  public static final int SIMPLE_TITLECASE_MAPPING_14 = 28;
  public static final int BIDI_CLASS_4 = 8;
  public static final int CANONICAL_COMBINING_CLASS_3 = 6;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7, 
     8,  8,  9,  9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\2\1\3\2\0\1\4\22\0\1\2\2\0\1\5\10\0"+
    "\1\11\3\0\12\1\1\0\1\6\1\7\1\0\1\10\2\0\6\1"+
    "\5\0\1\12\24\0\1\13\5\1\14\0\1\14\1\15\uff8b\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\17\0\1\1\1\2\1\0\2\3\1\0\1\4\1\3"+
    "\1\5\1\3\1\6\1\7\1\10\1\11\1\12\1\13"+
    "\1\14\1\15\1\16\1\17\1\20\1\21\1\22\1\23"+
    "\1\24\1\25\2\26\2\3\1\0\1\3\1\0\1\3"+
    "\1\0\1\3\1\0\1\3\1\0\1\3\1\0\2\27";

  private static int [] zzUnpackAction() {
    int [] result = new int[58];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\16\0\34\0\52\0\70\0\106\0\124\0\142"+
    "\0\160\0\176\0\214\0\232\0\250\0\266\0\304\0\322"+
    "\0\340\0\356\0\374\0\u010a\0\u0118\0\374\0\u0126\0\374"+
    "\0\u0134\0\u0142\0\374\0\374\0\374\0\374\0\374\0\374"+
    "\0\374\0\374\0\374\0\374\0\u0150\0\374\0\u015e\0\374"+
    "\0\u016c\0\374\0\u017a\0\u0118\0\u0188\0\u0196\0\u01a4\0\u01b2"+
    "\0\u01c0\0\u01ce\0\u01dc\0\u01ea\0\u01f8\0\u0206\0\u0214\0\u0222"+
    "\0\u0126\0\374";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[58];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\0\1\21\1\22\1\23\1\24\1\25\1\26\4\0"+
    "\1\21\2\0\6\27\1\30\1\31\6\27\6\32\1\33"+
    "\7\32\6\27\1\34\15\27\1\35\15\27\1\36\15\27"+
    "\1\37\15\27\1\40\15\27\1\41\15\27\1\42\15\27"+
    "\1\43\15\27\1\44\7\27\6\45\1\46\7\45\6\47"+
    "\1\50\7\47\3\51\1\52\1\53\11\51\3\20\1\0"+
    "\12\20\1\0\1\21\11\0\1\21\4\0\1\22\1\23"+
    "\1\24\1\25\31\0\1\23\12\0\3\25\1\23\1\54"+
    "\11\25\6\27\1\0\7\27\6\55\1\56\1\55\2\27"+
    "\4\55\6\32\1\0\7\32\6\45\1\0\7\45\6\47"+
    "\1\0\7\47\3\51\2\0\11\51\3\0\1\52\12\0"+
    "\6\55\1\56\1\55\1\27\1\57\4\55\10\56\1\0"+
    "\1\60\4\56\2\27\1\57\3\27\1\0\3\27\1\61"+
    "\3\27\2\0\1\60\7\0\1\62\3\0\6\27\1\0"+
    "\4\27\1\63\2\27\13\0\1\64\2\0\6\27\1\0"+
    "\5\27\1\65\1\27\14\0\1\66\1\0\6\27\1\0"+
    "\6\27\1\67\15\0\1\70\6\27\1\0\1\27\1\71"+
    "\5\27\10\0\1\72\5\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[560];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\17\0\2\1\1\0\1\11\1\1\1\0\1\11\1\1"+
    "\1\11\2\1\12\11\1\1\1\11\1\1\1\11\1\1"+
    "\1\11\3\1\1\0\1\1\1\0\1\1\1\0\1\1"+
    "\1\0\1\1\1\0\1\1\1\0\1\1\1\11";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[58];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /* user code: */
  private static final String GENERAL_CATEGORY = "General_Category";
  UnicodeVersion unicodeVersion;
  int codePoint = -1;
  int startCodePoint = -1;
  int prevCodePoint = 0;
  int assignedStartCodePoint = -1;
  int assignedEndCodePoint = -1;
  String genCatPropValue;
  String prevGenCatPropValue;
  String uppercaseMapping = null;
  String lowercaseMapping = null;
  String titlecaseMapping = null;
  boolean isLastInRange = false;
  
  public void handleEntry() {
    if (codePoint != -1) {
      unicodeVersion.addCaselessMatches
        (codePoint, uppercaseMapping, lowercaseMapping, titlecaseMapping);

        // UnicodeData-1.1.5.txt does not list the end point for the Unified Han
        // range (starting point is listed as U+4E00).  This is U+9FFF according
        // to <http://unicode.org/Public/TEXT/OLDAPIX/CHANGES.TXT>:
        //
        //    U+4E00 ^ U+9FFF		20,992	I-ZONE Ideographs
        //
        // U+4E00 is listed in UnicodeData-1.1.5.txt as having the "Lo" property
        // value, as are the previous code points, so to include
        // [ U+4E00 - U+9FFF ], this interval should be extended to U+9FFF.
        if (assignedEndCodePoint  == 0x4E00
            && unicodeVersion.majorMinorVersion.equals("1.1")) {
          assignedEndCodePoint = 0x9FFF;
        }

      if (assignedStartCodePoint == -1) {
        assignedStartCodePoint = startCodePoint;
      } else if (codePoint > assignedEndCodePoint + 1 && ! isLastInRange) {
        unicodeVersion.addInterval
          ("Assigned", assignedStartCodePoint, assignedEndCodePoint);
        unicodeVersion.addInterval(GENERAL_CATEGORY, "Cn", 
                                   assignedEndCodePoint + 1, codePoint - 1);
        assignedStartCodePoint = codePoint;
      }
      assignedEndCodePoint = codePoint;

      if (startCodePoint != -1
          && prevGenCatPropValue.length() > 0
          && (((codePoint > prevCodePoint + 1) && ! isLastInRange)
              || ! genCatPropValue.equals(prevGenCatPropValue))) {
        // UnicodeData-1.1.5.txt does not list the end point for the Unified Han
        // range (starting point is listed as U+4E00).  This is U+9FFF according
        // to <http://unicode.org/Public/TEXT/OLDAPIX/CHANGES.TXT>:
        //
        //    U+4E00 ^ U+9FFF		20,992	I-ZONE Ideographs
        //
        // U+4E00 is listed in UnicodeData-1.1.5.txt as having the "Lo" property
        // value, as are the previous code points, so to include
        // [ U+4E00 - U+9FFF ], this interval should be extended to U+9FFF.
        if (prevCodePoint == 0x4E00
            && unicodeVersion.majorMinorVersion.equals("1.1")) {
          prevCodePoint = 0x9FFF;
        }
        unicodeVersion.addInterval
          (GENERAL_CATEGORY, prevGenCatPropValue, startCodePoint, prevCodePoint);
        startCodePoint = -1;
      }
      if (genCatPropValue.length() > 0 && startCodePoint == -1) {
        startCodePoint = codePoint;
      }
      prevCodePoint = codePoint;
      prevGenCatPropValue = genCatPropValue;
      reset();
    }
  }
  
  public void reset() {
    isLastInRange = false;
    uppercaseMapping = null;
    lowercaseMapping = null;
    titlecaseMapping = null;
    codePoint = -1;
  }
  
  public void handleFinalInterval() {
    if (startCodePoint != -1 && prevGenCatPropValue.length() > 0) {
      unicodeVersion.addInterval
        (GENERAL_CATEGORY, prevGenCatPropValue, startCodePoint, prevCodePoint);
    }
    
    // Handle the final Assigned interval
    unicodeVersion.addInterval
      ("Assigned", assignedStartCodePoint, assignedEndCodePoint);
    
    // Round max code point up to end-of-plane.
    unicodeVersion.setMaximumCodePoint(((prevCodePoint + 0x800) & 0xFFF000) - 1);
    
    // Handle the final Unassigned (Cn) interval, if any
    if (assignedEndCodePoint < unicodeVersion.getMaximumCodePoint()) {
      unicodeVersion.addInterval(GENERAL_CATEGORY, "Cn", 
                                 assignedEndCodePoint + 1, 
                                 unicodeVersion.getMaximumCodePoint());
    }
  }


  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public UnicodeDataScanner(java.io.Reader in, UnicodeVersion unicodeVersion) {
    this.unicodeVersion = unicodeVersion;
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public UnicodeDataScanner(java.io.InputStream in, UnicodeVersion unicodeVersion) {
    this(new java.io.InputStreamReader(in), unicodeVersion);
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 58) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead > 0) {
      zzEndRead+= numRead;
      return false;
    }
    // unlikely but not impossible: read 0 characters, but not at end of stream    
    if (numRead == 0) {
      int c = zzReader.read();
      if (c == -1) {
        return true;
      } else {
        zzBuffer[zzEndRead++] = (char) c;
        return false;
      }     
    }

	// numRead < 0
    return true;
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEOFDone = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void zzDoEOF() throws java.io.IOException {
    if (!zzEOFDone) {
      zzEOFDone = true;
      yyclose();
    }
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public int scan() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 6: 
          { genCatPropValue = yytext();
          }
        case 24: break;
        case 8: 
          { yybegin(BIDI_CLASS_4);
          }
        case 25: break;
        case 16: 
          { yybegin(SIMPLE_UPPERCASE_MAPPING_12);
          }
        case 26: break;
        case 18: 
          { yybegin(SIMPLE_LOWERCASE_MAPPING_13);
          }
        case 27: break;
        case 10: 
          { yybegin(NUMERIC_TYPE_6);
          }
        case 28: break;
        case 2: 
          { codePoint = Integer.parseInt(yytext(), 16);
          }
        case 29: break;
        case 14: 
          { yybegin(UNICODE_1_NAME_10);
          }
        case 30: break;
        case 23: 
          { isLastInRange = true;
          }
        case 31: break;
        case 9: 
          { yybegin(DECOMPOSITION_TYPE_AND_MAPPING_5);
          }
        case 32: break;
        case 1: 
          { reset(); yybegin(YYINITIAL);
          }
        case 33: break;
        case 22: 
          { handleEntry(); yybegin(YYINITIAL);
          }
        case 34: break;
        case 12: 
          { yybegin(NUMERIC_VALUE_OTHER_8);
          }
        case 35: break;
        case 20: 
          { yybegin(SIMPLE_TITLECASE_MAPPING_14);
          }
        case 36: break;
        case 21: 
          { titlecaseMapping = yytext();
          }
        case 37: break;
        case 11: 
          { yybegin(NUMERIC_VALUE_INTEGER_7);
          }
        case 38: break;
        case 13: 
          { yybegin(BIDI_MIRRORED_9);
          }
        case 39: break;
        case 5: 
          { yybegin(GENERAL_CATEGORY_2);
          }
        case 40: break;
        case 17: 
          { uppercaseMapping = yytext();
          }
        case 41: break;
        case 4: 
          { yybegin(NAME_1);
          }
        case 42: break;
        case 19: 
          { lowercaseMapping = yytext();
          }
        case 43: break;
        case 7: 
          { yybegin(CANONICAL_COMBINING_CLASS_3);
          }
        case 44: break;
        case 3: 
          { 
          }
        case 45: break;
        case 15: 
          { yybegin(ISO_COMMENT_11);
          }
        case 46: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            zzDoEOF();
            switch (zzLexicalState) {
            case YYINITIAL: {
              handleFinalInterval(); return 0;
            }
            case 59: break;
            case SIMPLE_TITLECASE_MAPPING_14: {
              handleEntry(); handleFinalInterval(); return 0;
            }
            case 60: break;
            default:
            return YYEOF;
            }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
