/*
 * Decompiled with CFR 0.152.
 */
package jflex;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jflex.ArchaicBlocksScanner;
import jflex.ArchaicLineBreakScanner;
import jflex.ArchaicPropListScanner;
import jflex.BinaryPropertiesFileScanner;
import jflex.DerivedAgeScanner;
import jflex.EnumeratedPropertyFileScanner;
import jflex.PropertyAliasesScanner;
import jflex.PropertyValueAliasesScanner;
import jflex.ScriptExtensionsScanner;
import jflex.UnicodeDataScanner;
import jflex.UnicodeVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DataFileType {
    PROPERTY_ALIASES("PropertyAliases"){

        public void scan(URL url, UnicodeVersion version) throws IOException {
            InputStreamReader reader = new InputStreamReader(url.openStream(), "UTF-8");
            PropertyAliasesScanner scanner = new PropertyAliasesScanner(reader, version);
            scanner.scan();
        }
    }
    ,
    PROPERTY_VALUE_ALIASES("PropertyValueAliases"){

        public void scan(URL url, UnicodeVersion version) throws IOException {
            InputStreamReader reader = new InputStreamReader(url.openStream(), "UTF-8");
            PropertyValueAliasesScanner scanner = new PropertyValueAliasesScanner(reader, version);
            scanner.scan();
        }
    }
    ,
    UNICODE_DATA("UnicodeData"){

        public void scan(URL url, UnicodeVersion version) throws IOException {
            InputStreamReader reader = new InputStreamReader(url.openStream(), "UTF-8");
            UnicodeDataScanner scanner = new UnicodeDataScanner(reader, version);
            scanner.scan();
        }
    }
    ,
    PROPLIST("PropList"){

        public void scan(URL url, UnicodeVersion version) throws IOException {
            InputStreamReader reader = new InputStreamReader(url.openStream(), "UTF-8");
            if (version.majorMinorVersion.equals("2.0") || version.majorMinorVersion.equals("2.1") || version.majorMinorVersion.equals("3.0")) {
                ArchaicPropListScanner scanner = new ArchaicPropListScanner(reader, version);
                scanner.scan();
            } else {
                BinaryPropertiesFileScanner scanner = new BinaryPropertiesFileScanner(reader, version);
                scanner.scan();
            }
        }
    }
    ,
    DERIVED_CORE_PROPERTIES("DerivedCoreProperties"){

        public void scan(URL url, UnicodeVersion version) throws IOException {
            InputStreamReader reader = new InputStreamReader(url.openStream(), "UTF-8");
            BinaryPropertiesFileScanner scanner = new BinaryPropertiesFileScanner(reader, version);
            scanner.scan();
        }
    }
    ,
    SCRIPTS("Scripts"){

        public void scan(URL url, UnicodeVersion version) throws IOException {
            String defaultPropertyValue = "Unknown";
            if (version.majorMinorVersion.equals("3.1") || version.majorMinorVersion.equals("3.2") || version.majorMinorVersion.equals("4.0") || version.majorMinorVersion.equals("4.1")) {
                defaultPropertyValue = "Common";
            }
            InputStreamReader reader = new InputStreamReader(url.openStream(), "UTF-8");
            EnumeratedPropertyFileScanner scanner = new EnumeratedPropertyFileScanner(reader, version, "Script", defaultPropertyValue);
            scanner.scan();
        }
    }
    ,
    SCRIPT_EXTENSIONSS("ScriptExtensions"){

        public void scan(URL url, UnicodeVersion version) throws IOException {
            InputStreamReader reader = new InputStreamReader(url.openStream(), "UTF-8");
            ScriptExtensionsScanner scanner = new ScriptExtensionsScanner(reader, version, "Script_Extensions");
            scanner.scan();
        }
    }
    ,
    BLOCKS("Blocks"){

        public void scan(URL url, UnicodeVersion version) throws IOException {
            InputStreamReader reader = new InputStreamReader(url.openStream(), "UTF-8");
            if (version.majorMinorVersion.equals("2.0") || version.majorMinorVersion.equals("2.1") || version.majorMinorVersion.equals("3.0")) {
                ArchaicBlocksScanner scanner = new ArchaicBlocksScanner(reader, version);
                scanner.scan();
            } else {
                EnumeratedPropertyFileScanner scanner = new EnumeratedPropertyFileScanner(reader, version, "Block", "No_Block");
                scanner.scan();
            }
        }
    }
    ,
    LINE_BREAK("LineBreak"){

        public void scan(URL url, UnicodeVersion version) throws IOException {
            InputStreamReader reader = new InputStreamReader(url.openStream(), "UTF-8");
            if (version.majorMinorVersion.equals("3.0")) {
                ArchaicLineBreakScanner scanner = new ArchaicLineBreakScanner(reader, version);
                scanner.scan();
            } else {
                EnumeratedPropertyFileScanner scanner = new EnumeratedPropertyFileScanner(reader, version, "Line_Break", "XX");
                scanner.scan();
            }
        }
    }
    ,
    GRAPHEME_BREAK_PROPERTY("GraphemeBreakProperty"){

        public void scan(URL url, UnicodeVersion version) throws IOException {
            InputStreamReader reader = new InputStreamReader(url.openStream(), "UTF-8");
            EnumeratedPropertyFileScanner scanner = new EnumeratedPropertyFileScanner(reader, version, "Grapheme_Cluster_Break", "Other");
            scanner.scan();
        }
    }
    ,
    SENTENCE_BREAK_PROPERTY("SentenceBreakProperty"){

        public void scan(URL url, UnicodeVersion version) throws IOException {
            InputStreamReader reader = new InputStreamReader(url.openStream(), "UTF-8");
            EnumeratedPropertyFileScanner scanner = new EnumeratedPropertyFileScanner(reader, version, "Sentence_Break", "Other");
            scanner.scan();
        }
    }
    ,
    WORD_BREAK_PROPERTY("WordBreakProperty"){

        public void scan(URL url, UnicodeVersion version) throws IOException {
            InputStreamReader reader = new InputStreamReader(url.openStream(), "UTF-8");
            EnumeratedPropertyFileScanner scanner = new EnumeratedPropertyFileScanner(reader, version, "Word_Break", "Other");
            scanner.scan();
        }
    }
    ,
    DERIVED_AGE("DerivedAge"){

        public void scan(URL url, UnicodeVersion version) throws IOException {
            InputStreamReader reader = new InputStreamReader(url.openStream(), "UTF-8");
            DerivedAgeScanner scanner = new DerivedAgeScanner(reader, version);
            scanner.scan();
        }

        public URL getURL(String version, URL baseURL, String versionedDirectoryListing) throws MalformedURLException {
            return version.startsWith("1.1") ? null : new URL("http://www.unicode.org/Public/UNIDATA/DerivedAge.txt");
        }
    };

    private Pattern nonBetaHTMLLinkPattern;

    private DataFileType(String fileNamePrefix) {
        this.nonBetaHTMLLinkPattern = Pattern.compile("<a\\s+href\\s*=\\s*\"(" + fileNamePrefix + "(?:|-\\d+(?:\\.\\d+){0,2})\\.txt)\"\\s*>", 2);
    }

    public String getFileName(String htmlDirectoryListing) {
        Matcher matcher = this.nonBetaHTMLLinkPattern.matcher(htmlDirectoryListing);
        return matcher.find() ? matcher.group(1) : null;
    }

    public abstract void scan(URL var1, UnicodeVersion var2) throws IOException;

    public URL getURL(String version, URL baseURL, String versionedDirectoryListing) throws MalformedURLException {
        String fileName = this.getFileName(versionedDirectoryListing);
        return null == fileName ? null : new URL(baseURL, fileName);
    }
}

