/*
 * Decompiled with CFR 0.152.
 */
package jflex;

import java.io.Reader;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jflex.EnumeratedPropertyFileScanner;
import jflex.NamedRange;
import jflex.NamedRangeSet;
import jflex.UnicodeVersion;

public class DerivedAgeScanner
extends EnumeratedPropertyFileScanner {
    private static final Pattern MAJOR_MINOR_VERSION_PATTERN = Pattern.compile("(\\d+)\\.(\\d+)");
    private static final Pattern AGE_PATTERN = Pattern.compile("(\\d+)\\.(\\d)");

    public DerivedAgeScanner(Reader in, UnicodeVersion unicodeVersion) {
        super(in, unicodeVersion, "Age", "Unassigned");
    }

    protected boolean accept(String propertyValue) {
        Matcher matcher = MAJOR_MINOR_VERSION_PATTERN.matcher(propertyValue);
        if (!matcher.matches()) {
            throw new RuntimeException("Malformed Age property value '" + propertyValue + "'");
        }
        int major = Integer.parseInt(matcher.group(1));
        int minor = Integer.parseInt(matcher.group(2));
        return this.unicodeVersion.majorVersion > major || this.unicodeVersion.majorVersion == major && this.unicodeVersion.minorVersion >= minor;
    }

    public void addPropertyValueIntervals() {
        TreeMap<String, NamedRangeSet> ageRangesPerVersion = new TreeMap<String, NamedRangeSet>();
        for (NamedRange interval : this.intervals) {
            String sortableVersion = this.getSortableVersion(interval.name);
            NamedRangeSet versionedAgeRanges = (NamedRangeSet)ageRangesPerVersion.get(sortableVersion);
            if (null == versionedAgeRanges) {
                versionedAgeRanges = new NamedRangeSet();
                ageRangesPerVersion.put(sortableVersion, versionedAgeRanges);
            }
            versionedAgeRanges.add(new NamedRangeSet(interval));
        }
        String previousVersion = null;
        for (String version : ageRangesPerVersion.keySet()) {
            NamedRangeSet targetRanges = (NamedRangeSet)ageRangesPerVersion.get(version);
            if (null != previousVersion) {
                targetRanges.add((NamedRangeSet)ageRangesPerVersion.get(previousVersion));
            }
            previousVersion = version;
            String age = this.getAge(version);
            for (NamedRange range : targetRanges.getRanges()) {
                this.unicodeVersion.addInterval(this.propertyName, age, range.start, range.end);
            }
        }
        NamedRangeSet highestVersionRanges = (NamedRangeSet)ageRangesPerVersion.get(ageRangesPerVersion.lastKey());
        NamedRangeSet unassignedRanges = new NamedRangeSet(new NamedRange(0, this.unicodeVersion.maximumCodePoint));
        unassignedRanges.sub(highestVersionRanges);
        for (NamedRange unassignedRange : unassignedRanges.getRanges()) {
            this.unicodeVersion.addInterval(this.propertyName, this.defaultPropertyValue, unassignedRange.start, unassignedRange.end);
        }
    }

    private String getSortableVersion(String version) {
        Matcher matcher = AGE_PATTERN.matcher(version);
        if (matcher.matches()) {
            return Integer.toString(Integer.parseInt(matcher.group(1)), 36) + matcher.group(2);
        }
        throw new RuntimeException("Unparseable age property value: '" + version + "'");
    }

    private String getAge(String sortableVersion) {
        return Integer.parseInt(sortableVersion.substring(0, 1), 36) + "." + sortableVersion.substring(1);
    }
}

