/*
 * Decompiled with CFR 0.152.
 */
package jflex;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Collections;
import java.util.EnumMap;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jflex.DataFileType;
import jflex.UnicodePropertiesSkeleton;
import jflex.UnicodeVersion;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JFlexUnicodeMojo
extends AbstractMojo {
    private static final String UNICODE_DOT_ORG_URL = "http://www.unicode.org/Public/";
    private static final Pattern UNICODE_VERSION_LINK_PATTERN = Pattern.compile("<a\\s+href\\s*=\\s*\"((\\d+(?:\\.\\d+){1,2})(?i:-(Update(\\d*)))?/)\"\\s*>", 2);
    private static final int BUF_SIZE = 4096;
    private File outputDirectory = null;
    private SortedMap<String, UnicodeVersion> unicodeVersions = new TreeMap<String, UnicodeVersion>();
    private static final String OUTPUT_CLASS_NAME = "UnicodeProperties";
    private static final String SKELETON_FILENAME = "UnicodeProperties.java.skeleton";
    private static final Pattern DIRECTORY_LINK_PATTERN = Pattern.compile("<a\\s+href\\s*=\\s*\"([^/\"]+/)\"\\s*>", 2);

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.getLog().info((CharSequence)"Downloading Unicode data from http://www.unicode.org/Public/\n");
            this.collectUnicodeVersions();
            this.emitUnicodeProperties();
            this.emitVersionedUnicodeData();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Exception", e);
        }
    }

    private void collectUnicodeVersions() throws IOException {
        TreeMap allUnicodeVersions = new TreeMap();
        URL unicodeURL = new URL(UNICODE_DOT_ORG_URL);
        Matcher matcher = UNICODE_VERSION_LINK_PATTERN.matcher(this.getPageContent(unicodeURL));
        while (matcher.find()) {
            TreeMap updates;
            String relativeURL = matcher.group(1);
            String baseVersion = matcher.group(2);
            String update = matcher.group(3);
            int updateNumber = -1;
            if (null != update) {
                updateNumber = 0;
                if (null != matcher.group(4) && matcher.group(4).length() > 0) {
                    updateNumber = Integer.parseInt(matcher.group(4));
                }
            }
            if (null == (updates = (TreeMap)allUnicodeVersions.get(baseVersion))) {
                updates = new TreeMap(Collections.reverseOrder());
                allUnicodeVersions.put(baseVersion, updates);
            }
            updates.put(updateNumber, relativeURL);
        }
        for (String version : allUnicodeVersions.keySet()) {
            this.populateUnicodeVersion(version, (SortedMap)allUnicodeVersions.get(version));
        }
    }

    private void populateUnicodeVersion(String version, SortedMap<Integer, String> relativeURLs) throws IOException {
        EnumMap<DataFileType, URL> dataFiles = new EnumMap<DataFileType, URL>(DataFileType.class);
        for (String relativeURL : relativeURLs.values()) {
            URL baseURL = new URL(UNICODE_DOT_ORG_URL + relativeURL);
            String versionedDirectoryListing = this.getPageContent(baseURL);
            if (-1 != versionedDirectoryListing.indexOf("<a href=\"ucd/\">")) {
                baseURL = new URL(baseURL, "ucd/");
                versionedDirectoryListing = this.getPageContent(baseURL);
            }
            for (DataFileType fileType : DataFileType.values()) {
                URL url;
                if (null != dataFiles.get((Object)fileType) || null == (url = fileType.getURL(version, baseURL, versionedDirectoryListing))) continue;
                dataFiles.put(fileType, url);
            }
            Matcher matcher = DIRECTORY_LINK_PATTERN.matcher(versionedDirectoryListing);
            while (matcher.find()) {
                URL nestedBaseURL = new URL(baseURL, matcher.group(1));
                String nestedVersionedDirectoryListing = this.getPageContent(nestedBaseURL);
                for (DataFileType fileType : DataFileType.values()) {
                    URL url;
                    if (null != dataFiles.get((Object)fileType) || null == (url = fileType.getURL(version, nestedBaseURL, nestedVersionedDirectoryListing))) continue;
                    dataFiles.put(fileType, url);
                }
            }
        }
        if (null != dataFiles.get((Object)DataFileType.UNICODE_DATA)) {
            UnicodeVersion unicodeVersion = new UnicodeVersion(version, dataFiles);
            unicodeVersion.fetchAndParseDataFiles(this.getLog());
            unicodeVersion.addCompatibilityProperties();
            this.unicodeVersions.put(unicodeVersion.majorMinorVersion, unicodeVersion);
            this.getLog().info((CharSequence)("Completed downloading and parsing Unicode " + unicodeVersion.majorMinorVersion + " data.\n"));
        }
    }

    private String getPageContent(URL url) throws IOException {
        int charsRead;
        InputStreamReader reader = new InputStreamReader(url.openStream(), "UTF-8");
        StringBuilder builder = new StringBuilder();
        char[] buf = new char[4096];
        while ((charsRead = reader.read(buf)) > 0) {
            builder.append(buf, 0, charsRead);
        }
        return builder.toString();
    }

    private void emitUnicodeProperties() throws Exception {
        StringBuilder builder = new StringBuilder();
        UnicodePropertiesSkeleton skeleton = new UnicodePropertiesSkeleton(SKELETON_FILENAME);
        skeleton.emitNext(builder);
        this.emitClassComment(builder);
        skeleton.emitNext(builder);
        this.emitUnicodeVersionsString(builder);
        skeleton.emitNext(builder);
        this.emitDefaultUnicodeVersion(builder);
        skeleton.emitNext(builder);
        this.emitInitBody(builder);
        skeleton.emitNext(builder);
        this.writeOutputFile(builder);
    }

    private void emitDefaultUnicodeVersion(StringBuilder builder) {
        builder.append("    \"").append(this.unicodeVersions.lastKey()).append("\";");
    }

    private void emitUnicodeVersionsString(StringBuilder builder) {
        builder.append("    \"");
        boolean isFirst = true;
        for (String majorMinorVersion : this.unicodeVersions.keySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                builder.append(", ");
            }
            if (majorMinorVersion.indexOf(".0") == majorMinorVersion.length() - 2) {
                String majorVersion = majorMinorVersion.substring(0, majorMinorVersion.indexOf("."));
                builder.append(majorVersion).append(", ");
            }
            builder.append(majorMinorVersion).append(", ").append(((UnicodeVersion)this.unicodeVersions.get((Object)majorMinorVersion)).majorMinorUpdateVersion);
        }
        builder.append("\";");
    }

    private void emitVersionedUnicodeData() throws IOException {
        for (UnicodeVersion unicodeVersion : this.unicodeVersions.values()) {
            unicodeVersion.emitToDir(new File(this.outputDirectory, "data"));
        }
    }

    private void emitClassComment(StringBuilder builder) {
        builder.append("\n/**\n").append(" * This class was automatically generated by").append(" jflex-unicode-maven-plugin based\n").append(" * on data files downloaded from unicode.org.\n */");
    }

    private void emitInitBody(StringBuilder builder) {
        boolean isFirst = true;
        for (String majorMinorVersion : this.unicodeVersions.keySet()) {
            if (isFirst) {
                builder.append("    if (");
                isFirst = false;
            } else {
                builder.append("    } else if (");
            }
            if (majorMinorVersion.indexOf(".0") == majorMinorVersion.length() - 2) {
                String majorVersion = majorMinorVersion.substring(0, majorMinorVersion.indexOf("."));
                builder.append("version.equals(\"").append(majorVersion).append("\") || ");
            }
            UnicodeVersion unicodeVersion = (UnicodeVersion)this.unicodeVersions.get(majorMinorVersion);
            String versionSuffix = unicodeVersion.getVersionSuffix();
            builder.append("version.equals(\"").append(majorMinorVersion).append("\") || version.equals(\"").append(unicodeVersion.majorMinorUpdateVersion).append("\")) {\n").append("      bind(Unicode").append(versionSuffix).append(".propertyValues").append(", Unicode").append(versionSuffix).append(".intervals").append(", Unicode").append(versionSuffix).append(".propertyValueAliases").append(",\n         Unicode").append(versionSuffix).append(".maximumCodePoint").append(", Unicode").append(versionSuffix).append(".caselessMatchPartitions").append(", Unicode").append(versionSuffix).append(".caselessMatchPartitionSize").append(");\n");
        }
        builder.append("    } else {\n").append("      throw new UnsupportedUnicodeVersionException();\n").append("    }\n");
    }

    private void writeOutputFile(StringBuilder builder) throws IOException {
        PrintWriter writer = new PrintWriter(this.getOutputFile(), "UTF-8");
        writer.write(builder.toString());
        writer.flush();
        writer.close();
    }

    private File getOutputFile() {
        return new File(this.outputDirectory, "UnicodeProperties.java");
    }
}

