/*
 * Decompiled with CFR 0.152.
 */
package jflex;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class UnicodePropertiesSkeleton {
    private static final int size = 5;
    private static final String NL = System.getProperty("line.separator");
    private List<String> sections = new ArrayList<String>();
    private int pos = 0;

    public UnicodePropertiesSkeleton(String skeletonFilename) throws Exception {
        this.read(skeletonFilename);
    }

    public void emitNext(StringBuilder out) {
        out.append(this.sections.get(this.pos++));
    }

    public void read(String skeletonFilename) throws Exception {
        String line;
        ClassLoader loader = UnicodePropertiesSkeleton.class.getClassLoader();
        URL url = loader.getResource(skeletonFilename);
        if (null == url) {
            throw new Exception("Cannot locate '" + skeletonFilename + "' - aborting.");
        }
        StringBuilder section = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));
        while (null != (line = reader.readLine())) {
            if (line.startsWith("---")) {
                this.sections.add(section.toString());
                section.setLength(0);
                continue;
            }
            section.append(line);
            section.append(NL);
        }
        if (section.length() > 0) {
            this.sections.add(section.toString());
        }
        if (this.sections.size() != 5) {
            throw new Exception("Skeleton file '" + skeletonFilename + "' has " + this.sections.size() + " static sections, but " + 5 + " were expected.");
        }
    }
}

