/*
 * Decompiled with CFR 0.152.
 */
package jflex;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jflex.DataFileType;
import jflex.NamedRange;
import jflex.NamedRangeSet;
import org.apache.maven.plugin.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UnicodeVersion {
    private static final Pattern FULL_VERSION_PATTERN = Pattern.compile("((\\d+)\\.(\\d+))\\.\\d+");
    private static final Pattern FULL_VERSION_PATTERN_IN_URL = Pattern.compile("UnicodeData-((\\d+)\\.(\\d+)\\.\\d+)\\.txt$");
    private static final Pattern WORD_SEP_PATTERN = Pattern.compile("[-_\\s()]");
    private static final String NORMALIZED_GENERAL_CATEGORY = UnicodeVersion.normalize("General_Category");
    private static final String NORMALIZED_SCRIPT = UnicodeVersion.normalize("Script");
    private static final int INTERVALS_PER_LINE = 4;
    private static final int PROPERTY_VALUE_ALIAS_MAPPINGS_PER_LINE = 2;
    private static final int PROPERTY_VALUES_PER_LINE = 6;
    private static final int CASELESS_MATCH_PARTITIONS_PER_LINE = 3;
    private static final Pattern SURROGATE_PATTERN = Pattern.compile("^cs$|surrogate", 2);
    String majorMinorUpdateVersion;
    String majorMinorVersion;
    int majorVersion;
    int minorVersion;
    int maximumCodePoint;
    SortedMap<String, List<NamedRange>> propertyValueIntervals = new TreeMap<String, List<NamedRange>>();
    Map<String, Set<String>> usedEnumeratedProperties = new HashMap<String, Set<String>>();
    Set<String> usedBinaryProperties = new HashSet<String>();
    Map<String, Set<String>> allPropertyAliases = new HashMap<String, Set<String>>();
    Map<String, Map<String, Set<String>>> allPropertyValueAliases = new HashMap<String, Map<String, Set<String>>>();
    Map<String, String> propertyAlias2CanonicalName = new HashMap<String, String>();
    Map<String, Map<String, String>> propertyValueAlias2CanonicalValue = new HashMap<String, Map<String, String>>();
    Map<Integer, SortedSet<Integer>> caselessMatchPartitions = new HashMap<Integer, SortedSet<Integer>>();
    int caselessMatchPartitionSize = 0;
    private EnumMap<DataFileType, URL> dataFiles;

    UnicodeVersion(String version, EnumMap<DataFileType, URL> dataFiles) {
        this.dataFiles = dataFiles;
        this.setVersions(version, dataFiles.get((Object)DataFileType.UNICODE_DATA));
    }

    public void fetchAndParseDataFiles(Log log) throws IOException {
        for (Map.Entry<DataFileType, URL> entry : this.dataFiles.entrySet()) {
            DataFileType fileType = entry.getKey();
            URL url = entry.getValue();
            log.info((CharSequence)("\t\tFetching/parsing: " + url.getPath()));
            fileType.scan(url, this);
            log.info((CharSequence)("\t\tCompleted: " + url.getPath()));
        }
    }

    private void setVersions(String version, URL unicodeDataURL) {
        Matcher matcher = FULL_VERSION_PATTERN.matcher(version);
        if (matcher.matches()) {
            this.majorMinorUpdateVersion = matcher.group(0);
            this.majorMinorVersion = matcher.group(1);
            this.majorVersion = Integer.parseInt(matcher.group(2));
            this.minorVersion = Integer.parseInt(matcher.group(3));
        } else {
            this.majorMinorVersion = version;
            matcher = FULL_VERSION_PATTERN_IN_URL.matcher(unicodeDataURL.toString());
            if (matcher.find()) {
                this.majorMinorUpdateVersion = matcher.group(1);
                this.majorVersion = Integer.parseInt(matcher.group(2));
                this.minorVersion = Integer.parseInt(matcher.group(3));
            }
        }
    }

    public void emitToDir(File outputDir) throws IOException {
        PrintWriter writer = new PrintWriter(new File(outputDir, "Unicode" + this.getVersionSuffix() + ".java"), "UTF-8");
        writer.append("package jflex.unicode.data;\n\n");
        writer.append("public class Unicode").append(this.getVersionSuffix()).append(" {\n");
        this.emitMaximumCodePoint(writer);
        this.emitPropertyValuesArray(writer);
        this.emitIntervalsArray(writer);
        this.emitPropertyValueAliasesArray(writer);
        this.emitCaselessMatchPartitions(writer);
        writer.append("}\n");
        writer.flush();
        writer.close();
    }

    void addCaselessMatches(int codePoint, String uppercaseMapping, String lowercaseMapping, String titlecaseMapping) {
        if (null != uppercaseMapping && uppercaseMapping.length() > 0 || null != lowercaseMapping && lowercaseMapping.length() > 0 || null != titlecaseMapping && titlecaseMapping.length() > 0) {
            Integer upper = null;
            if (null != uppercaseMapping && uppercaseMapping.length() > 0) {
                upper = Integer.valueOf(uppercaseMapping, 16);
            } else {
                uppercaseMapping = null;
            }
            Integer lower = null;
            if (null != lowercaseMapping && lowercaseMapping.length() > 0) {
                lower = Integer.valueOf(lowercaseMapping, 16);
            } else {
                lowercaseMapping = null;
            }
            Integer title = null;
            if (null != titlecaseMapping && titlecaseMapping.length() > 0) {
                title = Integer.valueOf(titlecaseMapping, 16);
            } else {
                titlecaseMapping = null;
            }
            SortedSet<Integer> partition = this.caselessMatchPartitions.get(codePoint);
            if (null == partition) {
                if (null != uppercaseMapping) {
                    partition = this.caselessMatchPartitions.get(upper);
                }
                if (null == partition && null != lowercaseMapping) {
                    partition = this.caselessMatchPartitions.get(lower);
                }
                if (null == partition && null != titlecaseMapping) {
                    partition = this.caselessMatchPartitions.get(title);
                }
                if (null == partition) {
                    partition = new TreeSet<Integer>();
                }
            }
            partition.add(codePoint);
            this.caselessMatchPartitions.put(codePoint, partition);
            if (null != uppercaseMapping) {
                partition.add(upper);
                this.caselessMatchPartitions.put(upper, partition);
            }
            if (null != lowercaseMapping) {
                partition.add(lower);
                this.caselessMatchPartitions.put(lower, partition);
            }
            if (null != titlecaseMapping) {
                partition.add(title);
                this.caselessMatchPartitions.put(title, partition);
            }
            if (partition.size() > this.caselessMatchPartitionSize) {
                this.caselessMatchPartitionSize = partition.size();
            }
        }
    }

    void addInterval(String propName, int startCodePoint, int endCodePoint) {
        List<NamedRange> ranges;
        if (!SURROGATE_PATTERN.matcher(propName = this.getCanonicalPropertyName(UnicodeVersion.normalize(propName))).find() && !(ranges = this.removeSurrogates(startCodePoint, endCodePoint)).isEmpty()) {
            ArrayList<NamedRange> intervals = (ArrayList<NamedRange>)this.propertyValueIntervals.get(propName);
            if (null == intervals) {
                intervals = new ArrayList<NamedRange>();
                this.propertyValueIntervals.put(propName, intervals);
            }
            for (NamedRange range : ranges) {
                if (range.end == 19968 && this.majorMinorVersion.equals("1.1")) {
                    range.end = 40959;
                }
                intervals.add(range);
            }
            this.usedBinaryProperties.add(propName);
        }
    }

    List<NamedRange> removeSurrogates(int startCodePoint, int endCodePoint) {
        assert (startCodePoint <= endCodePoint);
        if (startCodePoint >= 55296 && endCodePoint <= 57343) {
            return Collections.emptyList();
        }
        ArrayList<NamedRange> ranges = new ArrayList<NamedRange>();
        if (endCodePoint < 55296 || startCodePoint > 57343) {
            ranges.add(new NamedRange(startCodePoint, endCodePoint));
            return ranges;
        }
        if (startCodePoint < 55296) {
            ranges.add(new NamedRange(startCodePoint, 55295));
        }
        if (endCodePoint > 57343) {
            ranges.add(new NamedRange(57344, endCodePoint));
        }
        return ranges;
    }

    void addInterval(String propName, String propValue, int startCodePoint, int endCodePoint) {
        List<NamedRange> ranges;
        propValue = this.getCanonicalPropertyValue(propName = this.getCanonicalPropertyName(UnicodeVersion.normalize(propName)), UnicodeVersion.normalize(propValue));
        if (!SURROGATE_PATTERN.matcher(propValue).find() && !(ranges = this.removeSurrogates(startCodePoint, endCodePoint)).isEmpty()) {
            ArrayList<NamedRange> intervals;
            String canonicalValue = propName + '=' + propValue;
            if (propName.equals(NORMALIZED_GENERAL_CATEGORY) || propName.equals(NORMALIZED_SCRIPT)) {
                canonicalValue = propValue;
            }
            if (null == (intervals = (ArrayList<NamedRange>)this.propertyValueIntervals.get(canonicalValue))) {
                intervals = new ArrayList<NamedRange>();
                this.propertyValueIntervals.put(canonicalValue, intervals);
            }
            for (NamedRange range : ranges) {
                if (range.start == 65136 && range.end == 65279 && this.majorMinorVersion.equals("2.0")) {
                    range.end = 65278;
                }
                intervals.add(range);
            }
            Set<String> usedValues = this.usedEnumeratedProperties.get(propName);
            if (null == usedValues) {
                usedValues = new HashSet<String>();
                this.usedEnumeratedProperties.put(propName, usedValues);
            }
            usedValues.add(propValue);
            if (propName.equals(NORMALIZED_GENERAL_CATEGORY) && propValue.length() == 2) {
                String firstLetter = propValue.substring(0, 1);
                usedValues.add(firstLetter);
            }
        }
    }

    void emitMaximumCodePoint(PrintWriter writer) {
        writer.append("  public static final int maximumCodePoint").append(" = 0x").append(Integer.toString(this.maximumCodePoint, 16)).append(";\n");
    }

    void emitPropertyValuesArray(PrintWriter writer) {
        writer.append("  public static final String[] propertyValues").append("\n    = { ");
        int item = 0;
        for (String propValue : this.propertyValueIntervals.keySet()) {
            if (++item == 6) {
                writer.append(",\n        ");
                item = 1;
            } else if (item > 1) {
                writer.append(", ");
            }
            writer.append("\"").append(propValue).append("\"");
        }
        writer.append(" };\n");
    }

    void emitIntervalsArray(PrintWriter writer) {
        writer.append("  public static final String[] intervals = {\n");
        boolean isFirst = true;
        for (Map.Entry<String, List<NamedRange>> entry : this.propertyValueIntervals.entrySet()) {
            String propertyValue = entry.getKey();
            List<NamedRange> intervals = entry.getValue();
            if (isFirst) {
                isFirst = false;
            } else {
                writer.append(",\n");
            }
            writer.append("    // Unicode ").append(this.majorMinorVersion).append(" property value: {").append(propertyValue).append("}\n");
            int count = 0;
            boolean isFirstIntervalLine = true;
            for (NamedRange interval : intervals) {
                if (interval.start > this.getMaximumCodePoint()) continue;
                if (++count > 4) {
                    writer.append("\n");
                    count = 1;
                }
                if (count == 1) {
                    writer.append(isFirstIntervalLine ? "        \"" : "      + \"");
                } else {
                    writer.append("+\"");
                }
                isFirstIntervalLine = false;
                this.emitEscapedUTF16Char(writer, interval.start);
                this.emitEscapedUTF16Char(writer, Math.min(interval.end, this.getMaximumCodePoint()));
                writer.append("\"");
            }
        }
        writer.append("  };\n");
    }

    SortedMap<String, String> getUsedPropertyValueAliases() {
        TreeMap<String, String> usedPropertyValueAliases = new TreeMap<String, String>();
        for (String binaryProperty : this.usedBinaryProperties) {
            for (String nameAlias : this.getPropertyAliases(binaryProperty)) {
                if (nameAlias.equals(binaryProperty)) continue;
                usedPropertyValueAliases.put(nameAlias, binaryProperty);
            }
        }
        Set<String> genCatProps = this.usedEnumeratedProperties.get(NORMALIZED_GENERAL_CATEGORY);
        if (null != genCatProps) {
            genCatProps.add("lc");
        }
        for (Map.Entry<String, Set<String>> entry : this.usedEnumeratedProperties.entrySet()) {
            String propName = entry.getKey();
            Set<String> propValues = entry.getValue();
            for (String propValue : propValues) {
                String canonicalValue = propName + '=' + propValue;
                if (propName.equals(NORMALIZED_SCRIPT) || propName.equals(NORMALIZED_GENERAL_CATEGORY)) {
                    canonicalValue = propValue;
                    for (String valueAlias : this.getPropertyValueAliases(propName, propValue)) {
                        if (valueAlias.equals(propValue)) continue;
                        usedPropertyValueAliases.put(valueAlias, propValue);
                    }
                }
                for (String nameAlias : this.getPropertyAliases(propName)) {
                    for (String valueAlias : this.getPropertyValueAliases(propName, propValue)) {
                        if (!propName.equals(NORMALIZED_SCRIPT) && !propName.equals(NORMALIZED_GENERAL_CATEGORY) && nameAlias.equals(propName) && valueAlias.equals(propValue)) continue;
                        String alias = nameAlias + '=' + valueAlias;
                        usedPropertyValueAliases.put(alias, canonicalValue);
                    }
                }
            }
        }
        return usedPropertyValueAliases;
    }

    void emitPropertyValueAliasesArray(PrintWriter writer) {
        writer.append("  public static final String[] propertyValueAliases").append(" = {\n        ");
        int count = 0;
        boolean isFirstLine = true;
        for (Map.Entry<String, String> entry : this.getUsedPropertyValueAliases().entrySet()) {
            if (++count > 2) {
                writer.append(",\n        ");
                count = 1;
            } else if (!isFirstLine) {
                writer.append(",   ");
            } else {
                isFirstLine = false;
            }
            String alias = entry.getKey();
            String propertyValue = entry.getValue();
            writer.append("\"").append(alias).append("\", \"").append(propertyValue).append("\"");
        }
        writer.append("\n  };\n");
    }

    void emitCaselessMatchPartitions(PrintWriter writer) {
        writer.append("  public static final int caselessMatchPartitionSize").append(" = ").append(Integer.toString(this.caselessMatchPartitionSize)).append(";\n");
        writer.append("  public static final String caselessMatchPartitions").append(" =\n");
        TreeMap<Integer, SortedSet<Integer>> partitions = new TreeMap<Integer, SortedSet<Integer>>();
        for (SortedSet<Integer> partition : this.caselessMatchPartitions.values()) {
            partitions.put(partition.first(), partition);
        }
        int count = 0;
        boolean isFirstPartitionLine = true;
        for (SortedSet partition : partitions.values()) {
            if (++count > 3) {
                writer.append("\n");
                count = 1;
            }
            if (count == 1) {
                writer.append(isFirstPartitionLine ? "        \"" : "      + \"");
            } else {
                writer.append("+\"");
            }
            isFirstPartitionLine = false;
            for (Integer c : partition) {
                this.emitEscapedUTF16Char(writer, c);
            }
            for (int i = 0; i < this.caselessMatchPartitionSize - partition.size(); ++i) {
                this.emitEscapedUTF16Char(writer, 0);
            }
            writer.append("\"");
        }
        writer.append(";\n");
    }

    private void emitEscapedUTF16Char(PrintWriter writer, int codePoint) {
        if (codePoint <= 65535) {
            this.emitEscapedBMPChar(writer, codePoint);
        } else if (codePoint <= 0x10FFFF) {
            for (char surrogate : Character.toChars(codePoint)) {
                this.emitEscapedBMPChar(writer, surrogate);
            }
        } else {
            writer.append("<").append(Integer.toHexString(codePoint)).append(">");
        }
    }

    private void emitEscapedBMPChar(PrintWriter writer, int codePoint) {
        switch (codePoint) {
            case 34: {
                writer.append("\\\"");
                break;
            }
            case 0: {
                writer.append("\\000");
                break;
            }
            case 9: {
                writer.append("\\t");
                break;
            }
            case 10: {
                writer.append("\\n");
                break;
            }
            case 12: {
                writer.append("\\f");
                break;
            }
            case 13: {
                writer.append("\\r");
                break;
            }
            case 92: {
                writer.append("\\\\");
                break;
            }
            default: {
                writer.append(String.format("\\u%04x", codePoint));
            }
        }
    }

    String getVersionSuffix() {
        return "_" + this.majorMinorVersion.replace(".", "_");
    }

    static String normalize(String identifier) {
        if (null == identifier) {
            return identifier;
        }
        String normalized = WORD_SEP_PATTERN.matcher(identifier.toLowerCase(Locale.ENGLISH)).replaceAll("");
        return normalized.replace(':', '=');
    }

    Set<String> getPropertyAliases(String propertyName) {
        Set<String> aliases = this.allPropertyAliases.get(propertyName);
        if (null == aliases) {
            aliases = new HashSet<String>(Arrays.asList(propertyName));
        }
        return aliases;
    }

    Set<String> getPropertyValueAliases(String propertyName, String propertyValue) {
        Set<String> aliases = null;
        Map<String, Set<String>> values = this.allPropertyValueAliases.get(propertyName);
        if (null != values) {
            aliases = values.get(propertyValue);
        }
        if (null == aliases) {
            aliases = Collections.emptySet();
        }
        return aliases;
    }

    String getCanonicalPropertyName(String propertyAlias) {
        String canonicalName = null;
        propertyAlias = UnicodeVersion.normalize(propertyAlias);
        if (null != this.propertyAlias2CanonicalName) {
            canonicalName = this.propertyAlias2CanonicalName.get(propertyAlias);
        }
        return null == canonicalName ? propertyAlias : canonicalName;
    }

    String getCanonicalPropertyValue(String propertyName, String propertyValueAlias) {
        Map<String, String> valueAliases;
        String canonicalValue = null;
        if (null != this.propertyValueAlias2CanonicalValue && null != (valueAliases = this.propertyValueAlias2CanonicalValue.get(propertyName))) {
            canonicalValue = valueAliases.get(propertyValueAlias);
        }
        return null == canonicalValue ? propertyValueAlias : canonicalValue;
    }

    void addPropertyValueAliases(String propertyAlias, String propertyValue, Set<String> propertyValueAliases) {
        String propertyName = this.getCanonicalPropertyName(propertyAlias);
        propertyValue = UnicodeVersion.normalize(propertyValue);
        propertyValueAliases.add(propertyValue);
        Map<String, Set<String>> propertyValue2Aliases = this.allPropertyValueAliases.get(propertyName);
        if (null == propertyValue2Aliases) {
            propertyValue2Aliases = new HashMap<String, Set<String>>();
            this.allPropertyValueAliases.put(propertyName, propertyValue2Aliases);
        }
        propertyValue2Aliases.put(propertyValue, propertyValueAliases);
        Map<String, String> aliasMap = this.propertyValueAlias2CanonicalValue.get(propertyName);
        if (null == aliasMap) {
            aliasMap = new HashMap<String, String>();
            this.propertyValueAlias2CanonicalValue.put(propertyName, aliasMap);
        }
        for (String propertyValueAlias : propertyValueAliases) {
            propertyValueAlias = UnicodeVersion.normalize(propertyValueAlias);
            aliasMap.put(propertyValueAlias, propertyValue);
        }
    }

    void setMaximumCodePoint(int maximumCodePoint) {
        this.maximumCodePoint = maximumCodePoint;
    }

    public int getMaximumCodePoint() {
        return this.maximumCodePoint;
    }

    public void addCompatibilityProperties() {
        NamedRangeSet alnumSet;
        List whitespaceRanges = (List)this.propertyValueIntervals.get("whitespace");
        if (null == whitespaceRanges) {
            whitespaceRanges = (List)this.propertyValueIntervals.get("zs");
        }
        NamedRangeSet xdigitSet = new NamedRangeSet((List)this.propertyValueIntervals.get("nd"));
        ArrayList<NamedRange> hexDigitRanges = (ArrayList<NamedRange>)this.propertyValueIntervals.get("hexdigit");
        if (null == hexDigitRanges) {
            hexDigitRanges = new ArrayList<NamedRange>();
            hexDigitRanges.add(new NamedRange(65, 70));
            hexDigitRanges.add(new NamedRange(97, 102));
            hexDigitRanges.add(new NamedRange(65313, 65318));
            hexDigitRanges.add(new NamedRange(65345, 65350));
        }
        xdigitSet.add(new NamedRangeSet(hexDigitRanges));
        this.propertyValueIntervals.put("xdigit", xdigitSet.getRanges());
        this.usedBinaryProperties.add("xdigit");
        List alphaRanges = (List)this.propertyValueIntervals.get("alphabetic");
        if (null == alphaRanges) {
            alnumSet = new NamedRangeSet((List)this.propertyValueIntervals.get("ll"));
            alnumSet.add(new NamedRangeSet((List)this.propertyValueIntervals.get("lm")));
            alnumSet.add(new NamedRangeSet((List)this.propertyValueIntervals.get("lo")));
            alnumSet.add(new NamedRangeSet((List)this.propertyValueIntervals.get("lu")));
        } else {
            alnumSet = new NamedRangeSet(alphaRanges);
        }
        alnumSet.add(new NamedRangeSet((List)this.propertyValueIntervals.get("nd")));
        this.propertyValueIntervals.put("alnum", alnumSet.getRanges());
        NamedRangeSet blankSet = new NamedRangeSet(whitespaceRanges);
        blankSet.sub(new NamedRangeSet(new NamedRange(10, 13)));
        blankSet.sub(new NamedRangeSet(new NamedRange(133, 133)));
        blankSet.sub(new NamedRangeSet((List)this.propertyValueIntervals.get("zl")));
        blankSet.sub(new NamedRangeSet((List)this.propertyValueIntervals.get("zp")));
        this.propertyValueIntervals.put("blank", blankSet.getRanges());
        this.usedBinaryProperties.add("blank");
        NamedRangeSet graphSet = new NamedRangeSet(new NamedRange(0, this.getMaximumCodePoint()));
        graphSet.sub(new NamedRangeSet(whitespaceRanges));
        graphSet.sub(new NamedRangeSet((List)this.propertyValueIntervals.get("cc")));
        graphSet.sub(new NamedRangeSet((List)this.propertyValueIntervals.get("cn")));
        graphSet.sub(new NamedRangeSet(new NamedRange(55296, 57343)));
        this.propertyValueIntervals.put("graph", graphSet.getRanges());
        this.usedBinaryProperties.add("graph");
        NamedRangeSet printSet = graphSet.copy();
        printSet.add(blankSet);
        printSet.sub(new NamedRangeSet((List)this.propertyValueIntervals.get("cc")));
        this.propertyValueIntervals.put("print", printSet.getRanges());
        this.usedBinaryProperties.add("print");
    }
}

