/*
 * Decompiled with CFR 0.152.
 */
package edu.umich.its.lti;

import edu.umich.its.lti.utils.OauthCredentials;
import java.util.Arrays;
import java.util.HashMap;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TcSessionData {
    private static Log M_log = LogFactory.getLog(TcSessionData.class);
    private final String id = UUID.randomUUID().toString();
    private String contextId;
    private String contextLabel;
    private String contextTitle;
    private String membershipsId;
    private String membershipsUrl;
    private String resourceLinkId;
    private String userEmailAddress;
    private String userId;
    private String userImageUrl;
    private String userNameFull;
    private String userRoles;
    private String settingId;
    private String locale;
    private String customBrand;
    private HashMap<String, Object> customValuesMap;
    private String settingUrl;
    private String setting;
    private OauthCredentials oauthCredentials;
    private String[] userRoleArray;
    private String userSourceDid;

    public TcSessionData(HttpServletRequest request, OauthCredentials oac) {
        this.loadTcParameters(request, oac);
        M_log.debug((Object)("Tc value: " + this.toString()));
    }

    public TcSessionData(HttpServletRequest request, OauthCredentials oac, HashMap<String, Object> customValuesMap) {
        this.loadTcParameters(request, oac);
        M_log.debug((Object)("Tc value: " + this.toString()));
        this.customValuesMap = customValuesMap;
    }

    public boolean getHasRole(String role) {
        String[] roleArray = this.getUserRoleArray();
        if (roleArray != null) {
            for (int idx = 0; idx < roleArray.length; ++idx) {
                if (!role.equals(roleArray[idx])) continue;
                return true;
            }
        }
        return false;
    }

    public boolean getIsInstructor() {
        return this.getHasRole("Instructor");
    }

    public void loadTcParameters(HttpServletRequest request, OauthCredentials oac) {
        this.setOauthCredentials(oac);
        this.setContextId(request.getParameter("context_id"));
        this.setContextLabel(request.getParameter("context_label"));
        this.setContextTitle(request.getParameter("context_title"));
        this.setMembershipsId(request.getParameter("ext_ims_lis_memberships_id"));
        this.setMembershipsUrl(request.getParameter("ext_ims_lis_memberships_url"));
        this.setSettingId(request.getParameter("ext_ims_lti_tool_setting_id"));
        this.setSettingUrl(request.getParameter("ext_ims_lti_tool_setting_url"));
        this.setSetting(request.getParameter("ext_ims_lti_tool_setting"));
        this.setLocale(request.getParameter("launch_presentation_locale"));
        this.setResourceLinkId(request.getParameter("resource_link_id"));
        this.setUserEmailAddress(request.getParameter("lis_person_contact_email_primary"));
        this.setUserId(request.getParameter("user_id"));
        this.setUserImageUrl(request.getParameter("user_image"));
        this.setUserNameFull(request.getParameter("list_person_name_full"));
        this.setUserRoles(request.getParameter("roles"));
        this.setUserSourceDid(request.getParameter("lis_person_sourcedid"));
        this.setCustomBrand(request.getParameter("custom_brand"));
    }

    public boolean matchTpId(String value) {
        return this.getId().equals(value);
    }

    public void setUserRoles(String value) {
        this.userRoles = value;
        if (value != null) {
            this.setUserRoleArray(value.split(","));
        }
    }

    private void setUserRoleArray(String[] value) {
        this.userRoleArray = value;
    }

    public String getId() {
        return this.id;
    }

    public String getContextId() {
        return this.contextId;
    }

    public String getContextLabel() {
        return this.contextLabel;
    }

    public String getContextTitle() {
        return this.contextTitle;
    }

    public String getMembershipsId() {
        return this.membershipsId;
    }

    public String getMembershipsUrl() {
        return this.membershipsUrl;
    }

    public String getResourceLinkId() {
        return this.resourceLinkId;
    }

    public String getUserEmailAddress() {
        return this.userEmailAddress;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getUserImageUrl() {
        return this.userImageUrl;
    }

    public String getUserNameFull() {
        return this.userNameFull;
    }

    public String getUserRoles() {
        return this.userRoles;
    }

    public String getSettingId() {
        return this.settingId;
    }

    public String getLocale() {
        return this.locale;
    }

    public String getCustomBrand() {
        return this.customBrand;
    }

    public HashMap<String, Object> getCustomValuesMap() {
        return this.customValuesMap;
    }

    public String[] getUserRoleArray() {
        return this.userRoleArray;
    }

    public String getUserSourceDid() {
        return this.userSourceDid;
    }

    public void setContextId(String contextId) {
        this.contextId = contextId;
    }

    public void setContextLabel(String contextLabel) {
        this.contextLabel = contextLabel;
    }

    public void setContextTitle(String contextTitle) {
        this.contextTitle = contextTitle;
    }

    public void setMembershipsId(String membershipsId) {
        this.membershipsId = membershipsId;
    }

    public void setMembershipsUrl(String membershipsUrl) {
        this.membershipsUrl = membershipsUrl;
    }

    public void setResourceLinkId(String resourceLinkId) {
        this.resourceLinkId = resourceLinkId;
    }

    public void setUserEmailAddress(String userEmailAddress) {
        this.userEmailAddress = userEmailAddress;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setUserImageUrl(String userImageUrl) {
        this.userImageUrl = userImageUrl;
    }

    public void setUserNameFull(String userNameFull) {
        this.userNameFull = userNameFull;
    }

    public void setSettingId(String settingId) {
        this.settingId = settingId;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public void setCustomBrand(String customBrand) {
        this.customBrand = customBrand;
    }

    public void setCustomValuesMap(HashMap<String, Object> customValuesMap) {
        this.customValuesMap = customValuesMap;
    }

    public void setUserSourceDid(String userSourceDid) {
        this.userSourceDid = userSourceDid;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TcSessionData)) {
            return false;
        }
        TcSessionData other = (TcSessionData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$contextId = this.getContextId();
        String other$contextId = other.getContextId();
        if (this$contextId == null ? other$contextId != null : !this$contextId.equals(other$contextId)) {
            return false;
        }
        String this$contextLabel = this.getContextLabel();
        String other$contextLabel = other.getContextLabel();
        if (this$contextLabel == null ? other$contextLabel != null : !this$contextLabel.equals(other$contextLabel)) {
            return false;
        }
        String this$contextTitle = this.getContextTitle();
        String other$contextTitle = other.getContextTitle();
        if (this$contextTitle == null ? other$contextTitle != null : !this$contextTitle.equals(other$contextTitle)) {
            return false;
        }
        String this$membershipsId = this.getMembershipsId();
        String other$membershipsId = other.getMembershipsId();
        if (this$membershipsId == null ? other$membershipsId != null : !this$membershipsId.equals(other$membershipsId)) {
            return false;
        }
        String this$membershipsUrl = this.getMembershipsUrl();
        String other$membershipsUrl = other.getMembershipsUrl();
        if (this$membershipsUrl == null ? other$membershipsUrl != null : !this$membershipsUrl.equals(other$membershipsUrl)) {
            return false;
        }
        String this$resourceLinkId = this.getResourceLinkId();
        String other$resourceLinkId = other.getResourceLinkId();
        if (this$resourceLinkId == null ? other$resourceLinkId != null : !this$resourceLinkId.equals(other$resourceLinkId)) {
            return false;
        }
        String this$userEmailAddress = this.getUserEmailAddress();
        String other$userEmailAddress = other.getUserEmailAddress();
        if (this$userEmailAddress == null ? other$userEmailAddress != null : !this$userEmailAddress.equals(other$userEmailAddress)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$userImageUrl = this.getUserImageUrl();
        String other$userImageUrl = other.getUserImageUrl();
        if (this$userImageUrl == null ? other$userImageUrl != null : !this$userImageUrl.equals(other$userImageUrl)) {
            return false;
        }
        String this$userNameFull = this.getUserNameFull();
        String other$userNameFull = other.getUserNameFull();
        if (this$userNameFull == null ? other$userNameFull != null : !this$userNameFull.equals(other$userNameFull)) {
            return false;
        }
        String this$userRoles = this.getUserRoles();
        String other$userRoles = other.getUserRoles();
        if (this$userRoles == null ? other$userRoles != null : !this$userRoles.equals(other$userRoles)) {
            return false;
        }
        String this$settingId = this.getSettingId();
        String other$settingId = other.getSettingId();
        if (this$settingId == null ? other$settingId != null : !this$settingId.equals(other$settingId)) {
            return false;
        }
        String this$locale = this.getLocale();
        String other$locale = other.getLocale();
        if (this$locale == null ? other$locale != null : !this$locale.equals(other$locale)) {
            return false;
        }
        String this$customBrand = this.getCustomBrand();
        String other$customBrand = other.getCustomBrand();
        if (this$customBrand == null ? other$customBrand != null : !this$customBrand.equals(other$customBrand)) {
            return false;
        }
        HashMap<String, Object> this$customValuesMap = this.getCustomValuesMap();
        HashMap<String, Object> other$customValuesMap = other.getCustomValuesMap();
        if (this$customValuesMap == null ? other$customValuesMap != null : !((Object)this$customValuesMap).equals(other$customValuesMap)) {
            return false;
        }
        String this$settingUrl = this.getSettingUrl();
        String other$settingUrl = other.getSettingUrl();
        if (this$settingUrl == null ? other$settingUrl != null : !this$settingUrl.equals(other$settingUrl)) {
            return false;
        }
        String this$setting = this.getSetting();
        String other$setting = other.getSetting();
        if (this$setting == null ? other$setting != null : !this$setting.equals(other$setting)) {
            return false;
        }
        OauthCredentials this$oauthCredentials = this.getOauthCredentials();
        OauthCredentials other$oauthCredentials = other.getOauthCredentials();
        if (this$oauthCredentials == null ? other$oauthCredentials != null : !((Object)this$oauthCredentials).equals(other$oauthCredentials)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getUserRoleArray(), other.getUserRoleArray())) {
            return false;
        }
        String this$userSourceDid = this.getUserSourceDid();
        String other$userSourceDid = other.getUserSourceDid();
        return !(this$userSourceDid == null ? other$userSourceDid != null : !this$userSourceDid.equals(other$userSourceDid));
    }

    public boolean canEqual(Object other) {
        return other instanceof TcSessionData;
    }

    public int hashCode() {
        int PRIME = 277;
        int result = 1;
        String $id = this.getId();
        result = result * 277 + ($id == null ? 0 : $id.hashCode());
        String $contextId = this.getContextId();
        result = result * 277 + ($contextId == null ? 0 : $contextId.hashCode());
        String $contextLabel = this.getContextLabel();
        result = result * 277 + ($contextLabel == null ? 0 : $contextLabel.hashCode());
        String $contextTitle = this.getContextTitle();
        result = result * 277 + ($contextTitle == null ? 0 : $contextTitle.hashCode());
        String $membershipsId = this.getMembershipsId();
        result = result * 277 + ($membershipsId == null ? 0 : $membershipsId.hashCode());
        String $membershipsUrl = this.getMembershipsUrl();
        result = result * 277 + ($membershipsUrl == null ? 0 : $membershipsUrl.hashCode());
        String $resourceLinkId = this.getResourceLinkId();
        result = result * 277 + ($resourceLinkId == null ? 0 : $resourceLinkId.hashCode());
        String $userEmailAddress = this.getUserEmailAddress();
        result = result * 277 + ($userEmailAddress == null ? 0 : $userEmailAddress.hashCode());
        String $userId = this.getUserId();
        result = result * 277 + ($userId == null ? 0 : $userId.hashCode());
        String $userImageUrl = this.getUserImageUrl();
        result = result * 277 + ($userImageUrl == null ? 0 : $userImageUrl.hashCode());
        String $userNameFull = this.getUserNameFull();
        result = result * 277 + ($userNameFull == null ? 0 : $userNameFull.hashCode());
        String $userRoles = this.getUserRoles();
        result = result * 277 + ($userRoles == null ? 0 : $userRoles.hashCode());
        String $settingId = this.getSettingId();
        result = result * 277 + ($settingId == null ? 0 : $settingId.hashCode());
        String $locale = this.getLocale();
        result = result * 277 + ($locale == null ? 0 : $locale.hashCode());
        String $customBrand = this.getCustomBrand();
        result = result * 277 + ($customBrand == null ? 0 : $customBrand.hashCode());
        HashMap<String, Object> $customValuesMap = this.getCustomValuesMap();
        result = result * 277 + ($customValuesMap == null ? 0 : ((Object)$customValuesMap).hashCode());
        String $settingUrl = this.getSettingUrl();
        result = result * 277 + ($settingUrl == null ? 0 : $settingUrl.hashCode());
        String $setting = this.getSetting();
        result = result * 277 + ($setting == null ? 0 : $setting.hashCode());
        OauthCredentials $oauthCredentials = this.getOauthCredentials();
        result = result * 277 + ($oauthCredentials == null ? 0 : ((Object)$oauthCredentials).hashCode());
        result = result * 277 + Arrays.deepHashCode(this.getUserRoleArray());
        String $userSourceDid = this.getUserSourceDid();
        result = result * 277 + ($userSourceDid == null ? 0 : $userSourceDid.hashCode());
        return result;
    }

    public String toString() {
        return "TcSessionData(id=" + this.getId() + ", contextId=" + this.getContextId() + ", contextLabel=" + this.getContextLabel() + ", contextTitle=" + this.getContextTitle() + ", membershipsId=" + this.getMembershipsId() + ", membershipsUrl=" + this.getMembershipsUrl() + ", resourceLinkId=" + this.getResourceLinkId() + ", userEmailAddress=" + this.getUserEmailAddress() + ", userId=" + this.getUserId() + ", userImageUrl=" + this.getUserImageUrl() + ", userNameFull=" + this.getUserNameFull() + ", userRoles=" + this.getUserRoles() + ", settingId=" + this.getSettingId() + ", locale=" + this.getLocale() + ", customBrand=" + this.getCustomBrand() + ", customValuesMap=" + this.getCustomValuesMap() + ", settingUrl=" + this.getSettingUrl() + ", setting=" + this.getSetting() + ", oauthCredentials=" + this.getOauthCredentials() + ", userRoleArray=" + Arrays.deepToString(this.getUserRoleArray()) + ", userSourceDid=" + this.getUserSourceDid() + ")";
    }

    public String getSettingUrl() {
        return this.settingUrl;
    }

    public void setSettingUrl(String settingUrl) {
        this.settingUrl = settingUrl;
    }

    public String getSetting() {
        return this.setting;
    }

    public void setSetting(String setting) {
        this.setting = setting;
    }

    public OauthCredentials getOauthCredentials() {
        return this.oauthCredentials;
    }

    public void setOauthCredentials(OauthCredentials oauthCredentials) {
        this.oauthCredentials = oauthCredentials;
    }
}

