/*
 * Decompiled with CFR 0.152.
 */
package edu.umich.its.lti.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertiesUtilities {
    private static Log M_log = LogFactory.getLog(PropertiesUtilities.class);

    public static String getStringProperty(String defaultString, String propertyName, Properties prop) {
        String setValue = null;
        M_log.debug((Object)("setprop: defaultString: [" + defaultString + "] propertyName: [" + propertyName + "] local properties: [" + prop + "]"));
        setValue = System.getProperty(propertyName);
        M_log.debug((Object)("property after system properties check: [" + setValue + "]"));
        if (setValue == null) {
            setValue = prop.getProperty(propertyName);
        }
        M_log.debug((Object)("property after properties file check: [" + setValue + "]"));
        if (setValue == null) {
            setValue = defaultString;
        }
        M_log.debug((Object)("final properties value: [" + setValue + "]"));
        M_log.info((Object)("found property value: " + propertyName + ": " + setValue));
        return setValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getPropertiesObjectAsClassResource(String propertiesFileName) {
        InputStream is = null;
        Properties prop = new Properties();
        try {
            is = PropertiesUtilities.class.getResourceAsStream(propertiesFileName);
            prop.load(is);
        }
        catch (IOException e) {
            M_log.info((Object)("Properties file was not loaded: " + propertiesFileName), (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    M_log.error((Object)"IOException: ", (Throwable)e);
                }
            }
        }
        return prop;
    }

    public static Properties getPropertiesObjectFromURL(String propertiesFileURL) {
        Properties props = new Properties();
        InputStream in = null;
        in = PropertiesUtilities.getInputStreamFromURL(propertiesFileURL);
        if (in == null) {
            return null;
        }
        try {
            props.load(in);
        }
        catch (IOException e) {
            M_log.error((Object)("IO exception loading propertiesFileURL: " + propertiesFileURL), (Throwable)e);
            return null;
        }
        return props;
    }

    static InputStream getInputStreamFromURL(String fileURL) {
        InputStream in = null;
        URL url = null;
        if (fileURL == null || fileURL.length() == 0) {
            M_log.debug((Object)"null or zero length fileURL supplied");
            return null;
        }
        try {
            url = new URL(fileURL);
        }
        catch (MalformedURLException e) {
            M_log.error((Object)("file URL is malformed: " + fileURL), (Throwable)e);
            return null;
        }
        try {
            in = url.openStream();
        }
        catch (IOException e) {
            M_log.error((Object)("IO exception opening fileURL: " + fileURL), (Throwable)e);
            return null;
        }
        return in;
    }
}

