/*
 * Decompiled with CFR 0.152.
 */
package edu.umich.its.lti.utils;

import edu.umich.its.lti.utils.OauthCredentials;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthMessage;
import net.oauth.OAuthProblemException;
import net.oauth.SimpleOAuthValidator;
import net.oauth.server.OAuthServlet;
import net.oauth.signature.OAuthSignatureMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RequestSignatureUtils {
    private static final Log M_log = LogFactory.getLog(RequestSignatureUtils.class);

    public static Map<String, String> signParameters(Map<String, String> parameters, String url, String method, OauthCredentials oc) {
        HashMap<String, String> result = null;
        OAuthMessage oam = new OAuthMessage(method, url, parameters.entrySet());
        OAuthConsumer cons = new OAuthConsumer("about:blank", oc.getKey(), oc.getSecret(), null);
        OAuthAccessor acc = new OAuthAccessor(cons);
        try {
            oam.addRequiredParameters(acc);
            List params = oam.getParameters();
            result = new HashMap<String, String>();
            for (Map.Entry entry : params) {
                result.put((String)entry.getKey(), (String)entry.getValue());
            }
            return result;
        }
        catch (Exception err) {
            M_log.error((Object)"BasicLTIUtil.signProperties OAuth Exception ", (Throwable)err);
            throw new RuntimeException(err);
        }
    }

    public static boolean verifySignature(HttpServletRequest request, String oauth_consumer_key, String oauth_consumer_secret, String URL2) {
        if (URL2 == null || URL2.isEmpty()) {
            URL2 = request.getRequestURL().toString();
        }
        boolean result = false;
        OAuthMessage oam = OAuthServlet.getMessage((HttpServletRequest)request, (String)URL2);
        SimpleOAuthValidator oav = new SimpleOAuthValidator();
        OAuthConsumer cons = new OAuthConsumer("about:blank", oauth_consumer_key, oauth_consumer_secret, null);
        OAuthAccessor acc = new OAuthAccessor(cons);
        try {
            oav.validateMessage(oam, acc);
            result = true;
        }
        catch (Exception err) {
            String errMsg = "Failed to validate message";
            M_log.error((Object)errMsg, (Throwable)err);
            try {
                String base_string = OAuthSignatureMethod.getBaseString((OAuthMessage)oam);
                if (base_string != null) {
                    M_log.info((Object)base_string);
                }
            }
            catch (Exception err2) {
                M_log.error((Object)("Failed get get BaseString; this is for debugging - look at prior error \"" + errMsg + "\""), (Throwable)err);
            }
        }
        return result;
    }

    public static Boolean validateMessage(HttpServletRequest request, OauthCredentials oc) {
        OAuthMessage oam = OAuthServlet.getMessage((HttpServletRequest)request, null);
        SimpleOAuthValidator oav = new SimpleOAuthValidator();
        OAuthConsumer cons = new OAuthConsumer("about:blank#OAuth+CallBack+NotUsed", oc.getKey(), oc.getSecret(), null);
        OAuthAccessor acc = new OAuthAccessor(cons);
        String base_string = null;
        Boolean errorReturn = false;
        try {
            base_string = OAuthSignatureMethod.getBaseString((OAuthMessage)oam);
        }
        catch (Exception e) {
            base_string = null;
        }
        try {
            oav.validateMessage(oam, acc);
        }
        catch (OAuthProblemException oape) {
            M_log.error((Object)"OAuthProblemException during validation: ", (Throwable)oape);
            errorReturn = true;
            if (M_log.isDebugEnabled()) {
                Map parameters = oape.getParameters();
                Set keys = parameters.keySet();
                for (String k : keys) {
                    M_log.debug((Object)("key: [" + k + "] value: [" + parameters.get(k) + "]"));
                }
            }
        }
        catch (Exception e) {
            M_log.error((Object)"LTI validation failed: ", (Throwable)e);
            if (base_string != null) {
                M_log.debug((Object)("base string: " + base_string));
            }
            errorReturn = true;
        }
        return errorReturn;
    }
}

