/*
 * Decompiled with CFR 0.152.
 */
package edu.umich.its.lti.utils;

import edu.umich.its.lti.TcSessionData;
import edu.umich.its.lti.utils.ClientSslWrapper;
import edu.umich.its.lti.utils.RequestSignatureUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RosterClientUtils {
    public static final String USER_ID = "user_id";
    public static final String PERSON_SOURCEDID = "person_sourcedid";
    public static final String PERSON_NAME_GIVEN = "person_name_given";
    public static final String PERSON_NAME_FULL = "person_name_full";
    public static final String PERSON_NAME_FAMILY = "person_name_family";
    public static final String LIS_RESULT_SOURCEDID = "lis_result_sourcedid";
    public static final String ROLE = "role";
    public static final String PERSON_CONTACT_EMAIL_PRIMARY = "person_contact_email_primary";
    private static Log M_log = LogFactory.getLog(RosterClientUtils.class);
    static final String[] rosterDetailInfo = new String[]{"person_contact_email_primary", "role", "lis_result_sourcedid", "person_name_family", "person_name_full", "person_name_given", "person_sourcedid", "user_id"};

    public static List<String> getRoster(TcSessionData tcSessionData) throws ServletException, IOException {
        List<String> result = null;
        String sourceUrl = tcSessionData.getMembershipsUrl();
        HttpEntity httpEntity = RosterClientUtils.getRosterHttpEntity(tcSessionData, sourceUrl);
        try {
            result = RosterClientUtils.extractPersonContactEmailPrimaryFromRoster(httpEntity);
        }
        catch (ParserConfigurationException e) {
            M_log.error((Object)"Parser configuration error occurred when parsing the xml response which contains roster details", (Throwable)e);
        }
        catch (SAXException e) {
            M_log.error((Object)"SAXException error occurred when parsing the xml response which contains roster details", (Throwable)e);
        }
        return result;
    }

    public static List<String> getRosterWithNames(TcSessionData tcSessionData) throws ServletException, IOException {
        List<String> result = null;
        String sourceUrl = tcSessionData.getMembershipsUrl();
        HttpEntity httpEntity = RosterClientUtils.getRosterHttpEntity(tcSessionData, sourceUrl);
        try {
            result = RosterClientUtils.extractPersonEmailAndNamesFromRoster(httpEntity);
        }
        catch (ParserConfigurationException e) {
            M_log.error((Object)"Error occurred when parsing the xml response which contains roster details", (Throwable)e);
        }
        catch (SAXException e) {
            M_log.error((Object)"Error occurred when parsing the xml response which contains roster details", (Throwable)e);
        }
        return result;
    }

    public static HashMap<String, HashMap<String, String>> getRosterFull(TcSessionData tcSessionData) throws ServletException, IOException {
        HashMap<String, HashMap<String, String>> result = null;
        String sourceUrl = tcSessionData.getMembershipsUrl();
        HttpEntity httpEntity = RosterClientUtils.getRosterHttpEntity(tcSessionData, sourceUrl);
        try {
            result = RosterClientUtils.extractRosterInformationFromXML(httpEntity);
        }
        catch (ParserConfigurationException e) {
            M_log.error((Object)"Error occurred when parsing the xml response which contains roster details", (Throwable)e);
        }
        catch (SAXException e) {
            M_log.error((Object)"Error occurred when parsing the xml response which contains roster details", (Throwable)e);
        }
        return result;
    }

    protected static List<String> extractPersonContactEmailPrimaryFromRoster(HttpEntity httpEntity) throws ParserConfigurationException, SAXException, IOException {
        if (httpEntity == null) {
            M_log.warn((Object)"extractPersonContactEmailPrimaryFromRoster got null httpEntity");
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        Document doc = RosterClientUtils.documentInfo(httpEntity);
        if (doc == null) {
            M_log.warn((Object)"extractPersonContactEmailPrimaryFromRoster got null doc");
            return null;
        }
        NodeList nodes = doc.getElementsByTagName(PERSON_CONTACT_EMAIL_PRIMARY);
        for (int nodeIdx = 0; nodeIdx < nodes.getLength(); ++nodeIdx) {
            Node node = nodes.item(nodeIdx);
            result.add(node.getTextContent());
        }
        return result;
    }

    protected static List<String> extractPersonEmailAndNamesFromRoster(HttpEntity httpEntity) throws ParserConfigurationException, SAXException, IOException {
        if (httpEntity == null) {
            M_log.warn((Object)"extractPersonEmailAndNamesFromRoster got null httpEntity");
            return null;
        }
        HashMap<String, HashMap<String, String>> roster = RosterClientUtils.extractRosterInformationFromXML(httpEntity);
        List<String> result = RosterClientUtils.buildCSVEmailFirstnameLastnameFromRoster(roster);
        return result;
    }

    protected static HashMap<String, HashMap<String, String>> extractRosterInformationFromXML(HttpEntity httpEntity) throws ParserConfigurationException, SAXException, IOException {
        if (httpEntity == null) {
            return null;
        }
        HashMap<String, HashMap<String, String>> newRosterBig = new HashMap<String, HashMap<String, String>>();
        Document doc = RosterClientUtils.documentInfo(httpEntity);
        NodeList memberList = doc.getElementsByTagName("member");
        for (int i = 0; i < memberList.getLength(); ++i) {
            HashMap<String, String> nestedMap = new HashMap<String, String>();
            Node nNode = memberList.item(i);
            if (nNode.getNodeType() == 1) {
                Element eElement = (Element)nNode;
                for (String tagName : rosterDetailInfo) {
                    String text = "";
                    if (eElement.getElementsByTagName(tagName).item(0) == null) continue;
                    text = eElement.getElementsByTagName(tagName).item(0).getTextContent();
                    nestedMap.put(tagName, text);
                }
            }
            newRosterBig.put((String)nestedMap.get(PERSON_CONTACT_EMAIL_PRIMARY), nestedMap);
        }
        return newRosterBig;
    }

    protected static List<String> buildCSVEmailFirstnameLastnameFromRoster(HashMap<String, HashMap<String, String>> roster) {
        ArrayList<String> result = new ArrayList<String>();
        for (String email : roster.keySet()) {
            String familyName = roster.get(email).get(PERSON_NAME_FAMILY);
            String givenName = roster.get(email).get(PERSON_NAME_GIVEN);
            StringBuilder entry = new StringBuilder();
            entry.append(email).append(",").append(givenName).append(",").append(familyName);
            result.add(entry.toString());
        }
        return result;
    }

    protected static Document documentInfo(HttpEntity httpEntity) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = dbFactory.newDocumentBuilder();
        Document doc = docBuilder.parse(httpEntity.getContent());
        doc.getDocumentElement().normalize();
        return doc;
    }

    protected static HttpEntity getRosterHttpEntity(TcSessionData tcSessionData, String sourceUrl) throws UnsupportedEncodingException, IOException, ClientProtocolException {
        HttpPost httpPost = new HttpPost(sourceUrl);
        Map<String, String> ltiParams = RosterClientUtils.getLtiRosterParameters(tcSessionData, sourceUrl);
        ArrayList<NameValuePair> nvps = new ArrayList<NameValuePair>();
        for (Map.Entry<String, String> parameter : ltiParams.entrySet()) {
            RosterClientUtils.addParameter(nvps, parameter.getKey(), parameter.getValue());
        }
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, "UTF-8"));
        HttpClient client = ClientSslWrapper.wrapClient((HttpClient)new DefaultHttpClient());
        if (client == null) {
            M_log.warn((Object)"getRosterHttpEntity got null client");
            return null;
        }
        HttpResponse httpResponse = client.execute((HttpUriRequest)httpPost);
        HttpEntity httpEntity = httpResponse.getEntity();
        return httpEntity;
    }

    protected static void addParameter(List<NameValuePair> nvps, String name, String value) {
        nvps.add((NameValuePair)new BasicNameValuePair(name, value));
    }

    protected static Map<String, String> getLtiRosterParameters(TcSessionData tcSessionData, String sourceUrl) {
        Map<String, String> result = new HashMap<String, String>();
        result.put("id", tcSessionData.getMembershipsId());
        result.put("lti_message_type", "basic-lis-readmembershipsforcontext");
        result.put("lti_version", "LTI-1p0");
        result.put("oauth_callback", "about:blank");
        result = RequestSignatureUtils.signParameters(result, sourceUrl, "POST", tcSessionData.getOauthCredentials());
        return result;
    }
}

