/*
 * Decompiled with CFR 0.152.
 */
package edu.umich.its.lti.utils;

import edu.umich.its.lti.TcSessionData;
import edu.umich.its.lti.utils.ClientSslWrapper;
import edu.umich.its.lti.utils.RequestSignatureUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SettingsClientUtils {
    private static Log M_log = LogFactory.getLog(SettingsClientUtils.class);

    public static String getSettingString(TcSessionData tcSessionData) throws ServletException, IOException {
        List<String> resultStringList = null;
        String resultString = null;
        String sourceUrl = tcSessionData.getSettingUrl();
        M_log.debug((Object)("get setting from: [" + sourceUrl + "]"));
        if (sourceUrl != null) {
            try {
                Map<String, String> ltiParams = SettingsClientUtils.loadSettingFillParametersAndSignRequest(tcSessionData);
                HttpResponse httpResponse = SettingsClientUtils.postSettingRequestAndGetHttpResponse(sourceUrl, ltiParams);
                StatusLine status = httpResponse.getStatusLine();
                HttpEntity httpEntity = httpResponse.getEntity();
                if (M_log.isDebugEnabled()) {
                    String entityAsString = httpEntity.getContent().toString();
                    M_log.debug((Object)("setting service entity as string: " + entityAsString));
                }
                if (httpEntity != null) {
                    resultStringList = SettingsClientUtils.parseSettingXml(httpEntity.getContent());
                }
            }
            catch (Exception err) {
                M_log.error((Object)"error getting or parsing setting value", (Throwable)err);
            }
        } else {
            resultString = "{}";
            if (tcSessionData != null && tcSessionData.getSetting() != null) {
                resultString = tcSessionData.getSetting().toString();
            }
        }
        if (resultStringList != null && resultStringList.size() > 0) {
            resultString = (String)resultStringList.get(0);
            resultString = SettingsClientUtils.decodeSettingString(resultString);
        }
        M_log.debug((Object)("read setting string: " + resultString));
        return resultString;
    }

    protected static List<String> parseSettingXml(InputStream stream) throws ParserConfigurationException, SAXException, IOException {
        ArrayList<String> result = new ArrayList<String>();
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = dbFactory.newDocumentBuilder();
        Document doc = docBuilder.parse(stream);
        doc.getDocumentElement().normalize();
        NodeList nodes = doc.getElementsByTagName("setting");
        for (int nodeIdx = 0; nodeIdx < nodes.getLength(); ++nodeIdx) {
            Node node = nodes.item(nodeIdx);
            result.add(node.getTextContent().trim());
        }
        return result;
    }

    protected static void printNode(Node rootNode, String spacer) {
        M_log.debug((Object)(spacer + rootNode.getNodeName() + " -> " + rootNode.getNodeValue()));
        NodeList nl = rootNode.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            SettingsClientUtils.printNode(nl.item(i), spacer + "   ");
        }
    }

    public static Boolean setSetting(TcSessionData tcSessionData, String setting) throws ServletException, IOException {
        Boolean success = true;
        M_log.debug((Object)("write setting string: " + setting));
        String encodedSetting = SettingsClientUtils.encodeSettingString(setting);
        M_log.debug((Object)("setSetting encoded string: [" + encodedSetting + "]"));
        try {
            String sourceUrl = tcSessionData.getSettingUrl();
            M_log.debug((Object)("save setting to [" + sourceUrl + "]"));
            Map<String, String> ltiParams = SettingsClientUtils.saveSettingFillParametersAndSignRequest(tcSessionData, encodedSetting);
            HttpResponse httpResponse = SettingsClientUtils.postSettingRequestAndGetHttpResponse(sourceUrl, ltiParams);
            StatusLine status = httpResponse.getStatusLine();
            M_log.debug((Object)("setSetting: httpResponse.getStatusLine(): " + status));
            M_log.debug((Object)("setSetting: statusCode: " + status.getStatusCode()));
        }
        catch (Exception err) {
            success = false;
            M_log.error((Object)"Exception writing settings string", (Throwable)err);
        }
        return success;
    }

    public static HttpResponse postSettingRequestAndGetHttpResponse(String sourceUrl, Map<String, String> ltiParams) throws UnsupportedEncodingException, IOException, ClientProtocolException {
        HttpPost httpPost = new HttpPost(sourceUrl);
        ArrayList<NameValuePair> nvps = new ArrayList<NameValuePair>();
        for (Map.Entry<String, String> parameter : ltiParams.entrySet()) {
            SettingsClientUtils.addParameter(nvps, parameter.getKey(), parameter.getValue());
        }
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, "UTF-8"));
        HttpClient client = ClientSslWrapper.wrapClient((HttpClient)new DefaultHttpClient());
        HttpResponse httpResponse = client.execute((HttpUriRequest)httpPost);
        return httpResponse;
    }

    public static String encodeSettingString(String setting) {
        String encodedSetting = Base64.encodeBase64String((byte[])setting.getBytes());
        M_log.debug((Object)("base64 setting string: " + encodedSetting));
        return encodedSetting;
    }

    public static String decodeSettingString(String resultString) {
        if (Base64.isBase64((String)resultString)) {
            byte[] decoded = Base64.decodeBase64((String)resultString);
            resultString = new String(decoded);
        }
        return resultString;
    }

    protected static void addParameter(List<NameValuePair> nvps, String name, String value) {
        nvps.add((NameValuePair)new BasicNameValuePair(name, value));
    }

    protected static Map<String, String> saveSettingFillParametersAndSignRequest(TcSessionData tcSessionData, String setting) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("lti_message_type", "basic-lti-savesetting");
        if (setting == null) {
            setting = "";
        }
        result.put("setting", setting);
        return SettingsClientUtils.createSignedResult(tcSessionData, result);
    }

    protected static Map<String, String> loadSettingFillParametersAndSignRequest(TcSessionData tcSessionData) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("lti_message_type", "basic-lti-loadsetting");
        return SettingsClientUtils.createSignedResult(tcSessionData, result);
    }

    protected static Map<String, String> createSignedResult(TcSessionData tcSessionData, Map<String, String> result) {
        result.put("id", tcSessionData.getSettingId());
        result.put("lti_version", "LTI-1p0");
        result.put("oauth_callback", "about:blank");
        result = RequestSignatureUtils.signParameters(result, tcSessionData.getSettingUrl(), "POST", tcSessionData.getOauthCredentials());
        return result;
    }
}

