/*
 * Decompiled with CFR 0.152.
 */
package edu.upc.dama.dex.core;

import edu.upc.dama.dex.core.GraphPool;
import edu.upc.dama.dex.monitor.Monitor;
import edu.upc.dama.dex.utils.DEXConfig;
import edu.upc.dama.dex.utils.OS;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DEX
implements Closeable {
    private long handle = 0L;
    private Monitor monitor = null;
    private ArrayList<GraphPool> gpools = new ArrayList();

    synchronized void register(GraphPool gp) {
        this.gpools.add(gp);
    }

    synchronized void unregister(GraphPool gp) {
        this.gpools.remove(gp);
    }

    private native long init_(Config var1);

    private native void release_();

    private native GraphPool create_(String var1, String var2) throws FileNotFoundException;

    private native GraphPool open_(String var1, boolean var2) throws FileNotFoundException;

    private static native String getVersion_();

    private static native SystemStatistics getSystemStatistics_();

    public DEX(String license) {
        Config cfg = new Config();
        cfg.setLicense(license);
        this.init(cfg);
    }

    public DEX(Config cfg) {
        this.init(cfg);
    }

    public DEX() {
        this.init(new Config());
    }

    void init(Config cfg) {
        this.handle = this.init_(cfg);
        assert (this.handle != 0L);
        if (DEXConfig.getBoolean("dex.monitor.active")) {
            int port = DEXConfig.getInt("dex.monitor.port");
            this.monitor = new Monitor(this, port);
            try {
                this.monitor.start();
            }
            catch (Exception ex) {
                this.monitor = null;
            }
        }
    }

    public boolean isOpen() {
        return this.handle != 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.isOpen()) {
            ArrayList<GraphPool> arrayList = this.gpools;
            synchronized (arrayList) {
                while (this.gpools.size() > 0) {
                    this.gpools.get(0).close();
                }
            }
            if (this.monitor != null && this.monitor.isActive()) {
                this.monitor.stop();
                this.monitor = null;
            }
            this.release_();
            this.handle = 0L;
        }
    }

    public GraphPool create(String img) throws FileNotFoundException {
        return this.create(img, null);
    }

    public GraphPool create(String img, String alias) throws FileNotFoundException {
        GraphPool gp = this.create_(img, alias);
        this.register(gp);
        return gp;
    }

    public GraphPool create(File img) throws FileNotFoundException {
        return this.create(img.getPath(), null);
    }

    public GraphPool create(File img, String alias) throws FileNotFoundException {
        return this.create(img.getPath(), alias);
    }

    public GraphPool open(String img) throws FileNotFoundException {
        GraphPool gp = this.open_(img, false);
        this.register(gp);
        return gp;
    }

    public GraphPool openReadOnly(String img) throws FileNotFoundException {
        GraphPool gp = this.open_(img, true);
        this.register(gp);
        return gp;
    }

    public GraphPool open(File img) throws FileNotFoundException {
        return this.open(img.getPath());
    }

    public GraphPool openReadOnly(File img) throws FileNotFoundException {
        return this.openReadOnly(img.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<GraphPool> getGraphPools() {
        HashSet<GraphPool> hs = null;
        ArrayList<GraphPool> arrayList = this.gpools;
        synchronized (arrayList) {
            hs = new HashSet<GraphPool>(this.gpools);
        }
        return hs;
    }

    public static String getVersion() {
        return DEX.getVersion_();
    }

    public static SystemStatistics getSystemStatistics() {
        return DEX.getSystemStatistics_();
    }

    private static boolean loadLibrary() {
        try {
            String libname = null;
            String archLibPrefix = null;
            String archLibSuffix = null;
            switch (OS.getName()) {
                case WINDOWS: {
                    libname = "windows";
                    archLibPrefix = "";
                    archLibSuffix = ".dll";
                    break;
                }
                case LINUX: {
                    libname = "linux";
                    archLibPrefix = "lib";
                    archLibSuffix = ".so";
                    break;
                }
                case MAC: {
                    libname = "macos";
                    archLibPrefix = "lib";
                    archLibSuffix = ".dylib";
                    break;
                }
                case UNIX: 
                case UNKNOWN: {
                    throw new RuntimeException("This platform is not supported");
                }
            }
            OS.Arch a = OS.getArchitecture();
            switch (OS.getArchitecture()) {
                case ARCH_32: {
                    libname = libname + "32";
                    break;
                }
                case ARCH_64: {
                    libname = libname + "64";
                }
            }
            String libsDir = "/" + libname + ".nativelibs";
            File tmpLibFile = File.createTempFile(".jdex", "");
            tmpLibFile.deleteOnExit();
            File tmpLibDir = new File(tmpLibFile.getAbsolutePath() + ".LibsDir");
            tmpLibDir.mkdir();
            tmpLibDir.deleteOnExit();
            File tmpDLLSTLport = DEX.buildTempLibrary(libsDir + "/" + archLibPrefix + "stlport" + archLibSuffix, tmpLibDir.getPath() + "/" + archLibPrefix + "stlport" + archLibSuffix);
            System.load(tmpDLLSTLport.getPath());
            File tmpDLLjdex = DEX.buildTempLibrary(libsDir + "/" + archLibPrefix + "jdex" + archLibSuffix, tmpLibDir.getPath() + "/" + archLibPrefix + "jdex" + archLibSuffix);
            System.load(tmpDLLjdex.getPath());
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private static File buildTempLibrary(String sourcePath, String targetPath) throws Exception {
        InputStream istream = DEX.class.getResource(sourcePath).openStream();
        File tmpDLL = new File(targetPath);
        tmpDLL.createNewFile();
        tmpDLL.deleteOnExit();
        FileOutputStream outputStream = new FileOutputStream(tmpDLL);
        byte[] array = new byte[8192];
        int read = 0;
        while ((read = istream.read(array)) > 0) {
            outputStream.write(array, 0, read);
        }
        outputStream.close();
        return tmpDLL;
    }

    private static native void setTraceFile_(String var0, int var1);

    static void setTraceFile(String filePath, int bufferSize) {
        DEX.setTraceFile_(filePath, bufferSize);
    }

    private static native void closeTraceFile_();

    static void closeTraceFile() {
        DEX.closeTraceFile_();
    }

    private static native void pauseTrace_();

    static void pauseTrace() {
        DEX.pauseTrace_();
    }

    private static native void resumeTrace_();

    static void resumeTrace() {
        DEX.resumeTrace_();
    }

    private static native void flushTrace_();

    static void flushTrace() {
        DEX.flushTrace_();
    }

    private static native void traceEvent_(int var0, long var1, String var3);

    static void traceEvent(int id, long value, String desc) {
        DEX.traceEvent_(id, value, desc);
    }

    static {
        DEX.loadLibrary();
    }

    public static class Config {
        private int poolFrameSize = DEXConfig.getInt("dex.io.pool.frame.size");
        private int poolPersistentMinSize = DEXConfig.getInt("dex.io.pool.persistent.minsize");
        private int poolPersistentMaxSize = DEXConfig.getInt("dex.io.pool.persistent.maxsize");
        private int poolTemporalMinSize = DEXConfig.getInt("dex.io.pool.temporal.minsize");
        private int poolTemporalMaxSize = DEXConfig.getInt("dex.io.pool.temporal.maxsize");
        private int cacheMaxSize = DEXConfig.getInt("dex.io.cache.maxsize");
        private String license = DEXConfig.get("dex.license");
        private String log = DEXConfig.get("dex.log");

        public void setCacheMaxSize(int value) {
            this.cacheMaxSize = value;
        }

        public int getCacheMaxSize() {
            return this.cacheMaxSize;
        }

        public void setLicense(String value) {
            this.license = value;
        }

        public String getLicense() {
            return this.license;
        }

        public void setLog(String value) {
            this.log = value;
        }

        public String getLog() {
            return this.log;
        }
    }

    public static class SystemStatistics {
        public int cpu;
        public long realTime;
        public long userTime;
        public long sysTime;
        public long totalMem;
        public long availMem;

        private SystemStatistics() {
        }
    }
}

