/*
 * Decompiled with CFR 0.152.
 */
package edu.upc.dama.dex.core;

import edu.upc.dama.dex.core.Session;
import java.io.Closeable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Objects
implements Closeable,
Set<Long> {
    private long handle = 0L;
    private Session sess = null;
    private final ArrayList<Iterator> iters = new ArrayList();
    public static final short COMBINE_UNION = 0;
    public static final short COMBINE_INTERSECTION = 1;
    public static final short COMBINE_DIFFERENCE = 2;

    Objects(Session sess, long handle) {
        this.sess = sess;
        this.handle = handle;
        assert (handle != 0L);
    }

    private native long init_(Session var1);

    private native long init_combine_(Session var1, Objects var2, Objects var3, short var4);

    private native void release_(Session var1);

    private native boolean add_(Session var1, long var2);

    private native boolean exists_(Session var1, long var2);

    private native long first_(Session var1);

    private native long next_(Session var1, long var2, boolean var4);

    private native boolean remove_(Session var1, long var2);

    private native void clear_(Session var1);

    private native long size_(Session var1);

    private native long union_(Session var1, Objects var2);

    private native long intersection_(Session var1, Objects var2);

    private native long difference_(Session var1, Objects var2);

    private static native Objects sample_(Session var0, Objects var1, Objects var2, long var3);

    private native Iterator iterator_(Session var1);

    private native Iterator iterator_(Session var1, long var2);

    private native Iterator iteratorFromOID_(Session var1, long var2);

    public Objects(Session sess) {
        this.sess = sess;
        this.handle = this.init_(sess);
        assert (this.handle != 0L);
    }

    private native long init_copy_(Session var1, Objects var2);

    public Objects(Session sess, Objects objs) {
        this.sess = sess;
        this.handle = this.init_copy_(sess, objs);
        assert (this.handle != 0L);
    }

    public Objects(Session sess, Objects objs1, Objects objs2, short combine) {
        this.sess = sess;
        this.handle = this.init_combine_(sess, objs1, objs2, combine);
        assert (this.handle != 0L);
    }

    public static Objects union(Session sess, Objects objs1, Objects objs2) {
        return new Objects(sess, objs1, objs2, 0);
    }

    public static Objects intersection(Session sess, Objects objs1, Objects objs2) {
        return new Objects(sess, objs1, objs2, 1);
    }

    public static Objects difference(Session sess, Objects objs1, Objects objs2) {
        return new Objects(sess, objs1, objs2, 2);
    }

    @Deprecated
    public Objects(Session sess, Objects objs1, Objects objs2, Combine c) {
        this.sess = sess;
        switch (c) {
            case UNION: {
                this.handle = this.init_combine_(sess, objs1, objs2, (short)0);
                break;
            }
            case INTERSECTION: {
                this.handle = this.init_combine_(sess, objs1, objs2, (short)1);
                break;
            }
            case DIFFERENCE: {
                this.handle = this.init_combine_(sess, objs1, objs2, (short)2);
            }
        }
        assert (this.handle != 0L);
    }

    public Session getSession() {
        return this.sess;
    }

    public boolean isOpen() {
        return this.handle != 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.isOpen()) {
            ArrayList<Iterator> arrayList = this.iters;
            synchronized (arrayList) {
                while (this.iters.size() > 0) {
                    this.iters.get(0).close();
                }
            }
            this.release_(this.sess);
            this.handle = 0L;
        }
    }

    public long sizeLong() {
        return this.size_(this.sess);
    }

    @Override
    public boolean add(long oid) {
        return this.add_(this.sess, oid);
    }

    public boolean exists(long oid) {
        return this.exists_(this.sess, oid);
    }

    public long first() {
        return this.first_(this.sess);
    }

    public long next(long oid, boolean exists) {
        return this.next_(this.sess, oid, exists);
    }

    public boolean remove(long oid) {
        return this.remove_(this.sess, oid);
    }

    @Override
    public void clear() {
        this.clear_(this.sess);
    }

    public long union(Objects objs) {
        return this.union_(this.sess, objs);
    }

    public long intersection(Objects objs) {
        return this.intersection_(this.sess, objs);
    }

    public long difference(Objects objs) {
        return this.difference_(this.sess, objs);
    }

    public static Objects sample(Session sess, Objects src, Objects exclude, long samples) {
        return Objects.sample_(sess, src, exclude, samples);
    }

    public Iterator iterator() {
        Iterator it = this.iterator_(this.sess);
        this.register(it);
        return it;
    }

    public Iterator iterator(long startPosition) {
        Iterator it = this.iterator_(this.sess, startPosition);
        this.register(it);
        return it;
    }

    public Iterator iteratorFromOID(long oid) {
        Iterator it = this.iteratorFromOID_(this.sess, oid);
        this.register(it);
        return it;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void register(Iterator it) {
        ArrayList<Iterator> arrayList = this.iters;
        synchronized (arrayList) {
            this.iters.add(it);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void unregister(Iterator it) {
        ArrayList<Iterator> arrayList = this.iters;
        synchronized (arrayList) {
            this.iters.remove(it);
        }
    }

    @Override
    public int size() {
        long s = this.size_(this.sess);
        return s > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)s;
    }

    @Override
    public boolean isEmpty() {
        return this.size_(this.sess) == 0L;
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            throw new NullPointerException("This collection does not support null elements.");
        }
        if (o instanceof Long) {
            return this.exists_(this.sess, (Long)o);
        }
        throw new ClassCastException("The specified element is incompatible with this collection.");
    }

    @Override
    public Object[] toArray() {
        Long[] ret = null;
        int s = this.size();
        if (s > 0) {
            ret = new Long[s];
            Iterator it = this.iterator();
            int i = 0;
            while (it.hasNext()) {
                ret[i++] = it.next();
            }
            it.close();
        }
        return ret;
    }

    @Override
    public <T> T[] toArray(T[] ts) {
        if (ts == null) {
            throw new NullPointerException("The specified array is null.");
        }
        if (!Long.class.isAssignableFrom(ts.getClass().getComponentType()) && ts.getClass().getComponentType() != Long.TYPE) {
            throw new ArrayStoreException("Type of the specified array is not a supertype of the runtime type of every element in this collection.");
        }
        int size = this.size();
        boolean spare = ts.length > size;
        T[] ret = ts.length >= size ? ts : (Object[])Array.newInstance(ts.getClass().getComponentType(), size);
        Iterator it = this.iterator();
        int i = 0;
        while (it.hasNext()) {
            ret[i++] = it.next();
        }
        it.close();
        if (spare) {
            ret[size] = null;
        }
        return ret;
    }

    @Override
    public boolean add(Long e) {
        if (e == null) {
            throw new NullPointerException("This collection does not support null elements.");
        }
        return this.add_(this.sess, e);
    }

    @Override
    public boolean remove(Object o) {
        if (o == null) {
            throw new NullPointerException("This collection does not support null elements.");
        }
        if (o instanceof Long) {
            return this.remove_(this.sess, (Long)o);
        }
        throw new ClassCastException("The specified element is incompatible with this collection.");
    }

    @Override
    public boolean containsAll(Collection<?> clctn) {
        boolean isSubSet;
        if (clctn == null) {
            throw new NullPointerException("The specified collection is null.");
        }
        if (clctn instanceof Objects) {
            Objects objs = new Objects(this.sess, this, (Objects)clctn, 1);
            isSubSet = objs.size_(this.sess) == ((Objects)clctn).sizeLong();
            objs.close();
        } else {
            Object object;
            java.util.Iterator<?> it = clctn.iterator();
            for (isSubSet = true; it.hasNext() && isSubSet; isSubSet &= this.exists_(this.sess, (Long)object)) {
                object = it.next();
                if (object == null) {
                    throw new NullPointerException("The specified collection contains one or more null elements and this set does not support null elements");
                }
                if (object instanceof Long) {
                    continue;
                }
                throw new ClassCastException("The types of one or more elements in the specified collection are incompatible with this set.");
            }
        }
        return isSubSet;
    }

    @Override
    public boolean addAll(Collection<? extends Long> clctn) {
        if (clctn == null) {
            throw new NullPointerException("The specified collection is null.");
        }
        if (clctn instanceof Objects) {
            long oldSize = this.size_(this.sess);
            long l = this.union((Objects)clctn);
            return l != oldSize;
        }
        boolean updated = false;
        for (Long l : clctn) {
            if (l == null) {
                throw new NullPointerException("This collection does not support null elements.");
            }
            updated |= this.add_(this.sess, l);
        }
        return updated;
    }

    @Override
    public boolean retainAll(Collection<?> clctn) {
        if (clctn == null) {
            throw new NullPointerException("The specified collection is null.");
        }
        if (clctn instanceof Objects) {
            long oldSize = this.size_(this.sess);
            long newSize = this.intersection((Objects)clctn);
            return newSize != oldSize;
        }
        boolean updated = false;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            long oid = it.next();
            if (clctn.contains(oid)) continue;
            updated &= this.remove_(this.sess, oid);
        }
        it.close();
        return updated;
    }

    @Override
    public boolean removeAll(Collection<?> clctn) {
        if (clctn == null) {
            throw new NullPointerException("The specified collection is null.");
        }
        if (clctn instanceof Objects) {
            long oldSize = this.size_(this.sess);
            long newSize = this.difference((Objects)clctn);
            return newSize != oldSize;
        }
        boolean updated = false;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            long oid = it.next();
            if (!clctn.contains(oid)) continue;
            updated &= this.remove_(this.sess, oid);
        }
        it.close();
        return updated;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Iterator
    implements java.util.Iterator<Long>,
    Closeable {
        private long handle = 0L;

        private native void release_(Session var1);

        private native boolean hasNext_();

        private native long next_();

        Iterator(long handle) {
            this.handle = handle;
            assert (this.handle != 0L);
        }

        @Override
        public boolean hasNext() {
            return this.hasNext_();
        }

        @Override
        public Long next() {
            return this.next_();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean isOpen() {
            return this.handle != 0L;
        }

        @Override
        public void close() {
            if (this.isOpen()) {
                Objects.this.unregister(this);
                this.release_(Objects.this.sess);
                this.handle = 0L;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    public static enum Combine {
        UNION,
        INTERSECTION,
        DIFFERENCE;

    }
}

