/*
 * Decompiled with CFR 0.152.
 */
package edu.upc.dama.dex.io;

import edu.upc.dama.dex.io.RowReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVReader
implements RowReader {
    private File file;
    private Reader reader;
    private BufferedReader br;
    private boolean hasNext = true;
    private char separator;
    private char quotechar;
    private int skipLines;
    private int maxLines;
    private boolean linesSkiped;
    private boolean allowMultilines;
    private int linesReaded;
    public static final boolean DEFAULT_ALLOW_MULTILINE = true;
    public static final char DEFAULT_SEPARATOR = ',';
    public static final char DEFAULT_QUOTE_CHARACTER = '\"';
    public static final int DEFAULT_SKIP_LINES = 0;
    public static final int DEFAULT_MAX_LINES = 0;

    public CSVReader(Reader reader) {
        this(reader, ',');
    }

    public CSVReader(File file) throws FileNotFoundException {
        this(new FileReader(file));
        this.file = file;
    }

    public CSVReader(Reader reader, char separator) {
        this(reader, separator, '\"');
    }

    public CSVReader(File file, char separator) throws FileNotFoundException {
        this(new FileReader(file), separator);
        this.file = file;
    }

    public CSVReader(Reader reader, char separator, char quotechar) {
        this(reader, separator, quotechar, true);
    }

    public CSVReader(File file, char separator, char quotechar) throws FileNotFoundException {
        this(new FileReader(file), separator, quotechar, true);
        this.file = file;
    }

    public CSVReader(Reader reader, char separator, char quotechar, boolean allowMultilines) {
        this(reader, separator, quotechar, allowMultilines, 0);
    }

    public CSVReader(File file, char separator, char quotechar, boolean allowMultilines) throws FileNotFoundException {
        this(new FileReader(file), separator, quotechar, allowMultilines, 0);
        this.file = file;
    }

    public CSVReader(Reader reader, char separator, char quotechar, boolean allowMultilines, int startline) {
        this(reader, separator, quotechar, allowMultilines, startline, 0);
    }

    public CSVReader(File file, char separator, char quotechar, boolean allowMultilines, int startline) throws FileNotFoundException {
        this(file, separator, quotechar, allowMultilines, startline, 0);
        this.file = file;
    }

    public CSVReader(Reader reader, char separator, char quotechar, boolean allowMultilines, int startline, int maxlines) {
        this.reader = reader;
        this.br = new BufferedReader(this.reader);
        this.separator = separator;
        this.quotechar = quotechar;
        this.allowMultilines = allowMultilines;
        this.skipLines = startline;
        this.maxLines = maxlines;
        this.file = null;
        this.linesReaded = 0;
    }

    public CSVReader(File file, char separator, char quotechar, boolean allowMultilines, int startline, int maxlines) throws FileNotFoundException {
        this(new FileReader(file), separator, quotechar, allowMultilines, startline, maxlines);
        this.file = file;
    }

    public List<String[]> readAll() throws IOException {
        ArrayList<String[]> allElements = new ArrayList<String[]>();
        while (this.hasNext) {
            String[] nextLineAsTokens = this.readNext();
            if (nextLineAsTokens == null) continue;
            allElements.add(nextLineAsTokens);
        }
        return allElements;
    }

    @Override
    public String[] readNext() throws IOException {
        String nextLine = this.getNextLine();
        return this.hasNext ? this.parseLine(nextLine) : null;
    }

    private String getNextLine() throws IOException {
        if (!this.linesSkiped) {
            for (int i = 0; i < this.skipLines; ++i) {
                this.br.readLine();
            }
            this.linesSkiped = true;
            this.linesReaded = this.skipLines;
        }
        String nextLine = this.br.readLine();
        ++this.linesReaded;
        if (nextLine == null || this.maxLines != 0 && this.linesReaded > this.maxLines) {
            this.hasNext = false;
        }
        return this.hasNext ? nextLine : null;
    }

    private String[] parseLine(String nextLine) throws IOException {
        if (nextLine == null) {
            return null;
        }
        ArrayList<String> tokensOnThisLine = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        boolean inQuotes = false;
        do {
            if (inQuotes) {
                if (!this.allowMultilines) break;
                sb.append("\n");
                nextLine = this.getNextLine();
                if (nextLine == null) break;
            }
            for (int i = 0; i < nextLine.length(); ++i) {
                char c = nextLine.charAt(i);
                if (c == this.quotechar) {
                    if (inQuotes && nextLine.length() > i + 1 && nextLine.charAt(i + 1) == this.quotechar) {
                        sb.append(nextLine.charAt(i + 1));
                        ++i;
                        continue;
                    }
                    inQuotes = !inQuotes;
                    sb.append(c);
                    continue;
                }
                if (c == this.separator && !inQuotes) {
                    tokensOnThisLine.add(this.cleanExpression(sb));
                    sb = new StringBuffer();
                    continue;
                }
                sb.append(c);
            }
        } while (inQuotes);
        tokensOnThisLine.add(this.cleanExpression(sb));
        if (nextLine == null) {
            throw new IllegalStateException("Unexpected state: Maybe a quote has not been closed.");
        }
        return nextLine.length() > 0 ? tokensOnThisLine.toArray(new String[0]) : new String[]{};
    }

    private String cleanExpression(StringBuffer sb) {
        int first;
        int last = sb.length() - 1;
        for (first = 0; first < sb.length() && sb.charAt(first) == ' '; ++first) {
        }
        while (last >= 0 && sb.charAt(last) == ' ') {
            --last;
        }
        if (sb.length() > 0 && first < last && sb.charAt(first) == this.quotechar && sb.charAt(last) == this.quotechar) {
            return sb.substring(first + 1, last);
        }
        return sb.toString();
    }

    @Override
    public boolean reset() throws IOException {
        if (this.file != null) {
            this.br.close();
            this.reader.close();
            this.reader = new FileReader(this.file);
            this.br = new BufferedReader(this.reader);
            this.hasNext = true;
            this.linesSkiped = false;
            this.linesReaded = 0;
            return true;
        }
        return false;
    }

    @Override
    public void close() throws IOException {
        this.br.close();
        this.reader.close();
        this.file = null;
    }
}

