/*
 * Decompiled with CFR 0.152.
 */
package edu.upc.dama.dex.script;

import edu.upc.dama.dex.core.DEX;
import edu.upc.dama.dex.core.DbGraph;
import edu.upc.dama.dex.core.GraphPool;
import edu.upc.dama.dex.core.Session;
import edu.upc.dama.dex.io.CSVReader;
import edu.upc.dama.dex.io.EdgeTypeLoader;
import edu.upc.dama.dex.io.Loader;
import edu.upc.dama.dex.io.NodeTypeLoader;
import edu.upc.dama.dex.script.DefaultScriptLoaderListener;
import edu.upc.dama.dex.script.ParseException;
import edu.upc.dama.dex.script.ScriptParserConstants;
import edu.upc.dama.dex.script.ScriptParserTokenManager;
import edu.upc.dama.dex.script.SimpleCharStream;
import edu.upc.dama.dex.script.Token;
import edu.upc.dama.dex.utils.IOLib;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;

public class ScriptParser
implements ScriptParserConstants {
    private DbGraph dbgraph = null;
    private Reader reader = null;
    private DEX dex;
    private Session sess;
    private GraphPool gp;
    private String dateFormat;
    public ScriptParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[0];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private final JJCalls[] jj_2_rtns = new JJCalls[57];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public ScriptParser(DEX dex, Reader reader) {
        this(reader);
        this.reader = reader;
        this.dex = dex;
    }

    public void close() {
        this.dbgraph = null;
        this.reader = null;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Wrong number of arguments: only one argument is needed, a DEX scripting file (*.des)");
            return;
        }
        DEX dex = new DEX();
        try {
            ScriptParser ps = new ScriptParser(dex, new FileReader(args[0]));
            ps.parse(true);
        }
        catch (Exception ex) {
            System.out.println("** ERROR: " + ex.getMessage());
        }
        dex.close();
    }

    public void parse(boolean execution) throws Exception {
        if (this.reader != null) {
            try {
                this.Script(execution);
            }
            catch (Exception ex) {
                throw ex;
            }
            finally {
                if (this.gp != null) {
                    this.sess.close();
                    this.gp.close();
                }
            }
        }
    }

    private String extractString(Token tk) {
        String str = tk.image;
        str = str.substring(1, str.length() - 1);
        str = str.replace("\\'", "'");
        return str;
    }

    public final void Script(boolean execution) throws ParseException, Exception {
        this.reader = this.reader;
        this.gp = null;
        this.sess = null;
        boolean create = false;
        this.dateFormat = "yyyy-MM-dd hh:mm:ss";
        while (this.jj_2_1(2)) {
            if (this.jj_2_7(2)) {
                if (this.jj_2_2(2)) {
                    this.jj_consume_token(23);
                    create = false;
                } else if (this.jj_2_3(2)) {
                    this.jj_consume_token(24);
                    create = true;
                } else {
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                this.jj_consume_token(11);
                String alias = this.Identifier();
                this.jj_consume_token(39);
                String path = this.Identifier();
                if (!execution) continue;
                if (this.gp != null) {
                    this.gp.close();
                }
                File img = new File(path);
                this.gp = create ? this.dex.create(img, alias) : this.dex.open(img);
                this.sess = this.gp.newSession();
                this.dbgraph = this.sess.getDbGraph();
                System.out.println((create ? "Created " : "Opened ") + "graph database '" + this.gp.getAlias() + "' into '" + path + "'");
                continue;
            }
            if (this.jj_2_8(2)) {
                Element e;
                if (this.jj_2_4(2)) {
                    e = this.CreateNode(execution);
                } else if (this.jj_2_5(2)) {
                    e = this.CreateEdge(execution);
                } else if (this.jj_2_6(2)) {
                    e = this.CreateVirtual(execution);
                } else {
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                if (!execution) continue;
                e.create();
                continue;
            }
            if (this.jj_2_9(2)) {
                this.Drop(execution);
                continue;
            }
            if (this.jj_2_10(2)) {
                this.Load(execution);
                continue;
            }
            if (this.jj_2_11(2)) {
                this.Index(execution);
                continue;
            }
            if (this.jj_2_12(2)) {
                this.jj_consume_token(53);
                this.jj_consume_token(33);
                this.jj_consume_token(54);
                this.dateFormat = this.Identifier();
                System.out.println("Timestamp format set to '" + this.dateFormat + "'");
                continue;
            }
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void Drop(boolean execution) throws ParseException {
        this.jj_consume_token(25);
        if (this.jj_2_15(2)) {
            if (this.jj_2_13(2)) {
                this.jj_consume_token(12);
            } else if (this.jj_2_14(2)) {
                this.jj_consume_token(17);
            } else {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            String type = this.Identifier();
            if (!execution) return;
            int t = 0;
            t = this.dbgraph.findType(type);
            if (t == 0) throw new ParseException("Unexisting type '" + type + "'");
            this.dbgraph.removeType(t);
            System.out.println("Dropped type '" + type + "'");
            return;
        } else if (this.jj_2_16(2)) {
            this.jj_consume_token(26);
            String type = this.Identifier();
            this.jj_consume_token(66);
            String attr = this.Identifier();
            if (!execution) return;
            int t = 0;
            t = this.dbgraph.findType(type);
            if (t == 0) throw new ParseException("Unexisting type '" + type + "'");
            long a = 0L;
            a = this.dbgraph.findAttribute(t, attr);
            if (a == 0L) throw new ParseException("Unexisting attribute '" + type + "'.'" + attr + "'");
            this.dbgraph.removeAttribute(a);
            System.out.println("Dropped attribute '" + type + "'.'" + attr + "'");
            return;
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void Index(boolean execution) throws ParseException {
        this.jj_consume_token(27);
        String type = this.Identifier();
        this.jj_consume_token(66);
        String attr = this.Identifier();
        Short kind = this.AttributeKind();
        if (!execution) return;
        int t = 0;
        t = this.dbgraph.findType(type);
        if (t == 0) throw new ParseException("Unexisting type '" + type + "'");
        long a = 0L;
        a = this.dbgraph.findAttribute(t, attr);
        if (a == 0L) throw new ParseException("Unexisting attribute '" + type + "'.'" + attr + "'");
        System.out.println("Indexing attribute '" + type + "'.'" + attr + "'...");
        this.dbgraph.indexAttribute(a, kind);
        System.out.print("New index kind for attribute '" + type + "'.'" + attr + "' is ");
        if (kind == 1) {
            System.out.println("UNIQUE.");
            return;
        } else if (kind == 2) {
            System.out.println("INDEXED.");
            return;
        } else {
            System.out.println("BASIC.");
        }
    }

    public final void Load(boolean execution) throws ParseException, IOException {
        boolean rows;
        String auxAlias;
        String column;
        boolean node;
        ArrayList<String> attributes = new ArrayList<String>();
        ArrayList<String> alias = new ArrayList<String>();
        ArrayList<Boolean> valids = new ArrayList<Boolean>();
        int typeId = 0;
        int headPosition = -1;
        int tailPosition = -1;
        long headAttr = 0L;
        long tailAttr = 0L;
        char separator = ',';
        char quote = '\"';
        boolean allowMultilines = false;
        int from = 0;
        int max = 0;
        int partitions = 1;
        boolean split = false;
        this.jj_consume_token(35);
        if (execution && this.dbgraph == null) {
            throw new ParseException("To be able loading objects, a dbgraph is needed");
        }
        if (this.jj_2_17(2)) {
            this.jj_consume_token(36);
            node = true;
        } else if (this.jj_2_18(2)) {
            this.jj_consume_token(37);
            node = false;
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        String filePath = this.Identifier();
        this.jj_consume_token(38);
        if (this.jj_2_20(2)) {
            this.jj_consume_token(10);
            if (execution) {
                attributes.add("");
                alias.add("");
                valids.add(Boolean.FALSE);
            }
        } else if (this.jj_2_21(2)) {
            column = this.Identifier();
            auxAlias = null;
            if (this.jj_2_19(2)) {
                auxAlias = this.Identifier();
            }
            if (execution) {
                if (auxAlias == null) {
                    auxAlias = column;
                }
                attributes.add(column);
                alias.add(auxAlias);
                valids.add(Boolean.TRUE);
            }
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        while (this.jj_2_22(2)) {
            this.jj_consume_token(9);
            if (this.jj_2_24(2)) {
                this.jj_consume_token(10);
                if (!execution) continue;
                attributes.add("");
                alias.add("");
                valids.add(Boolean.FALSE);
                continue;
            }
            if (this.jj_2_25(2)) {
                column = this.Identifier();
                auxAlias = null;
                if (this.jj_2_23(2)) {
                    auxAlias = this.Identifier();
                }
                if (!execution) continue;
                if (auxAlias == null) {
                    auxAlias = column;
                }
                attributes.add(column);
                alias.add(auxAlias);
                valids.add(Boolean.TRUE);
                continue;
            }
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(39);
        String type = this.Identifier();
        if (execution) {
            typeId = this.dbgraph.findType(type);
            if (typeId == 0) {
                throw new ParseException("Unexisting type " + type);
            }
            if (node && this.dbgraph.isTypeEdge(typeId)) {
                throw new ParseException(type + " must be a node type");
            }
        }
        if (this.jj_2_27(2)) {
            int position;
            this.jj_consume_token(40);
            column = this.Identifier();
            if (execution) {
                position = alias.indexOf(column);
                if (position == -1) {
                    position = attributes.indexOf(column);
                }
                if (position == -1) {
                    throw new ParseException("Wrong column identifier " + column);
                }
                valids.set(position, Boolean.FALSE);
            }
            while (this.jj_2_26(2)) {
                this.jj_consume_token(9);
                column = this.Identifier();
                if (!execution) continue;
                position = alias.indexOf(column);
                if (position == -1) {
                    position = attributes.indexOf(column);
                }
                if (position == -1) {
                    throw new ParseException("Wrong column identifier " + column);
                }
                valids.set(position, Boolean.FALSE);
            }
        }
        if (execution) {
            for (int i = 0; i < valids.size(); ++i) {
                if (!((Boolean)valids.get(i)).booleanValue() || this.dbgraph.findAttribute(typeId, (String)attributes.get(i)) != 0L) continue;
                throw new ParseException("Wrong attribute name " + type + "." + (String)attributes.get(i));
            }
        }
        if (this.jj_2_28(2)) {
            this.jj_consume_token(41);
            this.jj_consume_token(44);
            column = this.Identifier();
            if (execution) {
                tailPosition = alias.indexOf(column);
                if (tailPosition == -1) {
                    tailPosition = attributes.indexOf(column);
                }
                if (tailPosition == -1) {
                    throw new ParseException("Wrong column idetifier " + column);
                }
            }
            this.jj_consume_token(67);
            column = this.Identifier();
            this.jj_consume_token(66);
            auxAlias = this.Identifier();
            if (execution) {
                tailAttr = this.dbgraph.findAttribute(this.dbgraph.findType(column), auxAlias);
            }
            this.jj_consume_token(45);
            column = this.Identifier();
            if (execution) {
                headPosition = alias.indexOf(column);
                if (headPosition == -1) {
                    headPosition = attributes.indexOf(column);
                }
                if (headPosition == -1) {
                    throw new ParseException("Wrong column idetifier " + column);
                }
            }
            this.jj_consume_token(67);
            column = this.Identifier();
            this.jj_consume_token(66);
            auxAlias = this.Identifier();
            if (execution) {
                headAttr = this.dbgraph.findAttribute(this.dbgraph.findType(column), auxAlias);
            }
        }
        if (execution && !node && tailPosition == -1) {
            throw new ParseException("Loading edges needs 'WHERE TAIL <column> HEAD <column>' identifiers");
        }
        if (this.jj_2_32(2)) {
            this.jj_consume_token(49);
            if (this.jj_2_29(2)) {
                this.jj_consume_token(50);
                separator = this.Char();
            }
            if (this.jj_2_30(2)) {
                this.jj_consume_token(51);
                quote = this.Char();
            }
            if (this.jj_2_31(2)) {
                this.jj_consume_token(52);
                allowMultilines = true;
            }
        }
        if (this.jj_2_33(2)) {
            this.jj_consume_token(19);
            column = this.Number();
            from = Integer.parseInt(column);
        }
        if (this.jj_2_34(2)) {
            this.jj_consume_token(46);
            column = this.Number();
            max = Integer.parseInt(column);
        }
        this.jj_consume_token(42);
        if (this.jj_2_37(2)) {
            this.jj_consume_token(47);
            rows = true;
        } else if (this.jj_2_38(2)) {
            this.jj_consume_token(38);
            rows = false;
            if (this.jj_2_36(2)) {
                this.jj_consume_token(48);
                split = true;
                if (this.jj_2_35(2)) {
                    this.jj_consume_token(43);
                    column = this.Number();
                    partitions = Integer.parseInt(column);
                }
            }
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        if (execution) {
            InputStreamReader areader;
            if (IOLib.isGZipFile(filePath)) {
                InputStream isreader = IOLib.streamFromString(filePath);
                areader = new InputStreamReader(isreader);
            } else {
                areader = new FileReader(filePath);
            }
            CSVReader csvreader = new CSVReader(areader, separator, quote, allowMultilines, from, max);
            System.out.println("Loading " + type + " ...");
            Loader loader = node ? new NodeTypeLoader(csvreader, this.dbgraph, typeId) : new EdgeTypeLoader(csvreader, this.dbgraph, typeId, tailAttr, tailPosition, headAttr, headPosition);
            for (int i = 0; i < valids.size(); ++i) {
                if (!((Boolean)valids.get(i)).booleanValue()) continue;
                loader.setAttribute(this.dbgraph.findAttribute(typeId, (String)attributes.get(i)), i);
            }
            loader.setFrequency(100000);
            loader.setLogFile(new File(type + "-errors.log"));
            DefaultScriptLoaderListener ll = new DefaultScriptLoaderListener();
            loader.registerLoaderListener(ll);
            loader.setDateFormat(this.dateFormat);
            this.sess.beginTx();
            if (rows) {
                loader.run(Loader.Mode.ONE_PHASE, 1);
            } else if (split) {
                loader.run(Loader.Mode.N_PHASES, partitions);
            } else {
                loader.run(Loader.Mode.TWO_PHASES, 1);
            }
            this.sess.commitTx();
            System.out.println("Loaded " + type);
        }
    }

    public final void Attributes(Attributes attrs) throws ParseException {
        if (this.jj_2_41(2)) {
            this.jj_consume_token(57);
            if (this.jj_2_40(2)) {
                this.Attribute(attrs);
                while (this.jj_2_39(2)) {
                    this.jj_consume_token(9);
                    this.Attribute(attrs);
                }
            }
            this.jj_consume_token(58);
        }
    }

    public final Short AttributeKind() throws ParseException {
        Short kind = 0;
        if (this.jj_2_45(2)) {
            if (this.jj_2_42(2)) {
                this.jj_consume_token(14);
                kind = 2;
            } else if (this.jj_2_43(2)) {
                this.jj_consume_token(15);
                kind = 1;
            } else if (this.jj_2_44(2)) {
                this.jj_consume_token(16);
                kind = 0;
            } else {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return kind;
    }

    public final void Attribute(Attributes attrs) throws ParseException {
        Type type;
        Short kind = 0;
        String name = this.Identifier();
        if (this.jj_2_46(2)) {
            this.jj_consume_token(28);
            type = Type.INT;
        } else if (this.jj_2_47(2)) {
            this.jj_consume_token(31);
            type = Type.STRING;
        } else if (this.jj_2_48(2)) {
            this.jj_consume_token(29);
            type = Type.LONG;
        } else if (this.jj_2_49(2)) {
            this.jj_consume_token(30);
            type = Type.DOUBLE;
        } else if (this.jj_2_50(2)) {
            this.jj_consume_token(32);
            type = Type.BOOL;
        } else if (this.jj_2_51(2)) {
            this.jj_consume_token(33);
            type = Type.TIMESTAMP;
        } else if (this.jj_2_52(2)) {
            this.jj_consume_token(34);
            type = Type.TEXT;
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        kind = this.AttributeKind();
        if (type == Type.TEXT && kind != 0) {
            throw new ParseException("\"" + name + "\" TEXT attribute cannot be indexed or unique");
        }
        attrs.add(name, type, kind);
    }

    public final Element CreateNode(boolean execution) throws ParseException {
        this.jj_consume_token(24);
        this.jj_consume_token(12);
        String s = this.Identifier();
        NodeElement node = new NodeElement(s, execution);
        this.Attributes(node.attrs);
        return node;
    }

    public final Element CreateEdge(boolean execution) throws ParseException {
        this.jj_consume_token(24);
        boolean directed = true;
        boolean neighbors = false;
        String name = null;
        String from = null;
        String to = null;
        Attributes attrs = new Attributes();
        if (this.jj_2_53(2)) {
            this.jj_consume_token(13);
            directed = false;
        }
        this.jj_consume_token(17);
        name = this.Identifier();
        if (this.jj_2_54(2)) {
            this.jj_consume_token(19);
            from = this.Identifier();
            this.jj_consume_token(20);
            to = this.Identifier();
        }
        this.Attributes(attrs);
        if (this.jj_2_55(2)) {
            this.jj_consume_token(55);
            this.jj_consume_token(56);
            neighbors = true;
        }
        if (from == null && to == null) {
            EdgeElement e = new EdgeElement(name, directed, neighbors, execution);
            e.attrs = attrs;
            return e;
        }
        RestrictedElement e = new RestrictedElement(name, directed, neighbors, from, to, execution);
        e.attrs = attrs;
        return e;
    }

    public final Element CreateVirtual(boolean execution) throws ParseException {
        this.jj_consume_token(24);
        this.jj_consume_token(21);
        this.jj_consume_token(17);
        String s = this.Identifier();
        this.jj_consume_token(19);
        String f = this.Identifier();
        this.jj_consume_token(66);
        String af = this.Identifier();
        this.jj_consume_token(20);
        String t = this.Identifier();
        this.jj_consume_token(66);
        String at = this.Identifier();
        return new VirtualElement(s, f, af, t, at, execution);
    }

    public final String Number() throws ParseException {
        Token t = this.jj_consume_token(60);
        return t.image;
    }

    public final char Char() throws ParseException {
        Token t = this.jj_consume_token(64);
        String tt = this.extractString(t);
        if (tt.length() > 1) {
            if (tt.compareTo("\\t") == 0) {
                return '\t';
            }
        } else {
            return tt.charAt(0);
        }
        throw new Error("Missing return statement in function");
    }

    public final String Identifier() throws ParseException {
        if (this.jj_2_56(2)) {
            Token t = this.jj_consume_token(59);
            return t.image;
        }
        if (this.jj_2_57(2)) {
            Token t = this.jj_consume_token(64);
            return this.extractString(t);
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_11();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(10, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_12(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_12();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(11, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_13(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_13();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(12, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_14(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_14();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(13, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_15(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_15();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(14, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_16(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_16();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(15, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_17(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_17();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(16, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_18(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_18();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(17, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_19(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_19();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(18, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_20(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_20();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(19, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_21(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_21();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(20, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_22(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_22();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(21, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_23(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_23();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(22, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_24(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_24();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(23, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_25(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_25();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(24, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_26(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_26();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(25, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_27(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_27();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(26, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_28(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_28();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(27, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_29(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_29();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(28, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_30(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_30();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(29, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_31(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_31();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(30, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_32(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_32();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(31, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_33(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_33();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(32, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_34(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_34();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(33, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_35(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_35();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(34, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_36(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_36();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(35, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_37(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_37();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(36, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_38(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_38();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(37, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_39(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_39();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(38, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_40(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_40();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(39, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_41(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_41();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(40, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_42(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_42();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(41, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_43(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_43();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(42, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_44(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_44();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(43, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_45(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_45();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(44, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_46(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_46();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(45, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_47(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_47();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(46, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_48(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_48();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(47, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_49(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_49();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(48, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_50(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_50();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(49, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_51(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_51();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(50, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_52(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_52();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(51, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_53(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_53();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(52, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_54(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_54();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(53, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_55(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_55();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(54, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_56(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_56();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(55, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_57(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_57();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(56, xla);
        }
    }

    private final boolean jj_3_17() {
        return this.jj_scan_token(36);
    }

    private final boolean jj_3_14() {
        return this.jj_scan_token(17);
    }

    private final boolean jj_3_28() {
        if (this.jj_scan_token(41)) {
            return true;
        }
        return this.jj_scan_token(44);
    }

    private final boolean jj_3_5() {
        return this.jj_3R_6();
    }

    private final boolean jj_3R_12() {
        return this.jj_scan_token(64);
    }

    private final boolean jj_3R_9() {
        if (this.jj_scan_token(35)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_17()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_18()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_13() {
        return this.jj_scan_token(12);
    }

    private final boolean jj_3_15() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_13()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_14()) {
                return true;
            }
        }
        return this.jj_3R_11();
    }

    private final boolean jj_3R_8() {
        if (this.jj_scan_token(25)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_15()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_16()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_38() {
        if (this.jj_scan_token(38)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_36()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private final boolean jj_3_52() {
        return this.jj_scan_token(34);
    }

    private final boolean jj_3R_13() {
        return this.jj_scan_token(60);
    }

    private final boolean jj_3_51() {
        return this.jj_scan_token(33);
    }

    private final boolean jj_3_3() {
        return this.jj_scan_token(24);
    }

    private final boolean jj_3_50() {
        return this.jj_scan_token(32);
    }

    private final boolean jj_3_23() {
        return this.jj_3R_11();
    }

    private final boolean jj_3_12() {
        if (this.jj_scan_token(53)) {
            return true;
        }
        return this.jj_scan_token(33);
    }

    private final boolean jj_3_49() {
        return this.jj_scan_token(30);
    }

    private final boolean jj_3_11() {
        return this.jj_3R_10();
    }

    private final boolean jj_3_10() {
        return this.jj_3R_9();
    }

    private final boolean jj_3_9() {
        return this.jj_3R_8();
    }

    private final boolean jj_3_26() {
        if (this.jj_scan_token(9)) {
            return true;
        }
        return this.jj_3R_11();
    }

    private final boolean jj_3_48() {
        return this.jj_scan_token(29);
    }

    private final boolean jj_3R_7() {
        if (this.jj_scan_token(24)) {
            return true;
        }
        return this.jj_scan_token(21);
    }

    private final boolean jj_3_4() {
        return this.jj_3R_5();
    }

    private final boolean jj_3_8() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_4()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_5()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_6()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3_47() {
        return this.jj_scan_token(31);
    }

    private final boolean jj_3_37() {
        return this.jj_scan_token(47);
    }

    private final boolean jj_3_46() {
        return this.jj_scan_token(28);
    }

    private final boolean jj_3_19() {
        return this.jj_3R_11();
    }

    private final boolean jj_3_27() {
        if (this.jj_scan_token(40)) {
            return true;
        }
        return this.jj_3R_11();
    }

    private final boolean jj_3R_14() {
        if (this.jj_3R_11()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_46()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_47()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_48()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_49()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3_50()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3_51()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3_52()) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3_2() {
        return this.jj_scan_token(23);
    }

    private final boolean jj_3_34() {
        if (this.jj_scan_token(46)) {
            return true;
        }
        return this.jj_3R_13();
    }

    private final boolean jj_3_31() {
        return this.jj_scan_token(52);
    }

    private final boolean jj_3_30() {
        if (this.jj_scan_token(51)) {
            return true;
        }
        return this.jj_3R_12();
    }

    private final boolean jj_3_33() {
        if (this.jj_scan_token(19)) {
            return true;
        }
        return this.jj_3R_13();
    }

    private final boolean jj_3_1() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_7()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_8()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_9()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_10()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3_11()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3_12()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3_7() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_2()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_3()) {
                return true;
            }
        }
        return this.jj_scan_token(11);
    }

    private final boolean jj_3_29() {
        if (this.jj_scan_token(50)) {
            return true;
        }
        return this.jj_3R_12();
    }

    private final boolean jj_3_32() {
        if (this.jj_scan_token(49)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_29()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_30()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_31()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private final boolean jj_3_55() {
        if (this.jj_scan_token(55)) {
            return true;
        }
        return this.jj_scan_token(56);
    }

    private final boolean jj_3_54() {
        if (this.jj_scan_token(19)) {
            return true;
        }
        return this.jj_3R_11();
    }

    private final boolean jj_3_39() {
        if (this.jj_scan_token(9)) {
            return true;
        }
        return this.jj_3R_14();
    }

    private final boolean jj_3_35() {
        if (this.jj_scan_token(43)) {
            return true;
        }
        return this.jj_3R_13();
    }

    private final boolean jj_3_53() {
        return this.jj_scan_token(13);
    }

    private final boolean jj_3_44() {
        return this.jj_scan_token(16);
    }

    private final boolean jj_3R_10() {
        if (this.jj_scan_token(27)) {
            return true;
        }
        return this.jj_3R_11();
    }

    private final boolean jj_3_43() {
        return this.jj_scan_token(15);
    }

    private final boolean jj_3_25() {
        if (this.jj_3R_11()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_23()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private final boolean jj_3_24() {
        return this.jj_scan_token(10);
    }

    private final boolean jj_3R_6() {
        if (this.jj_scan_token(24)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_53()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(17);
    }

    private final boolean jj_3_45() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_42()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_43()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_44()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3_42() {
        return this.jj_scan_token(14);
    }

    private final boolean jj_3_18() {
        return this.jj_scan_token(37);
    }

    private final boolean jj_3_40() {
        return this.jj_3R_14();
    }

    private final boolean jj_3_6() {
        return this.jj_3R_7();
    }

    private final boolean jj_3_22() {
        if (this.jj_scan_token(9)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_24()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_25()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_57() {
        return this.jj_scan_token(64);
    }

    private final boolean jj_3_36() {
        if (this.jj_scan_token(48)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_35()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private final boolean jj_3_41() {
        if (this.jj_scan_token(57)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_40()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(58);
    }

    private final boolean jj_3R_11() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_56()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_57()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_56() {
        return this.jj_scan_token(59);
    }

    private final boolean jj_3_21() {
        if (this.jj_3R_11()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_19()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private final boolean jj_3R_5() {
        if (this.jj_scan_token(24)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3_16() {
        if (this.jj_scan_token(26)) {
            return true;
        }
        return this.jj_3R_11();
    }

    private final boolean jj_3_20() {
        return this.jj_scan_token(10);
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[0];
    }

    private static void jj_la1_1() {
        jj_la1_1 = new int[0];
    }

    private static void jj_la1_2() {
        jj_la1_2 = new int[0];
    }

    public ScriptParser(InputStream stream) {
        this(stream, null);
    }

    public ScriptParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new ScriptParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public ScriptParser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new ScriptParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public ScriptParser(ScriptParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(ScriptParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            boolean exists = false;
            Enumeration e = this.jj_expentries.elements();
            while (e.hasMoreElements()) {
                int[] oldentry = (int[])e.nextElement();
                if (oldentry.length != this.jj_expentry.length) continue;
                exists = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    exists = false;
                    break;
                }
                if (!exists) continue;
                break;
            }
            if (!exists) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[68];
        for (i = 0; i < 68; ++i) {
            la1tokens[i] = false;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 0; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) == 0) continue;
                la1tokens[64 + j] = true;
            }
        }
        for (i = 0; i < 68; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 57; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                            break;
                        }
                        case 8: {
                            this.jj_3_9();
                            break;
                        }
                        case 9: {
                            this.jj_3_10();
                            break;
                        }
                        case 10: {
                            this.jj_3_11();
                            break;
                        }
                        case 11: {
                            this.jj_3_12();
                            break;
                        }
                        case 12: {
                            this.jj_3_13();
                            break;
                        }
                        case 13: {
                            this.jj_3_14();
                            break;
                        }
                        case 14: {
                            this.jj_3_15();
                            break;
                        }
                        case 15: {
                            this.jj_3_16();
                            break;
                        }
                        case 16: {
                            this.jj_3_17();
                            break;
                        }
                        case 17: {
                            this.jj_3_18();
                            break;
                        }
                        case 18: {
                            this.jj_3_19();
                            break;
                        }
                        case 19: {
                            this.jj_3_20();
                            break;
                        }
                        case 20: {
                            this.jj_3_21();
                            break;
                        }
                        case 21: {
                            this.jj_3_22();
                            break;
                        }
                        case 22: {
                            this.jj_3_23();
                            break;
                        }
                        case 23: {
                            this.jj_3_24();
                            break;
                        }
                        case 24: {
                            this.jj_3_25();
                            break;
                        }
                        case 25: {
                            this.jj_3_26();
                            break;
                        }
                        case 26: {
                            this.jj_3_27();
                            break;
                        }
                        case 27: {
                            this.jj_3_28();
                            break;
                        }
                        case 28: {
                            this.jj_3_29();
                            break;
                        }
                        case 29: {
                            this.jj_3_30();
                            break;
                        }
                        case 30: {
                            this.jj_3_31();
                            break;
                        }
                        case 31: {
                            this.jj_3_32();
                            break;
                        }
                        case 32: {
                            this.jj_3_33();
                            break;
                        }
                        case 33: {
                            this.jj_3_34();
                            break;
                        }
                        case 34: {
                            this.jj_3_35();
                            break;
                        }
                        case 35: {
                            this.jj_3_36();
                            break;
                        }
                        case 36: {
                            this.jj_3_37();
                            break;
                        }
                        case 37: {
                            this.jj_3_38();
                            break;
                        }
                        case 38: {
                            this.jj_3_39();
                            break;
                        }
                        case 39: {
                            this.jj_3_40();
                            break;
                        }
                        case 40: {
                            this.jj_3_41();
                            break;
                        }
                        case 41: {
                            this.jj_3_42();
                            break;
                        }
                        case 42: {
                            this.jj_3_43();
                            break;
                        }
                        case 43: {
                            this.jj_3_44();
                            break;
                        }
                        case 44: {
                            this.jj_3_45();
                            break;
                        }
                        case 45: {
                            this.jj_3_46();
                            break;
                        }
                        case 46: {
                            this.jj_3_47();
                            break;
                        }
                        case 47: {
                            this.jj_3_48();
                            break;
                        }
                        case 48: {
                            this.jj_3_49();
                            break;
                        }
                        case 49: {
                            this.jj_3_50();
                            break;
                        }
                        case 50: {
                            this.jj_3_51();
                            break;
                        }
                        case 51: {
                            this.jj_3_52();
                            break;
                        }
                        case 52: {
                            this.jj_3_53();
                            break;
                        }
                        case 53: {
                            this.jj_3_54();
                            break;
                        }
                        case 54: {
                            this.jj_3_55();
                            break;
                        }
                        case 55: {
                            this.jj_3_56();
                            break;
                        }
                        case 56: {
                            this.jj_3_57();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        ScriptParser.jj_la1_0();
        ScriptParser.jj_la1_1();
        ScriptParser.jj_la1_2();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }

    class RestrictedElement
    extends Element {
        String from;
        String to;
        boolean directed;
        boolean neighbors;
        Attributes attrs;

        RestrictedElement(String name, boolean directed, boolean neighbors, String from, String to, boolean execution) throws ParseException {
            super(name, execution);
            this.from = from;
            this.to = to;
            this.directed = directed;
            this.neighbors = neighbors;
            this.attrs = new Attributes();
            if (!execution) {
                return;
            }
            if (ScriptParser.this.dbgraph.findType(name) != 0) {
                throw new ParseException("Two types have the same name \"" + name + "\"");
            }
            if (!directed) {
                throw new ParseException("Restricted edge \"" + name + "\" cannot be undirected");
            }
            if (ScriptParser.this.dbgraph.findNodeType(from) == 0) {
                throw new ParseException("Node type \"" + from + "\" does not exist");
            }
            if (ScriptParser.this.dbgraph.findNodeType(to) == 0) {
                throw new ParseException("Node type \"" + to + "\" does not exist");
            }
        }

        void create() {
            int eT = ScriptParser.this.dbgraph.newRestrictedEdgeType(this.name, ScriptParser.this.dbgraph.findType(this.from), ScriptParser.this.dbgraph.findType(this.to), this.neighbors);
            for (int a = 0; a < this.attrs.size(); ++a) {
                ScriptParser.this.dbgraph.newAttribute(eT, this.attrs.getName(a), this.attrs.getType(a).getValue(), this.attrs.getKind(a));
            }
            System.out.println("Created restricted edge type '" + this.name + "' from '" + this.from + "' to '" + this.to + "'" + (this.neighbors ? " (materialize neighbors)" : ""));
        }
    }

    class VirtualElement
    extends Element {
        String from;
        String attrFrom;
        String to;
        String attrTo;

        VirtualElement(String name, String from, String attrFrom, String to, String attrTo, boolean execution) throws ParseException {
            long attr;
            super(name, execution);
            this.from = from;
            this.attrFrom = attrFrom;
            this.to = to;
            this.attrTo = attrTo;
            if (!execution) {
                return;
            }
            if (ScriptParser.this.dbgraph.findType(name) != 0) {
                throw new ParseException("Two types have the same name \"" + name + "\"");
            }
            if (ScriptParser.this.dbgraph.findType(from) != 0) {
                attr = ScriptParser.this.dbgraph.findAttribute(ScriptParser.this.dbgraph.findType(from), attrFrom);
                if (attr == 0L) {
                    throw new ParseException("Type \"" + from + "\" does not have the attribute \"" + attrFrom + "\"");
                }
            } else {
                throw new ParseException("Type \"" + from + "\" cannot be found");
            }
            short dtypeFrom = ScriptParser.this.dbgraph.getAttributeData(attr).getDatatype();
            if (ScriptParser.this.dbgraph.findType(to) != 0) {
                attr = ScriptParser.this.dbgraph.findAttribute(ScriptParser.this.dbgraph.findType(to), attrTo);
                if (attr == 0L) {
                    throw new ParseException("Type \"" + to + "\" does not have the attribute \"" + attrTo + "\"");
                }
            } else {
                throw new ParseException("Type \"" + to + "\" cannot be found");
            }
            short dtypeTo = ScriptParser.this.dbgraph.getAttributeData(attr).getDatatype();
            if (dtypeFrom != dtypeTo) {
                throw new ParseException("\"" + from + "\".\"" + attrFrom + "\" and \"" + to + "\".\"" + attrTo + "\" belong to different datatype");
            }
        }

        void create() {
            ScriptParser.this.dbgraph.newVirtualEdgeType(this.name, ScriptParser.this.dbgraph.findAttribute(ScriptParser.this.dbgraph.findType(this.from), this.attrFrom), ScriptParser.this.dbgraph.findAttribute(ScriptParser.this.dbgraph.findType(this.to), this.attrTo));
            System.out.println("Created virtual edge type '" + this.name + "'");
        }
    }

    class EdgeElement
    extends Element {
        Attributes attrs;
        boolean directed;
        boolean neighbors;

        EdgeElement(String name, boolean directed, boolean neighbors, boolean execution) throws ParseException {
            super(name, execution);
            this.attrs = new Attributes();
            this.directed = directed;
            this.neighbors = neighbors;
            if (execution && ScriptParser.this.dbgraph.findType(name) != 0) {
                throw new ParseException("Two types have the same name \"" + name + "\"");
            }
        }

        void create() {
            int eT = ScriptParser.this.dbgraph.newEdgeType(this.name, this.directed, this.neighbors);
            for (int a = 0; a < this.attrs.size(); ++a) {
                ScriptParser.this.dbgraph.newAttribute(eT, this.attrs.getName(a), this.attrs.getType(a).getValue(), this.attrs.getKind(a));
            }
            System.out.println("Created " + (this.directed ? "directed " : "") + "edge type '" + this.name + "'" + (this.neighbors ? " (materialize neighbors)" : ""));
        }
    }

    public class NodeElement
    extends Element {
        Attributes attrs;

        NodeElement(String name, boolean execution) throws ParseException {
            super(name, execution);
            this.attrs = new Attributes();
            if (execution && ScriptParser.this.dbgraph.findType(name) != 0) {
                throw new ParseException("Two types have the same name \"" + name + "\"");
            }
        }

        void create() {
            int nT = ScriptParser.this.dbgraph.newNodeType(this.name);
            for (int a = 0; a < this.attrs.size(); ++a) {
                ScriptParser.this.dbgraph.newAttribute(nT, this.attrs.getName(a), this.attrs.getType(a).getValue(), this.attrs.getKind(a));
            }
            System.out.println("Created node type '" + this.name + "'");
        }
    }

    public class Attributes {
        ArrayList<String> names = new ArrayList();
        ArrayList<Type> types = new ArrayList();
        ArrayList<Short> kinds = new ArrayList();

        Attributes() {
        }

        void add(String name, Type type, Short k) {
            this.names.add(name);
            this.types.add(type);
            this.kinds.add(k);
        }

        int size() {
            return this.names.size();
        }

        String getName(int attr) {
            return this.names.get(attr);
        }

        Type getType(int attr) {
            return this.types.get(attr);
        }

        Short getKind(int attr) {
            return this.kinds.get(attr);
        }

        int nameIndex(String name) {
            return this.names.indexOf(name);
        }
    }

    public abstract class Element {
        protected String name;
        protected boolean execution;

        Element(String name, boolean execution) {
            this.name = name;
            this.execution = execution;
        }

        abstract void create();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        NULL(0),
        INT(1),
        STRING(2),
        DOUBLE(3),
        BOOL(4),
        TIMESTAMP(5),
        LONG(6),
        TEXT(7);

        private short value;

        private Type(short value) {
            this.value = value;
        }

        short getValue() {
            return this.value;
        }
    }
}

