/*
 * Decompiled with CFR 0.152.
 */
package edu.upc.dama.dex.tasks;

import edu.upc.dama.dex.tasks.Scheduler;
import edu.upc.dama.dex.tasks.Task;
import edu.upc.dama.dex.tasks.TaskListener;
import java.util.concurrent.atomic.AtomicBoolean;

class ListenerTask
extends Task {
    private final Task subtask;
    private final TaskListener listener;
    private final AtomicBoolean finished = new AtomicBoolean(false);

    ListenerTask(Task subtask, TaskListener listener) {
        this.subtask = subtask;
        this.listener = listener;
        Scheduler.register(subtask, this);
    }

    void add(Task childTask) {
        throw new IllegalStateException("There is no collection task");
    }

    protected boolean execute() throws Throwable {
        if (!this.finished.get()) {
            this.registerChild(this.subtask);
            Scheduler.enqueueTask(this.subtask);
        }
        return false;
    }

    public void cancel() {
        if (!this.finished.getAndSet(true)) {
            Scheduler.unregister(this);
            super.cancel();
            this.listener.onCancel();
        }
    }

    boolean finish() {
        if (super.finish()) {
            if (!this.finished.getAndSet(true)) {
                Scheduler.unregister(this);
                if (!this.hasException()) {
                    this.listener.onSucess();
                } else {
                    this.listener.onFailure(this.getException());
                }
            }
            return true;
        }
        return false;
    }
}

