/*
 * Decompiled with CFR 0.152.
 */
package edu.upc.dama.dex.utils;

import edu.upc.dama.dex.core.DEX;
import edu.upc.dama.dex.core.Graph;
import edu.upc.dama.dex.core.GraphPool;
import edu.upc.dama.dex.core.Objects;
import edu.upc.dama.dex.core.RGraph;
import edu.upc.dama.dex.core.Session;
import edu.upc.dama.dex.core.Value;
import edu.upc.dama.dex.io.CSVWriter;
import edu.upc.dama.dex.io.NodeTypeExporter;
import edu.upc.dama.dex.utils.CmdLineArgs;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Statistics {
    private Graph graph;
    private String path = new File(".").getAbsolutePath();
    private static final String OPT_HELP = "Help";
    private static final String OPT_IMAGE = "DEX graph-db image";
    private static final String OPT_PATH = "Results path";
    private static final String OPT_STATS = "Statistics";
    private static final String OPT_STATS_FLAGS = "D";
    private static final String OPT_STATS_FLAGS_DEFAULT = "D";

    public Statistics(Graph g) {
        this.graph = g;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void getDegreeStatistics() throws IOException {
        this.getDegreeStatistics(this.graph.nodeTypes(), this.graph.edgeTypes());
    }

    public void getDegreeStatistics(Set<Integer> nodeTypes, Set<Integer> edgeTypes) throws IOException {
        for (int nodeType : nodeTypes) {
            Objects o = this.graph.select(nodeType);
            for (int edgeType : edgeTypes) {
                Graph.TypeData edgeTypeData = this.graph.getTypeData(edgeType);
                if (edgeTypeData.isVirtual()) {
                    long[] attrsVirtualEdge = edgeTypeData.getVirtual();
                    if (nodeType == this.graph.getAttributeData(attrsVirtualEdge[0]).getType()) {
                        this.writeDegreeStats(o, edgeType, (short)2);
                        continue;
                    }
                    if (nodeType != this.graph.getAttributeData(attrsVirtualEdge[1]).getType()) continue;
                    this.writeDegreeStats(o, edgeType, (short)1);
                    continue;
                }
                if (edgeTypeData.isRestricted()) {
                    int[] typesRestricted = edgeTypeData.getRestricted();
                    if (nodeType == typesRestricted[0] && nodeType != typesRestricted[1]) {
                        this.writeDegreeStats(o, edgeType, (short)2);
                        continue;
                    }
                    if (nodeType != typesRestricted[0] && nodeType == typesRestricted[1]) {
                        this.writeDegreeStats(o, edgeType, (short)1);
                        continue;
                    }
                    if (typesRestricted[0] != typesRestricted[1] || nodeType != typesRestricted[0]) continue;
                    this.writeDegreeStats(o, edgeType, (short)3);
                    continue;
                }
                if (edgeTypeData.isUndirected()) {
                    this.writeDegreeStats(o, edgeType, (short)1);
                    continue;
                }
                this.writeDegreeStats(o, edgeType, (short)3);
            }
            o.close();
        }
    }

    private void writeDegreeStats(Objects nodes, int edgeType, short direction) throws IOException {
        if (nodes.size() == 0) {
            return;
        }
        RGraph rgraph = this.graph.getSession().newGraph();
        String nodeTypeName = this.graph.getTypeData(this.graph.getType(nodes.first())).getName();
        String edgeTypeName = this.graph.getTypeData(edgeType).getName();
        int aux = rgraph.newNodeType("degrees");
        long degree = rgraph.newAttribute(aux, "DEGREE", (short)6);
        long freq = rgraph.newAttribute(aux, direction != 1 ? "FREQUENCY_OUT" : "FREQUENCY_IN", (short)6, (short)0);
        Value v = new Value();
        FileWriter fw = new FileWriter(new File(this.path, nodeTypeName + "_" + edgeTypeName + (direction != 1 ? "_OUT.csv" : "_IN.csv")));
        CSVWriter csw = new CSVWriter(fw, ';');
        if (direction == 3) {
            int auxIn = rgraph.newNodeType("degrees_in");
            long degreeIn = rgraph.newAttribute(auxIn, "DEGREE_IN", (short)6);
            long freqIn = rgraph.newAttribute(auxIn, "FREQUENCY_IN", (short)6, (short)0);
            FileWriter fwIn = new FileWriter(new File(this.path, nodeTypeName + "_" + edgeTypeName + "_IN.csv"));
            CSVWriter cswIn = new CSVWriter(fwIn, ';');
            Objects.Iterator it = nodes.iterator();
            while (it.hasNext()) {
                long l = it.next();
                v.setLong(this.graph.degree(l, edgeType, (short)2));
                long node = rgraph.findObj(degree, v);
                if (node == 0L) {
                    node = rgraph.newNode(aux);
                    rgraph.setAttribute(node, degree, v);
                    v.setLong(1L);
                    rgraph.setAttribute(node, freq, v);
                } else {
                    v = rgraph.getAttribute(node, freq);
                    v.setLong(v.getLong() + 1L);
                    rgraph.setAttribute(node, freq, v);
                }
                v.setLong(this.graph.degree(l, edgeType, (short)1));
                node = rgraph.findObj(degreeIn, v);
                if (node == 0L) {
                    node = rgraph.newNode(auxIn);
                    rgraph.setAttribute(node, degreeIn, v);
                    v.setLong(1L);
                    rgraph.setAttribute(node, freqIn, v);
                    continue;
                }
                v = rgraph.getAttribute(node, freqIn);
                v.setLong(v.getLong() + 1L);
                rgraph.setAttribute(node, freqIn, v);
            }
            NodeTypeExporter export = new NodeTypeExporter(csw, rgraph, aux, new Long[]{degree, freq});
            export.setNamesOnTop(true);
            export.run();
            NodeTypeExporter exportIn = new NodeTypeExporter(cswIn, rgraph, auxIn, new Long[]{degreeIn, freqIn});
            exportIn.setNamesOnTop(true);
            exportIn.run();
        } else {
            Objects.Iterator it = nodes.iterator();
            while (it.hasNext()) {
                long l = it.next();
                v.setLong(this.graph.degree(l, edgeType, direction));
                long node = rgraph.findObj(degree, v);
                if (node == 0L) {
                    node = rgraph.newNode(aux);
                    rgraph.setAttribute(node, degree, v);
                    v.setLong(1L);
                    rgraph.setAttribute(node, freq, v);
                    continue;
                }
                v = rgraph.getAttribute(node, freq);
                v.setLong(v.getLong() + 1L);
                rgraph.setAttribute(node, freq, v);
            }
            NodeTypeExporter export = new NodeTypeExporter(csw, rgraph, aux);
            export.setNamesOnTop(true);
            export.run();
        }
        rgraph.close();
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        CmdLineArgs opt = new CmdLineArgs();
        opt.registerOption(OPT_HELP, 'h', false, ": print usage and exit", false);
        opt.registerString(OPT_IMAGE, 'i', true, ": image name", null);
        opt.registerString(OPT_PATH, 'p', false, ": results path", ".");
        opt.registerFlags(OPT_STATS, 's', "D", true, ": statistics\n\t\t(D) Degree", "D");
        try {
            opt.parse(args);
        }
        catch (Exception e) {
            System.out.println("ERROR in arguments: " + e.getMessage());
            System.out.println("USAGE: " + opt.usage());
            return;
        }
        File image = new File(opt.getOptionString(OPT_IMAGE));
        File path = new File(opt.getOptionString(OPT_PATH));
        DEX dex = new DEX();
        GraphPool gpool = dex.open(image);
        Session sess = gpool.newSession();
        Statistics stats = new Statistics(sess.getDbGraph());
        System.out.println("DEX graph database image: " + image.getAbsolutePath());
        if (opt.getOptionFlag(OPT_STATS, 'D')) {
            File degreepath = new File(path, "degree");
            if (!degreepath.mkdirs()) {
                throw new IOException("Error creating directory " + degreepath.getAbsolutePath());
            }
            System.out.println("Dump degree statistics into " + degreepath.getAbsolutePath());
            stats.setPath(degreepath.getAbsolutePath());
            stats.getDegreeStatistics();
        }
        sess.close();
        gpool.close();
        dex.close();
    }
}

