/*
 * Decompiled with CFR 0.152.
 */
package edu.upc.dama.dex.core;

import edu.upc.dama.dex.core.TextStream;
import java.util.Calendar;

public class Value {
    public static final int STRING_MAX_LENGTH = 2048;
    private short type;
    private Object object;
    public static final short NULL = 0;
    public static final short INT = 1;
    public static final short STRING = 2;
    public static final short DOUBLE = 3;
    public static final short BOOL = 4;
    public static final short TIMESTAMP = 5;
    public static final short LONG = 6;
    public static final short TEXT = 7;

    static boolean isValidDatatype(short datatype) {
        return datatype >= 0 && datatype <= 7;
    }

    public Value() {
        this.setNull();
    }

    public Value(int v) {
        this.setInt(v);
    }

    public Value(long v) {
        this.setLong(v);
    }

    public Value(String v) {
        this.setString(v);
    }

    public Value(boolean v) {
        this.setBool(v);
    }

    public Value(double v) {
        this.setDouble(v);
    }

    public Value(Calendar v) {
        this.setTimestamp(v);
    }

    public Value(TextStream v) {
        this.setTextStream(v);
    }

    public Value(Object object) {
        if (object == null) {
            this.type = 0;
        } else if (object instanceof Integer) {
            this.type = 1;
        } else if (object instanceof String) {
            if (((String)object).length() >= 2048) {
                throw new IllegalArgumentException("illegal argument object: object string length cannot exceed 2048 characters");
            }
            this.type = (short)2;
        } else if (object instanceof Double) {
            this.type = (short)3;
        } else if (object instanceof Boolean) {
            this.type = (short)4;
        } else if (object instanceof Calendar) {
            this.type = (short)5;
        } else if (object instanceof Long) {
            this.type = (short)6;
        } else if (object instanceof TextStream) {
            this.type = (short)7;
        } else {
            throw new IllegalArgumentException("Illegal argument object: datatype not supported for " + object.getClass().getName());
        }
        this.object = object;
    }

    public Object get() {
        return this.object;
    }

    public String toString() {
        if (this.type == 5) {
            return ((Calendar)this.object).getTime().toString();
        }
        if (this.type != 0) {
            return this.object.toString();
        }
        return new String("null");
    }

    public short getType() {
        return this.type;
    }

    public Value setNull() {
        this.object = null;
        this.type = 0;
        return this;
    }

    public boolean isNull() {
        return this.type == 0;
    }

    public Value setInt(int value) {
        this.object = new Integer(value);
        this.type = 1;
        return this;
    }

    public int getInt() {
        this.checkType((short)1);
        return (Integer)this.object;
    }

    public Value setString(String value) {
        if (value == null) {
            this.setNull();
        } else {
            if (value.length() >= 2048) {
                throw new IllegalArgumentException("illegal argument value: value length cannot exceed 2048 characters");
            }
            this.object = value;
            this.type = (short)2;
        }
        return this;
    }

    public String getString() {
        this.checkType((short)2);
        return (String)this.object;
    }

    public Value setDouble(double value) {
        this.object = new Double(value);
        this.type = (short)3;
        return this;
    }

    public double getDouble() {
        this.checkType((short)3);
        return (Double)this.object;
    }

    public Value setBool(boolean value) {
        this.object = new Boolean(value);
        this.type = (short)4;
        return this;
    }

    public boolean getBool() {
        this.checkType((short)4);
        return (Boolean)this.object;
    }

    public Value setTimestamp(Calendar value) {
        this.object = value;
        this.type = (short)5;
        return this;
    }

    public Calendar getTimestamp() {
        this.checkType((short)5);
        return (Calendar)this.object;
    }

    public long getTimestampValue() {
        Calendar c = this.getTimestamp();
        return c.getTimeInMillis();
    }

    public Value setLong(long value) {
        this.object = new Long(value);
        this.type = (short)6;
        return this;
    }

    public long getLong() {
        this.checkType((short)6);
        return (Long)this.object;
    }

    public Value setTextStream(TextStream tstrm) {
        this.object = tstrm;
        this.type = (short)7;
        return this;
    }

    public TextStream getTextStream() {
        this.checkType((short)7);
        return (TextStream)this.object;
    }

    public short compare(Value value) {
        if (this.type != value.type) {
            throw new RuntimeException("Value.compare/different types");
        }
        int cmp = 0;
        switch (this.type) {
            case 0: {
                break;
            }
            case 1: {
                int i1 = this.getInt();
                int i2 = value.getInt();
                if (i1 < i2) {
                    cmp = -1;
                    break;
                }
                if (i1 <= i2) break;
                cmp = 1;
                break;
            }
            case 2: {
                cmp = (short)this.getString().compareTo(value.getString());
                break;
            }
            case 3: {
                double d1 = this.getDouble();
                double d2 = value.getDouble();
                if (d1 < d2) {
                    cmp = -1;
                    break;
                }
                if (!(d1 > d2)) break;
                cmp = 1;
                break;
            }
            case 4: {
                boolean b1 = this.getBool();
                boolean b2 = value.getBool();
                if (b1 == b2) break;
                if (b1 && !b2) {
                    cmp = 1;
                }
                if (b1 || !b2) break;
                cmp = -1;
                break;
            }
            case 5: {
                long l1 = this.getTimestampValue();
                long l2 = value.getTimestampValue();
                if (l1 < l2) {
                    cmp = -1;
                    break;
                }
                if (l1 <= l2) break;
                cmp = 1;
                break;
            }
            case 6: {
                long l1 = this.getLong();
                long l2 = value.getLong();
                if (l1 < l2) {
                    cmp = -1;
                    break;
                }
                if (l1 <= l2) break;
                cmp = 1;
                break;
            }
            case 7: {
                throw new IllegalArgumentException("Illegal argument exception: this operation is not supported for the given " + this.type);
            }
            default: {
                throw new IllegalStateException("Illegal state exception: type " + this.type + " not valid.");
            }
        }
        return (short)cmp;
    }

    public static String getTypeName(short type) {
        String result = "";
        switch (type) {
            case 0: {
                result = "NULL";
                break;
            }
            case 1: {
                result = "INT";
                break;
            }
            case 2: {
                result = "STRING";
                break;
            }
            case 3: {
                result = "DOUBLE";
                break;
            }
            case 4: {
                result = "BOOL";
                break;
            }
            case 5: {
                result = "TIMESTAMP";
                break;
            }
            case 6: {
                result = "LONG";
                break;
            }
            case 7: {
                result = "TEXT";
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal argument type: type " + type + " not valid.");
            }
        }
        return result;
    }

    public static short getType(String typename) {
        if (typename.equalsIgnoreCase("NULL")) {
            return 0;
        }
        if (typename.equalsIgnoreCase("INT")) {
            return 1;
        }
        if (typename.equalsIgnoreCase("STRING")) {
            return 2;
        }
        if (typename.equalsIgnoreCase("DOUBLE")) {
            return 3;
        }
        if (typename.equalsIgnoreCase("BOOL")) {
            return 4;
        }
        if (typename.equalsIgnoreCase("TIMESTAMP")) {
            return 5;
        }
        if (typename.equalsIgnoreCase("LONG")) {
            return 6;
        }
        if (typename.equalsIgnoreCase("TEXT")) {
            return 7;
        }
        throw new IllegalArgumentException("Illegal argument type: + " + typename + " is not valid.");
    }

    public int hashCode() {
        int hash = 0;
        if (this.type != 0) {
            hash = this.object.hashCode();
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Value other = (Value)obj;
        if (this.type != other.type) {
            return false;
        }
        return this.object == other.object || this.object != null && this.object.equals(other.object);
    }

    private void checkType(short type) {
        if (this.type != type) {
            throw new ClassCastException("Illegal type:" + Value.getTypeName(type) + ", current type:" + Value.getTypeName(this.type));
        }
    }
}

