/*
 * Decompiled with CFR 0.152.
 */
package edu.upc.dama.dex.tasks;

import edu.upc.dama.dex.tasks.Scheduler;
import edu.upc.dama.dex.tasks.Task;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class WhileTask
extends Task {
    private static final int CHUNK = 100;
    private final AtomicBoolean executed = new AtomicBoolean(false);
    private boolean evaluateCondition = false;
    private boolean more = false;

    protected void before() throws Throwable {
    }

    protected abstract boolean whileCondition() throws Throwable;

    protected abstract void whileBody() throws Throwable;

    protected void after() throws Throwable {
    }

    protected void add(Task childTask) {
        if (!this.hasException()) {
            this.registerChild(childTask);
            Scheduler.enqueueTask(childTask);
        }
    }

    protected final boolean execute() throws Throwable {
        if (!this.more) {
            this.before();
        }
        if (this.evaluateCondition || this.whileCondition()) {
            this.whileBody();
            if (this.getDependenceCount() == 1) {
                this.evaluateCondition = this.whileCondition();
                if (this.evaluateCondition) {
                    int count = 100;
                    do {
                        this.whileBody();
                    } while (--count > 0 && this.getDependenceCount() == 1 && (this.evaluateCondition = this.whileCondition()));
                }
                this.more = this.evaluateCondition;
            } else {
                this.more = true;
                this.evaluateCondition = false;
            }
            this.executed.set(true);
        } else {
            this.more = false;
        }
        if (!this.more) {
            this.after();
        }
        return this.more && this.getDependenceCount() == 1;
    }

    boolean finish() {
        int dependenceCount = this.getDependenceCount();
        if (dependenceCount == 1 && this.executed.getAndSet(false) && this.more && !this.hasException()) {
            this.incrementDependenceCount();
            Scheduler.enqueueTask(this);
        }
        return super.finish();
    }

    public static void main(String[] p) throws Throwable {
        WhileTask task = new WhileTask(){
            int i = 0;

            protected boolean whileCondition() throws Throwable {
                return this.i < 10;
            }

            protected void whileBody() throws Throwable {
                final int k = this.i++;
                this.add(new Task(){

                    protected boolean execute() throws Throwable {
                        System.out.println("Iteration: " + k);
                        return false;
                    }
                });
            }
        };
        Scheduler.addAndWait(task);
    }
}

