/*
 * Decompiled with CFR 0.152.
 */
package edu.upc.dama.dex.core;

import edu.upc.dama.dex.core.Attribute;
import edu.upc.dama.dex.core.Export;
import edu.upc.dama.dex.core.GraphPool;
import edu.upc.dama.dex.core.Identifiers;
import edu.upc.dama.dex.core.Objects;
import edu.upc.dama.dex.core.Operation;
import edu.upc.dama.dex.core.Session;
import edu.upc.dama.dex.core.Value;
import edu.upc.dama.dex.core.Values;
import edu.upc.dama.dex.utils.StringLib;
import java.awt.Color;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Graph
implements Identifiers {
    private long handle = 0L;
    private Session sess = null;
    public static final short ATTR_KIND_BASIC = 0;
    public static final short ATTR_KIND_UNIQUE = 1;
    public static final short ATTR_KIND_INDEXED = 2;
    public static final short ORDER_ASCENDENT = 1;
    public static final short ORDER_DESCENDENT = 2;
    public static final short OPERATION_LT = 1;
    public static final short OPERATION_LE = 2;
    public static final short OPERATION_EQ = 3;
    public static final short OPERATION_GE = 4;
    public static final short OPERATION_GT = 5;
    public static final short OPERATION_NE = 6;
    public static final short OPERATION_BETWEEN = 9;
    public static final short OPERATION_LIKE = 7;
    public static final short OPERATION_ILIKE = 11;
    public static final short OPERATION_ERE = 12;
    public static final short EDGES_IN = 1;
    public static final short EDGES_OUT = 2;
    public static final short EDGES_BOTH = 3;
    protected long numNodes = 0L;
    protected long numEdges = 0L;

    private native long nodes_(Session var1);

    private native long edges_(Session var1);

    private native int newNodeType_(Session var1, String var2);

    private native int newEdgeType_(Session var1, String var2, boolean var3, boolean var4);

    private native int newRestrictedEdgeType_(Session var1, String var2, int var3, int var4, boolean var5);

    private native int findType_(Session var1, String var2);

    private native TypeData getTypeData_(Session var1, int var2);

    private native boolean removeType_(Session var1, int var2);

    private native int[] nodeTypes_(Session var1);

    private native int[] edgeTypes_(Session var1);

    private native long newNode_(Session var1, int var2);

    private native long newEdge_(Session var1, long var2, long var4, int var6);

    private native long newEdge_(Session var1, long var2, Value var4, long var5, Value var7, int var8);

    private native int getObjectType_(Session var1, long var2, boolean var4);

    private native boolean drop_(Session var1, long var2);

    private native long newAttribute_(Session var1, int var2, String var3, short var4, short var5);

    private native long newTransientAttribute_(Session var1, int var2, short var3, short var4);

    private native boolean indexAttribute_(Session var1, long var2, short var4);

    private static String getAttributeKindString(short k) {
        switch (k) {
            case 0: {
                return "BASIC";
            }
            case 2: {
                return "INDEXED";
            }
            case 1: {
                return "UNIQUE";
            }
        }
        return null;
    }

    private native AttributeData getAttributeData_(Session var1, long var2);

    private native AttributeStats getAttributeStats_(Session var1, long var2);

    private native long getAttributeIntervalCount_(Session var1, long var2, Value var4, boolean var5, Value var6, boolean var7);

    private native long findAttribute_(Session var1, int var2, String var3);

    private native long[] getAttributesFromType_(Session var1, int var2);

    private native boolean removeAttribute_(Session var1, long var2);

    private native boolean setAttribute_(Session var1, long var2, long var4, Value var6);

    private native boolean getAttribute_(Session var1, long var2, long var4, Value var6);

    private native Values getValues_(Session var1, long var2, short var4);

    private native long[] getAttributes_(Session var1, long var2);

    private native long[] getEdge_(Session var1, long var2);

    private native long findObj_(Session var1, long var2, Value var4);

    private native Objects findEdges_(Session var1, long var2, long var4, int var6, int var7);

    private native long findEdge_(Session var1, long var2, long var4, int var6);

    private native Objects select_(Session var1, int var2);

    private native Objects select_(Session var1, long var2, short var4, Value var5);

    private native Objects select_(Session var1, long var2, short var4, Value var5, Value var6);

    private native Objects explode_(Session var1, long var2, int var4, short var5);

    private native Objects explode2_(Session var1, Objects var2, int var3, short var4);

    private native Objects neighbors_(Session var1, long var2, int var4, short var5);

    private native Objects neighbors2_(Session var1, Objects var2, int var3, short var4);

    private native Objects tails_(Session var1, Objects var2);

    private native Objects heads_(Session var1, Objects var2);

    Graph(Session sess, long handle) {
        this.sess = sess;
        this.handle = handle;
        assert (handle != 0L);
        this.numNodes = this.nodes_(this.sess);
        this.numEdges = this.edges_(this.sess);
    }

    protected void close() {
        this.sess = null;
        this.handle = 0L;
    }

    public boolean isOpen() {
        return this.handle != 0L;
    }

    public Session getSession() {
        return this.sess;
    }

    public GraphPool getGraphPool() {
        return this.sess.getGraphPool();
    }

    public int newNodeType(String name) {
        return this.newNodeType_(this.sess, name);
    }

    public int newEdgeType(String name, boolean directed) {
        return this.newEdgeType_(this.sess, name, directed, false);
    }

    public int newEdgeType(String name, boolean directed, boolean neighbors) {
        return this.newEdgeType_(this.sess, name, directed, neighbors);
    }

    public int newEdgeType(String name) {
        return this.newEdgeType_(this.sess, name, true, false);
    }

    public int newUndirectedEdgeType(String name) {
        return this.newEdgeType_(this.sess, name, false, false);
    }

    public int newRestrictedEdgeType(String name, int typeTail, int typeHead) {
        return this.newRestrictedEdgeType_(this.sess, name, typeTail, typeHead, false);
    }

    public int newRestrictedEdgeType(String name, int typeTail, int typeHead, boolean neighbors) {
        return this.newRestrictedEdgeType_(this.sess, name, typeTail, typeHead, neighbors);
    }

    public int findType(String name) {
        return this.findType_(this.sess, name);
    }

    @Deprecated
    public int findNodeType(String name) {
        int type = this.findType_(this.sess, name);
        if (type != 0 && !this.getTypeData_(this.sess, type).isEdgeType) {
            return type;
        }
        return 0;
    }

    @Deprecated
    public int findEdgeType(String name) {
        int type = this.findType_(this.sess, name);
        if (type != 0 && this.getTypeData_(this.sess, type).isEdgeType) {
            return type;
        }
        return 0;
    }

    public TypeData getTypeData(int type) {
        return this.getTypeData_(this.sess, type);
    }

    @Deprecated
    public String getTypeName(int type) {
        return this.getTypeData_(this.sess, type).getName();
    }

    public boolean removeType(int type) {
        boolean rc = this.removeType_(this.sess, type);
        if (rc) {
            this.numNodes = this.nodes_(this.sess);
            this.numEdges = this.edges_(this.sess);
        }
        return rc;
    }

    public boolean isTypeEdge(int type) {
        TypeData tdata = this.getTypeData(type);
        return tdata.isEdgeType;
    }

    public boolean isTypeNode(int type) {
        TypeData tdata = this.getTypeData(type);
        return !tdata.isEdgeType;
    }

    @Deprecated
    public Iterator<Integer> getNodeTypes() {
        return this.nodeTypes().iterator();
    }

    public Set<Integer> nodeTypes() {
        int[] types = this.nodeTypes_(this.sess);
        HashSet<Integer> hs = new HashSet<Integer>(types.length);
        for (int i = 0; i < types.length; ++i) {
            hs.add(types[i]);
        }
        return hs;
    }

    @Deprecated
    public Iterator<Integer> getEdgeTypes() {
        return this.edgeTypes().iterator();
    }

    public Set<Integer> edgeTypes() {
        int[] types = this.edgeTypes_(this.sess);
        HashSet<Integer> hs = new HashSet<Integer>(types.length);
        for (int i = 0; i < types.length; ++i) {
            hs.add(types[i]);
        }
        return hs;
    }

    @Deprecated
    public boolean isEdgeTypeRestricted(int type) {
        return this.getTypeData_(this.sess, type).isRestricted();
    }

    @Deprecated
    public boolean isEdgeTypeDirected(int type) {
        return this.getTypeData_(this.sess, type).isDirected();
    }

    @Deprecated
    public boolean isEdgeTypeUndirected(int type) {
        return this.getTypeData_(this.sess, type).isUndirected();
    }

    public long newNode(int type) {
        long oid = this.newNode_(this.sess, type);
        if (oid != 0L) {
            ++this.numNodes;
        }
        return oid;
    }

    public long newEdge(long tail, long head, int type) {
        long oid = this.newEdge_(this.sess, tail, head, type);
        if (oid != 0L) {
            ++this.numEdges;
        }
        return oid;
    }

    public long newEdge(long attrTail, Value vTail, long attrHead, Value vHead, int type) {
        long oid = this.newEdge_(this.sess, attrTail, vTail, attrHead, vHead, type);
        if (oid != 0L) {
            ++this.numEdges;
        }
        return oid;
    }

    public int getObjectType(long oid) {
        return this.getObjectType_(this.sess, oid, true);
    }

    public int getType(long oid) {
        return this.getObjectType_(this.sess, oid, true);
    }

    public long nodes() {
        return this.numNodes;
    }

    public long edges() {
        return this.numEdges;
    }

    public boolean drop(long oid) {
        boolean rc = this.drop_(this.sess, oid);
        if (rc) {
            this.numNodes = this.nodes_(this.sess);
            this.numEdges = this.edges_(this.sess);
        }
        return rc;
    }

    public long newAttribute(int type, String name, short datatype, short kind) {
        return this.newAttribute_(this.sess, type, name, datatype, kind);
    }

    public long newAttribute(int type, String name, short datatype) {
        return this.newAttribute_(this.sess, type, name, datatype, (short)2);
    }

    public long newTransientAttribute(int type, short datatype, short kind) {
        return this.newTransientAttribute_(this.sess, type, datatype, kind);
    }

    public long newTransientAttribute(int type, short datatype) {
        return this.newTransientAttribute_(this.sess, type, datatype, (short)2);
    }

    public AttributeData getAttributeData(long attribute) {
        return this.getAttributeData_(this.sess, attribute);
    }

    public AttributeStats getAttributeStats(long attribute) {
        return this.getAttributeStats_(this.sess, attribute);
    }

    public long getAttributeIntervalCount(long attribute, Value low, boolean includeLow, Value high, boolean includeHigh) {
        return this.getAttributeIntervalCount_(this.sess, attribute, low, includeLow, high, includeHigh);
    }

    @Deprecated
    public String getAttributeName(long attribute) {
        return this.getAttributeData_(this.sess, attribute).getName();
    }

    @Deprecated
    public long getAttributeSize(long attribute) {
        return this.getAttributeData_(this.sess, attribute).getSize();
    }

    @Deprecated
    public long getAttributeCount(long attribute) {
        return this.getAttributeData_(this.sess, attribute).getCount();
    }

    @Deprecated
    public short getAttributeType(long attribute) {
        return this.getAttributeData_(this.sess, attribute).getDatatype();
    }

    public long findAttribute(int type, String name) {
        return this.findAttribute_(this.sess, type, name);
    }

    public Set<Long> getAttributesFromType(int type) {
        long[] attrs = this.getAttributesFromType_(this.sess, type);
        HashSet<Long> hs = new HashSet<Long>(attrs.length);
        for (int i = 0; i < attrs.length; ++i) {
            hs.add(attrs[i]);
        }
        return hs;
    }

    public boolean removeAttribute(long attribute) {
        return this.removeAttribute_(this.sess, attribute);
    }

    public boolean indexAttribute(long attribute, short kind) {
        return this.indexAttribute_(this.sess, attribute, kind);
    }

    public boolean setAttribute(long oid, long attribute, Value v) {
        return this.setAttribute_(this.sess, oid, attribute, v);
    }

    public boolean setAttribute(long oid, String attribute, Value v) {
        int type = this.getObjectType_(this.sess, oid, true);
        long attr = this.findAttribute_(this.sess, type, attribute);
        return this.setAttribute_(this.sess, oid, attr, v);
    }

    public Value getAttribute(long oid, long attribute) {
        Value v = new Value();
        this.getAttribute_(this.sess, oid, attribute, v);
        return v;
    }

    public Value getAttribute(long oid, String attribute) {
        Value v = new Value();
        int type = this.getObjectType_(this.sess, oid, true);
        long attr = this.findAttribute_(this.sess, type, attribute);
        this.getAttribute_(this.sess, oid, attr, v);
        return v;
    }

    public boolean getAttribute(long oid, long attribute, Value v) {
        return this.getAttribute_(this.sess, oid, attribute, v);
    }

    public Values getValues(long attribute, short order) {
        return this.getValues_(this.sess, attribute, order);
    }

    public Set<Long> getAttributes(long oid) {
        long[] attrs = this.getAttributes_(this.sess, oid);
        HashSet<Long> hs = new HashSet<Long>(attrs.length);
        for (int i = 0; i < attrs.length; ++i) {
            hs.add(attrs[i]);
        }
        return hs;
    }

    @Deprecated
    public Attribute[] findAttributes(long oid) {
        long[] attrs = this.getAttributes_(this.sess, oid);
        Attribute[] attributes = new Attribute[attrs.length];
        for (int i = 0; i < attrs.length; ++i) {
            attributes[i] = new Attribute();
            attributes[i].name = this.getAttributeData_(this.sess, attrs[i]).getName();
            attributes[i].value = new Value();
            this.getAttribute_(this.sess, oid, attrs[i], attributes[i].value);
        }
        return attributes;
    }

    @Deprecated
    public Attribute[] findAttributes(int type) {
        long[] attrs = this.getAttributesFromType_(this.sess, type);
        Attribute[] attributes = new Attribute[attrs.length];
        for (int i = 0; i < attrs.length; ++i) {
            attributes[i] = new Attribute();
            attributes[i].value = new Value(attrs[i]);
            attributes[i].name = this.getAttributeData_(this.sess, attrs[i]).getName();
        }
        return attributes;
    }

    public long[] getEdge(long oid) {
        return this.getEdge_(this.sess, oid);
    }

    @Deprecated
    public long getTail(long oid) {
        return this.getEdge_(this.sess, oid)[0];
    }

    @Deprecated
    public long getHead(long oid) {
        return this.getEdge_(this.sess, oid)[1];
    }

    public long getEdgePeer(long edge, long node) {
        long[] edges = this.getEdge_(this.sess, edge);
        long peer = 0L;
        if (edges[0] == node) {
            peer = edges[1];
        } else if (edges[1] == node) {
            peer = edges[0];
        } else {
            throw new IllegalArgumentException("Invalid object identifier");
        }
        return peer;
    }

    public long findObj(long attr, Value v) {
        return this.findObj_(this.sess, attr, v);
    }

    public Objects findEdges(long tail, long head, int type) {
        return this.findEdges_(this.sess, tail, head, type, Integer.MAX_VALUE);
    }

    public long findEdge(long tail, long head, int type) {
        return this.findEdge_(this.sess, tail, head, type);
    }

    @Deprecated
    public long[] findEdges(long tail, long head, int type, int max) {
        Objects objs = this.findEdges_(this.sess, tail, head, type, max);
        long[] oids = new long[objs.size()];
        Objects.Iterator it = objs.iterator();
        for (int i = 0; i < oids.length; ++i) {
            oids[i] = it.next();
        }
        it.close();
        objs.close();
        return oids;
    }

    @Deprecated
    public boolean existsNode(long oid) {
        int type = this.getObjectType_(this.sess, oid, false);
        if (type != 0) {
            TypeData tdata = this.getTypeData_(this.sess, type);
            return false == tdata.isEdgeType();
        }
        return false;
    }

    @Deprecated
    public boolean existsEdgeIn(long oid1, long oid2, int type) {
        long edge = this.findEdge(oid2, oid1, type);
        return edge != 0L;
    }

    @Deprecated
    public boolean existsEdgeOut(long oid1, long oid2, int type) {
        long edge = this.findEdge(oid1, oid2, type);
        return edge != 0L;
    }

    @Deprecated
    public boolean existsEdge(long oid1, long oid2, int type) {
        if (this.existsEdgeIn(oid1, oid2, type)) {
            return true;
        }
        return this.existsEdgeOut(oid1, oid2, type);
    }

    public Objects select(int type) {
        return this.select_(this.sess, type);
    }

    @Deprecated
    public Objects select(long attribute, Operation op, Value v) {
        return this.select_(this.sess, attribute, op.toShort(), v);
    }

    public Objects select(long attribute, short op, Value v) {
        return this.select_(this.sess, attribute, op, v);
    }

    public Objects select(long attribute, short op, Value v1, Value v2) {
        return this.select_(this.sess, attribute, op, v1, v2);
    }

    @Deprecated
    public Objects select(int type, String attribute, Operation op, Value v) {
        long attr = this.findAttribute_(this.sess, type, attribute);
        return this.select_(this.sess, attr, op.toShort(), v);
    }

    public Objects explode(long oid, int type, short direction) {
        return this.explode_(this.sess, oid, type, direction);
    }

    public Objects explode(long oid, String type, short direction) {
        int t = this.findType_(this.sess, type);
        return this.explode_(this.sess, oid, t, direction);
    }

    public Objects explode(Objects nodes, int type, short direction) {
        return this.explode2_(this.sess, nodes, type, direction);
    }

    public Objects explode(Objects nodes, String type, short direction) {
        int t = this.findType_(this.sess, type);
        return this.explode2_(this.sess, nodes, t, direction);
    }

    public Objects neighbors(long oid, int type, short direction) {
        return this.neighbors_(this.sess, oid, type, direction);
    }

    @Deprecated
    public Objects neighbors(long oid, String type, short direction) {
        int t = this.findType_(this.sess, type);
        return this.neighbors_(this.sess, oid, t, direction);
    }

    public Objects neighbors(Objects nodes, int type, short direction) {
        return this.neighbors2_(this.sess, nodes, type, direction);
    }

    @Deprecated
    public Objects neighbors(Objects nodes, String type, short direction) {
        int t = this.findType_(this.sess, type);
        return this.neighbors2_(this.sess, nodes, t, direction);
    }

    public long degree(long oid, int type, short direction) {
        long degree = 0L;
        TypeData tdata = this.getTypeData_(this.sess, type);
        Objects edges = this.explode_(this.sess, oid, type, direction);
        degree = edges.size();
        edges.close();
        return degree;
    }

    public Objects tails(Objects edges) {
        return this.tails_(this.sess, edges);
    }

    public Objects heads(Objects edges) {
        return this.heads_(this.sess, edges);
    }

    public void export(PrintWriter ps, Export.Type type, Export extra) {
        Export e = extra;
        if (e == null) {
            e = new DefaultExport();
        }
        e.prepare(this);
        this.exportProcess(ps, type, e);
        e.release();
    }

    private void exportNode(PrintWriter ps, Export.Type type, Export.NodeExport nExp, long node, int n) {
        String typename = this.getTypeName(this.getType(node));
        String label = null;
        Export.NodeExport.Shape shape = Export.NodeExport.Shape.BOX;
        int colorNode = 10863606;
        int colorLabel = Color.BLACK.getRGB();
        float height = 25.0f;
        int width = 25;
        int fontSize = 10;
        label = nExp.getLabel();
        shape = nExp.getShape();
        colorNode = nExp.getColor().getRGB();
        colorLabel = nExp.getColorLabel().getRGB();
        fontSize = nExp.getFontSize();
        if (nExp.isFit() && label != null) {
            int nbmayus = 0;
            for (int i = 0; i < label.length(); ++i) {
                if (!Character.isUpperCase(label.charAt(i))) continue;
                ++nbmayus;
            }
            height = 6.0f + (float)fontSize * 1.3f;
            width = label.length() * (fontSize / 2 + fontSize % 10) + nbmayus * (fontSize % 10 + 1);
        } else {
            height = nExp.getHeight();
            width = nExp.getWidth();
        }
        if (label == null) {
            label = typename + "\\n" + n;
        }
        switch (type) {
            case GRAPHVIZ: {
                ps.println("  N" + n + " [label=\"" + label + "\"]");
                break;
            }
            case GRAPHML: {
                ps.println("      <node id=\"" + n + "\"/>");
                break;
            }
            case YGRAPHML: {
                label = StringLib.escape(label);
                ps.println("      <node id=\"" + n + "\">");
                ps.println("        <data key=\"d0\" >");
                ps.println("          <y:ShapeNode>");
                ps.println("            <y:Geometry height=\"" + height + "\" width=\"" + width + "\"/>");
                String aux = Integer.toHexString(colorNode);
                ps.println("            <y:Fill color=\"#" + aux.substring(2, aux.length()) + "\"/>");
                ps.println("            <y:BorderStyle color=\"#" + aux.substring(2, aux.length()) + "\"/>");
                aux = Integer.toHexString(colorLabel);
                ps.println("            <y:NodeLabel fontSize=\"" + fontSize + "\" textColor=\"#" + aux.substring(2, aux.length()) + "\">" + label + "</y:NodeLabel>");
                if (shape == Export.NodeExport.Shape.ROUND) {
                    ps.println("            <y:Shape type=\"ellipse\"/>");
                } else if (shape == Export.NodeExport.Shape.BOX) {
                    ps.println("            <y:Shape type=\"rectangle\"/>");
                }
                ps.println("          </y:ShapeNode>");
                ps.println("        </data>");
                ps.println("      </node>");
            }
        }
    }

    private void exportEdge(PrintWriter ps, Export.Type type, Export.EdgeExport eExp, long tail, long head) {
        int colorEdge = Color.LIGHT_GRAY.getRGB();
        int colorEdgeLabel = Color.BLACK.getRGB();
        int fontSize = 10;
        short width = 1;
        Export.EdgeExport.Direction direction = Export.EdgeExport.Direction.DIRECTED;
        String label = null;
        label = eExp.getLabel();
        colorEdge = eExp.getColor().getRGB();
        colorEdgeLabel = eExp.getColorLabel().getRGB();
        fontSize = eExp.getFontSize();
        direction = eExp.getDirection();
        width = eExp.getWidth();
        switch (type) {
            case GRAPHVIZ: {
                ps.print("  N" + tail + " -> N" + head);
                if (label != null) {
                    ps.print(" [label=\"" + label + "\"]");
                }
                ps.println();
                break;
            }
            case GRAPHML: {
                ps.println("      <edge source=\"" + tail + "\" target=\"" + head + "\"/>");
                break;
            }
            case YGRAPHML: {
                ps.println("      <edge source=\"" + tail + "\" target=\"" + head + "\">");
                ps.println("        <data key=\"d1\" >");
                ps.println("          <y:PolyLineEdge>");
                String aux = Integer.toHexString(colorEdge);
                ps.println("            <y:LineStyle color=\"#" + aux.substring(2, aux.length()) + "\" width=\"" + width + "\"/>");
                if (direction == Export.EdgeExport.Direction.DIRECTED) {
                    ps.println("            <y:Arrows source=\"none\" target=\"standard\"/>");
                } else {
                    ps.println("            <y:Arrows source=\"none\" target=\"none\"/>");
                }
                if (label != null) {
                    aux = Integer.toHexString(colorEdgeLabel);
                    ps.println("            <y:EdgeLabel fontSize=\"" + fontSize + "\" textColor=\"#" + aux.substring(2, aux.length()) + "\">" + label + "</y:EdgeLabel>");
                }
                ps.println("          </y:PolyLineEdge>");
                ps.println("        </data>");
                ps.println("      </edge>");
            }
        }
    }

    private void exportProcess(PrintWriter ps, Export.Type type, Export extra) {
        String typename;
        assert (extra != null);
        String gname = extra.getGraph().getLabel();
        if (gname == null) {
            gname = "G";
        }
        switch (type) {
            case GRAPHVIZ: {
                ps.println("digraph G {\n  overlap=scale");
                ps.println("  graph [label=\"<" + gname + ">\"]");
                break;
            }
            case GRAPHML: {
                ps.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
                ps.println("<graphml xmlns=\"http://graphml.graphdrawing.org/xmlns\"");
                ps.println("  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
                ps.println("  xsi:schemaLocation=\"http://graphml.graphdrawing.org/xmlns ");
                ps.println("  http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd\">");
                ps.println("  <graph id=\"" + gname + "\" edgedefault=\"undirected\">");
                break;
            }
            case YGRAPHML: {
                ps.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
                ps.println("<graphml xmlns=\"http://graphml.graphdrawing.org/xmlns/graphml\" ");
                ps.println("  xmlns:y=\"http://www.yworks.com/xml/graphml\" ");
                ps.println("  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" ");
                ps.println("  xsi:schemaLocation=\"http://graphml.graphdrawing.org/xmlns/graphml ");
                ps.println("  http://www.yworks.com/xml/schema/graphml/1.0/ygraphml.xsd\">");
                ps.println("  <key id=\"d0\" for=\"node\" yfiles.type=\"nodegraphics\"/>");
                ps.println("  <key id=\"d1\" for=\"edge\" yfiles.type=\"edgegraphics\"/>");
                ps.println("  <graph id=\"" + gname + "\" edgedefault=\"undirected\">");
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        HashMap<Long, Integer> mapNodes = new HashMap<Long, Integer>();
        Iterator<Integer> it = this.getNodeTypes();
        while (it.hasNext()) {
            int ntype = it.next();
            typename = this.getTypeName(ntype);
            if (!extra.enableType(ntype)) continue;
            Export.NodeExport nExp = extra.getNodeType(ntype);
            Objects nodes = this.select(ntype);
            Objects.Iterator nit = nodes.iterator();
            while (nit.hasNext()) {
                long node = nit.next();
                int n = mapNodes.size();
                mapNodes.put(node, n);
                Export.NodeExport nExpN = extra.getNode(node);
                if (nExpN == null) {
                    nExpN = nExp;
                }
                this.exportNode(ps, type, nExpN, node, n);
            }
            nodes.close();
        }
        it = this.getEdgeTypes();
        while (it.hasNext()) {
            int etype = it.next();
            typename = this.getTypeName(etype);
            if (!extra.enableType(etype)) continue;
            TypeData tdata = this.getTypeData(etype);
            Export.EdgeExport eEdge = extra.getEdgeType(etype);
            Objects edges = this.select(etype);
            Objects.Iterator nit = edges.iterator();
            while (nit.hasNext()) {
                long e = nit.next();
                long[] edge = this.getEdge(e);
                if (!mapNodes.containsKey(edge[0]) || !mapNodes.containsKey(edge[1])) continue;
                int tail = (Integer)mapNodes.get(edge[0]);
                int head = (Integer)mapNodes.get(edge[1]);
                Export.EdgeExport eEdgeN = extra.getEdge(e);
                if (eEdgeN == null) {
                    eEdgeN = eEdge;
                }
                this.exportEdge(ps, type, eEdgeN, tail, head);
            }
            nit.close();
            edges.close();
        }
        switch (type) {
            case GRAPHVIZ: {
                ps.println("}");
                break;
            }
            case GRAPHML: {
                ps.println("  </graph>");
                ps.println("</graphml>");
                break;
            }
            case YGRAPHML: {
                ps.println("  </graph>");
                ps.println("</graphml>");
            }
        }
        ps.flush();
    }

    private final class DefaultExport
    implements Export {
        private Export.GraphExport gExp = new Export.GraphExport();
        private Export.NodeExport nExp = new Export.NodeExport();
        private Export.EdgeExport eExp = new Export.EdgeExport();
        private Graph graph = null;

        private DefaultExport() {
        }

        public void prepare(Graph graph) {
            this.graph = graph;
        }

        public void release() {
        }

        public Export.GraphExport getGraph() {
            this.gExp.setLabel(this.graph.getGraphPool().getAlias());
            return this.gExp;
        }

        public Export.NodeExport getNodeType(int type) {
            return this.nExp;
        }

        public Export.EdgeExport getEdgeType(int type) {
            return this.eExp;
        }

        public Export.NodeExport getNode(long node) {
            this.nExp.setLabel("" + node);
            return this.nExp;
        }

        public Export.EdgeExport getEdge(long edge) {
            this.eExp.setColor(Color.LIGHT_GRAY);
            this.eExp.setLabel("" + edge);
            int t = this.graph.getType(edge);
            if (this.graph.isEdgeTypeDirected(t)) {
                this.eExp.setDirection(Export.EdgeExport.Direction.DIRECTED);
            } else {
                this.eExp.setDirection(Export.EdgeExport.Direction.UNDIRECTED);
            }
            return this.eExp;
        }

        public boolean enableType(int type) {
            return true;
        }
    }

    public static class AttributeStats {
        public long total;
        public long nil;
        public long distinct;
        public Value min;
        public Value max;
        public Value mode;
        public long modeCount;
        public double mean;
        public double variance;
        public double median;

        public String toString() {
            return new String("total=" + this.total + " nil=" + this.nil + " distinct=" + this.distinct + " min=" + this.min + " max=" + this.max + " mode=" + this.mode + " modeCount=" + this.modeCount + " mean=" + this.mean + " variance=" + this.variance + " median=" + this.median);
        }
    }

    public static class AttributeData {
        private long id = 0L;
        private String name = null;
        private int type = 0;
        private long size = 0L;
        private long count = 0L;
        private short datatype = 0;
        private short kind = 0;
        private long parent = 0L;

        private AttributeData(long id) {
            assert (id != 0L);
            this.id = id;
        }

        public long getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public int getType() {
            return this.type;
        }

        public long getSize() {
            return this.size;
        }

        public long getCount() {
            return this.count;
        }

        public short getDatatype() {
            return this.datatype;
        }

        public short getKind() {
            return this.kind;
        }

        public long getParent() {
            return this.parent;
        }

        public String toString() {
            return "id=" + this.id + " (type=" + (this.type == 1 ? "GLOBAL" : Integer.valueOf(this.type)) + " name=" + this.name + ") " + Value.getTypeName(this.datatype) + "{" + Graph.getAttributeKindString(this.kind) + "}" + " [size=" + this.size + " count=" + this.count + "]";
        }
    }

    public static class TypeData {
        private int id = 0;
        private String name = null;
        private long objects = 0L;
        private boolean isEdgeType = false;
        private boolean isDirected = false;
        private boolean isRestricted = false;
        private boolean hasNeighbors = false;
        private int rfrom = 0;
        private int rto = 0;

        private TypeData(int id) {
            assert (id != 0);
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public boolean isNodeType() {
            return !this.isEdgeType;
        }

        public boolean isEdgeType() {
            return this.isEdgeType;
        }

        public boolean isDirected() {
            return this.isEdgeType && this.isDirected;
        }

        public boolean hasNeighbors() {
            return this.isEdgeType && this.hasNeighbors;
        }

        public boolean isUndirected() {
            return this.isEdgeType && !this.isDirected;
        }

        public boolean isRestricted() {
            return this.isEdgeType && this.isRestricted;
        }

        public int[] getRestricted() {
            assert (this.isRestricted());
            return new int[]{this.rfrom, this.rto};
        }

        public String toString() {
            String clazz = null;
            if (this.isNodeType()) {
                clazz = "N";
            } else {
                if (this.isRestricted()) {
                    clazz = "RE{" + this.rfrom + "->" + this.rto + "}";
                } else {
                    String string = clazz = this.isDirected() ? "DE" : "UE";
                }
                if (this.hasNeighbors()) {
                    clazz = clazz + "{NeighIndexed}";
                }
            }
            return "id=" + this.id + " (name=" + this.name + ") " + clazz;
        }
    }
}

