/*
 * Decompiled with CFR 0.152.
 */
package edu.upc.dama.dex.core;

import edu.upc.dama.dex.core.DEX;
import edu.upc.dama.dex.core.DbGraph;
import edu.upc.dama.dex.core.Graph;
import edu.upc.dama.dex.core.Session;
import edu.upc.dama.dex.core.Value;
import edu.upc.dama.dex.utils.StringLib;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Set;

public final class GraphPool
implements Closeable {
    private long handle = 0L;
    private DEX dex = null;
    private String alias = null;
    private File img = null;

    private native void release_();

    private native void warmUp_();

    private native String getAlias_();

    private native String getFileImage_();

    private native void dumpStorage_(Session var1, String var2) throws FileNotFoundException;

    private native void dumpData_(Session var1, String var2) throws FileNotFoundException;

    private native void flush_();

    private native Statistics getStatistics_();

    private native Session newSession_();

    GraphPool(DEX dex, long handle) {
        this.dex = dex;
        this.handle = handle;
        assert (handle != 0L);
    }

    public boolean isOpen() {
        return this.handle != 0L;
    }

    public void close() {
        if (this.isOpen()) {
            this.dex.unregister(this);
            this.release_();
            this.handle = 0L;
            this.dex = null;
        }
    }

    public DEX getDEX() {
        return this.dex;
    }

    public void warmUp() {
        this.warmUp_();
    }

    public Session newSession() {
        return this.newSession_();
    }

    public String getAlias() {
        if (this.alias == null) {
            this.alias = this.getAlias_();
        }
        return this.alias;
    }

    public File getFileImage() {
        if (this.img == null) {
            this.img = new File(this.getFileImage_());
        }
        return this.img;
    }

    public void dumpStorage(Session sess, File file) throws FileNotFoundException {
        this.dumpStorage_(sess, file.getPath());
    }

    public void dumpData(Session sess, File file) throws FileNotFoundException {
        this.dumpData_(sess, file.getPath());
    }

    public void dumpStorage(Session sess, String file) throws FileNotFoundException {
        this.dumpStorage_(sess, file);
    }

    public void dumpData(Session sess, String file) throws FileNotFoundException {
        this.dumpData_(sess, file);
    }

    public void dumpSchema(Session sess, Writer writer) throws IOException {
        DbGraph dbg = sess.getDbGraph();
        writer.write("CREATE DBGRAPH " + StringLib.quote(this.getAlias()) + " INTO '" + this.getFileImage().getPath() + "'\n");
        for (int type : dbg.nodeTypes()) {
            Graph.TypeData tdata = dbg.getTypeData(type);
            writer.write("CREATE NODE " + StringLib.quote(tdata.getName()));
            Set<Long> attrs = dbg.getAttributesFromType(type);
            Iterator<Long> itAttrs = attrs.iterator();
            if (itAttrs.hasNext()) {
                writer.write(" ( ");
                int j = 0;
                while (itAttrs.hasNext()) {
                    long attr = itAttrs.next();
                    Graph.AttributeData adata = dbg.getAttributeData(attr);
                    writer.write(StringLib.quote(adata.getName()) + " " + Value.getTypeName(adata.getDatatype()));
                    switch (adata.getKind()) {
                        case 1: {
                            writer.write(" UNIQUE");
                            break;
                        }
                        case 2: {
                            writer.write(" INDEXED");
                        }
                    }
                    writer.write(j < attrs.size() - 1 ? ", " : " ");
                    ++j;
                }
                writer.write(")");
            }
            writer.write("\n");
        }
        for (int type : dbg.edgeTypes()) {
            Set<Long> attrs;
            Iterator<Long> itAttrs;
            Graph.TypeData tdata = dbg.getTypeData(type);
            writer.write("CREATE ");
            if (tdata.isUndirected()) {
                writer.write("UNDIRECTED ");
            }
            writer.write("EDGE " + StringLib.quote(tdata.getName()));
            if (tdata.isRestricted()) {
                int[] types = tdata.getRestricted();
                writer.write(" FROM " + StringLib.quote(dbg.getTypeData(types[0]).getName()) + " TO " + StringLib.quote(dbg.getTypeData(types[1]).getName()));
            }
            if ((itAttrs = (attrs = dbg.getAttributesFromType(type)).iterator()).hasNext()) {
                writer.write(" ( ");
                int j = 0;
                while (itAttrs.hasNext()) {
                    long attr = itAttrs.next();
                    Graph.AttributeData adata = dbg.getAttributeData(attr);
                    writer.write(StringLib.quote(adata.getName()) + " " + Value.getTypeName(adata.getDatatype()));
                    switch (adata.getKind()) {
                        case 1: {
                            writer.write(" UNIQUE");
                            break;
                        }
                        case 2: {
                            writer.write(" INDEXED");
                        }
                    }
                    writer.write(j < attrs.size() - 1 ? ", " : " ");
                    ++j;
                }
                writer.write(")");
            }
            if (tdata.hasNeighbors()) {
                writer.write(" MATERIALIZE NEIGHBORS");
            }
            writer.write("\n");
        }
        writer.flush();
    }

    public void flush() {
        this.flush_();
    }

    public Statistics getStatistics() {
        return this.getStatistics_();
    }

    public class Statistics {
        public long in = 0L;
        public long out = 0L;
        public long data = 0L;
        public long cache = 0L;
        public long temp = 0L;
    }
}

