/*
 * Decompiled with CFR 0.152.
 */
package edu.upc.dama.dex.core;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

public class TextStream
implements Closeable {
    private long handle = 0L;
    private boolean write = false;

    private native long init_(boolean var1);

    private native void write_(char[] var1, int var2, int var3) throws IOException;

    private native int read_(char[] var1, int var2, int var3) throws IOException;

    private native void release_();

    private TextStream(long handle) {
        this.handle = handle;
        this.write = false;
    }

    public TextStream(boolean append) {
        this.handle = this.init_(append);
        this.write = true;
    }

    public TextStream() {
        this(false);
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.handle == 0L) {
            throw new IOException("Handle is null");
        }
        if (this.write) {
            throw new IllegalStateException("Only-write text stream");
        }
        return this.read_(cbuf, off, len);
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.handle == 0L) {
            throw new IOException("Handle is null");
        }
        if (!this.write) {
            throw new IllegalStateException("Only-read text stream");
        }
        this.write_(cbuf, off, len);
    }

    public void flush() throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void close() throws IOException {
        if (this.handle != 0L) {
            this.release_();
        }
        this.handle = 0L;
    }

    public static class TextWriter
    extends Writer {
        TextStream strm = null;

        public TextWriter(TextStream strm) {
            this.strm = strm;
            if (!this.strm.write) {
                throw new IllegalArgumentException("TextWriter cannot be created from a reader TextStream");
            }
        }

        public void write(char[] chars, int i, int i1) throws IOException {
            this.strm.write(chars, i, i1);
        }

        public void flush() throws IOException {
            this.strm.flush();
        }

        public void close() throws IOException {
            this.strm.close();
        }
    }

    public static class TextReader
    extends Reader {
        TextStream strm = null;

        public TextReader(TextStream strm) {
            this.strm = strm;
            if (this.strm.write) {
                throw new IllegalArgumentException("TextReader cannot be created from a writer TextStream");
            }
        }

        public boolean markSupported() {
            return false;
        }

        public int read(char[] chars, int i, int i1) throws IOException {
            int r = this.strm.read(chars, i, i1);
            return r == 0 ? -1 : r;
        }

        public void close() throws IOException {
            this.strm.close();
        }
    }
}

