/*
 * Decompiled with CFR 0.152.
 */
package edu.upc.dama.dex.tasks;

import edu.upc.dama.dex.tasks.Scheduler;
import edu.upc.dama.dex.tasks.Task;
import java.util.LinkedList;
import java.util.List;

public abstract class SerialTask
extends Task {
    private boolean stopped = false;
    private final List<Task> taskList = new LinkedList<Task>();
    private int insertionPosition = 0;

    protected void add(Task childTask) {
        if (!this.hasException() && !this.stopped) {
            this.registerChild(childTask);
            this.taskList.add(this.insertionPosition, childTask);
            ++this.insertionPosition;
        }
    }

    public void stop() {
        this.stopped = true;
    }

    boolean success() {
        boolean result = super.success();
        if (this.taskList.size() > 0 && !this.stopped) {
            if (result) {
                throw new IllegalStateException("unexpected completion");
            }
            Task next = this.taskList.remove(0);
            this.insertionPosition = 0;
            Scheduler.enqueueTask(next);
        } else if (!result && !this.stopped) {
            throw new IllegalStateException("unexpected uncompletion");
        }
        return result;
    }

    boolean fail(Throwable th) {
        int count = this.taskList.size();
        this.decrementDependenceCount(count);
        this.taskList.clear();
        return super.fail(th);
    }

    public static void main(String[] p) throws Throwable {
        SerialTask task = new SerialTask(){

            protected boolean execute() throws Throwable {
                this.add(new Task(){

                    protected boolean execute() throws Throwable {
                        System.out.println("Step 1");
                        return false;
                    }
                });
                this.add(new Task(){
                    int i = 2;

                    protected boolean execute() throws Throwable {
                        final int k = this.i++;
                        this.add(new Task(){

                            protected boolean execute() throws Throwable {
                                System.out.println("Step " + k);
                                return false;
                            }
                        });
                        return this.i < 15;
                    }
                });
                this.add(new Task(){

                    protected boolean execute() throws Throwable {
                        System.out.println("Step 15");
                        return false;
                    }
                });
                return false;
            }
        };
        Scheduler.addAndWait(task);
    }
}

