/*
 * Decompiled with CFR 0.152.
 */
package edu.upc.dama.dex.core;

import com.sparsity.dex.gdb.AttributeKind;
import com.sparsity.dex.gdb.AttributeList;
import com.sparsity.dex.gdb.AttributeStatistics;
import com.sparsity.dex.gdb.Condition;
import com.sparsity.dex.gdb.DataType;
import com.sparsity.dex.gdb.EdgeData;
import com.sparsity.dex.gdb.EdgesDirection;
import com.sparsity.dex.gdb.ObjectType;
import com.sparsity.dex.gdb.ObjectsIterator;
import com.sparsity.dex.gdb.Type;
import com.sparsity.dex.gdb.TypeList;
import edu.upc.dama.dex.core.Attribute;
import edu.upc.dama.dex.core.Export;
import edu.upc.dama.dex.core.GraphPool;
import edu.upc.dama.dex.core.Identifiers;
import edu.upc.dama.dex.core.Objects;
import edu.upc.dama.dex.core.Operation;
import edu.upc.dama.dex.core.Session;
import edu.upc.dama.dex.core.TextStream;
import edu.upc.dama.dex.core.Value;
import edu.upc.dama.dex.core.Values;
import edu.upc.dama.dex.utils.StringLib;
import java.awt.Color;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Graph
implements Identifiers {
    private com.sparsity.dex.gdb.Graph handle = null;
    private Session sess = null;
    public static final short ATTR_KIND_BASIC = 0;
    public static final short ATTR_KIND_UNIQUE = 1;
    public static final short ATTR_KIND_INDEXED = 2;
    public static final short ORDER_ASCENDENT = 1;
    public static final short ORDER_DESCENDENT = 2;
    public static final short OPERATION_LT = 1;
    public static final short OPERATION_LE = 2;
    public static final short OPERATION_EQ = 3;
    public static final short OPERATION_GE = 4;
    public static final short OPERATION_GT = 5;
    public static final short OPERATION_NE = 6;
    public static final short OPERATION_BETWEEN = 9;
    public static final short OPERATION_LIKE = 7;
    public static final short OPERATION_ILIKE = 11;
    public static final short OPERATION_ERE = 12;
    public static final short EDGES_IN = 1;
    public static final short EDGES_OUT = 2;
    public static final short EDGES_BOTH = 3;
    protected long numNodes = 0L;
    protected long numEdges = 0L;

    private static String getAttributeKindString(short k) {
        switch (k) {
            case 0: {
                return "BASIC";
            }
            case 2: {
                return "INDEXED";
            }
            case 1: {
                return "UNIQUE";
            }
        }
        return null;
    }

    Graph(Session sess, com.sparsity.dex.gdb.Graph handle) {
        this.sess = sess;
        this.handle = handle;
        assert (handle != null);
        this.numNodes = handle.countNodes();
        this.numEdges = handle.countEdges();
    }

    public com.sparsity.dex.gdb.Graph getHandle() {
        return this.handle;
    }

    protected void close() {
        this.sess = null;
        this.handle = null;
    }

    public boolean isOpen() {
        return this.handle != null;
    }

    public Session getSession() {
        return this.sess;
    }

    public GraphPool getGraphPool() {
        return this.sess.getGraphPool();
    }

    public int newNodeType(String name) {
        return this.handle.newNodeType(name);
    }

    public int newEdgeType(String name, boolean directed) {
        return this.handle.newEdgeType(name, directed, false);
    }

    public int newEdgeType(String name, boolean directed, boolean neighbors) {
        return this.handle.newEdgeType(name, directed, neighbors);
    }

    public int newEdgeType(String name) {
        return this.handle.newEdgeType(name, true, false);
    }

    public int newUndirectedEdgeType(String name) {
        return this.handle.newEdgeType(name, false, false);
    }

    public int newRestrictedEdgeType(String name, int typeTail, int typeHead) {
        return this.newRestrictedEdgeType(name, typeTail, typeHead, false);
    }

    public int newRestrictedEdgeType(String name, int typeTail, int typeHead, boolean neighbors) {
        return this.handle.newRestrictedEdgeType(name, typeTail, typeHead, neighbors);
    }

    public int findType(String name) {
        return this.handle.findType(name);
    }

    @Deprecated
    public int findNodeType(String name) {
        int type = this.handle.findType(name);
        if (type != 0 && this.handle.getType(type).getObjectType() == ObjectType.Node) {
            return type;
        }
        return 0;
    }

    @Deprecated
    public int findEdgeType(String name) {
        int type = this.handle.findType(name);
        if (type != 0 && this.handle.getType(type).getObjectType() == ObjectType.Edge) {
            return type;
        }
        return 0;
    }

    public TypeData getTypeData(int type) {
        return new TypeData(this.handle.getType(type));
    }

    @Deprecated
    public String getTypeName(int type) {
        return this.getTypeData(type).getName();
    }

    public boolean removeType(int type) {
        this.handle.removeType(type);
        this.numNodes = this.handle.countNodes();
        this.numEdges = this.handle.countEdges();
        return true;
    }

    public boolean isTypeEdge(int type) {
        TypeData tdata = this.getTypeData(type);
        return tdata.isEdgeType();
    }

    public boolean isTypeNode(int type) {
        TypeData tdata = this.getTypeData(type);
        return !tdata.isEdgeType();
    }

    @Deprecated
    public Iterator<Integer> getNodeTypes() {
        return this.nodeTypes().iterator();
    }

    public Set<Integer> nodeTypes() {
        TypeList ts = this.handle.findNodeTypes();
        HashSet<Integer> hs = new HashSet<Integer>(ts.count());
        Iterator i$ = ts.iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            hs.add(i);
        }
        return hs;
    }

    @Deprecated
    public Iterator<Integer> getEdgeTypes() {
        return this.edgeTypes().iterator();
    }

    public Set<Integer> edgeTypes() {
        TypeList ts = this.handle.findEdgeTypes();
        HashSet<Integer> hs = new HashSet<Integer>(ts.count());
        Iterator i$ = ts.iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            hs.add(i);
        }
        return hs;
    }

    @Deprecated
    public boolean isEdgeTypeRestricted(int type) {
        return this.getTypeData(type).isRestricted();
    }

    @Deprecated
    public boolean isEdgeTypeDirected(int type) {
        return this.getTypeData(type).isDirected();
    }

    @Deprecated
    public boolean isEdgeTypeUndirected(int type) {
        return this.getTypeData(type).isUndirected();
    }

    public long newNode(int type) {
        long oid = this.handle.newNode(type);
        if (oid != 0L) {
            ++this.numNodes;
        }
        return oid;
    }

    public long newEdge(long tail, long head, int type) {
        long oid = this.handle.newEdge(type, tail, head);
        if (oid != 0L) {
            ++this.numEdges;
        }
        return oid;
    }

    public long newEdge(long attrTail, Value vTail, long attrHead, Value vHead, int type) {
        long oid = this.handle.newEdge(type, (int)attrTail, vTail.getHandle(), (int)attrHead, vHead.getHandle());
        if (oid != 0L) {
            ++this.numEdges;
        }
        return oid;
    }

    public int getObjectType(long oid) {
        return this.handle.getObjectType(oid);
    }

    public int getType(long oid) {
        return this.handle.getObjectType(oid);
    }

    public long nodes() {
        return this.numNodes;
    }

    public long edges() {
        return this.numEdges;
    }

    public boolean drop(long oid) {
        this.handle.drop(oid);
        this.numNodes = this.handle.countNodes();
        this.numEdges = this.handle.countEdges();
        return true;
    }

    public long newAttribute(int type, String name, short datatype, short kind) {
        return this.handle.newAttribute(type, name, Value.convertFromDataType(datatype), Graph.convertFromAttrKind(kind));
    }

    public long newAttribute(int type, String name, short datatype) {
        if (7 == datatype) {
            return this.handle.newAttribute(type, name, Value.convertFromDataType(datatype), AttributeKind.Basic);
        }
        return this.handle.newAttribute(type, name, Value.convertFromDataType(datatype), AttributeKind.Indexed);
    }

    public long newTransientAttribute(int type, short datatype, short kind) {
        return this.handle.newSessionAttribute(type, Value.convertFromDataType(datatype), Graph.convertFromAttrKind(kind));
    }

    public long newTransientAttribute(int type, short datatype) {
        return this.handle.newSessionAttribute(type, Value.convertFromDataType(datatype), AttributeKind.Indexed);
    }

    public AttributeData getAttributeData(long attribute) {
        return new AttributeData(this.handle.getAttribute((int)attribute));
    }

    public AttributeStats getAttributeStats(long attribute) {
        AttributeStatistics s1 = this.handle.getAttributeStatistics((int)attribute, false);
        AttributeStats s2 = new AttributeStats();
        s2.distinct = s1.getDistinct();
        s2.max = new Value(s1.getMax());
        s2.mean = s1.getMean();
        s2.median = s1.getMedian();
        s2.min = new Value(s1.getMin());
        s2.mode = new Value(s1.getMode());
        s2.modeCount = s1.getModeCount();
        s2.nil = s1.getNull();
        s2.total = s1.getTotal();
        s2.variance = s1.getVariance();
        return s2;
    }

    public long getAttributeIntervalCount(long attribute, Value low, boolean includeLow, Value high, boolean includeHigh) {
        return this.handle.getAttributeIntervalCount((int)attribute, low.getHandle(), includeLow, high.getHandle(), includeHigh);
    }

    @Deprecated
    public String getAttributeName(long attribute) {
        return this.getAttributeData(attribute).getName();
    }

    @Deprecated
    public long getAttributeSize(long attribute) {
        return this.getAttributeData(attribute).getSize();
    }

    @Deprecated
    public long getAttributeCount(long attribute) {
        return this.getAttributeData(attribute).getCount();
    }

    @Deprecated
    public short getAttributeType(long attribute) {
        return this.getAttributeData(attribute).getDatatype();
    }

    public long findAttribute(int type, String name) {
        return this.handle.findAttribute(type, name);
    }

    public Set<Long> getAttributesFromType(int type) {
        AttributeList ts = this.handle.findAttributes(type);
        HashSet<Long> hs = new HashSet<Long>(ts.count());
        Iterator i$ = ts.iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            hs.add(Long.valueOf(i));
        }
        return hs;
    }

    public boolean removeAttribute(long attribute) {
        this.handle.removeAttribute((int)attribute);
        return true;
    }

    public boolean indexAttribute(long attribute, short kind) {
        boolean rc = true;
        try {
            this.handle.indexAttribute((int)attribute, Graph.convertFromAttrKind(kind));
        }
        catch (Exception e) {
            rc = false;
        }
        return rc;
    }

    public boolean setAttribute(long oid, long attribute, Value v) {
        if (v.getType() == 7) {
            this.handle.setAttributeText(oid, (int)attribute, v.getTextStream().getHandle());
        } else {
            this.handle.setAttribute(oid, (int)attribute, v.getHandle());
        }
        return true;
    }

    public boolean setAttribute(long oid, String attribute, Value v) {
        int type = this.handle.getObjectType(oid);
        long attr = this.handle.findAttribute(type, attribute);
        return this.setAttribute(oid, attr, v);
    }

    public Value getAttribute(long oid, long attribute) {
        Value value = new Value();
        this.getAttribute(oid, attribute, value);
        return value;
    }

    public Value getAttribute(long oid, String attribute) {
        int type = this.handle.getObjectType(oid);
        long attr = this.handle.findAttribute(type, attribute);
        return this.getAttribute(oid, attr);
    }

    public boolean getAttribute(long oid, long attribute, Value v) {
        com.sparsity.dex.gdb.Value vv = new com.sparsity.dex.gdb.Value();
        if (this.handle.getAttribute((int)attribute).getDataType() == DataType.Text) {
            TextStream stream = new TextStream(this.handle.getAttributeText(oid, (int)attribute));
            v.setTextStream(stream);
        } else {
            this.handle.getAttribute(oid, (int)attribute, vv);
            v.setHandle(vv);
        }
        return true;
    }

    public Values getValues(long attribute, short order) {
        return new Values(this.sess, this.handle.getValues((int)attribute), order);
    }

    public Set<Long> getAttributes(long oid) {
        AttributeList ts = this.handle.getAttributes(oid);
        HashSet<Long> hs = new HashSet<Long>(ts.count());
        Iterator i$ = ts.iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            hs.add(Long.valueOf(i));
        }
        return hs;
    }

    @Deprecated
    public Attribute[] findAttributes(long oid) {
        AttributeList ts = this.handle.getAttributes(oid);
        Attribute[] attributes = new Attribute[ts.count()];
        int i = 0;
        Iterator i$ = ts.iterator();
        while (i$.hasNext()) {
            int attr = (Integer)i$.next();
            attributes[i] = new Attribute();
            attributes[i].name = this.getAttributeData(attr).getName();
            attributes[i].value = new Value();
            this.getAttribute(oid, attr, attributes[i].value);
            ++i;
        }
        return attributes;
    }

    @Deprecated
    public Attribute[] findAttributes(int type) {
        AttributeList ts = this.handle.findAttributes(type);
        Attribute[] attributes = new Attribute[ts.count()];
        int i = 0;
        Iterator i$ = ts.iterator();
        while (i$.hasNext()) {
            int attr = (Integer)i$.next();
            attributes[i] = new Attribute();
            attributes[i].name = this.getAttributeData(attr).getName();
            attributes[i].value = new Value(attr);
            ++i;
        }
        return attributes;
    }

    public long[] getEdge(long oid) {
        long[] oids = new long[2];
        EdgeData ed = this.handle.getEdgeData(oid);
        oids[0] = ed.getTail();
        oids[1] = ed.getHead();
        return oids;
    }

    @Deprecated
    public long getTail(long oid) {
        return this.handle.getEdgeData(oid).getTail();
    }

    @Deprecated
    public long getHead(long oid) {
        return this.handle.getEdgeData(oid).getHead();
    }

    public long getEdgePeer(long edge, long node) {
        return this.handle.getEdgePeer(edge, node);
    }

    public long findObj(long attr, Value v) {
        return this.handle.findObject((int)attr, v.getHandle());
    }

    public Objects findEdges(long tail, long head, int type) {
        return new Objects(this.sess, this.handle.edges(type, tail, head));
    }

    public long findEdge(long tail, long head, int type) {
        return this.handle.findEdge(type, tail, head);
    }

    @Deprecated
    public long[] findEdges(long tail, long head, int type, int max) {
        long[] oids;
        if (max == 1) {
            long oid = this.handle.findEdge(type, tail, head);
            oids = oid != com.sparsity.dex.gdb.Objects.InvalidOID ? new long[]{oid} : new long[]{};
        } else {
            com.sparsity.dex.gdb.Objects objs = this.handle.edges(type, tail, head);
            int n = objs.size();
            if (n > max) {
                n = max;
            }
            oids = new long[n];
            ObjectsIterator it = objs.iterator();
            for (int i = 0; i < n; ++i) {
                oids[i] = it.next();
            }
            it.close();
            objs.close();
        }
        return oids;
    }

    @Deprecated
    public boolean existsNode(long oid) {
        boolean rc = false;
        try {
            rc = this.isTypeNode(this.handle.getObjectType(oid));
        }
        catch (Exception e) {
            // empty catch block
        }
        return rc;
    }

    @Deprecated
    public boolean existsEdgeIn(long oid1, long oid2, int type) {
        long edge = this.findEdge(oid2, oid1, type);
        return edge != 0L;
    }

    @Deprecated
    public boolean existsEdgeOut(long oid1, long oid2, int type) {
        long edge = this.findEdge(oid1, oid2, type);
        return edge != 0L;
    }

    @Deprecated
    public boolean existsEdge(long oid1, long oid2, int type) {
        if (this.existsEdgeIn(oid1, oid2, type)) {
            return true;
        }
        return this.existsEdgeOut(oid1, oid2, type);
    }

    public Objects select(int type) {
        return new Objects(this.sess, this.handle.select(type));
    }

    @Deprecated
    public Objects select(long attribute, Operation op, Value v) {
        return new Objects(this.sess, this.handle.select((int)attribute, this.convertFromOp(op.toShort()), v.getHandle()));
    }

    public Objects select(long attribute, short op, Value v) {
        return new Objects(this.sess, this.handle.select((int)attribute, this.convertFromOp(op), v.getHandle()));
    }

    public Objects select(long attribute, short op, Value v1, Value v2) {
        return new Objects(this.sess, this.handle.select((int)attribute, this.convertFromOp(op), v1.getHandle(), v2.getHandle()));
    }

    @Deprecated
    public Objects select(int type, String attribute, Operation op, Value v) {
        long attr = this.handle.findAttribute(type, attribute);
        return new Objects(this.sess, this.handle.select((int)attr, this.convertFromOp(op.toShort()), v.getHandle()));
    }

    public Objects explode(long oid, int type, short direction) {
        return new Objects(this.sess, this.handle.explode(oid, type, this.convertFromDirection(direction)));
    }

    public Objects explode(long oid, String type, short direction) {
        int t = this.handle.findType(type);
        return new Objects(this.sess, this.handle.explode(oid, t, this.convertFromDirection(direction)));
    }

    public Objects explode(Objects nodes, int type, short direction) {
        return new Objects(this.sess, this.handle.explode(nodes.getHandle(), type, this.convertFromDirection(direction)));
    }

    public Objects explode(Objects nodes, String type, short direction) {
        int t = this.handle.findType(type);
        return new Objects(this.sess, this.handle.explode(nodes.getHandle(), t, this.convertFromDirection(direction)));
    }

    public Objects neighbors(long oid, int type, short direction) {
        return new Objects(this.sess, this.handle.neighbors(oid, type, this.convertFromDirection(direction)));
    }

    @Deprecated
    public Objects neighbors(long oid, String type, short direction) {
        int t = this.handle.findType(type);
        return new Objects(this.sess, this.handle.neighbors(oid, t, this.convertFromDirection(direction)));
    }

    public Objects neighbors(Objects nodes, int type, short direction) {
        return new Objects(this.sess, this.handle.neighbors(nodes.getHandle(), type, this.convertFromDirection(direction)));
    }

    @Deprecated
    public Objects neighbors(Objects nodes, String type, short direction) {
        int t = this.handle.findType(type);
        return new Objects(this.sess, this.handle.neighbors(nodes.getHandle(), t, this.convertFromDirection(direction)));
    }

    public long degree(long oid, int type, short direction) {
        return this.handle.degree(oid, type, this.convertFromDirection(direction));
    }

    public Objects tails(Objects edges) {
        return new Objects(this.sess, this.handle.tails(edges.getHandle()));
    }

    public Objects heads(Objects edges) {
        return new Objects(this.sess, this.handle.heads(edges.getHandle()));
    }

    public void export(PrintWriter ps, Export.Type type, Export extra) {
        Export e = extra;
        if (e == null) {
            e = new DefaultExport();
        }
        e.prepare(this);
        this.exportProcess(ps, type, e);
        e.release();
    }

    private void exportNode(PrintWriter ps, Export.Type type, Export.NodeExport nExp, long node, int n) {
        String typename = this.getTypeName(this.getType(node));
        String label = null;
        Export.NodeExport.Shape shape = Export.NodeExport.Shape.BOX;
        int colorNode = 10863606;
        int colorLabel = Color.BLACK.getRGB();
        float height = 25.0f;
        int width = 25;
        int fontSize = 10;
        label = nExp.getLabel();
        shape = nExp.getShape();
        colorNode = nExp.getColor().getRGB();
        colorLabel = nExp.getColorLabel().getRGB();
        fontSize = nExp.getFontSize();
        if (nExp.isFit() && label != null) {
            int nbmayus = 0;
            for (int i = 0; i < label.length(); ++i) {
                if (!Character.isUpperCase(label.charAt(i))) continue;
                ++nbmayus;
            }
            height = 6.0f + (float)fontSize * 1.3f;
            width = label.length() * (fontSize / 2 + fontSize % 10) + nbmayus * (fontSize % 10 + 1);
        } else {
            height = nExp.getHeight();
            width = nExp.getWidth();
        }
        if (label == null) {
            label = typename + "\\n" + n;
        }
        switch (type) {
            case GRAPHVIZ: {
                ps.println("  N" + n + " [label=\"" + label + "\"]");
                break;
            }
            case GRAPHML: {
                ps.println("      <node id=\"" + n + "\"/>");
                break;
            }
            case YGRAPHML: {
                label = StringLib.escape(label);
                ps.println("      <node id=\"" + n + "\">");
                ps.println("        <data key=\"d0\" >");
                ps.println("          <y:ShapeNode>");
                ps.println("            <y:Geometry height=\"" + height + "\" width=\"" + width + "\"/>");
                String aux = Integer.toHexString(colorNode);
                ps.println("            <y:Fill color=\"#" + aux.substring(2, aux.length()) + "\"/>");
                ps.println("            <y:BorderStyle color=\"#" + aux.substring(2, aux.length()) + "\"/>");
                aux = Integer.toHexString(colorLabel);
                ps.println("            <y:NodeLabel fontSize=\"" + fontSize + "\" textColor=\"#" + aux.substring(2, aux.length()) + "\">" + label + "</y:NodeLabel>");
                if (shape == Export.NodeExport.Shape.ROUND) {
                    ps.println("            <y:Shape type=\"ellipse\"/>");
                } else if (shape == Export.NodeExport.Shape.BOX) {
                    ps.println("            <y:Shape type=\"rectangle\"/>");
                }
                ps.println("          </y:ShapeNode>");
                ps.println("        </data>");
                ps.println("      </node>");
            }
        }
    }

    private void exportEdge(PrintWriter ps, Export.Type type, Export.EdgeExport eExp, long tail, long head) {
        int colorEdge = Color.LIGHT_GRAY.getRGB();
        int colorEdgeLabel = Color.BLACK.getRGB();
        int fontSize = 10;
        short width = 1;
        Export.EdgeExport.Direction direction = Export.EdgeExport.Direction.DIRECTED;
        String label = null;
        label = eExp.getLabel();
        colorEdge = eExp.getColor().getRGB();
        colorEdgeLabel = eExp.getColorLabel().getRGB();
        fontSize = eExp.getFontSize();
        direction = eExp.getDirection();
        width = eExp.getWidth();
        switch (type) {
            case GRAPHVIZ: {
                ps.print("  N" + tail + " -> N" + head);
                if (label != null) {
                    ps.print(" [label=\"" + label + "\"]");
                }
                ps.println();
                break;
            }
            case GRAPHML: {
                ps.println("      <edge source=\"" + tail + "\" target=\"" + head + "\"/>");
                break;
            }
            case YGRAPHML: {
                ps.println("      <edge source=\"" + tail + "\" target=\"" + head + "\">");
                ps.println("        <data key=\"d1\" >");
                ps.println("          <y:PolyLineEdge>");
                String aux = Integer.toHexString(colorEdge);
                ps.println("            <y:LineStyle color=\"#" + aux.substring(2, aux.length()) + "\" width=\"" + width + "\"/>");
                if (direction == Export.EdgeExport.Direction.DIRECTED) {
                    ps.println("            <y:Arrows source=\"none\" target=\"standard\"/>");
                } else {
                    ps.println("            <y:Arrows source=\"none\" target=\"none\"/>");
                }
                if (label != null) {
                    aux = Integer.toHexString(colorEdgeLabel);
                    ps.println("            <y:EdgeLabel fontSize=\"" + fontSize + "\" textColor=\"#" + aux.substring(2, aux.length()) + "\">" + label + "</y:EdgeLabel>");
                }
                ps.println("          </y:PolyLineEdge>");
                ps.println("        </data>");
                ps.println("      </edge>");
            }
        }
    }

    private void exportProcess(PrintWriter ps, Export.Type type, Export extra) {
        String typename;
        assert (extra != null);
        String gname = extra.getGraph().getLabel();
        if (gname == null) {
            gname = "G";
        }
        switch (type) {
            case GRAPHVIZ: {
                ps.println("digraph G {\n  overlap=scale");
                ps.println("  graph [label=\"<" + gname + ">\"]");
                break;
            }
            case GRAPHML: {
                ps.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
                ps.println("<graphml xmlns=\"http://graphml.graphdrawing.org/xmlns\"");
                ps.println("  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
                ps.println("  xsi:schemaLocation=\"http://graphml.graphdrawing.org/xmlns ");
                ps.println("  http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd\">");
                ps.println("  <graph id=\"" + gname + "\" edgedefault=\"undirected\">");
                break;
            }
            case YGRAPHML: {
                ps.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
                ps.println("<graphml xmlns=\"http://graphml.graphdrawing.org/xmlns/graphml\" ");
                ps.println("  xmlns:y=\"http://www.yworks.com/xml/graphml\" ");
                ps.println("  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" ");
                ps.println("  xsi:schemaLocation=\"http://graphml.graphdrawing.org/xmlns/graphml ");
                ps.println("  http://www.yworks.com/xml/schema/graphml/1.0/ygraphml.xsd\">");
                ps.println("  <key id=\"d0\" for=\"node\" yfiles.type=\"nodegraphics\"/>");
                ps.println("  <key id=\"d1\" for=\"edge\" yfiles.type=\"edgegraphics\"/>");
                ps.println("  <graph id=\"" + gname + "\" edgedefault=\"undirected\">");
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        HashMap<Long, Integer> mapNodes = new HashMap<Long, Integer>();
        Iterator<Integer> it = this.getNodeTypes();
        while (it.hasNext()) {
            int ntype = it.next();
            typename = this.getTypeName(ntype);
            if (!extra.enableType(ntype)) continue;
            Export.NodeExport nExp = extra.getNodeType(ntype);
            Objects nodes = this.select(ntype);
            Objects.Iterator nit = nodes.iterator();
            while (nit.hasNext()) {
                long node = nit.next();
                int n = mapNodes.size();
                mapNodes.put(node, n);
                Export.NodeExport nExpN = extra.getNode(node);
                if (nExpN == null) {
                    nExpN = nExp;
                }
                this.exportNode(ps, type, nExpN, node, n);
            }
            nodes.close();
        }
        it = this.getEdgeTypes();
        while (it.hasNext()) {
            int etype = it.next();
            typename = this.getTypeName(etype);
            if (!extra.enableType(etype)) continue;
            TypeData tdata = this.getTypeData(etype);
            Export.EdgeExport eEdge = extra.getEdgeType(etype);
            Objects edges = this.select(etype);
            Objects.Iterator nit = edges.iterator();
            while (nit.hasNext()) {
                long e = nit.next();
                long[] edge = this.getEdge(e);
                if (!mapNodes.containsKey(edge[0]) || !mapNodes.containsKey(edge[1])) continue;
                int tail = (Integer)mapNodes.get(edge[0]);
                int head = (Integer)mapNodes.get(edge[1]);
                Export.EdgeExport eEdgeN = extra.getEdge(e);
                if (eEdgeN == null) {
                    eEdgeN = eEdge;
                }
                this.exportEdge(ps, type, eEdgeN, tail, head);
            }
            nit.close();
            edges.close();
        }
        switch (type) {
            case GRAPHVIZ: {
                ps.println("}");
                break;
            }
            case GRAPHML: {
                ps.println("  </graph>");
                ps.println("</graphml>");
                break;
            }
            case YGRAPHML: {
                ps.println("  </graph>");
                ps.println("</graphml>");
            }
        }
        ps.flush();
    }

    Condition convertFromOp(short op) {
        Condition c;
        switch (op) {
            case 1: {
                c = Condition.LessThan;
                break;
            }
            case 2: {
                c = Condition.LessEqual;
                break;
            }
            case 3: {
                c = Condition.Equal;
                break;
            }
            case 4: {
                c = Condition.GreaterEqual;
                break;
            }
            case 5: {
                c = Condition.GreaterThan;
                break;
            }
            case 6: {
                c = Condition.NotEqual;
                break;
            }
            case 7: {
                c = Condition.Like;
                break;
            }
            case 9: {
                c = Condition.Between;
                break;
            }
            case 11: {
                c = Condition.LikeNoCase;
                break;
            }
            case 12: {
                c = Condition.RegExp;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid operation");
            }
        }
        return c;
    }

    static AttributeKind convertFromAttrKind(short kind) {
        AttributeKind k;
        switch (kind) {
            case 0: {
                k = AttributeKind.Basic;
                break;
            }
            case 1: {
                k = AttributeKind.Unique;
                break;
            }
            case 2: {
                k = AttributeKind.Indexed;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid attribute kind");
            }
        }
        return k;
    }

    static short convertToAttrKind(AttributeKind kind) {
        short k;
        switch (kind) {
            case Basic: {
                k = 0;
                break;
            }
            case Unique: {
                k = 1;
                break;
            }
            case Indexed: {
                k = 2;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid attribute kind");
            }
        }
        return k;
    }

    EdgesDirection convertFromDirection(short direction) {
        EdgesDirection d;
        switch (direction) {
            case 2: {
                d = EdgesDirection.Outgoing;
                break;
            }
            case 1: {
                d = EdgesDirection.Ingoing;
                break;
            }
            case 3: {
                d = EdgesDirection.Any;
                break;
            }
            default: {
                throw new RuntimeException("Invalid direction");
            }
        }
        return d;
    }

    private final class DefaultExport
    implements Export {
        private Export.GraphExport gExp = new Export.GraphExport();
        private Export.NodeExport nExp = new Export.NodeExport();
        private Export.EdgeExport eExp = new Export.EdgeExport();
        private Graph graph = null;

        private DefaultExport() {
        }

        public void prepare(Graph graph) {
            this.graph = graph;
        }

        public void release() {
        }

        public Export.GraphExport getGraph() {
            this.gExp.setLabel(this.graph.getGraphPool().getAlias());
            return this.gExp;
        }

        public Export.NodeExport getNodeType(int type) {
            return this.nExp;
        }

        public Export.EdgeExport getEdgeType(int type) {
            return this.eExp;
        }

        public Export.NodeExport getNode(long node) {
            this.nExp.setLabel("" + node);
            return this.nExp;
        }

        public Export.EdgeExport getEdge(long edge) {
            this.eExp.setColor(Color.LIGHT_GRAY);
            this.eExp.setLabel("" + edge);
            int t = this.graph.getType(edge);
            if (this.graph.isEdgeTypeDirected(t)) {
                this.eExp.setDirection(Export.EdgeExport.Direction.DIRECTED);
            } else {
                this.eExp.setDirection(Export.EdgeExport.Direction.UNDIRECTED);
            }
            return this.eExp;
        }

        public boolean enableType(int type) {
            return true;
        }
    }

    public static class AttributeStats {
        public long total;
        public long nil;
        public long distinct;
        public Value min;
        public Value max;
        public Value mode;
        public long modeCount;
        public double mean;
        public double variance;
        public double median;

        public String toString() {
            return new String("total=" + this.total + " nil=" + this.nil + " distinct=" + this.distinct + " min=" + this.min + " max=" + this.max + " mode=" + this.mode + " modeCount=" + this.modeCount + " mean=" + this.mean + " variance=" + this.variance + " median=" + this.median);
        }
    }

    public static class AttributeData {
        com.sparsity.dex.gdb.Attribute handle = null;

        private AttributeData(com.sparsity.dex.gdb.Attribute handle) {
            assert (handle != null);
            this.handle = handle;
        }

        public long getId() {
            return this.handle.getId();
        }

        public String getName() {
            return this.handle.getName();
        }

        public int getType() {
            return this.handle.getTypeId();
        }

        public long getSize() {
            return this.handle.getSize();
        }

        public long getCount() {
            return this.handle.getCount();
        }

        public short getDatatype() {
            return Value.convertToDataType(this.handle.getDataType());
        }

        public short getKind() {
            return Graph.convertToAttrKind(this.handle.getKind());
        }

        @Deprecated
        public long getParent() {
            return 0L;
        }

        public String toString() {
            return "id=" + this.getId() + " (type=" + (this.getType() == 1 ? "GLOBAL" : Integer.valueOf(this.getType())) + " name=" + this.getName() + ") " + Value.getTypeName(this.getDatatype()) + "{" + Graph.getAttributeKindString(this.getKind()) + "}" + " [size=" + this.getSize() + " count=" + this.getCount() + "]";
        }
    }

    public static class TypeData {
        Type handle = null;

        private TypeData(Type handle) {
            assert (handle != null);
            this.handle = handle;
        }

        public int getId() {
            return this.handle.getId();
        }

        public String getName() {
            return this.handle.getName();
        }

        public boolean isNodeType() {
            return this.handle.getObjectType() == ObjectType.Node;
        }

        public boolean isEdgeType() {
            return this.handle.getObjectType() == ObjectType.Edge;
        }

        public boolean isDirected() {
            return this.isEdgeType() && this.handle.getIsDirected();
        }

        public boolean hasNeighbors() {
            return this.isEdgeType() && this.handle.getAreNeighborsIndexed();
        }

        public boolean isUndirected() {
            return this.isEdgeType() && !this.handle.getIsDirected();
        }

        public boolean isRestricted() {
            return this.isEdgeType() && this.handle.getIsRestricted();
        }

        public int[] getRestricted() {
            assert (this.isRestricted());
            return new int[]{this.handle.getRestrictedFrom(), this.handle.getRestrictedTo()};
        }

        public String toString() {
            String clazz = null;
            if (this.isNodeType()) {
                clazz = "N";
            } else {
                if (this.isRestricted()) {
                    clazz = "RE{" + this.handle.getRestrictedFrom() + "->" + this.handle.getRestrictedTo() + "}";
                } else {
                    String string = clazz = this.isDirected() ? "DE" : "UE";
                }
                if (this.hasNeighbors()) {
                    clazz = clazz + "{NeighIndexed}";
                }
            }
            return "id=" + this.handle.getId() + " (name=" + this.handle.getName() + ") " + clazz;
        }
    }
}

