/*
 * Decompiled with CFR 0.152.
 */
package edu.upc.dama.dex.core;

import com.sparsity.dex.gdb.ObjectsIterator;
import edu.upc.dama.dex.core.Session;
import java.io.Closeable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Objects
implements Closeable,
Set<Long> {
    private com.sparsity.dex.gdb.Objects handle = null;
    private Session sess = null;
    private final ArrayList<Iterator> iters = new ArrayList();
    public static final short COMBINE_UNION = 0;
    public static final short COMBINE_INTERSECTION = 1;
    public static final short COMBINE_DIFFERENCE = 2;

    Objects(Session sess, com.sparsity.dex.gdb.Objects handle) {
        this.sess = sess;
        this.handle = handle;
        assert (handle != null);
        sess.register(this);
    }

    public com.sparsity.dex.gdb.Objects getHandle() {
        return this.handle;
    }

    public Objects(Session sess) {
        this.sess = sess;
        this.handle = sess.getHandle().newObjects();
        assert (this.handle != null);
        sess.register(this);
    }

    public Objects(Session sess, Objects objs) {
        this.sess = sess;
        this.handle = objs.handle.copy();
        assert (this.handle != null);
        sess.register(this);
    }

    public Objects(Session sess, Objects objs1, Objects objs2, short combine) {
        this.sess = sess;
        switch (combine) {
            case 0: {
                this.handle = com.sparsity.dex.gdb.Objects.combineUnion((com.sparsity.dex.gdb.Objects)objs1.getHandle(), (com.sparsity.dex.gdb.Objects)objs2.getHandle());
                break;
            }
            case 1: {
                this.handle = com.sparsity.dex.gdb.Objects.combineIntersection((com.sparsity.dex.gdb.Objects)objs1.getHandle(), (com.sparsity.dex.gdb.Objects)objs2.getHandle());
                break;
            }
            case 2: {
                this.handle = com.sparsity.dex.gdb.Objects.combineDifference((com.sparsity.dex.gdb.Objects)objs1.getHandle(), (com.sparsity.dex.gdb.Objects)objs2.getHandle());
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid combine operation");
            }
        }
        assert (this.handle != null);
        sess.register(this);
    }

    public static Objects union(Session sess, Objects objs1, Objects objs2) {
        return new Objects(sess, objs1, objs2, 0);
    }

    public static Objects intersection(Session sess, Objects objs1, Objects objs2) {
        return new Objects(sess, objs1, objs2, 1);
    }

    public static Objects difference(Session sess, Objects objs1, Objects objs2) {
        return new Objects(sess, objs1, objs2, 2);
    }

    @Deprecated
    public Objects(Session sess, Objects objs1, Objects objs2, Combine c) {
        this.sess = sess;
        switch (c) {
            case UNION: {
                this.handle = com.sparsity.dex.gdb.Objects.combineUnion((com.sparsity.dex.gdb.Objects)objs1.getHandle(), (com.sparsity.dex.gdb.Objects)objs2.getHandle());
                break;
            }
            case INTERSECTION: {
                this.handle = com.sparsity.dex.gdb.Objects.combineIntersection((com.sparsity.dex.gdb.Objects)objs1.getHandle(), (com.sparsity.dex.gdb.Objects)objs2.getHandle());
                break;
            }
            case DIFFERENCE: {
                this.handle = com.sparsity.dex.gdb.Objects.combineDifference((com.sparsity.dex.gdb.Objects)objs1.getHandle(), (com.sparsity.dex.gdb.Objects)objs2.getHandle());
            }
        }
        assert (this.handle != null);
        sess.register(this);
    }

    public Session getSession() {
        return this.sess;
    }

    public boolean isOpen() {
        return this.handle != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.isOpen()) {
            this.sess.unregister(this);
            ArrayList<Iterator> arrayList = this.iters;
            synchronized (arrayList) {
                while (this.iters.size() > 0) {
                    this.iters.get(0).close();
                }
            }
            this.handle.close();
            this.handle = null;
        }
    }

    public long sizeLong() {
        return this.handle.size();
    }

    @Override
    public boolean add(long oid) {
        return this.handle.add(oid);
    }

    public boolean exists(long oid) {
        return this.handle.exists(oid);
    }

    public long first() {
        long oid = 0L;
        if (this.handle.size() > 0) {
            ObjectsIterator it = this.handle.iterator();
            oid = it.next();
            it.close();
        }
        return oid;
    }

    public long next(long oid, boolean exists) {
        long rc;
        block3: {
            rc = 0L;
            try {
                ObjectsIterator it = this.handle.iteratorFromElement(oid);
                it.next();
                if (it.hasNext()) {
                    rc = it.next();
                }
                it.close();
            }
            catch (Exception e) {
                if (!exists) break block3;
                throw new RuntimeException("Invalid index");
            }
        }
        return rc;
    }

    public boolean remove(long oid) {
        return this.handle.remove(oid);
    }

    @Override
    public void clear() {
        this.handle.clear();
    }

    public long union(Objects objs) {
        return this.handle.union(objs.getHandle());
    }

    public long intersection(Objects objs) {
        return this.handle.intersection(objs.getHandle());
    }

    public long difference(Objects objs) {
        return this.handle.difference(objs.getHandle());
    }

    public static Objects sample(Session sess, Objects src, Objects exclude, long samples) {
        return new Objects(sess, src.handle.sample(exclude.getHandle(), samples));
    }

    public Iterator iterator() {
        Iterator it = new Iterator(this.handle.iterator());
        this.register(it);
        return it;
    }

    public Iterator iterator(long startPosition) {
        Iterator it = new Iterator(this.handle.iteratorFromIndex(startPosition));
        this.register(it);
        return it;
    }

    public Iterator iteratorFromOID(long oid) {
        Iterator it = new Iterator(this.handle.iteratorFromElement(oid));
        this.register(it);
        return it;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void register(Iterator it) {
        ArrayList<Iterator> arrayList = this.iters;
        synchronized (arrayList) {
            this.iters.add(it);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void unregister(Iterator it) {
        ArrayList<Iterator> arrayList = this.iters;
        synchronized (arrayList) {
            this.iters.remove(it);
        }
    }

    @Override
    public int size() {
        long s = this.handle.size();
        return s > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)s;
    }

    @Override
    public boolean isEmpty() {
        return (long)this.handle.size() == 0L;
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            throw new NullPointerException("This collection does not support null elements.");
        }
        if (o instanceof Long) {
            return this.handle.exists(((Long)o).longValue());
        }
        throw new ClassCastException("The specified element is incompatible with this collection.");
    }

    @Override
    public Object[] toArray() {
        Long[] ret = null;
        int s = this.size();
        if (s > 0) {
            ret = new Long[s];
            Iterator it = this.iterator();
            int i = 0;
            while (it.hasNext()) {
                ret[i++] = it.next();
            }
            it.close();
        }
        return ret;
    }

    @Override
    public <T> T[] toArray(T[] ts) {
        if (ts == null) {
            throw new NullPointerException("The specified array is null.");
        }
        if (!Long.class.isAssignableFrom(ts.getClass().getComponentType()) && ts.getClass().getComponentType() != Long.TYPE) {
            throw new ArrayStoreException("Type of the specified array is not a supertype of the runtime type of every element in this collection.");
        }
        int size = this.size();
        boolean spare = ts.length > size;
        T[] ret = ts.length >= size ? ts : (Object[])Array.newInstance(ts.getClass().getComponentType(), size);
        Iterator it = this.iterator();
        int i = 0;
        while (it.hasNext()) {
            ret[i++] = it.next();
        }
        it.close();
        if (spare) {
            ret[size] = null;
        }
        return ret;
    }

    @Override
    public boolean add(Long e) {
        if (e == null) {
            throw new NullPointerException("This collection does not support null elements.");
        }
        return this.handle.add(e.longValue());
    }

    @Override
    public boolean remove(Object o) {
        if (o == null) {
            throw new NullPointerException("This collection does not support null elements.");
        }
        if (o instanceof Long) {
            return this.handle.remove(((Long)o).longValue());
        }
        throw new ClassCastException("The specified element is incompatible with this collection.");
    }

    @Override
    public boolean containsAll(Collection<?> clctn) {
        boolean isSubSet;
        if (clctn == null) {
            throw new NullPointerException("The specified collection is null.");
        }
        if (clctn instanceof Objects) {
            Objects objs = new Objects(this.sess, this, (Objects)clctn, 1);
            isSubSet = (long)objs.handle.size() == ((Objects)clctn).sizeLong();
            objs.close();
        } else {
            Object object;
            java.util.Iterator<?> it = clctn.iterator();
            for (isSubSet = true; it.hasNext() && isSubSet; isSubSet &= this.handle.exists(((Long)object).longValue())) {
                object = it.next();
                if (object == null) {
                    throw new NullPointerException("The specified collection contains one or more null elements and this set does not support null elements");
                }
                if (object instanceof Long) {
                    continue;
                }
                throw new ClassCastException("The types of one or more elements in the specified collection are incompatible with this set.");
            }
        }
        return isSubSet;
    }

    @Override
    public boolean addAll(Collection<? extends Long> clctn) {
        if (clctn == null) {
            throw new NullPointerException("The specified collection is null.");
        }
        if (clctn instanceof Objects) {
            long oldSize = this.handle.size();
            long l = this.union((Objects)clctn);
            return l != oldSize;
        }
        boolean updated = false;
        for (Long l : clctn) {
            if (l == null) {
                throw new NullPointerException("This collection does not support null elements.");
            }
            updated |= this.handle.add(l.longValue());
        }
        return updated;
    }

    @Override
    public boolean retainAll(Collection<?> clctn) {
        if (clctn == null) {
            throw new NullPointerException("The specified collection is null.");
        }
        if (clctn instanceof Objects) {
            long oldSize = this.handle.size();
            long newSize = this.intersection((Objects)clctn);
            return newSize != oldSize;
        }
        boolean updated = false;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            long oid = it.next();
            if (clctn.contains(oid)) continue;
            updated &= this.handle.remove(oid);
        }
        it.close();
        return updated;
    }

    @Override
    public boolean removeAll(Collection<?> clctn) {
        if (clctn == null) {
            throw new NullPointerException("The specified collection is null.");
        }
        if (clctn instanceof Objects) {
            long oldSize = this.handle.size();
            long newSize = this.difference((Objects)clctn);
            return newSize != oldSize;
        }
        boolean updated = false;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            long oid = it.next();
            if (!clctn.contains(oid)) continue;
            updated &= this.handle.remove(oid);
        }
        it.close();
        return updated;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Iterator
    implements java.util.Iterator<Long>,
    Closeable {
        private ObjectsIterator handle = null;

        Iterator(ObjectsIterator handle) {
            this.handle = handle;
            assert (this.handle != null);
        }

        @Override
        public boolean hasNext() {
            return this.handle.hasNext();
        }

        @Override
        public Long next() {
            return this.handle.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean isOpen() {
            return this.handle != null;
        }

        @Override
        public void close() {
            if (this.isOpen()) {
                Objects.this.unregister(this);
                this.handle.close();
                this.handle = null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    public static enum Combine {
        UNION,
        INTERSECTION,
        DIFFERENCE;

    }
}

