/*
 * Decompiled with CFR 0.152.
 */
package edu.upc.dama.dex.core;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;

public class TextStream
implements Closeable {
    private com.sparsity.dex.gdb.TextStream handle = null;
    private boolean write = false;

    TextStream(com.sparsity.dex.gdb.TextStream handle) {
        this.handle = handle;
        this.write = false;
    }

    public TextStream(boolean append) {
        this.handle = new com.sparsity.dex.gdb.TextStream(append);
        this.write = true;
    }

    public TextStream() {
        this(false);
    }

    public com.sparsity.dex.gdb.TextStream getHandle() {
        return this.handle;
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        int rc;
        if (this.handle == null) {
            throw new IOException("Handle is null");
        }
        if (this.write) {
            throw new IllegalStateException("Only-write text stream");
        }
        if (this.handle.isNull()) {
            return 0;
        }
        if (off == 0) {
            rc = this.handle.read(cbuf, len);
        } else {
            int ll = len - off;
            char[] cc = new char[ll];
            rc = this.handle.read(cc, ll);
            System.arraycopy(cc, 0, cbuf, off, rc);
        }
        return rc;
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.handle == null) {
            throw new IOException("Handle is null");
        }
        if (!this.write) {
            throw new IllegalStateException("Only-read text stream");
        }
        char[] cc = cbuf;
        int ll = len;
        if (off > 0) {
            cc = Arrays.copyOfRange(cbuf, off, len);
            ll = cc.length;
        }
        this.handle.write(cc, ll);
    }

    public void flush() throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void close() throws IOException {
        if (this.handle != null) {
            this.handle.close();
        }
        this.handle = null;
    }

    public static class TextWriter
    extends Writer {
        TextStream strm = null;

        public TextWriter(TextStream strm) {
            this.strm = strm;
            if (!this.strm.write) {
                throw new IllegalArgumentException("TextWriter cannot be created from a reader TextStream");
            }
        }

        public void write(char[] chars, int i, int i1) throws IOException {
            this.strm.write(chars, i, i1);
        }

        public void flush() throws IOException {
            this.strm.flush();
        }

        public void close() throws IOException {
            this.strm.close();
        }
    }

    public static class TextReader
    extends Reader {
        TextStream strm = null;

        public TextReader(TextStream strm) {
            this.strm = strm;
            if (this.strm.write) {
                throw new IllegalArgumentException("TextReader cannot be created from a writer TextStream");
            }
        }

        public boolean markSupported() {
            return false;
        }

        public int read(char[] chars, int i, int i1) throws IOException {
            int r = this.strm.read(chars, i, i1);
            return r == 0 ? -1 : r;
        }

        public void close() throws IOException {
            this.strm.close();
        }
    }
}

