/*
 * Decompiled with CFR 0.152.
 */
package edu.upc.dama.dex.core;

import com.sparsity.dex.gdb.DataType;
import edu.upc.dama.dex.core.TextStream;
import java.util.Calendar;

public class Value {
    public static final int STRING_MAX_LENGTH = 2048;
    private com.sparsity.dex.gdb.Value handle;
    private TextStream stream;
    public static final short NULL = 0;
    public static final short INT = 1;
    public static final short STRING = 2;
    public static final short DOUBLE = 3;
    public static final short BOOL = 4;
    public static final short TIMESTAMP = 5;
    public static final short LONG = 6;
    public static final short TEXT = 7;

    static boolean isValidDatatype(short datatype) {
        return datatype >= 0 && datatype <= 7;
    }

    public com.sparsity.dex.gdb.Value getHandle() {
        return this.handle;
    }

    public Value() {
        this.handle = new com.sparsity.dex.gdb.Value();
        this.setNull();
    }

    Value(com.sparsity.dex.gdb.Value value) {
        this.handle = value;
        this.stream = null;
    }

    public Value(int v) {
        this.handle = new com.sparsity.dex.gdb.Value();
        this.setInt(v);
    }

    public Value(long v) {
        this.handle = new com.sparsity.dex.gdb.Value();
        this.setLong(v);
    }

    public Value(String v) {
        this.handle = new com.sparsity.dex.gdb.Value();
        this.setString(v);
    }

    public Value(boolean v) {
        this.handle = new com.sparsity.dex.gdb.Value();
        this.setBool(v);
    }

    public Value(double v) {
        this.handle = new com.sparsity.dex.gdb.Value();
        this.setDouble(v);
    }

    public Value(Calendar v) {
        this.handle = new com.sparsity.dex.gdb.Value();
        this.setTimestamp(v);
    }

    public Value(TextStream v) {
        this.handle = new com.sparsity.dex.gdb.Value();
        this.setTextStream(v);
    }

    public Value(Object object) {
        this.handle = new com.sparsity.dex.gdb.Value();
        if (object == null) {
            this.setNull();
        } else if (object instanceof Integer) {
            this.setInt((Integer)object);
        } else if (object instanceof String) {
            if (((String)object).length() >= 2048) {
                throw new IllegalArgumentException("Illegal argument object: object string length cannot exceed 2048 characters");
            }
            this.setString((String)object);
        } else if (object instanceof Double) {
            this.setDouble((Double)object);
        } else if (object instanceof Boolean) {
            this.setBool((Boolean)object);
        } else if (object instanceof Calendar) {
            this.setTimestamp((Calendar)object);
        } else if (object instanceof Long) {
            this.setLong((Long)object);
        } else if (object instanceof TextStream) {
            this.setTextStream((TextStream)object);
        } else {
            throw new IllegalArgumentException("Illegal argument object: datatype not supported for " + object.getClass().getName());
        }
    }

    public Object get() {
        Object object = null;
        if (this.stream != null) {
            object = this.stream;
        } else if (!this.handle.isNull()) {
            switch (this.handle.getDataType()) {
                case Integer: {
                    object = new Integer(this.handle.getInteger());
                    break;
                }
                case String: {
                    object = this.handle.getString();
                    break;
                }
                case Double: {
                    object = new Double(this.handle.getDouble());
                    break;
                }
                case Boolean: {
                    object = new Boolean(this.handle.getBoolean());
                    break;
                }
                case Timestamp: {
                    object = this.handle.getTimestampAsCalendar();
                    break;
                }
                case Long: {
                    object = new Long(this.handle.getLong());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid value");
                }
            }
        }
        return object;
    }

    public String toString() {
        if (this.stream != null) {
            return this.stream.toString();
        }
        if (!this.handle.isNull()) {
            if (this.handle.getDataType() == DataType.Timestamp) {
                return this.handle.getTimestampAsCalendar().getTime().toString();
            }
            return this.handle.toString();
        }
        return new String("null");
    }

    public short getType() {
        if (this.stream != null) {
            return 7;
        }
        if (this.handle.isNull()) {
            return 0;
        }
        return Value.convertToDataType(this.handle.getDataType());
    }

    public Value setNull() {
        this.handle.setNull();
        this.stream = null;
        return this;
    }

    public boolean isNull() {
        return this.stream == null && this.handle.isNull();
    }

    public Value setInt(int value) {
        this.handle.setInteger(value);
        this.stream = null;
        return this;
    }

    public int getInt() {
        this.checkType((short)1);
        return this.handle.getInteger();
    }

    public Value setString(String value) {
        if (value == null) {
            this.setNull();
        } else {
            if (value.length() >= 2048) {
                throw new IllegalArgumentException("Illegal argument value: value length cannot exceed 2048 characters");
            }
            this.stream = null;
            this.handle.setString(value);
        }
        return this;
    }

    public String getString() {
        this.checkType((short)2);
        return this.handle.getString();
    }

    public Value setDouble(double value) {
        this.handle.setDouble(value);
        this.stream = null;
        return this;
    }

    public double getDouble() {
        this.checkType((short)3);
        return this.handle.getDouble();
    }

    public Value setBool(boolean value) {
        this.handle.setBoolean(value);
        this.stream = null;
        return this;
    }

    public boolean getBool() {
        this.checkType((short)4);
        return this.handle.getBoolean();
    }

    public Value setTimestamp(Calendar value) {
        this.handle.setTimestamp(value);
        this.stream = null;
        return this;
    }

    public Calendar getTimestamp() {
        this.checkType((short)5);
        return this.handle.getTimestampAsCalendar();
    }

    public long getTimestampValue() {
        this.checkType((short)5);
        Calendar c = this.getTimestamp();
        return c.getTimeInMillis();
    }

    public Value setLong(long value) {
        this.handle.setLong(value);
        this.stream = null;
        return this;
    }

    public long getLong() {
        this.checkType((short)6);
        return this.handle.getLong();
    }

    public Value setTextStream(TextStream tstrm) {
        this.stream = tstrm;
        return this;
    }

    public TextStream getTextStream() {
        this.checkType((short)7);
        return this.stream;
    }

    public short compare(Value value) {
        if (this.stream != null || value.stream != null) {
            throw new RuntimeException("Cannot compare text values");
        }
        if (this.handle.isNull() || value.isNull()) {
            if (!this.handle.isNull() || !value.isNull()) {
                throw new RuntimeException("Cannot compare with null");
            }
            return 0;
        }
        if (this.handle.getDataType() != value.getHandle().getDataType()) {
            throw new RuntimeException("Value.compare/different types");
        }
        short rc = 0;
        int cmp = this.handle.compare(value.getHandle());
        if (cmp < 0) {
            rc = -1;
        } else if (cmp > 0) {
            rc = 1;
        }
        return rc;
    }

    public static String getTypeName(short type) {
        String result = "";
        switch (type) {
            case 0: {
                result = "NULL";
                break;
            }
            case 1: {
                result = "INT";
                break;
            }
            case 2: {
                result = "STRING";
                break;
            }
            case 3: {
                result = "DOUBLE";
                break;
            }
            case 4: {
                result = "BOOL";
                break;
            }
            case 5: {
                result = "TIMESTAMP";
                break;
            }
            case 6: {
                result = "LONG";
                break;
            }
            case 7: {
                result = "TEXT";
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal argument type: type " + type + " not valid.");
            }
        }
        return result;
    }

    public static short getType(String typename) {
        if (typename.equalsIgnoreCase("NULL")) {
            return 0;
        }
        if (typename.equalsIgnoreCase("INT")) {
            return 1;
        }
        if (typename.equalsIgnoreCase("STRING")) {
            return 2;
        }
        if (typename.equalsIgnoreCase("DOUBLE")) {
            return 3;
        }
        if (typename.equalsIgnoreCase("BOOL")) {
            return 4;
        }
        if (typename.equalsIgnoreCase("TIMESTAMP")) {
            return 5;
        }
        if (typename.equalsIgnoreCase("LONG")) {
            return 6;
        }
        if (typename.equalsIgnoreCase("TEXT")) {
            return 7;
        }
        throw new IllegalArgumentException("Illegal argument type: + " + typename + " is not valid.");
    }

    public int hashCode() {
        if (this.stream != null) {
            return this.stream.hashCode();
        }
        return this.handle.hashCode();
    }

    public boolean equals(Object obj) {
        if (this.stream != null || obj instanceof TextStream) {
            throw new RuntimeException("Cannot compare text values");
        }
        return this.handle.equals(obj);
    }

    private void checkType(short type) {
        if (this.getType() != type) {
            throw new ClassCastException("Illegal type:" + Value.getTypeName(type) + ", current type:" + Value.getTypeName(this.getType()));
        }
    }

    static DataType convertFromDataType(short datatype) {
        DataType dt;
        switch (datatype) {
            case 1: {
                dt = DataType.Integer;
                break;
            }
            case 2: {
                dt = DataType.String;
                break;
            }
            case 3: {
                dt = DataType.Double;
                break;
            }
            case 4: {
                dt = DataType.Boolean;
                break;
            }
            case 5: {
                dt = DataType.Timestamp;
                break;
            }
            case 6: {
                dt = DataType.Long;
                break;
            }
            case 7: {
                dt = DataType.Text;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid datatype");
            }
        }
        return dt;
    }

    static short convertToDataType(DataType datatype) {
        short dt;
        switch (datatype) {
            case Integer: {
                dt = 1;
                break;
            }
            case String: {
                dt = 2;
                break;
            }
            case Double: {
                dt = 3;
                break;
            }
            case Boolean: {
                dt = 4;
                break;
            }
            case Timestamp: {
                dt = 5;
                break;
            }
            case Long: {
                dt = 6;
                break;
            }
            case Text: {
                dt = 7;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid datatype");
            }
        }
        return dt;
    }

    void setHandle(com.sparsity.dex.gdb.Value value) {
        this.handle = value;
        this.stream = null;
    }
}

